-- Generated by Craft v2.4.2702 on 2 Dec 2015 08:59:01.

--
-- Disable foreign key checks and autocommit.
--

SET FOREIGN_KEY_CHECKS = 0;
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
SET NAMES utf8;


DROP TABLE IF EXISTS `craft_assetfiles`;


--
-- Schema for table `craft_assetfiles`
--
CREATE TABLE `craft_assetfiles` (
  `id` int(11) NOT NULL,
  `sourceId` int(11) DEFAULT NULL,
  `folderId` int(11) NOT NULL,
  `filename` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `kind` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'unknown',
  `width` smallint(6) unsigned DEFAULT NULL,
  `height` smallint(6) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `dateModified` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_assetfiles_filename_folderId_unq_idx` (`filename`,`folderId`),
  KEY `craft_assetfiles_sourceId_fk` (`sourceId`),
  KEY `craft_assetfiles_folderId_fk` (`folderId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_assetfiles`
--

INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('41', '2', '2', 'sport-woman.jpg', 'image', '254', '252', '83428', '2015-11-13 12:48:48', '2015-11-13 12:48:48', '2015-11-13 12:48:48', '7084d6f3-3bbd-4b7c-b96a-007b498400be');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('48', '1', '1', 'Joint-Pain.jpg', 'image', '576', '394', '165973', '2015-11-13 15:22:49', '2015-11-13 15:22:50', '2015-11-13 15:22:50', '55c7299e-e435-412a-ac43-0e2573544fef');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('51', '1', '1', 'banner.png', 'image', '656', '292', '209646', '2015-11-13 15:44:50', '2015-11-13 15:44:50', '2015-11-13 15:44:50', 'd532041f-e364-4a11-934e-2a78ef72b5d2');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('56', '3', '3', 'sarah-profile.png', 'image', '208', '196', '87149', '2015-11-17 12:00:36', '2015-11-17 12:00:36', '2015-11-17 12:00:36', '52fa11d4-c7c8-40b3-835c-333cd89b055d');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('64', '1', '1', 'sports-injury-2.jpg', 'image', '412', '232', '42497', '2015-11-19 11:37:55', '2015-11-19 11:37:55', '2015-11-19 11:37:55', 'b909be1b-9a2b-4c69-8ae9-e8ee59d2768a');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('66', '1', '1', 'back-pain.gif-437580.gif', 'image', '590', '350', '128726', '2015-11-19 11:39:40', '2015-11-19 11:39:40', '2015-11-19 11:39:40', 'fb6099cb-e8b8-4548-808f-ad397632fb2a');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('67', '1', '1', 'istock_rf_photo_of_arthritis_pain_in_hand.jpg', 'image', '405', '225', '74128', '2015-11-19 11:39:49', '2015-11-19 11:39:49', '2015-11-19 11:39:49', 'a262fb22-c5ef-4b20-8bde-861b2101b926');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('70', '1', '1', 'Tennis-Elbow.jpg', 'image', '300', '221', '18836', '2015-11-19 11:42:57', '2015-11-19 11:42:57', '2015-11-19 11:42:57', '924a850c-7eb0-4302-925a-789b7fceb8ca');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('76', '2', '2', 'lifetime-couple.jpg', 'image', '265', '262', '96280', '2015-11-25 12:05:47', '2015-11-25 12:05:47', '2015-11-25 12:05:47', '3bee7f7f-47d5-48b7-8ff7-766f0c5ab8f0');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('77', '2', '2', 'work-man.jpg', 'image', '261', '263', '69570', '2015-11-25 12:05:48', '2015-11-25 12:05:48', '2015-11-25 12:05:48', '1911cc14-6661-4617-9810-dc42a9a1c978');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('78', '4', '4', '6f14d766-8edf-4b3c-b385-96bfed558d4c.jpg', 'image', '500', '469', '24683', '2015-11-25 14:01:01', '2015-11-25 14:01:02', '2015-11-25 14:01:02', '527f3024-e682-440e-a1c1-a0ae4e498fb1');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('79', '4', '4', 'hpc-logo-registered.jpg', 'image', '300', '217', '30673', '2015-11-25 14:01:02', '2015-11-25 14:01:02', '2015-11-25 14:01:02', '840baac4-b424-4288-bd7c-c8baf99e2dcc');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('80', '4', '4', 'imgres.png', 'image', '295', '171', '16517', '2015-11-25 14:01:03', '2015-11-25 14:01:03', '2015-11-25 14:01:03', 'f3231cea-2545-41f3-8ec2-93ece9201bc0');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('81', '4', '4', '6f14d766-8edf-4b3c-b385-96bfed558d4c_1.jpg', 'image', '500', '469', '24683', '2015-11-25 14:04:57', '2015-11-25 14:04:57', '2015-11-25 14:04:57', '4c9777fa-6651-420b-8af0-472769b2d74c');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('82', '4', '4', 'BMAS-logo.jpg', 'image', '1666', '1995', '846047', '2015-11-25 14:04:58', '2015-11-25 14:04:58', '2015-11-25 14:04:58', 'a96f569e-d8d3-4197-9383-9da1544f811b');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('83', '4', '4', 'hpc-logo-registered_1.jpg', 'image', '300', '217', '30673', '2015-11-25 14:04:58', '2015-11-25 14:04:59', '2015-11-25 14:04:59', '8d94ff90-497f-490f-80fc-e3747e8bd519');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('84', '4', '4', 'imgres_1.png', 'image', '295', '171', '16517', '2015-11-25 14:04:59', '2015-11-25 14:04:59', '2015-11-25 14:04:59', '85b0a243-0a80-4438-baa7-0904af435afb');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('89', '4', '4', 'BMAS-footer.png', 'image', '1666', '1995', '528848', '2015-11-25 14:20:36', '2015-11-25 14:20:37', '2015-11-25 14:20:37', 'fae6ff56-ebe6-485d-aca2-d37054b4b086');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('90', '4', '4', 'csp-footer.png', 'image', '295', '171', '202337', '2015-11-25 14:20:37', '2015-11-25 14:20:37', '2015-11-25 14:20:37', 'bc452d9e-3ec1-431e-8645-66bef419d78f');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('91', '4', '4', 'hpc-footer.png', 'image', '300', '217', '261092', '2015-11-25 14:20:37', '2015-11-25 14:20:38', '2015-11-25 14:20:38', '15044090-14c8-4ada-99fe-1887353f9e8b');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('92', '4', '4', 'physio-footer.png', 'image', '500', '469', '133399', '2015-11-25 14:20:38', '2015-11-25 14:20:38', '2015-11-25 14:20:38', 'cd7f783c-750c-4791-92e9-b634b4cb1d1e');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('93', '4', '4', 'physiofirst-footer.png', 'image', '500', '469', '940040', '2015-11-25 14:20:39', '2015-11-25 14:20:39', '2015-11-25 14:20:39', '8c6e5c68-7c07-4c39-b656-9ad0fb3733c5');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('94', '4', '4', 'BMAS.png', 'image', '1666', '1995', '1151507', '2015-11-25 15:12:51', '2015-11-25 15:12:52', '2015-11-25 15:12:52', '63756403-b081-4a8b-b58d-d176ab41dd07');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('95', '4', '4', 'csp.png', 'image', '295', '171', '202337', '2015-11-25 15:12:52', '2015-11-25 15:12:52', '2015-11-25 15:12:52', 'b0ac8a50-f254-458c-b0e7-86d7cb8ff366');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('96', '4', '4', 'hpc.png', 'image', '300', '217', '261092', '2015-11-25 15:12:53', '2015-11-25 15:12:53', '2015-11-25 15:12:53', '69a12b96-4e03-4149-a02e-cb6e39cf61f6');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('97', '4', '4', 'physio-first.png', 'image', '500', '469', '151355', '2015-11-25 15:12:53', '2015-11-25 15:12:54', '2015-11-25 15:12:54', 'b93b0d98-caf8-41b0-b2a9-ebaa0230456b');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('118', '3', '3', 'wZGX_w9OUblVAajGCKA_uVWPWyL6HkG_jN0-gWjOUi4PvDzBhTAFO1L9eafkc8sWHdBTdK2xjDQUrDgK7sjl8A.jpg', 'image', '1066', '1600', '103930', '2015-11-30 11:27:32', '2015-11-30 11:27:33', '2015-11-30 11:27:33', 'f1fdf525-5dee-42ed-af4b-8f3852a548f3');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('119', '4', '4', 'MACP_logo_reverse.png', 'image', '1582', '771', '77283', '2015-12-01 09:37:00', '2015-12-01 09:37:00', '2015-12-01 09:37:00', 'd1ccf21d-cf09-49f0-aa5c-0e1e2fff9b24');
INSERT INTO `craft_assetfiles` (`id`, `sourceId`, `folderId`, `filename`, `kind`, `width`, `height`, `size`, `dateModified`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('120', '4', '4', 'MACP_logo.png', 'image', '1582', '771', '85351', '2015-12-01 09:37:14', '2015-12-01 09:37:14', '2015-12-01 09:37:14', '572d15e3-770f-4e4d-acfe-2d7637b1189d');



DROP TABLE IF EXISTS `craft_assetfolders`;


--
-- Schema for table `craft_assetfolders`
--
CREATE TABLE `craft_assetfolders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parentId` int(11) DEFAULT NULL,
  `sourceId` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_assetfolders_name_parentId_sourceId_unq_idx` (`name`,`parentId`,`sourceId`),
  KEY `craft_assetfolders_parentId_fk` (`parentId`),
  KEY `craft_assetfolders_sourceId_fk` (`sourceId`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_assetfolders`
--

INSERT INTO `craft_assetfolders` (`id`, `parentId`, `sourceId`, `name`, `path`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', NULL, '1', 'News Images', '', '2015-11-13 12:07:01', '2015-11-13 12:07:01', 'dcc4c854-7c89-4f71-9a71-82fb38a61fa4');
INSERT INTO `craft_assetfolders` (`id`, `parentId`, `sourceId`, `name`, `path`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', NULL, '2', 'Treatment Images', '', '2015-11-13 12:10:07', '2015-11-13 12:10:07', 'e9fbf936-671b-4980-8af5-5b874e4dee57');
INSERT INTO `craft_assetfolders` (`id`, `parentId`, `sourceId`, `name`, `path`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', NULL, '3', 'About Us Images', '', '2015-11-13 12:10:46', '2015-11-13 12:10:46', '9d1a1136-6ee3-4bb1-905c-947e8237ec07');
INSERT INTO `craft_assetfolders` (`id`, `parentId`, `sourceId`, `name`, `path`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', NULL, '4', 'Accreditation images', '', '2015-11-25 13:46:10', '2015-11-25 13:46:10', '4ee9bda3-5295-44e3-8423-f162afe1242f');



DROP TABLE IF EXISTS `craft_assetindexdata`;


--
-- Schema for table `craft_assetindexdata`
--
CREATE TABLE `craft_assetindexdata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sessionId` varchar(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sourceId` int(10) NOT NULL,
  `offset` int(10) NOT NULL,
  `uri` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `size` int(10) DEFAULT NULL,
  `recordId` int(10) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_assetindexdata_sessionId_sourceId_offset_unq_idx` (`sessionId`,`sourceId`,`offset`),
  KEY `craft_assetindexdata_sourceId_fk` (`sourceId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_assetsources`;


--
-- Schema for table `craft_assetsources`
--
CREATE TABLE `craft_assetsources` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `settings` text COLLATE utf8_unicode_ci,
  `sortOrder` tinyint(4) DEFAULT NULL,
  `fieldLayoutId` int(10) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_assetsources_name_unq_idx` (`name`),
  UNIQUE KEY `craft_assetsources_handle_unq_idx` (`handle`),
  KEY `craft_assetsources_fieldLayoutId_fk` (`fieldLayoutId`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_assetsources`
--

INSERT INTO `craft_assetsources` (`id`, `name`, `handle`, `type`, `settings`, `sortOrder`, `fieldLayoutId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', 'News Images', 'newsImages', 'Local', '{\"path\":\"{systemPath}\\/assets\\/uploads\\/news-images\\/\",\"url\":\"\\/assets\\/uploads\\/news-images\\/\"}', '1', '24', '2015-11-13 12:07:01', '2015-11-13 12:07:01', '62160689-fc39-4ace-911a-fdf233b50a06');
INSERT INTO `craft_assetsources` (`id`, `name`, `handle`, `type`, `settings`, `sortOrder`, `fieldLayoutId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', 'Treatment Images', 'treatmentImages', 'Local', '{\"path\":\"{systemPath}\\/assets\\/uploads\\/treatment-images\\/\",\"url\":\"\\/assets\\/uploads\\/treatment-images\\/\"}', '2', '25', '2015-11-13 12:10:07', '2015-11-13 12:10:07', '8d815068-711f-4c1a-8087-4642a3558f1f');
INSERT INTO `craft_assetsources` (`id`, `name`, `handle`, `type`, `settings`, `sortOrder`, `fieldLayoutId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', 'About Us Images', 'aboutUsImages', 'Local', '{\"path\":\"{systemPath}\\/assets\\/uploads\\/about-us-images\\/\",\"url\":\"\\/assets\\/uploads\\/about-us-images\\/\"}', '3', '26', '2015-11-13 12:10:46', '2015-11-13 12:10:46', '748cfe10-17ae-4479-b93e-7e3f55e8998e');
INSERT INTO `craft_assetsources` (`id`, `name`, `handle`, `type`, `settings`, `sortOrder`, `fieldLayoutId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', 'Accreditation images', 'accreditationImages', 'Local', '{\"path\":\"{systemPath}\\/assets\\/uploads\\/accreditation-images\\/\",\"url\":\"\\/assets\\/uploads\\/accreditation-images\\/\"}', '4', '102', '2015-11-25 13:46:10', '2015-11-25 13:46:10', '062714fb-b415-43c5-bd83-3f6fc5bda171');



DROP TABLE IF EXISTS `craft_assettransformindex`;


--
-- Schema for table `craft_assettransformindex`
--
CREATE TABLE `craft_assettransformindex` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fileId` int(11) NOT NULL,
  `filename` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `format` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `location` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `sourceId` int(11) DEFAULT NULL,
  `fileExists` tinyint(1) DEFAULT NULL,
  `inProgress` tinyint(1) DEFAULT NULL,
  `dateIndexed` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_assettransformindex_sourceId_fileId_location_idx` (`sourceId`,`fileId`,`location`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_assettransforms`;


--
-- Schema for table `craft_assettransforms`
--
CREATE TABLE `craft_assettransforms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mode` enum('stretch','fit','crop') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'crop',
  `position` enum('top-left','top-center','top-right','center-left','center-center','center-right','bottom-left','bottom-center','bottom-right') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'center-center',
  `height` int(10) DEFAULT NULL,
  `width` int(10) DEFAULT NULL,
  `format` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `quality` int(10) DEFAULT NULL,
  `dimensionChangeTime` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_assettransforms_name_unq_idx` (`name`),
  UNIQUE KEY `craft_assettransforms_handle_unq_idx` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_assettransforms`
--

INSERT INTO `craft_assettransforms` (`id`, `name`, `handle`, `mode`, `position`, `height`, `width`, `format`, `quality`, `dimensionChangeTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', 'Square Large', 'squareLarge', 'crop', 'center-center', '250', '250', NULL, NULL, '2015-11-13 12:12:15', '2015-11-13 12:12:15', '2015-11-13 12:12:15', 'faced37a-ea05-47fd-a070-94eccd5d4b0f');
INSERT INTO `craft_assettransforms` (`id`, `name`, `handle`, `mode`, `position`, `height`, `width`, `format`, `quality`, `dimensionChangeTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', 'Square Thumb', 'squareThumb', 'crop', 'center-center', '75', '75', NULL, NULL, '2015-11-13 12:13:09', '2015-11-13 12:13:09', '2015-11-13 12:13:09', 'd25e0ea0-5622-497b-815e-43e3befd4c49');
INSERT INTO `craft_assettransforms` (`id`, `name`, `handle`, `mode`, `position`, `height`, `width`, `format`, `quality`, `dimensionChangeTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', 'Square Medium', 'squareMedium', 'crop', 'center-center', '135', '135', NULL, NULL, '2015-11-13 12:14:04', '2015-11-13 12:14:04', '2015-11-13 12:14:04', 'acc03a18-e0f0-4ead-8f6f-09868f07cd34');
INSERT INTO `craft_assettransforms` (`id`, `name`, `handle`, `mode`, `position`, `height`, `width`, `format`, `quality`, `dimensionChangeTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', 'Accred Large', 'accredLarge', 'fit', 'center-center', '100', NULL, NULL, '80', '2015-11-25 14:43:26', '2015-11-25 13:50:11', '2015-11-25 14:43:26', '6f931167-2d9f-4084-9dc5-60b819dc1957');
INSERT INTO `craft_assettransforms` (`id`, `name`, `handle`, `mode`, `position`, `height`, `width`, `format`, `quality`, `dimensionChangeTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', 'Accred Small', 'accredSmall', 'fit', 'center-center', '60', NULL, NULL, '80', '2015-11-25 14:43:34', '2015-11-25 13:51:56', '2015-11-25 14:43:34', 'cb48b7ce-90d0-4868-875b-d1ab41c36013');



DROP TABLE IF EXISTS `craft_categories`;


--
-- Schema for table `craft_categories`
--
CREATE TABLE `craft_categories` (
  `id` int(11) NOT NULL,
  `groupId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_categories_groupId_fk` (`groupId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_categorygroups`;


--
-- Schema for table `craft_categorygroups`
--
CREATE TABLE `craft_categorygroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `structureId` int(11) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `hasUrls` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `template` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_categorygroups_name_unq_idx` (`name`),
  UNIQUE KEY `craft_categorygroups_handle_unq_idx` (`handle`),
  KEY `craft_categorygroups_structureId_fk` (`structureId`),
  KEY `craft_categorygroups_fieldLayoutId_fk` (`fieldLayoutId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_categorygroups_i18n`;


--
-- Schema for table `craft_categorygroups_i18n`
--
CREATE TABLE `craft_categorygroups_i18n` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `urlFormat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nestedUrlFormat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_categorygroups_i18n_groupId_locale_unq_idx` (`groupId`,`locale`),
  KEY `craft_categorygroups_i18n_locale_fk` (`locale`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_content`;


--
-- Schema for table `craft_content`
--
CREATE TABLE `craft_content` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_telephone` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_email` text COLLATE utf8_unicode_ci,
  `field_twitter` text COLLATE utf8_unicode_ci,
  `field_mainHeading` text COLLATE utf8_unicode_ci,
  `field_introParagraph` text COLLATE utf8_unicode_ci,
  `field_facebook` text COLLATE utf8_unicode_ci,
  `field_treatmentName` text COLLATE utf8_unicode_ci,
  `field_treatmentDescription` text COLLATE utf8_unicode_ci,
  `field_initialAssessment` text COLLATE utf8_unicode_ci,
  `field_subsequentTreatments` text COLLATE utf8_unicode_ci,
  `field_metaCanonical` text COLLATE utf8_unicode_ci,
  `field_metaDescription` varchar(160) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_metaRobots` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'INDEX, FOLLOW',
  `field_metaTitle` varchar(55) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_article` text COLLATE utf8_unicode_ci,
  `field_headline` varchar(120) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_articleIntro` text COLLATE utf8_unicode_ci,
  `field_googleAnalytics` text COLLATE utf8_unicode_ci,
  `field_references` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_content_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_content_title_idx` (`title`),
  KEY `craft_content_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=85 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_content`
--

INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', '1', 'en_gb', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-04 11:36:29', '2015-11-04 11:36:29', 'cdc2e64a-5488-46b9-8ed8-d3861d90f7a1');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', '2', 'en_gb', 'Homepage', NULL, NULL, NULL, 'Delivering Excellence, Experience and Enthusiasm ', 'Physiotherapy helps to restore movement and function when someone has been affected by injury, work-related problems, illness or disease. It is a science-based profession and takes a ‘whole person’ approach to health and wellbeing, which includes the patient’s general lifestyle. At the core is the patient’s involvement in their own care, through education, awareness, empowerment and participation in their treatment:', NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', NULL, NULL, NULL, NULL, NULL, '2015-11-04 11:36:32', '2015-11-30 12:00:24', '3f42a854-4694-4ba3-94d7-7b332833e272');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', '4', 'en_gb', 'About', NULL, NULL, NULL, 'Providing the best care', 'Excellence, experience and enthusiasm – three qualities which represents cathedral physiotherapy.\r\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy, who is passionate about providing the best possible care. ', NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', NULL, NULL, NULL, NULL, NULL, '2015-11-10 16:22:36', '2015-11-30 11:27:40', '194338b9-92e7-443c-b027-8961c156d05b');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', '5', 'en_gb', 'Accreditations', NULL, NULL, NULL, 'Accreditations', 'You can be assured that the clinic is regulated and governed by the following bodies for your safety.', NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', NULL, NULL, NULL, NULL, NULL, '2015-11-10 16:24:52', '2015-12-01 09:37:27', 'd406bb17-d4f1-424d-81b6-fec342d537cf');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('7', '7', 'en_gb', NULL, '07811 970 007', 'enquiries@cathedralphysiotherapy.co.uk', 'twitter', NULL, NULL, 'https://www.facebook.com/cathedralphysiotherapy', NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, 'UA-70464796-1', NULL, '2015-11-10 16:28:51', '2015-12-01 17:07:15', '08a821e4-a54c-4754-aaa5-f6be184083fb');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('8', '8', 'en_gb', 'Find Us', NULL, NULL, NULL, 'Find Us', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. ', NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', NULL, NULL, NULL, NULL, NULL, '2015-11-13 09:37:14', '2015-11-17 14:20:26', 'b3da8417-3590-4281-a0fe-9abbff806514');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('9', '9', 'en_gb', 'Treatments', NULL, NULL, NULL, 'Treatments', 'Physiotherapy helps to restore movement and function when someone has been affected by injury, work-related problems, illness or disease. It is a science-based profession and takes a ‘whole person’ approach to health and wellbeing, which includes the patient’s general lifestyle. At the core is the patient’s involvement in their own care, through education, awareness, empowerment and participation in their treatment. Please look through the lists below and see how we can help you. ', NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', NULL, NULL, NULL, NULL, NULL, '2015-11-13 09:37:54', '2015-11-23 11:02:48', 'a893733d-7057-4f7c-a679-d7e2622d4c1c');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('14', '14', 'en_gb', 'Fractures', NULL, NULL, NULL, NULL, NULL, NULL, 'Fractures', 'Following a broken bone, the joints around the area will often become stiff and painful, the muscles weak and balance poor. This is easily improved with the advice, manual therapy and exercises provided by Cathedral Physiotherapy.', '£75.00', '£30.00', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:49:40', '2015-11-13 11:50:50', '01e49b58-78fa-4430-91a2-733e5780822f');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('15', '15', 'en_gb', 'Children’s Injuries', NULL, NULL, NULL, NULL, NULL, NULL, 'Children’s Injuries', 'Although many children bounce back quickly after injury, if they are particularly sporty, or have lost their confidence after a sprain, strain or fracture they may need some reassurance and treatment / exercises to return to their previous level of care-free fitness.', '50', '50', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:50:05', '2015-11-26 11:10:39', 'c3e419bc-59d3-4df2-a779-4cd0ad9a62ae');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('16', '16', 'en_gb', 'Young adult hip pain', NULL, NULL, NULL, NULL, NULL, NULL, 'Young adult hip pain', 'Hip pain in young adults can be caused by a number of issues from muscle imbalance around the hip, cartilage problems within the joint, bony anatomical issues or referred pain from the back or pelvis. The excellent clinical reasoning found at Cathedral Physiotherapy will help to differentiate the causes and formulate a treatment plan or onward referral as required. I have worked closely with the Royal Devon and Exeter NHS Hospital hip consultants with patients with femoral acetabular impingement in particular, including being involved in research, and so am at the cutting edge of treating this group of patients.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:51:14', '2015-11-13 11:51:14', '7b83d3d0-838f-45b9-9c9b-ee2a7979300d');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('17', '17', 'en_gb', 'Sports Injuries', NULL, NULL, NULL, NULL, NULL, NULL, 'Sports Injuries', 'Whether you are after prevention or cure, Cathedral Physiotherapy can help you. Excellent assessment will ensure that you receive the treatment you require, be it a combination of functional exercise, manual therapy, ultrasound, taping or acupuncture. We have a small exercise area in the clinic, but can also adapt your training program for your to rehabilitate at your own gym / pool.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:51:34', '2015-11-13 11:51:34', 'ee09166b-3e8b-4106-9518-66b2c6046616');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('18', '18', 'en_gb', 'Haemophilia', NULL, NULL, NULL, NULL, NULL, NULL, 'Haemophilia', 'For those individuals diagnosed with haemophilia, early access to physiotherapy is crucial following a bleed. This is a niche area that Sarah has worked in as the designated haemophilia physiotherapy specialist at the Royal Devon and Exeter hospital over the last few years, so you can be assured that you are in safe hands', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:51:51', '2015-11-13 11:51:51', '36a32843-d4b7-443b-8e03-6dc45bc23720');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('19', '19', 'en_gb', 'Work-related pain', NULL, NULL, NULL, NULL, NULL, NULL, 'Work-related pain', 'Whether you work at a desk all day, or prune trees for a living, at some point during your working life you are likely to suffer from pain related to your occupation. In fact, 60% of people on long term sick leave cite musculoskeletal disorders as the cause. Rapid access to musculoskeletal physiotherapy can reduce the amount of time people are off sick, and it is vital in preventing a new acute problem becoming chronic and long lasting (Department of health, 2008).', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:53:14', '2015-11-19 14:54:27', 'ccd1d574-9934-4d27-a886-081e8d1302bf');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('20', '20', 'en_gb', 'Sprains and Strains', NULL, NULL, NULL, NULL, NULL, NULL, 'Sprains and Strains', 'Minor sprains and strains can be managed with PRICE therapy:\r\nProtect the area using a support temporarily, Rest the are for the first 48-72 hrs, apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin), Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow and remove the bandage before sleep, Elevate the injured area, supported on a pillow, to reduce the swelling. Ultrasound and taping can also promote healing. Following this we will help rehabilitate you range of movement, strength and balance so that you return to your full function.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:53:29', '2015-11-13 11:53:29', '12d2c043-a149-4963-b6a0-8f2a3e68ebd7');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('21', '21', 'en_gb', 'Back Pain', NULL, NULL, NULL, NULL, NULL, NULL, 'Back Pain', 'Low back pain is reported by 80% of people at sometime in their life. A large percentage of this will improve with basic advice and exercises, but some people need more specific treatment (work-related advice, functional exercises, manual therapy, or acupuncture). Come and be assessed today so that we can help you on your road to recovery, and to help prevent recurrence.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:53:48', '2015-11-13 11:53:48', '09348420-db42-4916-981a-7fe3a098f909');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('22', '22', 'en_gb', 'Neck Pain', NULL, NULL, NULL, NULL, NULL, NULL, 'Neck Pain', 'Neck pain is common but most cases aren’t caused by a serious problem. Some people get it after an accident or injury, whilst others find it appears if they are stressed, or inactive, or it can be related to age-related changes in the structures of the neck. Commonly felt locally in the neck, it can also refer to the shoulder / arm, and sometimes may cause pins and needles / numbness. With good advice, reassurance, specific exercises and sometimes manual therapy, the majority of neck pain improved within about six weeks.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:54:01', '2015-11-13 11:54:01', 'afb94a30-3336-4faf-a80b-2184c231de13');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('23', '23', 'en_gb', 'Shoulder / Elbow / Wrist pain', NULL, NULL, NULL, NULL, NULL, NULL, 'Shoulder / Elbow / Wrist pain', 'Whether your pain is work or hobby related it is important to get the correct advice early to prevent chronicity. Arm pain can be referred from the neck, but is more commonly related to impingement of the tendons, or tears of the muscle, but can also be due to ‘frozen shoulder’. Elbow complaints include tennis elbow, golfers elbow, or nerve irritation. Wrist pain is commonly related to the position of the wrist at work or during hobbies, but can be due to stiffness post fracture, or carpal tunnel syndrome. An excellent assessment will differentiate the problem and help you to manage and improve your symptoms.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:54:15', '2015-11-13 11:54:15', '63ca38ce-1fe7-4381-a748-8af618eb8ca2');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('24', '24', 'en_gb', 'Hip / Knee / Ankle pain', NULL, NULL, NULL, NULL, NULL, NULL, 'Hip / Knee / Ankle pain', 'Hip pain - Problems with cartilage, early osteoarthritis, tendonopathy, sprains and muscle imbalances can all cause hip pain, but it can also be referred from the back. Accurate assessment is crucial to ensure you have the right treatment to improve your problem.\r\n\r\nKnee pain – Be it local pain, swelling or stiffness secondary to an acute injury to the ligaments of the joint, more insidious in nature, or referred pain, once diagnosed, the majority of problems will significantly improve with a specific functional exercise program, but if necessary it can also be treated with manual therapy, ultrasound, taping or acupuncture too.\r\n\r\nAnkle pain – The majority of people have sustained a sprained ankle at some point, and we can offer acute treatment for this with ultrasound, soft tissie therapy, taping and exercises. However, we rely on our legs heavily, and the key is to prevent it recurring again through specific rehabilitation, so that you can stay as fit and active as you wish.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:54:33', '2015-11-13 11:55:11', '66bcb9ee-7ba1-42fc-89aa-88521de2358a');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('25', '25', 'en_gb', 'Orthopaedic post operative care', NULL, NULL, NULL, NULL, NULL, NULL, 'Orthopaedic post operative care', 'Come to Cathedral Physiotherapy for your post operative care. Be it following a fracture, ligament reconstruction, hip arthroscopy, or joint replacement we can help you regain your independence. Having worked at the Royal Devon and Exeter hospital for the last 11 years I have strong links with the orthopaedic teams there.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:55:27', '2015-11-13 11:55:27', '5fa90a10-3b26-4d61-9109-778cba1fb806');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('26', '26', 'en_gb', 'Post fracture rehabilitation', NULL, NULL, NULL, NULL, NULL, NULL, 'Post fracture rehabilitation', 'It is quite common to have on-going problems with pain, swelling and stiffness in the joints surrounding the area where you have fractured. However the real issue, is that people often lose their confidence too. Let us rehabilitate you back to your previous level of function or fitness allowing you to live your life to the full.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:55:43', '2015-11-13 11:55:43', '2f78381e-15a0-45f5-859c-cdf61f95f01a');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('27', '27', 'en_gb', 'Non specific arm pain', NULL, NULL, NULL, NULL, NULL, NULL, 'Non specific arm pain', 'Characterised by ongoing pain, altered sensations in the hand / arm and sometime feelings of weakness, this can be a frustrating condition to have, particularly as commonly many objective medical test are negative. Often, modifications to posture, work stations, gaining an understanding of pain mechanisms, and local tissues techniques can improve symptoms and function.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:55:55', '2015-11-13 11:55:55', '4a41efc2-0eb2-47ed-a296-e3dc4bbe6fef');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('28', '28', 'en_gb', 'Thoracic Outlet Syndrome', NULL, NULL, NULL, NULL, NULL, NULL, 'Thoracic Outlet Syndrome', 'Characterised by neck / shoulder / arm pain, feelings of weakness in the arm (particularly with overhead activities), and possible discolouration of the hand, this condition can be debilitating. With good quality conservative physiotherapy, symptoms and function can be significantly improved, thereby improving your quality of life.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:56:08', '2015-11-13 11:56:08', 'b3a7fcae-32f9-4da3-bcf5-0c01dbdef7ef');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('29', '29', 'en_gb', 'Headaches and Dizziness', NULL, NULL, NULL, NULL, NULL, NULL, 'Headaches and Dizziness', 'Benign headaches can be caused by tension in the muscles, stiffness in the neck or muscle imbalance. Often characterised by being one-sided, or in a band around the head, and associated with neck pain, or certain movements, symptoms can be improved significantly with a combination of exercise, manual therapy, acupuncture and an understanding of pain pathways.\r\n\r\nDizziness can be generated from the neck, the inner ear or the brain, and accurate differential diagnosis is crucial for appropriate treatment.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:56:26', '2015-11-13 11:56:26', '53c523b7-a916-40ac-9018-751b8d28b01f');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('30', '30', 'en_gb', 'Pregnancy related pain', NULL, NULL, NULL, NULL, NULL, NULL, 'Pregnancy related pain', 'Pregnancy related pelvic girdle pain is common and affects 1 in 5 women during their pregnancy. There are a wide range of symptoms, some of which improve naturally during the course of the pregnancy as your body adapts, some which need advice and /or treatment early on to keep you as active as possible. Don’t suffer in silence, get help early.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:56:42', '2015-11-13 11:56:42', '06133882-461d-4777-b514-1408d93a492e');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('31', '31', 'en_gb', 'Management of long term conditions', NULL, NULL, NULL, NULL, NULL, NULL, 'Management of long term conditions', 'Some people are diagnosed with long term conditions, be it persistent pain generated by the nervous system, or on-going musculoskeletal problems following a car crash. At Cathedral Physiotherapy we believe in working with you to assist you to maximise your physical potential. ', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:56:55', '2015-11-13 11:56:55', '85693cb4-1852-437d-8c78-10da2ce56a3d');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('32', '32', 'en_gb', 'Rheumatological conditions', NULL, NULL, NULL, NULL, NULL, NULL, 'Rheumatological conditions', 'Although consisting of a variety of diagnosis, for instance Rheumatoid Arthritis, Ankylosing Spondylitis, Psoriatic Arthritis etc, many of these diseases follow a period of flare and recovery. At Cathedral Physiotherapy we can help you not to be defined by your diagnosis, assist you through your flares, and maximise your return to function so that you continue to lead and full and fruitful life.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:57:11', '2015-11-13 11:57:11', '6b403b34-56fe-4245-9fe8-2d1269d1413d');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('33', '33', 'en_gb', 'Osteoarthritis', NULL, NULL, NULL, NULL, NULL, NULL, 'Osteoarthritis', 'Osteoarthritis is a common type of arthritis, a painful condition which can affect the joints especially the hips, knees, neck, lower back, hand or feet. Although it can occur at any age, it is more likely to appear between the ages of 45-75 years, and often in women more than men. There is much evidence showing that a combination of non steroidal anti-inflammatories and exercise or physiotherapy will help to reduce the symptoms of pain and stiffness, allowing you not to be restricted by your symptoms.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:57:28', '2015-11-13 11:57:28', 'a92238a8-39c4-4849-b694-fccb83ff4090');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('34', '34', 'en_gb', 'Joint Replacements', NULL, NULL, NULL, NULL, NULL, NULL, 'Joint Replacements', 'Following total or partial knee replacement, hip replacement or shoulder replacement, good quality regular physiotherapy is important to decrease swelling and pain and increase range of movement, muscle power and function. We are a lower ground premises, therefore you need to be able to complete one flight of stairs, however if access is an issue, contact us and we will discuss the possibility of a domiciliary visit.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:57:39', '2015-11-13 11:57:39', '2491d6c8-906e-4c71-82ee-ded09473bfb0');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('35', '35', 'en_gb', 'Osteoporosis', NULL, NULL, NULL, NULL, NULL, NULL, 'Osteoporosis', 'Having been the principle investigator for Exeter on the PROVE trial (2014-16) looking into rehabilitation of patients with osteoporosis who have vertebral fractures, I am well qualified to help you manage your condition, and to keep you as fit and active as possible.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:57:51', '2015-11-13 11:57:51', '99629008-2494-480f-833b-1d3a95cc1571');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('36', '36', 'en_gb', 'Post Cancer Rehabilitation', NULL, NULL, NULL, NULL, NULL, NULL, 'Post Cancer Rehabilitation', 'Most people are so relieved to have stopped the active stage of their treatment, be it radiotherapy or chemotherapy, that they are happy to live with compromises in function for a time. However, it is common to become frustrated with these compromises once your energy returns. We passionately  believe that you should not be defined by your diagnosis, and will work hard with you to facilitate and maximise your return to function; be it to improve your shoulder range of movement post breast surgery so that you can reach the top cupboards, or return to tennis and swimming again.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:58:03', '2015-11-13 11:58:03', '940d275b-aaff-4f6b-bca1-de3fc58fa9d5');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('37', '37', 'en_gb', 'Mild Continence Issues', NULL, NULL, NULL, NULL, NULL, NULL, 'Mild Continence Issues', 'Bladder or bowel continence issues can be embarrassing, but when it is only a mild issue much can be done with pelvic floor exercises and fluid intake management. We can happily treat mild continence issues e.g. post pregnancy, or stress incontinence related to respiratory problems. If we feel your continence issues need further input, then we will refer you on to the appropriate practitioner.', '', '', NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 11:58:20', '2015-11-13 11:58:20', '381d3c68-044e-4cc4-9807-a7c130d8d5c5');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('38', '41', 'en_gb', 'sport-woman', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 12:48:48', '2015-11-13 12:48:48', 'fe843625-e9ba-44af-bf9a-8b21b2cfc63c');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('39', '43', 'en_gb', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 12:54:44', '2015-11-13 12:57:48', '5bd69d99-8707-4fbe-8e8b-7128d8e66e25');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('40', '47', 'en_gb', 'News', NULL, NULL, NULL, 'Latest News', 'Welcome to our news page which includes information from self-help advice for what to do as soon as you’ve hurt yourself, to topical items in the news, and copies of our monthly news letter. There are also a number of useful links to u-tube clips which we feel are useful. If there is something that isn’t here and you would like to see, then please email us as enquiries@cathedralphysiotherapy.co.uk and we will do our best to respond to your suggestions.', NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', NULL, NULL, NULL, NULL, NULL, '2015-11-13 14:41:24', '2015-11-23 11:03:29', '1bd8b52e-56e8-49ab-ba79-dfee0d7e1185');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('41', '48', 'en_gb', 'Joint-Pain', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 15:22:50', '2015-11-13 15:22:50', '6c1c4498-a4cb-4642-b8cd-5c74ea4f20e7');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('42', '49', 'en_gb', 'Winter Chills', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', 'During the winter months aches and pains in joints can feel more painful and make getting up in the morning painful. Our specialities include treatment of injuries and conditions related to the joints and can help reduce pain, swelling and discomfort.\r\n\r\nSed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen', 'Winter Chills', 'This is the intro to the article in a short sentence.', NULL, NULL, '2015-11-13 15:22:59', '2015-11-23 11:17:51', '9251985d-9ef6-4b6d-9963-677a45de3b09');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('43', '50', 'en_gb', 'Muscle Pain', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', 'This is a test news article about nothing in particular. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen', 'Muscle Pain', 'This is the intro to the article in a short sentence.', NULL, NULL, '2015-11-13 15:43:34', '2015-11-23 11:17:46', '6ddf17f6-ece3-442f-a303-f70e931fe8ad');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('44', '51', 'en_gb', 'banner', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-13 15:44:50', '2015-11-13 15:44:50', 'ed1f283d-ae87-40d6-9acc-ede31d7053d5');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('45', '56', 'en_gb', 'sarah-profile', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-17 12:00:36', '2015-11-17 12:00:36', '28d0f794-b9cf-43d8-9970-13225e8bd5bb');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('46', '57', 'en_gb', 'Pricing', NULL, NULL, NULL, 'Pricing', 'At Cathedral Physiotherapy we like to keep things simple, so we only have two prices, regardless of the treatment you are having at the clinic: New appointments last an hour and cost £45\r\nFollow up appointments last ½ an hour and cost £35.', NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', NULL, NULL, NULL, NULL, NULL, '2015-11-17 14:07:49', '2015-12-01 17:22:07', 'd9c4f205-6bbe-4e6f-adc3-42f5b00f7d60');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('47', '58', 'en_gb', 'Testimonials', NULL, NULL, NULL, 'Placeholder heading for testimonials', 'Placeholder text for testimonials intro paragraph', NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', NULL, NULL, NULL, NULL, NULL, '2015-11-17 14:17:42', '2015-11-30 09:13:28', '043de98f-b546-4b71-a24c-4a72dd1d000b');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('48', '61', 'en_gb', 'Work and Social', NULL, NULL, NULL, 'Work & Social', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. ', NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', NULL, NULL, NULL, NULL, NULL, '2015-11-17 16:40:59', '2015-11-25 12:05:55', '35e51c3d-61de-4721-b440-ffbee5b8b87a');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('49', '62', 'en_gb', 'Young and Active', NULL, NULL, NULL, 'Young & Active', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec.', NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', NULL, NULL, NULL, NULL, NULL, '2015-11-17 16:41:18', '2015-11-23 10:26:04', '5e05d991-b3ca-4130-b355-5cc6bde7c0d0');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('50', '63', 'en_gb', 'Lifetime Support', NULL, NULL, NULL, 'Lifetime Support', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. ', NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', NULL, NULL, NULL, NULL, NULL, '2015-11-17 16:41:32', '2015-12-01 09:52:45', '94c3355b-4f81-42a5-a813-22cd9c11d33d');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('51', '64', 'en_gb', 'sports-injury-2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-19 11:37:55', '2015-11-19 11:37:55', '20d55244-3137-49cd-a068-cfe97e3bfc61');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('52', '65', 'en_gb', 'Sports injuries', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', 'Tips for treating sports injuries immediately after they happen. Use ice to reduce swelling. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen', 'Sports injuries', 'This is the intro to the article in a short sentence.', NULL, NULL, '2015-11-19 11:38:01', '2015-11-23 11:17:41', '674a5d5e-03c2-448a-b51d-c7c963360fda');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('53', '66', 'en_gb', 'back-pain.gif-437580', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-19 11:39:40', '2015-11-19 11:39:40', '4511ed01-11f3-4545-a6d1-279a7137ffcb');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('54', '67', 'en_gb', 'istock rf photo of arthritis pain in hand', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-19 11:39:49', '2015-11-19 11:39:49', '7a1f01cb-8c6f-48f6-adf4-0bbedc1d6163');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('55', '68', 'en_gb', 'Back pain tips', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', 'Mobilise your back, go swimming etc etc Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen', 'Back pain tips', 'This is the intro to the article in a short sentence.', NULL, NULL, '2015-11-19 11:39:54', '2015-11-23 11:17:34', '1d163bc0-1b25-4ab2-bee9-24f1953bbb4b');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('56', '69', 'en_gb', 'Arthritis', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', 'We can help you manage the pain a recommend techniques to reduce the debilitating effects. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen', 'Arthritis', 'This is the intro to the article in a short sentence.', NULL, NULL, '2015-11-19 11:41:01', '2015-11-23 11:17:25', 'a95b0476-f9f6-41de-ae86-15db3474f8ae');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('57', '70', 'en_gb', 'Tennis-Elbow', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-19 11:42:57', '2015-11-19 11:42:57', 'b8e7999d-f41e-4000-b842-12895573fe5f');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('58', '71', 'en_gb', 'Preventing tennis elbow', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', '', 'Preventing tennis elbow', 'This is the intro to the article in a short sentence.', NULL, '', '2015-11-19 11:43:00', '2015-11-30 11:26:36', '7aa8df85-8c90-4e33-b848-66e6243f75e2');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('59', '72', 'en_gb', 'Test article', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi venenatis eros nunc, at venenatis nibh gravida nec. Donec tincidunt lectus vel bibendum auctor. Aenean congue aliquam turpis, ac scelerisque elit consequat ut. Fusce at metus congue, mattis quam in, eleifend metus. Sed ipsum ipsum, ultricies vel sem nec, ultricies fringilla purus. Fusce a tortor eget lorem dapibus placerat. Aenean ut arcu in lorem finibus sagittis. Suspendisse venenatis, urna ut tempus finibus, mauris dui malesuada lectus, at mattis tortor lorem nec purus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi venenatis eros nunc, at venenatis nibh gravida nec. ', 'Test article', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi venenatis eros nunc, at venenatis.', NULL, '', '2015-11-23 11:39:56', '2015-11-30 09:50:13', 'ffe324a1-3e40-4a3c-8b12-0a3bfd81416e');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('60', '73', 'en_gb', 'Another Test Article', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', '', 'Another Test Article', 'Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro.', NULL, '', '2015-11-23 15:09:12', '2015-11-30 09:49:34', '8a45b374-3b9f-495c-ad71-bab978946eb2');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('61', '76', 'en_gb', 'lifetime-couple', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-25 12:05:47', '2015-11-25 12:05:47', '0994bf62-47d9-4c54-9824-61ceaf03dc37');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('62', '77', 'en_gb', 'work-man', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-25 12:05:48', '2015-11-25 12:05:48', '0b4ee9a3-4839-4c86-becf-7a53f2d996c4');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('63', '78', 'en_gb', '6f14d766-8edf-4b3c-b385-96bfed558d4c', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-25 14:01:01', '2015-11-25 14:01:01', 'e9f10ca0-752d-45f7-bc40-404b8707c00e');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('64', '79', 'en_gb', 'hpc-logo-registered', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-25 14:01:02', '2015-11-25 14:01:02', '4c01519e-b920-4272-8a93-84d506185c65');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('65', '80', 'en_gb', 'imgres', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-25 14:01:03', '2015-11-25 14:01:03', 'f798ca60-ee14-4f16-a629-01b148be61dd');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('66', '81', 'en_gb', '6f14d766-8edf-4b3c-b385-96bfed558d4c 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-25 14:04:57', '2015-11-25 14:04:57', 'e0da7225-94ec-4ebb-9de3-60c14106b11d');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('67', '82', 'en_gb', 'BMAS-logo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-25 14:04:58', '2015-11-25 14:04:58', 'db56255b-d4b1-4ffb-9dff-a9e092ce4df3');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('68', '83', 'en_gb', 'hpc-logo-registered 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-25 14:04:58', '2015-11-25 14:04:58', '94204398-a77f-493e-bdc3-ea7f426b0637');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('69', '84', 'en_gb', 'imgres 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-25 14:04:59', '2015-11-25 14:04:59', '98c0635f-aef8-4bdb-8828-81eaa357ba71');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('70', '89', 'en_gb', 'BMAS-footer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-25 14:20:36', '2015-11-25 14:20:36', 'c59bf0b5-cdde-4d3d-af3f-e4343f78965a');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('71', '90', 'en_gb', 'csp-footer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-25 14:20:37', '2015-11-25 14:20:37', '4206be31-658c-4b4f-8b2b-da71f56f9a5e');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('72', '91', 'en_gb', 'hpc-footer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-25 14:20:38', '2015-11-25 14:20:38', '3c81457d-027b-417b-9294-01a8a73ebc30');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('73', '92', 'en_gb', 'physio-footer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-25 14:20:38', '2015-11-25 14:20:38', '8accac6c-6d83-4f69-a0fb-25ec3be785a9');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('74', '93', 'en_gb', 'physiofirst-footer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-25 14:20:39', '2015-11-25 14:20:39', 'aad1ce09-1a31-4a60-aaa8-36ec1f44780c');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('75', '94', 'en_gb', 'BMAS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-25 15:12:52', '2015-11-25 15:12:52', '7af3c9aa-588a-4d15-9e1c-241a886b3d4f');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('76', '95', 'en_gb', 'csp', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-25 15:12:52', '2015-11-25 15:12:52', 'c16f1f46-1174-455b-9bd5-35960382516c');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('77', '96', 'en_gb', 'hpc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-25 15:12:53', '2015-11-25 15:12:53', '0b6b09f3-25cb-4d62-9444-1aa40e938e83');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('78', '97', 'en_gb', 'physio-first', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-25 15:12:54', '2015-11-25 15:12:54', '49ea1925-42f4-47ed-9ec8-ee49ef006d35');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('79', '99', 'en_gb', 'Ouch…I’ve hurt my back…', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', '', 'Ouch…I’ve hurt my back…', 'Getting the low down on what to do when you’ve hurt your back…', NULL, 'References: O’Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.', '2015-11-26 13:59:16', '2015-11-26 15:00:31', '4fc7a609-9ae8-4c22-96a5-17bec33cb807');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('80', '109', 'en_gb', 'Media comment: November', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', 'INDEX, FOLLOW', '', '', 'Media comment: November', 'As we look forward to Christmas and ahead to 2016, we will inevitably get thinking about those dreaded ‘New Year Resolutions’. Why not take a longer term approach to your health rather than the ‘boom and bust’ which often occurs as people go out to buy their new trainers in Jan, and then come across them under the woolly hats and gloves in the cupboard under the stairs whilst spring cleaning!', NULL, '', '2015-11-30 09:23:57', '2015-11-30 09:23:57', 'f6ed7a91-644a-4806-823f-16ee6bd65c9b');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('81', '118', 'en_gb', 'wZGX w9OUblVAajGCKA uVWPWyL6HkG jN0-gWjOUi4PvDzBhTAFO1L9eafkc8sWHdBTdK2xjDQUrDgK7sjl8A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-11-30 11:27:33', '2015-11-30 11:27:33', '8cfe7672-9cb1-4bcd-8c1b-d8e11726fa3f');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('82', '119', 'en_gb', 'MACP logo reverse', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-12-01 09:37:00', '2015-12-01 09:37:00', '1c745bfc-266b-4912-a7bc-7891577a6f53');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('83', '120', 'en_gb', 'MACP logo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-12-01 09:37:14', '2015-12-01 09:37:14', '57848551-7fb3-4637-ba6f-43762e57e966');
INSERT INTO `craft_content` (`id`, `elementId`, `locale`, `title`, `field_telephone`, `field_email`, `field_twitter`, `field_mainHeading`, `field_introParagraph`, `field_facebook`, `field_treatmentName`, `field_treatmentDescription`, `field_initialAssessment`, `field_subsequentTreatments`, `field_metaCanonical`, `field_metaDescription`, `field_metaRobots`, `field_metaTitle`, `field_article`, `field_headline`, `field_articleIntro`, `field_googleAnalytics`, `field_references`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('84', '124', 'en_gb', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'INDEX, FOLLOW', NULL, NULL, NULL, NULL, NULL, NULL, '2015-12-01 17:25:21', '2015-12-01 17:35:02', '3529005f-4c1e-4c72-a19e-5b1b127c6b2d');



DROP TABLE IF EXISTS `craft_deprecationerrors`;


--
-- Schema for table `craft_deprecationerrors`
--
CREATE TABLE `craft_deprecationerrors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fingerprint` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `lastOccurrence` datetime NOT NULL,
  `file` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `line` smallint(6) unsigned NOT NULL,
  `class` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `method` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `templateLine` smallint(6) unsigned DEFAULT NULL,
  `message` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `traces` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_deprecationerrors_key_fingerprint_unq_idx` (`key`,`fingerprint`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_elements`;


--
-- Schema for table `craft_elements`
--
CREATE TABLE `craft_elements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `archived` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_elements_type_idx` (`type`),
  KEY `craft_elements_enabled_idx` (`enabled`),
  KEY `craft_elements_archived_dateCreated_idx` (`archived`,`dateCreated`)
) ENGINE=InnoDB AUTO_INCREMENT=125 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_elements`
--

INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', 'User', '1', '0', '2015-11-04 11:36:29', '2015-11-04 11:36:29', 'd3cb7d89-fd5c-4f18-8487-f8774c62b2af');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', 'Entry', '1', '0', '2015-11-04 11:36:32', '2015-11-30 12:00:24', '7de79665-1e51-4ea9-8482-c5427b3965c5');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', 'Entry', '1', '0', '2015-11-10 16:22:36', '2015-11-30 11:27:40', '2153f411-6a2a-4523-9fc9-8a52434333bf');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', 'Entry', '1', '0', '2015-11-10 16:24:52', '2015-12-01 09:37:27', 'f1a1f413-56fe-4c1b-a893-bbd25abc6a90');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('7', 'GlobalSet', '1', '0', '2015-11-10 16:28:51', '2015-12-01 17:07:15', '4e655f9d-7f0c-4db6-8c4f-fa15ac91d707');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('8', 'Entry', '1', '0', '2015-11-13 09:37:14', '2015-11-17 14:20:26', '6b26386f-9dec-4c8e-b268-a02f99c644f3');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('9', 'Entry', '1', '0', '2015-11-13 09:37:54', '2015-11-23 11:02:48', '3b165632-afba-41a1-8ee7-d449ad15ed26');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('14', 'Entry', '1', '0', '2015-11-13 11:49:40', '2015-11-13 11:50:50', '71d17424-be16-4761-b8cc-899bc7928d44');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('15', 'Entry', '1', '0', '2015-11-13 11:50:05', '2015-11-26 11:10:39', 'e3d0a78a-88cc-42dd-9860-5b10d096f7e5');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('16', 'Entry', '1', '0', '2015-11-13 11:51:14', '2015-11-13 11:51:14', '6b5f272f-9af4-46c0-890a-d20283de0878');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('17', 'Entry', '1', '0', '2015-11-13 11:51:34', '2015-11-13 11:51:34', '14c0a3a2-cd9f-4a41-bfea-abbe61af8d68');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('18', 'Entry', '1', '0', '2015-11-13 11:51:51', '2015-11-13 11:51:51', '41799bb8-ed04-44fa-b299-26acf5f49c4f');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('19', 'Entry', '1', '0', '2015-11-13 11:53:14', '2015-11-19 14:54:27', 'b5bf655a-cf16-409f-be02-953d780f4f99');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('20', 'Entry', '1', '0', '2015-11-13 11:53:29', '2015-11-13 11:53:29', 'b755b202-2d39-499f-9b6e-5948fe2ffe0b');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('21', 'Entry', '1', '0', '2015-11-13 11:53:48', '2015-11-13 11:53:48', 'fda1a574-9e0f-47fa-ba9b-6edb21c23871');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('22', 'Entry', '1', '0', '2015-11-13 11:54:01', '2015-11-13 11:54:01', '9b2af7f0-19c7-4b65-83be-bfece196b909');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('23', 'Entry', '1', '0', '2015-11-13 11:54:15', '2015-11-13 11:54:15', '8b1e8ba6-9b23-4e5e-8ebf-c184350761af');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('24', 'Entry', '1', '0', '2015-11-13 11:54:33', '2015-11-13 11:55:11', '324e1e29-fb40-43e4-b12a-9f859e490c19');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('25', 'Entry', '1', '0', '2015-11-13 11:55:27', '2015-11-13 11:55:27', '0a0e31a5-a163-4940-a738-1735637bcc5e');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('26', 'Entry', '1', '0', '2015-11-13 11:55:43', '2015-11-13 11:55:43', '2e290be7-a46c-499c-8154-d41976e82a65');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('27', 'Entry', '1', '0', '2015-11-13 11:55:55', '2015-11-13 11:55:55', '9d88aeed-ddd3-4f27-b283-4255c225497c');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('28', 'Entry', '1', '0', '2015-11-13 11:56:08', '2015-11-13 11:56:08', '18896305-5a70-499f-82b9-c8b0321e333c');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('29', 'Entry', '1', '0', '2015-11-13 11:56:26', '2015-11-13 11:56:26', 'c1bca228-d7df-447b-ae6e-1b4a6d8abd1f');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('30', 'Entry', '1', '0', '2015-11-13 11:56:42', '2015-11-13 11:56:42', '21e0e064-3e75-4426-84ca-58f3d69ccbde');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('31', 'Entry', '1', '0', '2015-11-13 11:56:55', '2015-11-13 11:56:55', 'c1a082bc-3112-4abd-ac0c-994cf02386f2');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('32', 'Entry', '1', '0', '2015-11-13 11:57:11', '2015-11-13 11:57:11', '5c78c24c-0c27-40ad-943a-395897510404');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('33', 'Entry', '1', '0', '2015-11-13 11:57:28', '2015-11-13 11:57:28', '9e87781d-35b9-4527-8be0-23c73a328613');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('34', 'Entry', '1', '0', '2015-11-13 11:57:39', '2015-11-13 11:57:39', '7cc0a69c-4310-4ff2-a0ae-2e80cf752ad2');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('35', 'Entry', '1', '0', '2015-11-13 11:57:51', '2015-11-13 11:57:51', '5e7fe080-26b5-46f9-a25f-215b77691ffc');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('36', 'Entry', '1', '0', '2015-11-13 11:58:03', '2015-11-13 11:58:03', '7f73df69-23b9-4ff3-a092-6a6cc2dedbf4');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('37', 'Entry', '1', '0', '2015-11-13 11:58:20', '2015-11-13 11:58:20', '19ae12b3-10ec-4ea1-a92d-19cf915f90f8');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('41', 'Asset', '1', '0', '2015-11-13 12:48:48', '2015-11-13 12:48:48', 'f8860207-2dea-4e59-ad0e-c618e580277d');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('42', 'MatrixBlock', '1', '0', '2015-11-13 12:54:30', '2015-12-01 17:07:15', 'bc5c14fc-f155-48c2-8a6f-5fb9ac66a5ab');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('43', 'GlobalSet', '1', '0', '2015-11-13 12:54:44', '2015-11-13 12:57:48', '732b31f4-193e-4d74-877a-96bf1c2b7999');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('44', 'MatrixBlock', '1', '0', '2015-11-13 12:57:48', '2015-11-13 12:57:48', 'fa597e40-0a47-4d34-b28b-810bfc0a7af0');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('45', 'MatrixBlock', '1', '0', '2015-11-13 12:57:48', '2015-11-13 12:57:48', '68db6c8a-0281-4ed2-ac5b-7a8666ecf869');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('46', 'MatrixBlock', '1', '0', '2015-11-13 12:57:48', '2015-11-13 12:57:48', '534f5673-2912-435b-aae5-0c33de8a5a15');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('47', 'Entry', '1', '0', '2015-11-13 14:41:24', '2015-11-23 11:03:29', 'b943207e-c47b-4d0b-b745-396182e0cddb');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('48', 'Asset', '1', '0', '2015-11-13 15:22:50', '2015-11-13 15:22:50', '0ad7ebf9-bcb3-4e15-bef6-69f85e5fe33c');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('49', 'Entry', '1', '0', '2015-11-13 15:22:59', '2015-11-23 11:17:51', '539f8985-875f-484f-b978-a521eb602f8e');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('50', 'Entry', '1', '0', '2015-11-13 15:43:34', '2015-11-23 11:17:46', '5682680f-1d0f-46c3-8632-ea4f73752673');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('51', 'Asset', '1', '0', '2015-11-13 15:44:50', '2015-11-13 15:44:50', 'c4a7b67a-fd0f-4cc6-badd-77b94b494686');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('52', 'MatrixBlock', '1', '0', '2015-11-17 11:20:23', '2015-11-30 11:27:40', '5aa38e5e-9dcf-4790-8f91-69eee2103624');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('53', 'MatrixBlock', '1', '0', '2015-11-17 11:20:23', '2015-11-30 11:27:40', '5ddeb920-d4c4-4bcc-826f-479232eab327');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('54', 'MatrixBlock', '1', '0', '2015-11-17 11:20:23', '2015-11-30 11:27:40', 'c1a1a9b8-a6ef-441b-870f-2e2b59c329c1');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('55', 'MatrixBlock', '1', '0', '2015-11-17 11:20:23', '2015-11-30 11:27:40', '7c14eeb4-ebc1-4010-94ea-bf02705140df');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('56', 'Asset', '1', '0', '2015-11-17 12:00:36', '2015-11-17 12:00:36', '10ff3705-676d-4a33-ba6b-3979b7e2369d');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('57', 'Entry', '1', '0', '2015-11-17 14:07:49', '2015-12-01 17:22:07', '41bcaea2-aa0f-4c1f-a6f6-1a0520e010a4');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('58', 'Entry', '1', '0', '2015-11-17 14:17:42', '2015-11-30 09:13:28', '00202e9c-5e91-4f33-853d-7c7411f2d0cd');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('59', 'MatrixBlock', '1', '0', '2015-11-17 15:45:10', '2015-11-30 09:13:28', '4c73d7c8-2093-4c54-9009-6baa2f4d18d3');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('60', 'MatrixBlock', '1', '0', '2015-11-17 15:45:10', '2015-11-30 09:13:28', '4bd19695-af28-480a-ac96-6c8ff7190346');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('61', 'Entry', '1', '0', '2015-11-17 16:40:59', '2015-11-25 12:05:55', '988b7487-9b18-43cf-9f89-5e8b6bbdde62');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('62', 'Entry', '1', '0', '2015-11-17 16:41:18', '2015-11-23 10:26:04', '9bf30a7c-d17c-485c-b560-b463aad508c6');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('63', 'Entry', '1', '0', '2015-11-17 16:41:32', '2015-12-01 09:52:45', '16bcba56-9bfd-4d43-8273-9e59ed03b406');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('64', 'Asset', '1', '0', '2015-11-19 11:37:55', '2015-11-19 11:37:55', '29546b59-240f-4c38-81af-1d753dfa6dc6');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('65', 'Entry', '1', '0', '2015-11-19 11:38:01', '2015-11-23 11:17:41', 'fdee9129-9bfa-4ee7-b1ce-b9157cfa2dff');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('66', 'Asset', '1', '0', '2015-11-19 11:39:40', '2015-11-19 11:39:40', '57033de6-ae1b-45f2-993e-606c4892047e');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('67', 'Asset', '1', '0', '2015-11-19 11:39:49', '2015-11-19 11:39:49', '9badd336-967e-4d58-a739-669419fd229a');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('68', 'Entry', '1', '0', '2015-11-19 11:39:54', '2015-11-23 11:17:34', 'a42c2f16-1b8b-4d8b-bb36-c2bd7ae317e6');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('69', 'Entry', '1', '0', '2015-11-19 11:41:01', '2015-11-23 11:17:25', 'd6d79c40-164b-4b38-8778-f631e8a604b7');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('70', 'Asset', '1', '0', '2015-11-19 11:42:57', '2015-11-19 11:42:57', '2939cc63-b06b-4dea-b557-d4e64e4ce80b');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('71', 'Entry', '1', '0', '2015-11-19 11:43:00', '2015-11-30 11:26:36', 'a098e11e-87f7-437c-99aa-dc44cb7d14c6');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('72', 'Entry', '1', '0', '2015-11-23 11:39:56', '2015-11-30 09:50:13', 'd4beff79-056f-4e6b-85a4-2468884bf7d7');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('73', 'Entry', '1', '0', '2015-11-23 15:09:12', '2015-11-30 09:49:34', '89531eda-33a3-4089-a7ed-401e3ba89098');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('74', 'MatrixBlock', '1', '0', '2015-11-24 16:38:18', '2015-11-30 09:13:28', '9ccd9403-22a8-4966-ab3f-3aef7748d74f');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('75', 'MatrixBlock', '1', '0', '2015-11-24 16:38:18', '2015-11-30 09:13:28', '91f1a88f-230a-4c94-9b0a-e55c0dab5352');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('76', 'Asset', '1', '0', '2015-11-25 12:05:47', '2015-11-25 12:05:47', '69f676e1-520f-413d-8dd9-8e847e37dd65');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('77', 'Asset', '1', '0', '2015-11-25 12:05:48', '2015-11-25 12:05:48', 'e58e299f-0329-4bc7-85d8-3b3fee130fc5');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('78', 'Asset', '1', '0', '2015-11-25 14:01:01', '2015-11-25 14:01:01', '7c4f828e-501c-41f6-9a4c-4ce12180398c');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('79', 'Asset', '1', '0', '2015-11-25 14:01:02', '2015-11-25 14:01:02', 'c6e2d4d4-f2b1-4a24-a8d3-7b5f06c80648');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('80', 'Asset', '1', '0', '2015-11-25 14:01:03', '2015-11-25 14:01:03', '42ee809c-335f-4348-9582-72dc59fc78dc');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('81', 'Asset', '1', '0', '2015-11-25 14:04:57', '2015-11-25 14:04:57', '8cd2f3f7-8c2f-470e-9199-8ca264dceccb');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('82', 'Asset', '1', '0', '2015-11-25 14:04:58', '2015-11-25 14:04:58', 'ea997be4-6839-4b81-b055-9d00b1a7fe05');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('83', 'Asset', '1', '0', '2015-11-25 14:04:58', '2015-11-25 14:04:58', '7a03b345-46a3-4004-b643-7ffa1322b796');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('84', 'Asset', '1', '0', '2015-11-25 14:04:59', '2015-11-25 14:04:59', 'abceef24-7c52-40bd-b3d9-1d435f49fb48');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('85', 'MatrixBlock', '1', '0', '2015-11-25 14:09:00', '2015-12-01 09:37:28', '07ec00de-34a3-4b98-942b-5092dfa81fd2');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('86', 'MatrixBlock', '1', '0', '2015-11-25 14:09:00', '2015-12-01 09:37:28', '4ec157e7-4d29-418e-b8a5-54a3d1c72c75');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('87', 'MatrixBlock', '1', '0', '2015-11-25 14:09:00', '2015-12-01 09:37:28', '720eaa7c-3dc3-4673-80c3-75657c2bfb5f');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('88', 'MatrixBlock', '1', '0', '2015-11-25 14:09:00', '2015-12-01 09:37:28', 'a4fc1a66-d3d2-4cf3-a3e5-005c0df0aded');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('89', 'Asset', '1', '0', '2015-11-25 14:20:36', '2015-11-25 14:20:36', '2e5c0560-907e-4f4b-bc7b-8f969723db94');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('90', 'Asset', '1', '0', '2015-11-25 14:20:37', '2015-11-25 14:20:37', '38aeee78-4cf6-43ee-8228-68eba6c57003');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('91', 'Asset', '1', '0', '2015-11-25 14:20:37', '2015-11-25 14:20:37', 'b50061b5-c493-4dbb-9d93-7a10d119716a');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('92', 'Asset', '1', '0', '2015-11-25 14:20:38', '2015-11-25 14:20:38', '2b36df92-b3bd-40a2-842f-d79778723909');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('93', 'Asset', '1', '0', '2015-11-25 14:20:39', '2015-11-25 14:20:39', '1ff8a58c-203a-40cf-bf0f-12896131a789');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('94', 'Asset', '1', '0', '2015-11-25 15:12:52', '2015-11-25 15:12:52', 'a4c66193-3cdd-4b37-a278-cea2764ea7d9');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('95', 'Asset', '1', '0', '2015-11-25 15:12:52', '2015-11-25 15:12:52', 'd7d079fb-3914-4d91-a84a-64b11a9fb0fc');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('96', 'Asset', '1', '0', '2015-11-25 15:12:53', '2015-11-25 15:12:53', 'dacae331-098a-4ea5-a87f-bb34f2771be3');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('97', 'Asset', '1', '0', '2015-11-25 15:12:54', '2015-11-25 15:12:54', '86d75d31-3968-47eb-9c7e-41948d783601');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('98', 'MatrixBlock', '1', '0', '2015-11-26 11:46:49', '2015-12-01 09:37:28', 'a7177564-5b54-4c83-b6e5-15bec1acc1f3');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('99', 'Entry', '1', '0', '2015-11-26 13:59:16', '2015-11-26 15:00:31', '5e0efe1f-72ff-42db-b9f4-87337c49dc16');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('101', 'MatrixBlock', '1', '0', '2015-11-26 14:30:34', '2015-11-26 15:00:31', '0bf1f069-62da-40ff-93ba-ecea2e374bd8');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('102', 'MatrixBlock', '1', '0', '2015-11-26 14:30:34', '2015-11-26 15:00:31', '16cdab91-0b00-4fee-9709-eaef76ca3b05');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('103', 'MatrixBlock', '1', '0', '2015-11-26 14:30:34', '2015-11-26 15:00:31', '215f7a51-ef1f-4079-8e51-32bf9431c868');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('104', 'MatrixBlock', '1', '0', '2015-11-26 14:30:34', '2015-11-26 15:00:31', '261d7b17-ae01-4f2d-a1e7-3b576ff7b3ad');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('105', 'MatrixBlock', '1', '0', '2015-11-26 14:46:03', '2015-11-26 15:00:31', '1675ab71-bdf5-497c-bb41-f10fa118e85e');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('106', 'MatrixBlock', '1', '0', '2015-11-26 14:46:03', '2015-11-26 15:00:31', '9977d52e-7779-4900-95e3-c2c0a6ef0646');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('107', 'MatrixBlock', '1', '0', '2015-11-26 14:46:03', '2015-11-26 15:00:31', '4bc0982c-6053-4dc7-a615-5c7b3b9c5ca7');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('108', 'MatrixBlock', '1', '0', '2015-11-26 14:46:03', '2015-11-26 15:00:31', 'f025b70d-bd37-47d7-bebc-3dc4850157c0');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('109', 'Entry', '1', '0', '2015-11-30 09:23:57', '2015-11-30 09:23:57', '8a404c7b-4e2d-4dce-a58f-943ada7c27e5');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('110', 'MatrixBlock', '1', '0', '2015-11-30 09:23:58', '2015-11-30 09:23:58', '52cade5f-19ec-4835-ae65-8a410e9fced4');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('111', 'MatrixBlock', '1', '0', '2015-11-30 09:23:58', '2015-11-30 09:23:58', '433de69b-4e70-491e-aee2-a9ba21660cea');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('113', 'MatrixBlock', '1', '0', '2015-11-30 09:49:34', '2015-11-30 09:49:34', 'f762e657-5b5f-45a4-88dd-bbec1224bc50');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('114', 'MatrixBlock', '1', '0', '2015-11-30 09:50:13', '2015-11-30 09:50:13', 'e53babc0-05fe-49f5-8398-e27df3ec3511');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('115', 'MatrixBlock', '1', '0', '2015-11-30 11:26:37', '2015-11-30 11:26:37', '5a8af772-f430-4fa7-8b61-9933450cea22');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('116', 'MatrixBlock', '1', '0', '2015-11-30 11:26:37', '2015-11-30 11:26:37', '9867b4e1-7d9f-425f-baf9-3f9963257994');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('117', 'MatrixBlock', '1', '0', '2015-11-30 11:26:37', '2015-11-30 11:26:37', 'a0f9c217-aa4f-4ace-adaa-203f786fcde1');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('118', 'Asset', '1', '0', '2015-11-30 11:27:33', '2015-11-30 11:27:33', 'a37b5e55-8052-4f20-9cea-246f461f974e');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('119', 'Asset', '1', '0', '2015-12-01 09:37:00', '2015-12-01 09:37:00', 'f4536679-19ee-4812-9a77-41d84edea3ac');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('120', 'Asset', '1', '0', '2015-12-01 09:37:14', '2015-12-01 09:37:14', '6a440b4f-d0af-455a-adb4-5602742c0947');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('121', 'MatrixBlock', '1', '0', '2015-12-01 09:52:45', '2015-12-01 09:52:45', 'a5dd084b-f094-4ec4-9ab9-414912f8b9de');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('122', 'MatrixBlock', '1', '0', '2015-12-01 09:52:45', '2015-12-01 09:52:45', '3d0c34bb-44b9-4c1b-9c3c-e2fa4ed28127');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('123', 'MatrixBlock', '1', '0', '2015-12-01 09:52:45', '2015-12-01 09:52:45', 'f0de715f-f68f-440e-9cf3-3fbb2ed98783');
INSERT INTO `craft_elements` (`id`, `type`, `enabled`, `archived`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('124', 'User', '1', '0', '2015-12-01 17:25:21', '2015-12-01 17:35:02', '024978ed-a4f4-4e68-9a23-d2879c400acf');



DROP TABLE IF EXISTS `craft_elements_i18n`;


--
-- Schema for table `craft_elements_i18n`
--
CREATE TABLE `craft_elements_i18n` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `uri` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_elements_i18n_elementId_locale_unq_idx` (`elementId`,`locale`),
  UNIQUE KEY `craft_elements_i18n_uri_locale_unq_idx` (`uri`,`locale`),
  KEY `craft_elements_i18n_slug_locale_idx` (`slug`,`locale`),
  KEY `craft_elements_i18n_enabled_idx` (`enabled`),
  KEY `craft_elements_i18n_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=123 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_elements_i18n`
--

INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', '1', 'en_gb', '', NULL, '1', '2015-11-04 11:36:29', '2015-11-04 11:36:29', 'fe0fb403-bfbf-4246-b251-ac233cf19f81');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', '2', 'en_gb', 'homepage', '__home__', '1', '2015-11-04 11:36:32', '2015-11-30 12:00:24', 'd3a34750-2aa9-4128-9e37-ee07c29d59ad');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', '4', 'en_gb', 'about', 'about', '1', '2015-11-10 16:22:36', '2015-11-30 11:27:40', '188e8eff-fd0b-4aae-9ee2-b7d557d4f13e');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', '5', 'en_gb', 'accreditations', 'accreditations', '1', '2015-11-10 16:24:52', '2015-12-01 09:37:28', 'a20d9fc7-70ee-4455-9f2a-09c76b3c69b5');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('7', '7', 'en_gb', '', NULL, '1', '2015-11-10 16:28:51', '2015-12-01 17:07:15', '4331e16c-2712-45b5-ba01-1dfb39ee410e');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('8', '8', 'en_gb', 'find-us', 'find-us', '1', '2015-11-13 09:37:14', '2015-11-17 14:20:26', '9f6168e2-1ac0-4088-86ee-9b30ef8cdcc9');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('9', '9', 'en_gb', 'treatments', 'treatments', '1', '2015-11-13 09:37:54', '2015-11-23 11:02:48', '13e0fd10-42cd-42e2-b831-588873938bab');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('12', '14', 'en_gb', 'fractures', NULL, '1', '2015-11-13 11:49:40', '2015-11-13 11:50:50', 'd05dc1c2-7403-4c0d-a4b8-2201582a15e5');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('13', '15', 'en_gb', 'childrens-injuries', NULL, '1', '2015-11-13 11:50:05', '2015-11-26 11:10:39', '654131a7-2aad-4728-9544-2512565a611d');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('14', '16', 'en_gb', 'young-adult-hip-pain', NULL, '1', '2015-11-13 11:51:14', '2015-11-13 11:58:28', '84350d41-ed44-439e-8b84-154196168ec2');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('15', '17', 'en_gb', 'sports-injuries', NULL, '1', '2015-11-13 11:51:34', '2015-11-13 11:58:26', '0c75bf83-fd7e-421a-b973-ca7a84d51657');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('16', '18', 'en_gb', 'haemophilia', NULL, '1', '2015-11-13 11:51:51', '2015-11-13 11:51:51', 'b8204c62-d917-4b9f-94e1-6997311d19f3');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('17', '19', 'en_gb', 'work-related-pain', NULL, '1', '2015-11-13 11:53:14', '2015-11-19 14:54:28', 'd083aee2-cfb1-457c-be91-d1b563cfe766');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('18', '20', 'en_gb', 'sprains-and-strains', NULL, '1', '2015-11-13 11:53:29', '2015-11-13 11:53:29', '7894410a-18d1-4b3a-9356-2ea99e8cb0ce');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('19', '21', 'en_gb', 'back-pain', NULL, '1', '2015-11-13 11:53:48', '2015-11-13 11:53:48', '99844747-ef12-4337-bc22-5cf5b6fb8a6f');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('20', '22', 'en_gb', 'neck-pain', NULL, '1', '2015-11-13 11:54:01', '2015-11-13 11:54:01', '4f208e09-6751-490d-8ace-13a9410f677e');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('21', '23', 'en_gb', 'shoulder-elbow-wrist-pain', NULL, '1', '2015-11-13 11:54:15', '2015-11-13 11:54:15', '71e96065-89b6-45f6-8e85-775a53ab16eb');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('22', '24', 'en_gb', 'hip-knee-ankle-pain', NULL, '1', '2015-11-13 11:54:33', '2015-11-13 11:55:11', '620280d5-8ba3-4724-bb63-e305da8e1207');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('23', '25', 'en_gb', 'orthopaedic-post-operative-care', NULL, '1', '2015-11-13 11:55:27', '2015-11-13 11:55:28', 'c2f1ba8a-6c46-4c26-8f6b-49c48c75e21a');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('24', '26', 'en_gb', 'post-fracture-rehabilitation', NULL, '1', '2015-11-13 11:55:43', '2015-11-13 11:55:43', '08140f9c-8732-4d69-8578-9bf239c885d9');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('25', '27', 'en_gb', 'non-specific-arm-pain', NULL, '1', '2015-11-13 11:55:55', '2015-11-13 11:55:56', '68087e30-09a9-42f3-a583-84cdd365c26f');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('26', '28', 'en_gb', 'thoracic-outlet-syndrome', NULL, '1', '2015-11-13 11:56:08', '2015-11-13 11:56:08', '8441a83b-0762-4d04-ad53-11ac3e59f262');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('27', '29', 'en_gb', 'headaches-and-dizziness', NULL, '1', '2015-11-13 11:56:26', '2015-11-13 11:56:26', 'ff314287-0417-4f76-8465-1a1688fef19f');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('28', '30', 'en_gb', 'pregnancy-related-pain', NULL, '1', '2015-11-13 11:56:42', '2015-11-13 11:56:42', 'ae176d45-3ddd-4946-b445-383db057417e');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('29', '31', 'en_gb', 'management-of-long-term-conditions', NULL, '1', '2015-11-13 11:56:55', '2015-11-13 11:56:55', 'b13aba3b-c055-46e6-a50a-c0c1c1b072bd');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('30', '32', 'en_gb', 'rheumatological-conditions', NULL, '1', '2015-11-13 11:57:11', '2015-11-13 11:57:11', 'd57bc165-bfe6-4b7d-94ab-d10e87a682d9');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('31', '33', 'en_gb', 'osteoarthritis', NULL, '1', '2015-11-13 11:57:28', '2015-11-13 11:57:28', '1c2a34e8-d4a0-437f-a882-9cd7d26dcbbf');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('32', '34', 'en_gb', 'joint-replacements', NULL, '1', '2015-11-13 11:57:39', '2015-11-13 11:57:39', 'a5b0b63c-c12d-4e8d-9af6-898a547504ae');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('33', '35', 'en_gb', 'osteoporosis', NULL, '1', '2015-11-13 11:57:51', '2015-11-13 11:57:51', '3079c60a-fa61-4bcc-9d45-f5758ce135ec');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('34', '36', 'en_gb', 'post-cancer-rehabilitation', NULL, '1', '2015-11-13 11:58:03', '2015-11-13 11:58:03', '44208633-8abd-48a4-b968-d0541edd6797');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('35', '37', 'en_gb', 'mild-continence-issues', NULL, '1', '2015-11-13 11:58:20', '2015-11-13 11:58:20', '751d482f-ce59-4ff6-bcbc-1373a463b619');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('39', '41', 'en_gb', 'sport-woman', NULL, '1', '2015-11-13 12:48:48', '2015-11-13 12:48:48', 'd67298e0-dd58-4d6d-9e5c-24630353e09d');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('40', '42', 'en_gb', '', NULL, '1', '2015-11-13 12:54:30', '2015-12-01 17:07:15', '133e59ca-512a-45d4-b2ec-469479c57bee');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('41', '43', 'en_gb', '', NULL, '1', '2015-11-13 12:54:44', '2015-11-13 12:57:48', '5f5c080f-32ba-4565-bc13-3c65d2ab3d19');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('42', '44', 'en_gb', '', NULL, '1', '2015-11-13 12:57:48', '2015-11-13 12:57:48', '48da588a-2fa4-4bb7-aaf0-1c1177692402');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('43', '45', 'en_gb', '', NULL, '1', '2015-11-13 12:57:48', '2015-11-13 12:57:48', '64b34c86-dbef-493a-8d7b-c6a2a0ecc232');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('44', '46', 'en_gb', '', NULL, '1', '2015-11-13 12:57:48', '2015-11-13 12:57:48', 'a0b20da0-a9a6-460f-833c-e2fd3df266fb');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('45', '47', 'en_gb', 'news', 'news', '1', '2015-11-13 14:41:24', '2015-11-23 11:03:29', '848b90a3-a763-4983-83d0-077ffa8c3fc3');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('46', '48', 'en_gb', 'joint-pain', NULL, '1', '2015-11-13 15:22:50', '2015-11-13 15:22:50', '2a6ea55e-ef4d-4fe5-a32b-043235af5b40');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('47', '49', 'en_gb', 'winter-chills', 'news/2015/winter-chills', '1', '2015-11-13 15:22:59', '2015-11-23 11:17:51', '9a5afecc-d8c8-4f90-a29a-e8efce431771');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('48', '50', 'en_gb', 'test-news-article', 'news/2015/test-news-article', '1', '2015-11-13 15:43:34', '2015-11-23 11:17:46', '64b22684-d58b-4000-bf19-bb1dd3dd8f52');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('49', '51', 'en_gb', 'banner', NULL, '1', '2015-11-13 15:44:50', '2015-11-13 15:44:50', '72a01269-f8cd-4817-bc11-3e0105d9e339');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('50', '52', 'en_gb', '', NULL, '1', '2015-11-17 11:20:23', '2015-11-30 11:27:40', '63f84c95-4460-49ee-9d31-662bca5eb0f7');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('51', '53', 'en_gb', '', NULL, '1', '2015-11-17 11:20:23', '2015-11-30 11:27:40', '7e58d466-02b5-4dd7-8912-c5ab14b6007e');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('52', '54', 'en_gb', '', NULL, '1', '2015-11-17 11:20:23', '2015-11-30 11:27:40', 'd3321025-3547-4b07-a342-cf4c1045afc3');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('53', '55', 'en_gb', '', NULL, '1', '2015-11-17 11:20:23', '2015-11-30 11:27:40', '6b765181-1957-4512-b126-83d641618ac7');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('54', '56', 'en_gb', 'sarah-profile', NULL, '1', '2015-11-17 12:00:36', '2015-11-17 12:00:36', '6757258a-8eeb-4658-9339-cf0dfe1ca385');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('55', '57', 'en_gb', 'pricing', 'pricing', '1', '2015-11-17 14:07:49', '2015-12-01 17:22:07', '0726211e-ee23-4016-ba2e-ea162badf251');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('56', '58', 'en_gb', 'testimonialspg', 'testimonials', '1', '2015-11-17 14:17:42', '2015-11-30 09:13:28', '8325643a-2230-4eba-afca-ed61e467f71e');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('57', '59', 'en_gb', '', NULL, '1', '2015-11-17 15:45:10', '2015-11-30 09:13:28', 'a78f04a5-fefe-4a88-aa5d-5cb73888d98e');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('58', '60', 'en_gb', '', NULL, '1', '2015-11-17 15:45:10', '2015-11-30 09:13:28', '5d0b14ae-da42-44b6-8cf3-5c15f4dbe49e');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('59', '61', 'en_gb', 'work-and-social', 'treatments/work-and-social', '1', '2015-11-17 16:40:59', '2015-11-25 12:05:55', 'ec10499e-975d-4104-ac5f-880a96704ea5');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('60', '62', 'en_gb', 'young-and-active', 'treatments/young-and-active', '1', '2015-11-17 16:41:18', '2015-11-23 10:26:04', '2e4337da-ea53-4c29-9a87-b1f91bef8229');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('61', '63', 'en_gb', 'lifetime-support', 'treatments/lifetime-support', '1', '2015-11-17 16:41:32', '2015-12-01 09:52:45', '264183b7-06a7-414f-8c3b-012f356e2677');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('62', '64', 'en_gb', 'sports-injury-2', NULL, '1', '2015-11-19 11:37:55', '2015-11-19 11:37:55', 'a8812804-3b02-4ef1-8ad1-a9cd1104e6be');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('63', '65', 'en_gb', 'sports-injuries', 'news/2015/sports-injuries', '1', '2015-11-19 11:38:01', '2015-11-23 11:17:41', '52b36b00-ce04-4214-9f5a-f69564357ea7');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('64', '66', 'en_gb', 'back-pain-gif-437580', NULL, '1', '2015-11-19 11:39:40', '2015-11-19 11:39:40', '093dbbca-d045-4fd9-bde1-dad5e062c936');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('65', '67', 'en_gb', 'istock-rf-photo-of-arthritis-pain-in-hand', NULL, '1', '2015-11-19 11:39:49', '2015-11-19 11:39:49', '2d044c1f-9e1e-48db-920e-cac2d0017316');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('66', '68', 'en_gb', 'back-pain-tips', 'news/2015/back-pain-tips', '1', '2015-11-19 11:39:54', '2015-11-23 11:17:34', 'c7f6e4d5-abcf-46f8-b1db-1f18b3a4c7df');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('67', '69', 'en_gb', 'arthritis', 'news/2015/arthritis', '1', '2015-11-19 11:41:01', '2015-11-23 11:17:25', '24ca8639-b27a-4cf6-8027-9c5fce539d28');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('68', '70', 'en_gb', 'tennis-elbow', NULL, '1', '2015-11-19 11:42:57', '2015-11-19 11:42:57', 'ca22d7cf-1b96-4a75-bde9-5dd407fca0d9');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('69', '71', 'en_gb', 'preventing-tennis-elbow', 'news/2015/preventing-tennis-elbow', '1', '2015-11-19 11:43:00', '2015-11-30 11:26:37', '500515e8-38d0-4017-baaf-2053c84d9fce');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('70', '72', 'en_gb', 'test-article', 'news/2015/test-article', '1', '2015-11-23 11:39:56', '2015-11-30 09:50:13', 'd72ce25e-05e0-4089-bb30-dc464571a9aa');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('71', '73', 'en_gb', 'another-test-article', 'news/2015/another-test-article', '1', '2015-11-23 15:09:12', '2015-11-30 09:49:34', '0906bc3f-ba03-4b13-a6cf-48ab5c323816');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('72', '74', 'en_gb', '', NULL, '1', '2015-11-24 16:38:18', '2015-11-30 09:13:28', 'cfce861a-31b5-49b7-8a82-16d960f570dc');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('73', '75', 'en_gb', '', NULL, '1', '2015-11-24 16:38:18', '2015-11-30 09:13:28', '269ff801-8554-4959-9c2c-0c52cba34151');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('74', '76', 'en_gb', 'lifetime-couple', NULL, '1', '2015-11-25 12:05:47', '2015-11-25 12:05:47', 'cd1e9b02-0b28-45b7-bf98-efc70c4995ff');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('75', '77', 'en_gb', 'work-man', NULL, '1', '2015-11-25 12:05:48', '2015-11-25 12:05:48', '5b5ef301-abed-45e8-a063-8881e331ff27');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('76', '78', 'en_gb', '6f14d766-8edf-4b3c-b385-96bfed558d4c', NULL, '1', '2015-11-25 14:01:02', '2015-11-25 14:01:02', '238e8821-cd52-4fdd-93b8-3baf9a66056f');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('77', '79', 'en_gb', 'hpc-logo-registered', NULL, '1', '2015-11-25 14:01:02', '2015-11-25 14:01:02', '45cb6e5f-4d5b-456a-bb88-c24b875940b8');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('78', '80', 'en_gb', 'imgres', NULL, '1', '2015-11-25 14:01:03', '2015-11-25 14:01:03', '1a6fa0de-a1dd-42b9-854f-646ee0c77f56');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('79', '81', 'en_gb', '6f14d766-8edf-4b3c-b385-96bfed558d4c-1', NULL, '1', '2015-11-25 14:04:57', '2015-11-25 14:04:57', 'a1592959-e90e-423a-b6dc-d9bf3daa9df6');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('80', '82', 'en_gb', 'bmas-logo', NULL, '1', '2015-11-25 14:04:58', '2015-11-25 14:04:58', '7499bb8a-1d1e-4a7a-b4ce-e0f28aa3b861');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('81', '83', 'en_gb', 'hpc-logo-registered-1', NULL, '1', '2015-11-25 14:04:58', '2015-11-25 14:04:58', '14803ad7-b28c-4962-b3ec-d18361764337');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('82', '84', 'en_gb', 'imgres-1', NULL, '1', '2015-11-25 14:04:59', '2015-11-25 14:04:59', '8d91f180-d28b-4be9-8b80-68f1c2057e20');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('83', '85', 'en_gb', '', NULL, '1', '2015-11-25 14:09:00', '2015-12-01 09:37:28', 'f98feffb-2e6f-444d-8b38-b84f7c7fe0f6');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('84', '86', 'en_gb', '', NULL, '1', '2015-11-25 14:09:00', '2015-12-01 09:37:28', '64a4c382-ad4f-4045-9a73-b5455a5e999f');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('85', '87', 'en_gb', '', NULL, '1', '2015-11-25 14:09:00', '2015-12-01 09:37:28', '28d875f1-f6c4-4f14-a8c8-7c66bd81a57a');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('86', '88', 'en_gb', '', NULL, '1', '2015-11-25 14:09:00', '2015-12-01 09:37:28', '2e9df92a-8882-41b5-b5d6-759c0dfbdea7');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('87', '89', 'en_gb', 'bmas-footer', NULL, '1', '2015-11-25 14:20:37', '2015-11-25 14:20:37', 'a2420d33-9ee9-45a1-9456-5191924c6ca5');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('88', '90', 'en_gb', 'csp-footer', NULL, '1', '2015-11-25 14:20:37', '2015-11-25 14:20:37', '4fa7946f-7729-41ef-8536-1f56e37e0c2b');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('89', '91', 'en_gb', 'hpc-footer', NULL, '1', '2015-11-25 14:20:38', '2015-11-25 14:20:38', '84a70742-894f-4831-8019-84b7749b31f5');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('90', '92', 'en_gb', 'physio-footer', NULL, '1', '2015-11-25 14:20:38', '2015-11-25 14:20:38', '279245fe-3ae6-4026-b051-537bf974030e');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('91', '93', 'en_gb', 'physiofirst-footer', NULL, '1', '2015-11-25 14:20:39', '2015-11-25 14:20:39', 'f33e8cb7-ca28-4ee3-9dfc-f75d5f827550');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('92', '94', 'en_gb', 'bmas', NULL, '1', '2015-11-25 15:12:52', '2015-11-25 15:12:52', '42c944f6-30b6-4e17-a8a2-3f7eca3c6913');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('93', '95', 'en_gb', 'csp', NULL, '1', '2015-11-25 15:12:52', '2015-11-25 15:12:52', 'aec4c2e7-ac0f-4101-ab58-bcfcacc35dea');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('94', '96', 'en_gb', 'hpc', NULL, '1', '2015-11-25 15:12:53', '2015-11-25 15:12:53', '353f2588-9d8b-4811-8cf8-6fff53e378d5');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('95', '97', 'en_gb', 'physio-first', NULL, '1', '2015-11-25 15:12:54', '2015-11-25 15:12:54', '0c07366b-7d53-492d-a111-7902a52bab73');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('96', '98', 'en_gb', '', NULL, '1', '2015-11-26 11:46:49', '2015-12-01 09:37:28', '5b9f28a2-975e-48ed-9fb4-b857e02555e4');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('97', '99', 'en_gb', 'ouch-ive-hurt-my-back', 'news/2015/ouch-ive-hurt-my-back', '1', '2015-11-26 13:59:16', '2015-11-26 15:00:31', 'da24d3f1-5e6f-4cb7-8bb1-4b9809f83d76');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('99', '101', 'en_gb', '', NULL, '1', '2015-11-26 14:30:34', '2015-11-26 15:00:31', '18f24f3c-9281-4463-9291-5e735bcc2d59');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('100', '102', 'en_gb', '', NULL, '1', '2015-11-26 14:30:34', '2015-11-26 15:00:31', 'dbfcc0b7-60a0-48ef-a6be-76acb1ee4f71');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('101', '103', 'en_gb', '', NULL, '1', '2015-11-26 14:30:34', '2015-11-26 15:00:31', '640f4ee2-f8fc-4fa9-907e-edb67c523cbf');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('102', '104', 'en_gb', '', NULL, '1', '2015-11-26 14:30:34', '2015-11-26 15:00:31', '90cf59b8-ab9c-44a2-8ba1-91ed0b5735ab');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('103', '105', 'en_gb', '', NULL, '1', '2015-11-26 14:46:03', '2015-11-26 15:00:31', '4e565b71-36c7-4cb0-a823-fb9512eef030');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('104', '106', 'en_gb', '', NULL, '1', '2015-11-26 14:46:03', '2015-11-26 15:00:31', 'ad3c7045-deb8-4568-88ac-f2eb3c9f107d');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('105', '107', 'en_gb', '', NULL, '1', '2015-11-26 14:46:03', '2015-11-26 15:00:31', 'de9b161f-9396-4c8a-80c9-77a0c977f4bc');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('106', '108', 'en_gb', '', NULL, '1', '2015-11-26 14:46:03', '2015-11-26 15:00:31', 'f12d7d01-45a3-470b-abdc-d162b557ecae');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('107', '109', 'en_gb', 'media-comment-november', 'news/2015/media-comment-november', '1', '2015-11-30 09:23:58', '2015-11-30 09:23:58', '173fae39-954b-4398-bbb2-e7924344e50d');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('108', '110', 'en_gb', '', NULL, '1', '2015-11-30 09:23:58', '2015-11-30 09:23:58', '90677dce-94e9-4a63-b9ba-beb7db5531e5');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('109', '111', 'en_gb', '', NULL, '1', '2015-11-30 09:23:58', '2015-11-30 09:23:58', '33a9ce03-9de7-4277-baed-d340760e91cd');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('111', '113', 'en_gb', '', NULL, '1', '2015-11-30 09:49:34', '2015-11-30 09:49:34', 'e9ddf3c6-f043-49db-86ab-4ecfdd7131e6');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('112', '114', 'en_gb', '', NULL, '1', '2015-11-30 09:50:13', '2015-11-30 09:50:13', 'b89a0814-8e81-4f3d-97b5-c74907ce46ae');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('113', '115', 'en_gb', '', NULL, '1', '2015-11-30 11:26:37', '2015-11-30 11:26:37', 'b20b8b88-8fc0-4acb-972d-690f38f1a1f8');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('114', '116', 'en_gb', '', NULL, '1', '2015-11-30 11:26:37', '2015-11-30 11:26:37', '23f60dac-1e5b-417d-8d35-d412e5cc6b21');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('115', '117', 'en_gb', '', NULL, '1', '2015-11-30 11:26:37', '2015-11-30 11:26:37', '0879a7be-20ff-43ce-8c63-3624f1f8980f');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('116', '118', 'en_gb', 'wzgx-w9oublvaajgcka-uvwpwyl6hkg-jn0-gwjoui4pvdzbhtafo1l9eafkc8swhdbtdk2xjdqurdgk7sjl8a', NULL, '1', '2015-11-30 11:27:33', '2015-11-30 11:27:33', 'ed0c45bf-7367-4e34-ae62-1f89538aaa0a');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('117', '119', 'en_gb', 'macp-logo-reverse', NULL, '1', '2015-12-01 09:37:00', '2015-12-01 09:37:00', '58877954-780f-45f7-a27b-49e41cfd9374');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('118', '120', 'en_gb', 'macp-logo', NULL, '1', '2015-12-01 09:37:14', '2015-12-01 09:37:14', 'daec666c-de8a-4989-ad1c-2e9cb86f7c54');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('119', '121', 'en_gb', '', NULL, '1', '2015-12-01 09:52:45', '2015-12-01 09:52:45', '5fb0062e-1fc4-47b1-8d74-92c6a8332f16');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('120', '122', 'en_gb', '', NULL, '1', '2015-12-01 09:52:45', '2015-12-01 09:52:45', '494d3a1d-44e5-4313-a729-3e394bb278a7');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('121', '123', 'en_gb', '', NULL, '1', '2015-12-01 09:52:45', '2015-12-01 09:52:45', '3099a892-f11d-423d-ad94-c7236927524c');
INSERT INTO `craft_elements_i18n` (`id`, `elementId`, `locale`, `slug`, `uri`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('122', '124', 'en_gb', '', NULL, '1', '2015-12-01 17:25:21', '2015-12-01 17:35:02', '58a30103-de50-4b70-8ce9-936bff45dd37');



DROP TABLE IF EXISTS `craft_emailmessages`;


--
-- Schema for table `craft_emailmessages`
--
CREATE TABLE `craft_emailmessages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` char(150) COLLATE utf8_unicode_ci NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `subject` varchar(1000) COLLATE utf8_unicode_ci NOT NULL,
  `body` text COLLATE utf8_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_emailmessages_key_locale_unq_idx` (`key`,`locale`),
  KEY `craft_emailmessages_locale_fk` (`locale`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_entries`;


--
-- Schema for table `craft_entries`
--
CREATE TABLE `craft_entries` (
  `id` int(11) NOT NULL,
  `sectionId` int(11) NOT NULL,
  `typeId` int(11) DEFAULT NULL,
  `authorId` int(11) DEFAULT NULL,
  `postDate` datetime DEFAULT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_entries_sectionId_idx` (`sectionId`),
  KEY `craft_entries_typeId_idx` (`typeId`),
  KEY `craft_entries_postDate_idx` (`postDate`),
  KEY `craft_entries_expiryDate_idx` (`expiryDate`),
  KEY `craft_entries_authorId_fk` (`authorId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_entries`
--

INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', '1', '1', NULL, '2015-11-13 14:09:08', NULL, '2015-11-04 11:36:32', '2015-11-30 12:00:24', '37f00e0b-ad76-4f8e-98e8-87717b78c5e0');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', '3', NULL, NULL, '2015-11-10 16:22:36', NULL, '2015-11-10 16:22:36', '2015-11-30 11:27:40', 'bc8ed318-9257-47f3-a0ec-df84e74658b1');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', '5', NULL, NULL, '2015-11-10 16:24:52', NULL, '2015-11-10 16:24:52', '2015-12-01 09:37:28', 'df5adf6c-5c47-4ce4-9a44-c147c2fd68a0');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('8', '9', '9', NULL, '2015-11-17 14:20:25', NULL, '2015-11-13 09:37:14', '2015-11-17 14:20:25', '38d88ab5-c288-4c5a-ada5-839a727d8a6c');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('9', '10', NULL, NULL, '2015-11-13 09:37:53', NULL, '2015-11-13 09:37:54', '2015-11-23 11:02:49', '44a70d79-9ddb-4cc1-9f55-45ef9edda6a5');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('14', '11', '11', '1', '2015-11-13 11:49:00', NULL, '2015-11-13 11:49:40', '2015-11-13 11:50:50', 'a4627bbf-25a1-4ba5-bbe8-7a1b750537a5');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('15', '11', '11', '1', '2015-11-13 11:50:00', NULL, '2015-11-13 11:50:05', '2015-11-26 11:10:39', '5e7782d2-81c4-4222-a39f-286d9f3f9398');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('16', '11', '11', '1', '2015-11-13 11:51:14', NULL, '2015-11-13 11:51:14', '2015-11-13 11:51:14', '13791278-d2db-476d-a976-24f67f5a5076');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('17', '11', '11', '1', '2015-11-13 11:51:34', NULL, '2015-11-13 11:51:34', '2015-11-13 11:51:34', '3b1e8305-e38f-4824-bc35-b8ebd4379292');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('18', '11', '11', '1', '2015-11-13 11:51:51', NULL, '2015-11-13 11:51:51', '2015-11-13 11:51:51', '9debfa59-55f6-4132-b776-351e54d2f2b1');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('19', '11', '11', '1', '2015-11-13 11:53:00', NULL, '2015-11-13 11:53:14', '2015-11-19 14:54:28', '51946f4a-ec74-4c84-98ed-6cecd4ae935b');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('20', '11', '11', '1', '2015-11-13 11:53:29', NULL, '2015-11-13 11:53:29', '2015-11-13 11:53:29', 'bbbd3be5-da9f-48d7-b044-ce4edb3e809b');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('21', '11', '11', '1', '2015-11-13 11:53:48', NULL, '2015-11-13 11:53:48', '2015-11-13 11:53:48', '57d82c6a-2d97-4849-83d8-c4ea16782723');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('22', '11', '11', '1', '2015-11-13 11:54:01', NULL, '2015-11-13 11:54:01', '2015-11-13 11:54:01', '65f07460-1c85-436c-83ff-1f678b1a0acd');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('23', '11', '11', '1', '2015-11-13 11:54:15', NULL, '2015-11-13 11:54:15', '2015-11-13 11:54:15', '32219bb8-9dca-444d-8f73-5b726c6cad57');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('24', '11', '11', '1', '2015-11-13 11:54:00', NULL, '2015-11-13 11:54:33', '2015-11-13 11:55:11', 'e80cf0b7-231a-4521-83d3-ce39c9ba11d6');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('25', '11', '11', '1', '2015-11-13 11:55:27', NULL, '2015-11-13 11:55:27', '2015-11-13 11:55:27', '957af59c-7969-4b67-80e7-7925f738def7');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('26', '11', '11', '1', '2015-11-13 11:55:43', NULL, '2015-11-13 11:55:43', '2015-11-13 11:55:43', '712c19e7-389b-4c01-8028-78aefc65f299');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('27', '11', '11', '1', '2015-11-13 11:55:55', NULL, '2015-11-13 11:55:55', '2015-11-13 11:55:55', '2e8da2c7-16a3-4c08-a935-f7cf658f327a');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('28', '11', '11', '1', '2015-11-13 11:56:08', NULL, '2015-11-13 11:56:08', '2015-11-13 11:56:08', '3db75c4a-04eb-4f01-a549-5996e1cc554a');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('29', '11', '11', '1', '2015-11-13 11:56:26', NULL, '2015-11-13 11:56:26', '2015-11-13 11:56:26', 'cab373a5-c0e8-4a6e-a5ae-9f857ed87f14');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('30', '11', '11', '1', '2015-11-13 11:56:42', NULL, '2015-11-13 11:56:42', '2015-11-13 11:56:42', 'ea3905bd-7221-4a96-be71-c2ea68ac4ddc');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('31', '11', '11', '1', '2015-11-13 11:56:55', NULL, '2015-11-13 11:56:55', '2015-11-13 11:56:55', 'c8823b30-5624-4a05-9ef6-ea3736a06ed2');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('32', '11', '11', '1', '2015-11-13 11:57:11', NULL, '2015-11-13 11:57:11', '2015-11-13 11:57:11', '00c79fa8-eba3-482d-9afe-47cb1d511404');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('33', '11', '11', '1', '2015-11-13 11:57:28', NULL, '2015-11-13 11:57:28', '2015-11-13 11:57:28', '9bd0b37e-82f8-4fc1-8081-bd056cb996d9');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('34', '11', '11', '1', '2015-11-13 11:57:39', NULL, '2015-11-13 11:57:39', '2015-11-13 11:57:39', 'bb664290-99e6-4a1d-8fa8-fc6bcf8b405c');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('35', '11', '11', '1', '2015-11-13 11:57:50', NULL, '2015-11-13 11:57:51', '2015-11-13 11:57:51', '03eac07e-6679-4434-8a59-ecfc5af74fca');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('36', '11', '11', '1', '2015-11-13 11:58:03', NULL, '2015-11-13 11:58:03', '2015-11-13 11:58:03', '04ee8bd0-0e1e-4058-b98b-93f496f4c803');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('37', '11', '11', '1', '2015-11-13 11:58:20', NULL, '2015-11-13 11:58:20', '2015-11-13 11:58:20', '77a472e1-745c-47c0-8c7a-e680098c7ac0');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('47', '12', NULL, NULL, '2015-11-13 14:41:24', NULL, '2015-11-13 14:41:24', '2015-11-23 11:03:29', '2fffaae5-e6a1-4898-b2b5-06b2e3f9fa2a');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('49', '2', '2', '1', '2015-11-13 15:22:00', NULL, '2015-11-13 15:22:59', '2015-11-23 11:17:51', '4ca7fd04-3e4b-40cf-a4e8-e6a93cdcea63');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('50', '2', '2', '1', '2015-11-13 15:43:00', NULL, '2015-11-13 15:43:34', '2015-11-23 11:17:46', '559ea2d6-a5a5-4187-a49f-79bff855ce3e');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('57', '8', '8', NULL, '2015-11-17 14:16:28', NULL, '2015-11-17 14:07:49', '2015-12-01 17:22:07', 'f8a17d8f-c494-45bc-b20f-91c21868d0f4');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('58', '13', '13', NULL, '2015-11-17 14:19:11', NULL, '2015-11-17 14:17:42', '2015-11-30 09:13:28', 'b0a7586b-1e4b-4d09-ac6b-6b0595247baf');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('61', '14', '14', NULL, '2015-11-23 10:25:46', NULL, '2015-11-17 16:40:59', '2015-11-25 12:05:56', '89851005-353a-40d5-a31b-7d3778c957cb');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('62', '15', '15', NULL, '2015-11-23 10:26:03', NULL, '2015-11-17 16:41:18', '2015-11-23 10:26:03', '23e31da4-7fca-41fb-811d-4c838b55d2fc');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('63', '16', '16', NULL, '2015-11-23 10:26:14', NULL, '2015-11-17 16:41:32', '2015-12-01 09:52:45', '288edf0c-844d-47c1-baeb-b5243ad36b21');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('65', '2', '2', '1', '2015-11-19 11:38:00', NULL, '2015-11-19 11:38:01', '2015-11-23 11:17:41', 'e57c1773-055f-44eb-9f36-20aad0341cd3');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('68', '2', '2', '1', '2015-11-19 11:39:00', NULL, '2015-11-19 11:39:54', '2015-11-23 11:17:34', '6296e709-c613-446b-b052-78daa04e9efa');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('69', '2', '2', '1', '2015-11-19 11:41:00', NULL, '2015-11-19 11:41:01', '2015-11-23 11:17:25', '69787612-27f6-4dc9-b7ce-76af3f3dfda9');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('71', '2', '2', '1', '2015-11-19 11:43:00', NULL, '2015-11-19 11:43:00', '2015-11-30 11:26:37', '5101c245-114a-44a0-89dd-65a0c9fc6512');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('72', '2', '2', '1', '2015-11-23 11:39:00', NULL, '2015-11-23 11:39:56', '2015-11-30 09:50:13', '36e4b487-7921-4c08-a045-da07e99c2192');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('73', '2', '2', '1', '2015-11-23 15:09:00', NULL, '2015-11-23 15:09:12', '2015-11-30 09:49:34', '6daa355d-1582-4ded-ba0b-25d65bce9a88');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('99', '2', '2', '1', '2015-11-26 13:59:00', NULL, '2015-11-26 13:59:16', '2015-11-26 15:00:31', 'c0da62f4-4167-423d-a44a-81e7a16ea75c');
INSERT INTO `craft_entries` (`id`, `sectionId`, `typeId`, `authorId`, `postDate`, `expiryDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('109', '2', '2', '1', '2015-11-30 09:23:57', NULL, '2015-11-30 09:23:58', '2015-11-30 09:23:58', 'da6d1eab-186f-448d-b967-faa8d1dd625b');



DROP TABLE IF EXISTS `craft_entrydrafts`;


--
-- Schema for table `craft_entrydrafts`
--
CREATE TABLE `craft_entrydrafts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entryId` int(11) NOT NULL,
  `sectionId` int(11) NOT NULL,
  `creatorId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `notes` tinytext COLLATE utf8_unicode_ci,
  `data` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_entrydrafts_entryId_locale_idx` (`entryId`,`locale`),
  KEY `craft_entrydrafts_sectionId_fk` (`sectionId`),
  KEY `craft_entrydrafts_creatorId_fk` (`creatorId`),
  KEY `craft_entrydrafts_locale_fk` (`locale`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_entrytypes`;


--
-- Schema for table `craft_entrytypes`
--
CREATE TABLE `craft_entrytypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sectionId` int(11) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `hasTitleField` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `titleLabel` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'Title',
  `titleFormat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sortOrder` tinyint(4) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_entrytypes_name_sectionId_unq_idx` (`name`,`sectionId`),
  UNIQUE KEY `craft_entrytypes_handle_sectionId_unq_idx` (`handle`,`sectionId`),
  KEY `craft_entrytypes_sectionId_fk` (`sectionId`),
  KEY `craft_entrytypes_fieldLayoutId_fk` (`fieldLayoutId`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_entrytypes`
--

INSERT INTO `craft_entrytypes` (`id`, `sectionId`, `fieldLayoutId`, `name`, `handle`, `hasTitleField`, `titleLabel`, `titleFormat`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', '1', '59', 'Homepage', 'homepage', '0', NULL, '{ section.name|raw }', NULL, '2015-11-04 11:36:32', '2015-11-13 15:24:22', '1eaa4667-96cf-421f-be46-3a7b9f6d9a42');
INSERT INTO `craft_entrytypes` (`id`, `sectionId`, `fieldLayoutId`, `name`, `handle`, `hasTitleField`, `titleLabel`, `titleFormat`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', '2', '112', 'News', 'news', '0', NULL, '{headline}', NULL, '2015-11-04 11:36:32', '2015-11-26 15:00:13', '098a32c3-aaab-4533-9809-d6c2af03fdca');
INSERT INTO `craft_entrytypes` (`id`, `sectionId`, `fieldLayoutId`, `name`, `handle`, `hasTitleField`, `titleLabel`, `titleFormat`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', '3', '86', 'About', 'about', '0', NULL, '{section.name|raw}', NULL, '2015-11-10 16:22:36', '2015-11-23 16:47:24', 'f2eeb8f8-b73b-4aa6-8fb3-41706caedb29');
INSERT INTO `craft_entrytypes` (`id`, `sectionId`, `fieldLayoutId`, `name`, `handle`, `hasTitleField`, `titleLabel`, `titleFormat`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', '5', '104', 'Accreditations', 'accreditations', '0', NULL, '{section.name|raw}', NULL, '2015-11-10 16:24:52', '2015-11-25 13:58:40', '950d84fd-5426-454a-b8df-29dfe25dab04');
INSERT INTO `craft_entrytypes` (`id`, `sectionId`, `fieldLayoutId`, `name`, `handle`, `hasTitleField`, `titleLabel`, `titleFormat`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('8', '8', '95', 'Pricing', 'pricing', '0', NULL, '{ section.name|raw }', NULL, '2015-11-10 16:25:52', '2015-11-23 16:51:25', 'e807ad21-3fb6-47f9-9321-b29a0202cd28');
INSERT INTO `craft_entrytypes` (`id`, `sectionId`, `fieldLayoutId`, `name`, `handle`, `hasTitleField`, `titleLabel`, `titleFormat`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('9', '9', '89', 'Find Us', 'findUs', '0', NULL, '{section.name|raw}', NULL, '2015-11-13 09:37:14', '2015-11-23 16:47:51', '218c4bac-24d3-4e4b-ba08-54171d3a4e39');
INSERT INTO `craft_entrytypes` (`id`, `sectionId`, `fieldLayoutId`, `name`, `handle`, `hasTitleField`, `titleLabel`, `titleFormat`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('10', '10', '97', 'Treatments', 'treatments', '0', NULL, '{section.name|raw}', NULL, '2015-11-13 09:37:53', '2015-11-23 16:51:51', '87238f0c-7fa0-47ad-b6d9-8f9f9dc3c574');
INSERT INTO `craft_entrytypes` (`id`, `sectionId`, `fieldLayoutId`, `name`, `handle`, `hasTitleField`, `titleLabel`, `titleFormat`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('11', '11', '51', 'Treatments List', 'treatmentsList', '0', NULL, '{treatmentName}', NULL, '2015-11-13 11:16:57', '2015-11-13 14:48:14', '01dad867-e177-4b9b-b84d-7c1cc7c52c03');
INSERT INTO `craft_entrytypes` (`id`, `sectionId`, `fieldLayoutId`, `name`, `handle`, `hasTitleField`, `titleLabel`, `titleFormat`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('12', '12', '92', 'News', 'news', '0', NULL, '{section.name|raw}', NULL, '2015-11-13 14:41:24', '2015-11-23 16:50:06', '18bb3021-f070-42c7-b3ba-9dc3a7f817d5');
INSERT INTO `craft_entrytypes` (`id`, `sectionId`, `fieldLayoutId`, `name`, `handle`, `hasTitleField`, `titleLabel`, `titleFormat`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('13', '13', '107', 'Testimonialspg', 'testimonialspg', '0', NULL, '{section.name|raw}', NULL, '2015-11-17 14:17:42', '2015-11-25 15:15:43', 'a16e3429-048b-441b-b952-35d55b9569d8');
INSERT INTO `craft_entrytypes` (`id`, `sectionId`, `fieldLayoutId`, `name`, `handle`, `hasTitleField`, `titleLabel`, `titleFormat`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('14', '14', '114', 'Work and Social', 'workAndSocial', '0', NULL, '{section.name|raw}', NULL, '2015-11-17 16:40:59', '2015-11-30 12:35:56', 'bc57e26c-08d2-4984-8f23-05188fd5deb1');
INSERT INTO `craft_entrytypes` (`id`, `sectionId`, `fieldLayoutId`, `name`, `handle`, `hasTitleField`, `titleLabel`, `titleFormat`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('15', '15', '115', 'Young and Active', 'youngAndActive', '0', NULL, '{section.name|raw}', NULL, '2015-11-17 16:41:18', '2015-11-30 12:36:07', '48d48ccf-0b09-4276-bda8-a23de0b829cd');
INSERT INTO `craft_entrytypes` (`id`, `sectionId`, `fieldLayoutId`, `name`, `handle`, `hasTitleField`, `titleLabel`, `titleFormat`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('16', '16', '117', 'Lifetime Support', 'lifetimeSupport', '0', NULL, '{section.name|raw}', NULL, '2015-11-17 16:41:32', '2015-12-01 09:49:57', 'db2747a8-dba3-4d64-9706-48548aa26167');



DROP TABLE IF EXISTS `craft_entryversions`;


--
-- Schema for table `craft_entryversions`
--
CREATE TABLE `craft_entryversions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entryId` int(11) NOT NULL,
  `sectionId` int(11) NOT NULL,
  `creatorId` int(11) DEFAULT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `num` smallint(6) unsigned NOT NULL,
  `notes` tinytext COLLATE utf8_unicode_ci,
  `data` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_entryversions_entryId_locale_idx` (`entryId`,`locale`),
  KEY `craft_entryversions_sectionId_fk` (`sectionId`),
  KEY `craft_entryversions_creatorId_fk` (`creatorId`),
  KEY `craft_entryversions_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=131 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_entryversions`
--

INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', '4', '3', '1', 'en_gb', '1', NULL, '{\"typeId\":\"3\",\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-10 16:22:36', '2015-11-10 16:22:36', 'fe869c08-47b1-4933-bfea-c552ec9e38f7');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', '5', '5', '1', 'en_gb', '1', NULL, '{\"typeId\":\"5\",\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-10 16:24:52', '2015-11-10 16:24:52', '4103521d-5f03-4abe-b047-1d39d9b5ef73');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', '8', '9', '1', 'en_gb', '1', NULL, '{\"typeId\":\"9\",\"authorId\":null,\"title\":\"Find Us\",\"slug\":\"find-us\",\"postDate\":1447407434,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-13 09:37:14', '2015-11-13 09:37:14', '404cf88d-f367-4355-8dc7-9af7d892f75b');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', '9', '10', '1', 'en_gb', '1', NULL, '{\"typeId\":\"10\",\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-13 09:37:54', '2015-11-13 09:37:54', '2469b5ce-0473-473f-bfa5-44bfb2c7b936');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('12', '14', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Fractures\",\"slug\":\"fractures\",\"postDate\":1447415380,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\\u00a375.00\",\"24\":\"\\u00a330.00\",\"22\":\"Following a broken bone, the joints around the area will often become stiff and painful, the muscles weak and balance poor. This is easily improved with the advice, manual therapy and exercises provided by Cathedral Physiotherapy.\",\"21\":\"Fractures\"}}', '2015-11-13 11:49:40', '2015-11-13 11:49:40', '9c0b55ea-b11e-489b-a658-afc99be3ad0a');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('13', '15', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Children\\u2019s Injuries\",\"slug\":\"childrens-injuries\",\"postDate\":1447415405,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Although many children bounce back quickly after injury, if they are particularly sporty, or have lost their confidence after a sprain, strain or fracture they may need some reassurance and treatment \\/ exercises to return to their previous level of care-free fitness.\",\"21\":\"Children\\u2019s Injuries\"}}', '2015-11-13 11:50:05', '2015-11-13 11:50:05', '142f5aa6-978e-402f-b849-0bf6c33cbfea');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('14', '14', '11', '1', 'en_gb', '2', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Fractures\",\"slug\":\"fractures\",\"postDate\":1447415340,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\\u00a375.00\",\"24\":\"\\u00a330.00\",\"22\":\"Following a broken bone, the joints around the area will often become stiff and painful, the muscles weak and balance poor. This is easily improved with the advice, manual therapy and exercises provided by Cathedral Physiotherapy.\",\"21\":\"Fractures\"}}', '2015-11-13 11:50:50', '2015-11-13 11:50:50', '62803b09-b988-4007-afd3-5d1fcaa32b28');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('15', '15', '11', '1', 'en_gb', '2', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Children\\u2019s Injuries\",\"slug\":\"childrens-injuries\",\"postDate\":1447415400,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Although many children bounce back quickly after injury, if they are particularly sporty, or have lost their confidence after a sprain, strain or fracture they may need some reassurance and treatment \\/ exercises to return to their previous level of care-free fitness.\",\"21\":\"Children\\u2019s Injuries\"}}', '2015-11-13 11:50:54', '2015-11-13 11:50:54', '7e0f4b9a-97c6-4e3c-8f1a-813129a12ea3');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('16', '16', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Young adult hip pain\",\"slug\":\"young-adult-hip-pain\",\"postDate\":1447415474,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Hip pain in young adults can be caused by a number of issues from muscle imbalance around the hip, cartilage problems within the joint, bony anatomical issues or referred pain from the back or pelvis. The excellent clinical reasoning found at Cathedral Physiotherapy will help to differentiate the causes and formulate a treatment plan or onward referral as required. I have worked closely with the Royal Devon and Exeter NHS Hospital hip consultants with patients with femoral acetabular impingement in particular, including being involved in research, and so am at the cutting edge of treating this group of patients.\",\"21\":\"Young adult hip pain\"}}', '2015-11-13 11:51:14', '2015-11-13 11:51:14', '33395604-25bc-4063-bb60-35599b81bc06');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('17', '17', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Sports Injuries\",\"slug\":\"sports-injuries\",\"postDate\":1447415494,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Whether you are after prevention or cure, Cathedral Physiotherapy can help you. Excellent assessment will ensure that you receive the treatment you require, be it a combination of functional exercise, manual therapy, ultrasound, taping or acupuncture. We have a small exercise area in the clinic, but can also adapt your training program for your to rehabilitate at your own gym \\/ pool.\",\"21\":\"Sports Injuries\"}}', '2015-11-13 11:51:34', '2015-11-13 11:51:34', '2a87a3d8-0b0d-445c-8f77-41426fab36b8');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('18', '18', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Haemophilia\",\"slug\":\"haemophilia\",\"postDate\":1447415511,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"For those individuals diagnosed with haemophilia, early access to physiotherapy is crucial following a bleed. This is a niche area that Sarah has worked in as the designated haemophilia physiotherapy specialist at the Royal Devon and Exeter hospital over the last few years, so you can be assured that you are in safe hands\",\"21\":\"Haemophilia\"}}', '2015-11-13 11:51:51', '2015-11-13 11:51:51', '8c04501e-a9a6-440f-a860-f6c9b3af5eb0');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('19', '19', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Work-related pain\",\"slug\":\"work-related-pain\",\"postDate\":1447415594,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Whether you work at a desk all day, or prune trees for a living, at some point during your working life you are likely to suffer from pain related to your occupation. In fact, 60% of people on long term sick leave cite musculoskeletal disorders as the cause. Rapid access to musculoskeletal physiotherapy can reduce the amount of time people are off sick, and it is vital in preventing a new acute problem becoming chronic and long lasting (Department of health, 2008).\",\"21\":\"Work-related pain\"}}', '2015-11-13 11:53:14', '2015-11-13 11:53:14', 'f4296810-8484-4537-9573-493e648ff2f3');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('20', '20', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Sprains and Strains\",\"slug\":\"sprains-and-strains\",\"postDate\":1447415609,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Minor sprains and strains can be managed with PRICE therapy:\\r\\nProtect the area using a support temporarily, Rest the are for the first 48-72 hrs, apply Ice wrapped in a damp towel for 15-20 mins every 2-3 hrs of the day for the first 72 hrs (be careful not to place ice directly on the skin), Compress or bandage the injured area to limit swelling, being careful not to affect the blood flow and remove the bandage before sleep, Elevate the injured area, supported on a pillow, to reduce the swelling. Ultrasound and taping can also promote healing. Following this we will help rehabilitate you range of movement, strength and balance so that you return to your full function.\",\"21\":\"Sprains and Strains\"}}', '2015-11-13 11:53:29', '2015-11-13 11:53:29', '702edaed-3122-4a05-a20a-9ebc5b12471c');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('21', '21', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Back Pain\",\"slug\":\"back-pain\",\"postDate\":1447415628,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Low back pain is reported by 80% of people at sometime in their life. A large percentage of this will improve with basic advice and exercises, but some people need more specific treatment (work-related advice, functional exercises, manual therapy, or acupuncture). Come and be assessed today so that we can help you on your road to recovery, and to help prevent recurrence.\",\"21\":\"Back Pain\"}}', '2015-11-13 11:53:48', '2015-11-13 11:53:48', 'd28920ae-0b6a-4035-8ed0-07f07ce065af');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('22', '22', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Neck Pain\",\"slug\":\"neck-pain\",\"postDate\":1447415641,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Neck pain is common but most cases aren\\u2019t caused by a serious problem. Some people get it after an accident or injury, whilst others find it appears if they are stressed, or inactive, or it can be related to age-related changes in the structures of the neck. Commonly felt locally in the neck, it can also refer to the shoulder \\/ arm, and sometimes may cause pins and needles \\/ numbness. With good advice, reassurance, specific exercises and sometimes manual therapy, the majority of neck pain improved within about six weeks.\",\"21\":\"Neck Pain\"}}', '2015-11-13 11:54:01', '2015-11-13 11:54:01', 'f6c72ade-7fa8-444d-909a-ea1a1b5b4b9d');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('23', '23', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Shoulder \\/ Elbow \\/ Wrist pain\",\"slug\":\"shoulder-elbow-wrist-pain\",\"postDate\":1447415655,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Whether your pain is work or hobby related it is important to get the correct advice early to prevent chronicity. Arm pain can be referred from the neck, but is more commonly related to impingement of the tendons, or tears of the muscle, but can also be due to \\u2018frozen shoulder\\u2019. Elbow complaints include tennis elbow, golfers elbow, or nerve irritation. Wrist pain is commonly related to the position of the wrist at work or during hobbies, but can be due to stiffness post fracture, or carpal tunnel syndrome. An excellent assessment will differentiate the problem and help you to manage and improve your symptoms.\",\"21\":\"Shoulder \\/ Elbow \\/ Wrist pain\"}}', '2015-11-13 11:54:15', '2015-11-13 11:54:15', '5b928936-a492-4773-a31b-28a4c64fbf82');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('24', '24', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Hip \\/ Knee \\/ Ankle pain\",\"slug\":\"hip-knee-ankle-pain\",\"postDate\":1447415673,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Hip pain - Problems with cartilage, early osteoarthritis, tendonopathy, sprains and muscle imbalances can all cause hip pain, but it can also be referred from the back. Accurate assessment is crucial to ensure you have the right treatment to improve your problem.\",\"21\":\"Hip \\/ Knee \\/ Ankle pain\"}}', '2015-11-13 11:54:33', '2015-11-13 11:54:33', 'b17bf898-d7bc-403f-ad16-f10c1979fadd');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('25', '24', '11', '1', 'en_gb', '2', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Hip \\/ Knee \\/ Ankle pain\",\"slug\":\"hip-knee-ankle-pain\",\"postDate\":1447415640,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Hip pain - Problems with cartilage, early osteoarthritis, tendonopathy, sprains and muscle imbalances can all cause hip pain, but it can also be referred from the back. Accurate assessment is crucial to ensure you have the right treatment to improve your problem.\\r\\n\\r\\nKnee pain \\u2013 Be it local pain, swelling or stiffness secondary to an acute injury to the ligaments of the joint, more insidious in nature, or referred pain, once diagnosed, the majority of problems will significantly improve with a specific functional exercise program, but if necessary it can also be treated with manual therapy, ultrasound, taping or acupuncture too.\\r\\n\\r\\nAnkle pain \\u2013 The majority of people have sustained a sprained ankle at some point, and we can offer acute treatment for this with ultrasound, soft tissie therapy, taping and exercises. However, we rely on our legs heavily, and the key is to prevent it recurring again through specific rehabilitation, so that you can stay as fit and active as you wish.\",\"21\":\"Hip \\/ Knee \\/ Ankle pain\"}}', '2015-11-13 11:55:11', '2015-11-13 11:55:11', 'ea7b859f-92af-4f03-bf48-f6c585ecf72a');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('26', '25', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Orthopaedic post operative care\",\"slug\":\"orthopaedic-post-operative-care\",\"postDate\":1447415727,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Come to Cathedral Physiotherapy for your post operative care. Be it following a fracture, ligament reconstruction, hip arthroscopy, or joint replacement we can help you regain your independence. Having worked at the Royal Devon and Exeter hospital for the last 11 years I have strong links with the orthopaedic teams there.\",\"21\":\"Orthopaedic post operative care\"}}', '2015-11-13 11:55:27', '2015-11-13 11:55:27', 'ccd4c3eb-b2d1-457e-badb-74fb6a799587');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('27', '26', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Post fracture rehabilitation\",\"slug\":\"post-fracture-rehabilitation\",\"postDate\":1447415743,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"It is quite common to have on-going problems with pain, swelling and stiffness in the joints surrounding the area where you have fractured. However the real issue, is that people often lose their confidence too. Let us rehabilitate you back to your previous level of function or fitness allowing you to live your life to the full.\",\"21\":\"Post fracture rehabilitation\"}}', '2015-11-13 11:55:43', '2015-11-13 11:55:43', '3d3f1be6-222c-4617-b922-5e72551a6baf');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('28', '27', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Non specific arm pain\",\"slug\":\"non-specific-arm-pain\",\"postDate\":1447415755,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Characterised by ongoing pain, altered sensations in the hand \\/ arm and sometime feelings of weakness, this can be a frustrating condition to have, particularly as commonly many objective medical test are negative. Often, modifications to posture, work stations, gaining an understanding of pain mechanisms, and local tissues techniques can improve symptoms and function.\",\"21\":\"Non specific arm pain\"}}', '2015-11-13 11:55:55', '2015-11-13 11:55:55', 'd2401347-ebce-478b-a373-ed6333d916a8');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('29', '28', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Thoracic Outlet Syndrome\",\"slug\":\"thoracic-outlet-syndrome\",\"postDate\":1447415768,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Characterised by neck \\/ shoulder \\/ arm pain, feelings of weakness in the arm (particularly with overhead activities), and possible discolouration of the hand, this condition can be debilitating. With good quality conservative physiotherapy, symptoms and function can be significantly improved, thereby improving your quality of life.\",\"21\":\"Thoracic Outlet Syndrome\"}}', '2015-11-13 11:56:08', '2015-11-13 11:56:08', '020dc947-b96f-43ea-8ef8-bc2fd13dc577');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('30', '29', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Headaches and Dizziness\",\"slug\":\"headaches-and-dizziness\",\"postDate\":1447415786,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Benign headaches can be caused by tension in the muscles, stiffness in the neck or muscle imbalance. Often characterised by being one-sided, or in a band around the head, and associated with neck pain, or certain movements, symptoms can be improved significantly with a combination of exercise, manual therapy, acupuncture and an understanding of pain pathways.\\r\\n\\r\\nDizziness can be generated from the neck, the inner ear or the brain, and accurate differential diagnosis is crucial for appropriate treatment.\",\"21\":\"Headaches and Dizziness\"}}', '2015-11-13 11:56:26', '2015-11-13 11:56:26', '8ebd44c9-7d44-45b9-8c57-96b5f260211d');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('31', '30', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Pregnancy related pain\",\"slug\":\"pregnancy-related-pain\",\"postDate\":1447415802,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Pregnancy related pelvic girdle pain is common and affects 1 in 5 women during their pregnancy. There are a wide range of symptoms, some of which improve naturally during the course of the pregnancy as your body adapts, some which need advice and \\/or treatment early on to keep you as active as possible. Don\\u2019t suffer in silence, get help early.\",\"21\":\"Pregnancy related pain\"}}', '2015-11-13 11:56:42', '2015-11-13 11:56:42', 'd1cf87a7-daae-495a-9de6-26ee84bedb8c');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('32', '31', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Management of long term conditions\",\"slug\":\"management-of-long-term-conditions\",\"postDate\":1447415815,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Some people are diagnosed with long term conditions, be it persistent pain generated by the nervous system, or on-going musculoskeletal problems following a car crash. At Cathedral Physiotherapy we believe in working with you to assist you to maximise your physical potential. \",\"21\":\"Management of long term conditions\"}}', '2015-11-13 11:56:55', '2015-11-13 11:56:55', '7e2b9bf1-23a3-42ea-a3b3-828788211214');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('33', '32', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Rheumatological conditions\",\"slug\":\"rheumatological-conditions\",\"postDate\":1447415831,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Although consisting of a variety of diagnosis, for instance Rheumatoid Arthritis, Ankylosing Spondylitis, Psoriatic Arthritis etc, many of these diseases follow a period of flare and recovery. At Cathedral Physiotherapy we can help you not to be defined by your diagnosis, assist you through your flares, and maximise your return to function so that you continue to lead and full and fruitful life.\",\"21\":\"Rheumatological conditions\"}}', '2015-11-13 11:57:11', '2015-11-13 11:57:11', '34195ca3-b586-493a-90e6-85d960fcf541');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('34', '33', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Osteoarthritis\",\"slug\":\"osteoarthritis\",\"postDate\":1447415848,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Osteoarthritis is a common type of arthritis, a painful condition which can affect the joints especially the hips, knees, neck, lower back, hand or feet. Although it can occur at any age, it is more likely to appear between the ages of 45-75 years, and often in women more than men. There is much evidence showing that a combination of non steroidal anti-inflammatories and exercise or physiotherapy will help to reduce the symptoms of pain and stiffness, allowing you not to be restricted by your symptoms.\",\"21\":\"Osteoarthritis\"}}', '2015-11-13 11:57:28', '2015-11-13 11:57:28', '2594fb7b-0ac8-4663-b723-42ccfa15b329');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('35', '34', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Joint Replacements\",\"slug\":\"joint-replacements\",\"postDate\":1447415859,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Following total or partial knee replacement, hip replacement or shoulder replacement, good quality regular physiotherapy is important to decrease swelling and pain and increase range of movement, muscle power and function. We are a lower ground premises, therefore you need to be able to complete one flight of stairs, however if access is an issue, contact us and we will discuss the possibility of a domiciliary visit.\",\"21\":\"Joint Replacements\"}}', '2015-11-13 11:57:39', '2015-11-13 11:57:39', 'e88f1c88-303b-490a-98e4-531e08e489ab');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('36', '35', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Osteoporosis\",\"slug\":\"osteoporosis\",\"postDate\":1447415870,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Having been the principle investigator for Exeter on the PROVE trial (2014-16) looking into rehabilitation of patients with osteoporosis who have vertebral fractures, I am well qualified to help you manage your condition, and to keep you as fit and active as possible.\",\"21\":\"Osteoporosis\"}}', '2015-11-13 11:57:51', '2015-11-13 11:57:51', 'eea9fb71-e882-493e-9b3d-1762b77d93cd');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('37', '36', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Post Cancer Rehabilitation\",\"slug\":\"post-cancer-rehabilitation\",\"postDate\":1447415883,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Most people are so relieved to have stopped the active stage of their treatment, be it radiotherapy or chemotherapy, that they are happy to live with compromises in function for a time. However, it is common to become frustrated with these compromises once your energy returns. We passionately  believe that you should not be defined by your diagnosis, and will work hard with you to facilitate and maximise your return to function; be it to improve your shoulder range of movement post breast surgery so that you can reach the top cupboards, or return to tennis and swimming again.\",\"21\":\"Post Cancer Rehabilitation\"}}', '2015-11-13 11:58:03', '2015-11-13 11:58:03', '3b90e2bb-fe59-4891-bc02-8e0158e162fc');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('38', '37', '11', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Mild Continence Issues\",\"slug\":\"mild-continence-issues\",\"postDate\":1447415900,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Bladder or bowel continence issues can be embarrassing, but when it is only a mild issue much can be done with pelvic floor exercises and fluid intake management. We can happily treat mild continence issues e.g. post pregnancy, or stress incontinence related to respiratory problems. If we feel your continence issues need further input, then we will refer you on to the appropriate practitioner.\",\"21\":\"Mild Continence Issues\"}}', '2015-11-13 11:58:20', '2015-11-13 11:58:20', '31fcb91e-0c6e-4a40-9801-9e4958bdb4fd');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('39', '9', '10', '1', 'en_gb', '2', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"26\":{\"new2\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Young & Active\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"17\",\"16\",\"15\"]}},\"new1\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Work and Social\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"28\",\"29\",\"30\"]}},\"new3\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Lifetime Support\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"31\",\"33\",\"34\",\"35\",\"36\",\"37\"]}}}}}', '2015-11-13 12:31:57', '2015-11-13 12:31:57', '9a1ac544-7735-4678-a204-4d03c753f536');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('40', '9', '10', '1', 'en_gb', '3', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Treatments\",\"26\":{\"38\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Young & Active\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"17\",\"16\",\"15\"],\"treatmentImage\":[\"41\"]}},\"39\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Work and Social\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"treatmentImage\":[\"41\"]}},\"40\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Lifetime Support\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"31\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"treatmentImage\":[\"41\"]}}}}}', '2015-11-13 12:49:45', '2015-11-13 12:49:45', '3fb9a614-c5f2-4b3b-8bab-f3eef77b420a');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('43', '2', '1', '1', 'en_gb', '1', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-13 14:09:26', '2015-11-13 14:09:26', '017e37be-e896-471e-ab23-df1fcd3bec9c');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('44', '47', '12', '1', 'en_gb', '1', NULL, '{\"typeId\":\"12\",\"authorId\":null,\"title\":\"News\",\"slug\":\"news\",\"postDate\":1447425684,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-13 14:41:24', '2015-11-13 14:41:24', '719fd1b0-10b0-45a5-86a6-fe2290c0ad50');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('45', '49', '2', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Winter Chills\",\"slug\":\"winter-chills\",\"postDate\":1447428178,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"During the winter months aches and pains in joints can feel more painful and make getting up in the morning painful. Our specialities include treatment of injuries and conditions related to the joints and can help reduce pain, swelling and discomfort.\\r\\n\\r\\nGet in touch to find out how we can help you make your winter more enjoyable.\",\"38\":[\"48\"],\"37\":\"Winter Chills\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-13 15:22:59', '2015-11-13 15:22:59', '16d6d881-31fc-4605-a64d-006616751d4f');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('46', '4', '3', '1', 'en_gb', '2', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities which represents cathedral physiotherapy.\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy, who is passionate about providing the best possible care. \",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-13 15:27:55', '2015-11-13 15:27:55', '6dfd25d3-a20c-4dd4-9041-2ec141f18c57');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('47', '5', '5', '1', 'en_gb', '2', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-13 15:29:11', '2015-11-13 15:29:11', 'e623a286-65a2-4369-a095-a7c6dcbfa3ff');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('48', '8', '9', '1', 'en_gb', '2', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Find Us\",\"slug\":\"find-us\",\"postDate\":1447407434,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Find Us\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-13 15:29:43', '2015-11-13 15:29:43', '49785071-0f14-4f4e-b6a5-3ba3505e459d');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('49', '2', '1', '1', 'en_gb', '2', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Physiotherapy helps to restore movement and function when someone has been affected by injury, work-related problems, illness or disease. It is a science-based profession and takes a \\u2018whole person\\u2019 approach to health and wellbeing, which includes the patient\\u2019s general lifestyle. At the core is the patient\\u2019s involvement in their own care, through education, awareness, empowerment and participation in their treatment:\",\"6\":\"We stand for Excellence, Experience and Enthusiasm \",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-13 15:30:09', '2015-11-13 15:30:09', 'ce6b17b1-db33-4896-b274-41b929b9227d');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('50', '47', '12', '1', 'en_gb', '2', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"News\",\"slug\":\"news\",\"postDate\":1447425684,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Latest News\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-13 15:30:57', '2015-11-13 15:30:57', '1686940d-bdc6-4606-8143-8ed2584f998c');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('51', '9', '10', '1', 'en_gb', '4', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Treatments\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"26\":{\"38\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Young & Active\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"17\",\"16\",\"15\"],\"treatmentImage\":[\"41\"]}},\"39\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Work and Social\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"treatmentImage\":[\"41\"]}},\"40\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Lifetime Support\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"31\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"treatmentImage\":[\"41\"]}}}}}', '2015-11-13 15:32:11', '2015-11-13 15:32:11', '835ef35c-8b6f-482c-b6ff-6b0ccba054f9');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('52', '50', '2', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Test News Article\",\"slug\":\"test-news-article\",\"postDate\":1447429414,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.\",\"38\":\"\",\"37\":\"Test News Article\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-13 15:43:34', '2015-11-13 15:43:34', '47973350-0855-4aa6-975b-c69bb3759734');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('53', '50', '2', '1', 'en_gb', '2', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Test News Article\",\"slug\":\"test-news-article\",\"postDate\":1447429380,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.\",\"38\":[\"51\"],\"37\":\"Test News Article\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-13 15:44:55', '2015-11-13 15:44:55', '0153c55b-5981-4db2-91aa-99494938d485');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('54', '9', '10', '1', 'en_gb', '5', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Treatments\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"26\":{\"38\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Young & Active\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"17\",\"16\",\"15\"],\"treatmentImage\":[\"41\"]}},\"39\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Work & Social\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"treatmentImage\":[\"41\"]}},\"40\":{\"type\":\"treatment\",\"enabled\":\"1\",\"fields\":{\"mainHeading\":\"Lifetime Support\",\"introParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"addTreatments\":[\"31\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"treatmentImage\":[\"41\"]}}}}}', '2015-11-16 16:59:48', '2015-11-16 16:59:48', '8ee0bf74-bf4a-4f20-84e5-ebd62406eab8');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('55', '4', '3', '1', 'en_gb', '3', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities which represents cathedral physiotherapy.\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy, who is passionate about providing the best possible care. \",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"39\":{\"new1\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"new2\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. Currently her time is split between working as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, where she has been working for the last 12 years, and running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"new3\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. Sarah is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"new1\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute fo rHealth Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and audit a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-11-17 11:20:23', '2015-11-17 11:20:23', '6abf630d-61cd-4427-adf9-f6b05109fd50');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('56', '4', '3', '1', 'en_gb', '4', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities which represents cathedral physiotherapy.\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy, who is passionate about providing the best possible care. \",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"39\":{\"52\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"53\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. Currently her time is split between working as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, where she has been working for the last 12 years, and running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"54\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. Sarah is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"55\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"profilePhoto\":[\"56\"],\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute fo rHealth Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and audit a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-11-17 12:00:42', '2015-11-17 12:00:42', '4d1bff0b-1af2-4188-8bfe-f4afcdc92814');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('59', '57', '8', '1', 'en_gb', '1', NULL, '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769269,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-17 14:07:49', '2015-11-17 14:07:49', '45004983-11c3-43da-8f45-5c1914f7a0d6');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('60', '57', '8', '1', 'en_gb', '2', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769269,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Placeholder text for pricing page intro paragraph.\",\"6\":\"Heading for pricing placeholder\"}}', '2015-11-17 14:09:38', '2015-11-17 14:09:38', '1565a0b4-83c8-4acc-962c-02631f1353d5');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('61', '57', '8', '1', 'en_gb', '3', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769269,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Placeholder text for pricing page intro paragraph.\",\"6\":\"Heading for pricing placeholder\"}}', '2015-11-17 14:14:16', '2015-11-17 14:14:16', '7e29dda1-570c-46bd-9f57-e1184c76fe78');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('62', '58', '13', '1', 'en_gb', '1', NULL, '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonialspg\",\"slug\":\"testimonialspg\",\"postDate\":1447769862,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-17 14:17:42', '2015-11-17 14:17:42', '5459c343-8685-4bf1-9643-264b44e90805');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('63', '58', '13', '1', 'en_gb', '2', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-17 14:21:47', '2015-11-17 14:21:47', 'c283b5d7-6a1d-4438-b7c2-deb88482c3cf');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('64', '58', '13', '1', 'en_gb', '3', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Placeholder heading for testimonials\",\"6\":\"Placeholder text for testimonials intro paragraph\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-17 14:23:17', '2015-11-17 14:23:17', '6ed79e46-51fb-4e8f-b579-7b76c43f543a');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('65', '58', '13', '1', 'en_gb', '4', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Placeholder heading for testimonials\",\"6\":\"Placeholder text for testimonials intro paragraph\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"new1\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerforename\":\"James\",\"location\":\"Exeter\",\"quote\":\"Sarah treated a knee injury I couldn\'t shake off. Now I\'m completely pain free and back playing football.\"}},\"new2\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerforename\":\"Andy\",\"location\":\"Exeter\",\"quote\":\"I got injured just before a big table tennis game, but Sarah treated my arm just in time - unfortunately I still lost!\"}}}}}', '2015-11-17 15:45:10', '2015-11-17 15:45:10', '96dda8e2-68c4-4df8-bcdb-24dc1bf47227');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('66', '61', '14', '1', 'en_gb', '1', NULL, '{\"typeId\":\"14\",\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1447778459,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-17 16:40:59', '2015-11-17 16:40:59', '779807a7-bdc0-4d20-8500-486375ddfb45');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('67', '62', '15', '1', 'en_gb', '1', NULL, '{\"typeId\":\"15\",\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1447778478,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-17 16:41:18', '2015-11-17 16:41:18', 'a06942b5-a78c-4ce9-ab29-0f58e002f81a');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('68', '63', '16', '1', 'en_gb', '1', NULL, '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1447778492,\"expiryDate\":null,\"enabled\":1,\"fields\":[]}', '2015-11-17 16:41:32', '2015-11-17 16:41:32', '16dda47c-8dad-4f7f-ae54-d85415e73e8b');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('69', '61', '14', '1', 'en_gb', '2', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1447778459,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"41\"]}}', '2015-11-17 16:51:00', '2015-11-17 16:51:00', '02255c85-9036-4645-a9bf-1a181cf1ab77');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('70', '62', '15', '1', 'en_gb', '2', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Young and Active\",\"slug\":\"young-and-active\",\"postDate\":1447778478,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"52\":[\"17\",\"16\",\"15\"],\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec.\",\"6\":\"Young & Active\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"41\"]}}', '2015-11-17 16:51:31', '2015-11-17 16:51:31', '3209a607-4a4c-467c-9715-2e6d64896cdf');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('71', '63', '16', '1', 'en_gb', '2', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1447778492,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"41\"]}}', '2015-11-17 16:52:15', '2015-11-17 16:52:15', 'de8c148b-8420-4924-8109-5524b8a9ae77');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('72', '50', '2', '1', 'en_gb', '3', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Test News Article\",\"slug\":\"test-news-article\",\"postDate\":1447429380,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"This is a test news article about nothing in particular.\",\"38\":[\"51\"],\"37\":\"Test News Article\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-19 10:53:43', '2015-11-19 10:53:43', 'fde2d752-e00c-4f81-a91e-b0a53bebeaad');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('73', '65', '2', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Sports injuries\",\"slug\":\"sports-injuries\",\"postDate\":1447933081,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Tips for treating sports injuries immediately after they happen. Use ice to reduce swelling.\",\"38\":[\"64\"],\"37\":\"Sports injuries\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-19 11:38:01', '2015-11-19 11:38:01', '687a5b68-f0a4-4189-96f6-7037cbe31a4a');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('74', '68', '2', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Back pain tips\",\"slug\":\"back-pain-tips\",\"postDate\":1447933194,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Mobilise your back, go swimming etc etc\",\"38\":[\"66\"],\"37\":\"Back pain tips\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-19 11:39:54', '2015-11-19 11:39:54', 'd1e19b1e-b5e5-4e6d-8be8-d85784ba169a');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('75', '69', '2', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Arthritis\",\"slug\":\"arthritis\",\"postDate\":1447933261,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"We can help you manage the pain a recommend techniques to reduce the debilitating effects.\",\"38\":[\"67\"],\"37\":\"Arthritis\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-19 11:41:01', '2015-11-19 11:41:01', 'e529de78-0f58-46dd-906e-c1c9e8ebfe6b');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('76', '50', '2', '1', 'en_gb', '4', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Muscle Pain\",\"slug\":\"test-news-article\",\"postDate\":1447429380,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"This is a test news article about nothing in particular.\",\"38\":[\"51\"],\"37\":\"Muscle Pain\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-19 11:41:33', '2015-11-19 11:41:33', 'ac172559-0c54-48b1-913e-ebfdf2cab6a1');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('77', '71', '2', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Preventing tennis elbow\",\"slug\":\"preventing-tennis-elbow\",\"postDate\":1447933380,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Our top tips on how to prevent tennis elbow\",\"38\":[\"70\"],\"37\":\"Preventing tennis elbow\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-19 11:43:00', '2015-11-19 11:43:00', '830841aa-d90e-4146-a83a-cfc086bd756e');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('78', '61', '14', '1', 'en_gb', '3', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1447778459,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"41\"]}}', '2015-11-19 14:53:06', '2015-11-19 14:53:06', '51e0d10c-481c-4760-b5f1-6ad3f51376d0');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('79', '19', '11', '1', 'en_gb', '2', NULL, '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Work-related pain\",\"slug\":\"work-related-pain\",\"postDate\":1447415594,\"expiryDate\":null,\"enabled\":\"1\",\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Whether you work at a desk all day, or prune trees for a living, at some point during your working life you are likely to suffer from pain related to your occupation. In fact, 60% of people on long term sick leave cite musculoskeletal disorders as the cause. Rapid access to musculoskeletal physiotherapy can reduce the amount of time people are off sick, and it is vital in preventing a new acute problem becoming chronic and long lasting (Department of health,).\",\"21\":\"Work-related pain\"}}', '2015-11-19 14:53:46', '2015-11-19 14:53:46', 'bc719e73-a03e-4d72-a7c9-b5a646bd21ab');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('80', '19', '11', '1', 'en_gb', '3', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Work-related pain\",\"slug\":\"work-related-pain\",\"postDate\":1447415580,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"\",\"24\":\"\",\"22\":\"Whether you work at a desk all day, or prune trees for a living, at some point during your working life you are likely to suffer from pain related to your occupation. In fact, 60% of people on long term sick leave cite musculoskeletal disorders as the cause. Rapid access to musculoskeletal physiotherapy can reduce the amount of time people are off sick, and it is vital in preventing a new acute problem becoming chronic and long lasting (Department of health, 2008).\",\"21\":\"Work-related pain\"}}', '2015-11-19 14:54:28', '2015-11-19 14:54:28', '30d3b945-4b78-428c-83e9-6dc4598317b6');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('81', '71', '2', '1', 'en_gb', '2', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Preventing tennis elbow\",\"slug\":\"preventing-tennis-elbow\",\"postDate\":1447933380,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Our top tips on how to prevent tennis elbow. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen\",\"38\":[\"70\"],\"37\":\"Preventing tennis elbow\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 09:51:36', '2015-11-23 09:51:36', '07878c97-a3dd-4be2-b860-905b2f05b86d');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('82', '69', '2', '1', 'en_gb', '2', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Arthritis\",\"slug\":\"arthritis\",\"postDate\":1447933260,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"We can help you manage the pain a recommend techniques to reduce the debilitating effects. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen\",\"38\":[\"67\"],\"37\":\"Arthritis\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 09:51:43', '2015-11-23 09:51:43', 'c4f0abd1-1d25-4b69-a616-9e73941f76d8');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('83', '68', '2', '1', 'en_gb', '2', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Back pain tips\",\"slug\":\"back-pain-tips\",\"postDate\":1447933140,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Mobilise your back, go swimming etc etc Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen\",\"38\":[\"66\"],\"37\":\"Back pain tips\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 09:51:50', '2015-11-23 09:51:50', '03229134-4d98-4056-88ca-121a00199a93');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('84', '65', '2', '1', 'en_gb', '2', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Sports injuries\",\"slug\":\"sports-injuries\",\"postDate\":1447933080,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Tips for treating sports injuries immediately after they happen. Use ice to reduce swelling. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen\",\"38\":[\"64\"],\"37\":\"Sports injuries\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 09:51:56', '2015-11-23 09:51:56', 'c2f2e134-5b58-405c-8640-f700ed6eb84a');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('85', '65', '2', '1', 'en_gb', '3', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Sports injuries\",\"slug\":\"sports-injuries\",\"postDate\":1447933080,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Tips for treating sports injuries immediately after they happen. Use ice to reduce swelling. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen\",\"38\":[\"64\"],\"37\":\"Sports injuries\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 09:52:02', '2015-11-23 09:52:02', 'e20dc929-e593-4804-a1f0-a82514ab344c');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('86', '50', '2', '1', 'en_gb', '5', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Muscle Pain\",\"slug\":\"test-news-article\",\"postDate\":1447429380,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"This is a test news article about nothing in particular. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen\",\"38\":[\"51\"],\"37\":\"Muscle Pain\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 09:52:08', '2015-11-23 09:52:08', '9b900c4d-aab1-4f41-9c3b-b942ca18eb2e');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('87', '49', '2', '1', 'en_gb', '2', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Winter Chills\",\"slug\":\"winter-chills\",\"postDate\":1447428120,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"During the winter months aches and pains in joints can feel more painful and make getting up in the morning painful. Our specialities include treatment of injuries and conditions related to the joints and can help reduce pain, swelling and discomfort.\\r\\n\\r\\nSed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen\",\"38\":[\"48\"],\"37\":\"Winter Chills\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 09:52:17', '2015-11-23 09:52:17', '0f860d42-b149-452c-8d09-26bb43dfaa79');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('88', '9', '10', '1', 'en_gb', '6', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Treatments\",\"slug\":\"treatments\",\"postDate\":1447407473,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Physiotherapy helps to restore movement and function when someone has been affected by injury, work-related problems, illness or disease. It is a science-based profession and takes a \\u2018whole person\\u2019 approach to health and wellbeing, which includes the patient\\u2019s general lifestyle. At the core is the patient\\u2019s involvement in their own care, through education, awareness, empowerment and participation in their treatment. Please look through the lists below and see how we can help you. \",\"6\":\"Treatments\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 11:02:49', '2015-11-23 11:02:49', 'ae22f698-a792-46e9-9d96-b730e1e0ddb9');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('89', '47', '12', '1', 'en_gb', '3', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"News\",\"slug\":\"news\",\"postDate\":1447425684,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Welcome to our news page which includes information from self-help advice for what to do as soon as you\\u2019ve hurt yourself, to topical items in the news, and copies of our monthly news letter. There are also a number of useful links to u-tube clips which we feel are useful. If there is something that isn\\u2019t here and you would like to see, then please email us as enquiries@cathedralphysiotherapy.co.uk and we will do our best to respond to your suggestions.\",\"6\":\"Latest News\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 11:03:29', '2015-11-23 11:03:29', '42f8d12b-38e4-4e00-98f8-0cd07bf5b104');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('90', '71', '2', '1', 'en_gb', '3', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Preventing tennis elbow\",\"slug\":\"preventing-tennis-elbow\",\"postDate\":1447933380,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Our top tips on how to prevent tennis elbow. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.\\r\\n\\r\\nNemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.\\r\\n\\r\\nUt enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen\",\"38\":[\"70\"],\"37\":\"Preventing tennis elbow\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 11:13:38', '2015-11-23 11:13:38', '2d119b17-3b3f-450d-8892-d6d2916588d1');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('91', '71', '2', '1', 'en_gb', '4', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Preventing tennis elbow\",\"slug\":\"preventing-tennis-elbow\",\"postDate\":1447933380,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Our top tips on how to prevent tennis elbow. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.\\r\\n\\r\\nNemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.\\r\\n\\r\\nUt enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen\",\"38\":[\"70\"],\"54\":\"This is the intro to the article in a short sentence.\",\"37\":\"Preventing tennis elbow\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 11:17:16', '2015-11-23 11:17:16', '819e0e44-f8eb-45ca-bfa5-861fe2d4c7bb');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('92', '69', '2', '1', 'en_gb', '3', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Arthritis\",\"slug\":\"arthritis\",\"postDate\":1447933260,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"We can help you manage the pain a recommend techniques to reduce the debilitating effects. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen\",\"38\":[\"67\"],\"54\":\"This is the intro to the article in a short sentence.\",\"37\":\"Arthritis\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 11:17:25', '2015-11-23 11:17:25', '7249ff4a-39e1-4296-ac92-5e03d598d7d1');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('93', '68', '2', '1', 'en_gb', '3', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Back pain tips\",\"slug\":\"back-pain-tips\",\"postDate\":1447933140,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Mobilise your back, go swimming etc etc Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen\",\"38\":[\"66\"],\"54\":\"This is the intro to the article in a short sentence.\",\"37\":\"Back pain tips\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 11:17:34', '2015-11-23 11:17:34', '0574ec45-b257-4de3-89e5-f9efed6c8478');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('94', '65', '2', '1', 'en_gb', '4', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Sports injuries\",\"slug\":\"sports-injuries\",\"postDate\":1447933080,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Tips for treating sports injuries immediately after they happen. Use ice to reduce swelling. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen\",\"38\":[\"64\"],\"54\":\"This is the intro to the article in a short sentence.\",\"37\":\"Sports injuries\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 11:17:41', '2015-11-23 11:17:41', '9a11fbe7-cfdf-4f1b-a8e8-70da8dcda397');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('95', '50', '2', '1', 'en_gb', '6', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Muscle Pain\",\"slug\":\"test-news-article\",\"postDate\":1447429380,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"This is a test news article about nothing in particular. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen\",\"38\":[\"51\"],\"54\":\"This is the intro to the article in a short sentence.\",\"37\":\"Muscle Pain\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 11:17:46', '2015-11-23 11:17:46', '42bb58d2-0a9c-409f-9e0e-0cef74159ec0');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('96', '49', '2', '1', 'en_gb', '3', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Winter Chills\",\"slug\":\"winter-chills\",\"postDate\":1447428120,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"During the winter months aches and pains in joints can feel more painful and make getting up in the morning painful. Our specialities include treatment of injuries and conditions related to the joints and can help reduce pain, swelling and discomfort.\\r\\n\\r\\nSed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen\",\"38\":[\"48\"],\"54\":\"This is the intro to the article in a short sentence.\",\"37\":\"Winter Chills\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 11:17:51', '2015-11-23 11:17:51', '50e58bf8-a421-45f1-bf68-afb2928cc70a');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('97', '72', '2', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Test article\",\"slug\":\"test-article\",\"postDate\":1448278796,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi venenatis eros nunc, at venenatis nibh gravida nec. Donec tincidunt lectus vel bibendum auctor. Aenean congue aliquam turpis, ac scelerisque elit consequat ut. Fusce at metus congue, mattis quam in, eleifend metus. Sed ipsum ipsum, ultricies vel sem nec, ultricies fringilla purus. Fusce a tortor eget lorem dapibus placerat. Aenean ut arcu in lorem finibus sagittis. Suspendisse venenatis, urna ut tempus finibus, mauris dui malesuada lectus, at mattis tortor lorem nec purus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi venenatis eros nunc, at venenatis nibh gravida nec. \",\"38\":\"\",\"54\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi venenatis eros nunc, at venenatis.\",\"37\":\"Test article\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 11:39:56', '2015-11-23 11:39:56', '1f54dd0a-aea2-4175-b4b1-92acc1f2c624');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('98', '73', '2', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Another Test Article\",\"slug\":\"another-test-article\",\"postDate\":1448291352,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro.\\r\\n\\r\\nAgfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro.\",\"38\":\"\",\"54\":\"Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro.\",\"37\":\"Another Test Article\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-23 15:09:12', '2015-11-23 15:09:12', 'd721ed69-802f-4543-a444-9709dae21c90');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('99', '58', '13', '1', 'en_gb', '5', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Placeholder text for testimonials intro paragraph\",\"6\":\"Placeholder heading for testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"James\",\"location\":\"Exeter\",\"quote\":\"Sarah treated a knee injury I couldn\'t shake off. Now I\'m completely pain free and back playing football.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Andy\",\"location\":\"Exeter\",\"quote\":\"I got injured just before a big table tennis game, but Sarah treated my arm just in time - unfortunately I still lost!\"}}}}}', '2015-11-24 16:29:06', '2015-11-24 16:29:06', '546ac5c1-6ce4-4cec-8365-545a26993870');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('100', '58', '13', '1', 'en_gb', '6', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Placeholder text for testimonials intro paragraph\",\"6\":\"Placeholder heading for testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"I had some treatment at Cathedral Physiotherapy and it was brilliant!\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"I had some treatment at Cathedral Physiotherapy and it was brilliant!\"}},\"new1\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"I had some treatment at Cathedral Physiotherapy and it was brilliant!\"}},\"new2\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"I had some treatment at Cathedral Physiotherapy and it was brilliant!\"}}}}}', '2015-11-24 16:38:18', '2015-11-24 16:38:18', 'ab5a2861-690c-4e4e-beb2-088ad61cdd61');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('101', '58', '13', '1', 'en_gb', '7', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Placeholder text for testimonials intro paragraph\",\"6\":\"Placeholder heading for testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"The physiotherapists and office staff all provide a very personal service and seem to ensure that the atmosphere is calming, professional and friendly. My physiotherapist was incredibly approachable which definitely made me feel more positive and relaxed about my recovery. Things were explained in a much more comprehensive but understandable way at Cathedral Physiotherapy.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"Great Team of staff with excellent knowledge, care and professionalism\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"After seven years of suffering with arm pain, I went to Sarah to see if there was anything he could do to relieve it. Now three months on, all I can say is a HUGE Thank You, as I am completely clear of all arm and neck pain. For the first time in years I can do \\u2018normal\\u2019 things\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"Quickly diagnosed the problem, clearly explained the body\'s reaction and devised an effective remedy both in session and through exercises. All in all I am delighted.\"}}}}}', '2015-11-24 17:18:04', '2015-11-24 17:18:04', '351798b3-6a14-4460-9224-2112592fab41');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('102', '61', '14', '1', 'en_gb', '4', '', '{\"typeId\":\"14\",\"authorId\":null,\"title\":\"Work and Social\",\"slug\":\"work-and-social\",\"postDate\":1448274346,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"52\":[\"19\",\"21\",\"22\",\"23\",\"24\",\"26\",\"27\",\"28\",\"29\",\"30\"],\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Work & Social\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"77\"]}}', '2015-11-25 12:05:56', '2015-11-25 12:05:56', 'ec7dd785-6b0c-4751-96ac-13f47b78ee59');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('103', '63', '16', '1', 'en_gb', '3', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"53\":[\"76\"]}}', '2015-11-25 12:06:16', '2015-11-25 12:06:16', 'e8135dfe-19b1-406b-9c22-6185e5cd77c6');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('104', '5', '5', '1', 'en_gb', '3', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"58\":{\"new1\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"80\"],\"organisationName\":\"Chartered Society of Physiotherapy\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \"}},\"new2\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"82\"],\"organisationName\":\"British Medical Acupuncture Society\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \"}},\"new3\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"79\"],\"organisationName\":\"Health Professionals Council\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \"}},\"new4\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"78\"],\"organisationName\":\"Physio First\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \"}}}}}', '2015-11-25 14:09:00', '2015-11-25 14:09:00', '7eb566b3-4e1d-4601-934a-9866543cabb1');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('105', '5', '5', '1', 'en_gb', '4', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"58\":{\"85\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"80\"],\"organisationName\":\"Chartered Society of Physiotherapy\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"organisationLogoReversed\":[\"90\"]}},\"86\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"82\"],\"organisationName\":\"British Medical Acupuncture Society\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"organisationLogoReversed\":[\"89\"]}},\"87\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"79\"],\"organisationName\":\"Health Professionals Council\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"organisationLogoReversed\":[\"91\"]}},\"88\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"78\"],\"organisationName\":\"Physio First\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"organisationLogoReversed\":[\"93\"]}}}}}', '2015-11-25 14:21:28', '2015-11-25 14:21:28', '1f0575f0-2d50-4568-b5fb-0d714cd2b1fa');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('106', '5', '5', '1', 'en_gb', '5', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"58\":{\"85\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"95\"],\"organisationName\":\"Chartered Society of Physiotherapy\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"organisationLogoReversed\":[\"90\"]}},\"86\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"94\"],\"organisationName\":\"British Medical Acupuncture Society\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"organisationLogoReversed\":[\"89\"]}},\"87\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"96\"],\"organisationName\":\"Health Professionals Council\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"organisationLogoReversed\":[\"91\"]}},\"88\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"97\"],\"organisationName\":\"Physio First\",\"organisationDescription\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"organisationLogoReversed\":[\"93\"]}}}}}', '2015-11-25 15:13:25', '2015-11-25 15:13:25', 'bb70985c-5ea1-422f-8312-2c5e1868d332');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('107', '58', '13', '1', 'en_gb', '8', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Placeholder text for testimonials intro paragraph\",\"6\":\"Placeholder heading for testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"The physiotherapists and office staff all provide a very personal service and seem to ensure that the atmosphere is calming, professional and friendly. My physiotherapist was incredibly approachable which definitely made me feel more positive and relaxed about my recovery. Things were explained in a much more comprehensive but understandable way at Cathedral Physiotherapy.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"Great Team of staff with excellent knowledge, care and professionalism\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"After seven years of suffering with arm pain, I went to Sarah to see if there was anything she could do to relieve it. Now three months on, all I can say is a HUGE Thank You, as I am completely clear of all arm and neck pain. For the first time in years I can do \\u2018normal\\u2019 things\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"Quickly diagnosed the problem, clearly explained the body\'s reaction and devised an effective remedy both in session and through exercises. All in all I am delighted.\"}}}}}', '2015-11-25 15:14:48', '2015-11-25 15:14:48', '02da1a96-c13f-4137-9861-7c5a157bba72');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('108', '15', '11', '1', 'en_gb', '3', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Children\\u2019s Injuries\",\"slug\":\"childrens-injuries\",\"postDate\":1447415400,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"50.00\",\"24\":\"50.00\",\"22\":\"Although many children bounce back quickly after injury, if they are particularly sporty, or have lost their confidence after a sprain, strain or fracture they may need some reassurance and treatment \\/ exercises to return to their previous level of care-free fitness.\",\"21\":\"Children\\u2019s Injuries\"}}', '2015-11-26 11:08:24', '2015-11-26 11:08:24', '95bdde56-c2f8-476e-8bac-aaf5cbc718d7');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('109', '15', '11', '1', 'en_gb', '4', '', '{\"typeId\":\"11\",\"authorId\":\"1\",\"title\":\"Children\\u2019s Injuries\",\"slug\":\"childrens-injuries\",\"postDate\":1447415400,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"23\":\"50\",\"24\":\"50\",\"22\":\"Although many children bounce back quickly after injury, if they are particularly sporty, or have lost their confidence after a sprain, strain or fracture they may need some reassurance and treatment \\/ exercises to return to their previous level of care-free fitness.\",\"21\":\"Children\\u2019s Injuries\"}}', '2015-11-26 11:10:39', '2015-11-26 11:10:39', '0ab30a6a-b4d5-4feb-8487-1a0f7f77cfb0');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('110', '5', '5', '1', 'en_gb', '6', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"You can be assured that the clinic is regulated and governed by the following bodies for your safety.\",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"58\":{\"85\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"95\"],\"organisationName\":\"Chartered Society of Physiotherapy\",\"organisationDescription\":\"A chartered physiotherapist is a qualified member of their professional body, the Chartered Society of Physiotherapy (CSP). Through this membership they have committed themselves to providing high quality services and protecting the quality of physical treatments. For further information see: http:\\/\\/www.csp.org.uk\\/your-health\\/find-physio\\/choose-chartered\",\"organisationLogoReversed\":[\"90\"]}},\"86\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"94\"],\"organisationName\":\"British Medical Acupuncture Society\",\"organisationDescription\":\"The British Medical Acupuncture Society is a registered charity established to encourage the use and scientific understanding of acupuncture within medicine for the public benefit. It seeks to enhance the education and training of suitably qualified practitioners, and to promote high standards of working practices in acupuncture. Members are regulated healthcare professionals who practice acupuncture within the scope of their professional practice.\",\"organisationLogoReversed\":[\"89\"]}},\"87\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"96\"],\"organisationName\":\"Health Professionals Council\",\"organisationDescription\":\"The HCPC\\u2019s role is to protect the public. It does this by setting standards for registration as a health and care professional and keeping a register of individuals who meet these standards. HCPC standards relate to registrants\\u2019 education, professional knowledge and skills, behaviour (conduct, performance and ethics) and health. The HCPC register is open to the public so that individuals and employers can check whether a physiotherapist (or other health and care professional) holds registration.\",\"organisationLogoReversed\":[\"91\"]}},\"new1\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":\"\",\"organisationName\":\"Musculoskeletal Association of Chartered Physiotherapists\",\"organisationDescription\":\"The Musculoskeletal Association of Chartered Physiotherapists (MACP) is a group of over 1100 physiotherapists, who are members of the Chartered Society of Physiotherapy. In addition to their undergraduate training they have all undertaken extensive postgraduate study and reached a recognised standard of excellence in neuromusculoskeletal physiotherapy. Their knowledge and practical skills ensures that all MACP Physiotherapists are able to provide an excellent standard of care in examination, treatment and management for people with neuromusculoskeletal problems.\\r\\n\\r\\nIn the UK the MACP is recognised as the specialist manipulative therapy group by the International Federation of Orthopaedic Manipulative Physical Therapists (IFOMPT). To obtain membership of the MACP clinicians have to complete a recognised postgraduate course of study, many of which are at a Master of Science level. The association has 1000 full members (members who have passed a stringent examination process) and almost 200 associate members (members undertaking post-graduate education leading to membership).\",\"organisationLogoReversed\":\"\"}},\"88\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"97\"],\"organisationName\":\"Physio First\",\"organisationDescription\":\"Physio First is the Organisation which represents Physiotherapists in private practice launched in 1952 to promote the highest standards of clinical physiotherapy practice. Physio First, for the next 5-years, is for championing evidence based cost effective private physiotherapy with Physio First members in the changing healthcare marketplace. This includes our desire to help the general public understand how physiotherapy can help them and to facilitate easy access to our highly skilled members.\",\"organisationLogoReversed\":[\"93\"]}}}}}', '2015-11-26 11:46:49', '2015-11-26 11:46:49', '85f90279-77b0-48ad-8bf3-057712ea8ce4');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('111', '57', '8', '1', 'en_gb', '4', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"At Cathedral Physiotherapy we like to keep things simple, so we only have two prices, regardless of the treatment you are having at the clinic: New appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Heading for pricing placeholder\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-26 11:48:25', '2015-11-26 11:48:25', '75125982-c9aa-4010-9ac3-dba6c331d1d2');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('112', '99', '2', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546356,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nWhat have I done?\\r\\n\\r\\nYour back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nDo I need a scan?\\r\\n\\r\\nThe current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\\r\\n\\r\\nShould I see a doctor?\\r\\n\\r\\nThe majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\\r\\n\\r\\nReferences: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-26 13:59:16', '2015-11-26 13:59:16', 'b0131c27-8440-42d1-b08b-6f2321591b55');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('113', '99', '2', '1', 'en_gb', '2', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nWhat have I done?\\r\\n\\r\\nYour back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nDo I need a scan?\\r\\n\\r\\nThe current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\\r\\n\\r\\nShould I see a doctor?\\r\\n\\r\\nThe majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\\r\\n\\r\\nReferences: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"new1\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-26 14:18:10', '2015-11-26 14:18:10', 'a0288cf1-72e9-4101-b561-b23cdc5754b0');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('114', '99', '2', '1', 'en_gb', '3', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nWhat have I done?\\r\\n\\r\\nYour back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nDo I need a scan?\\r\\n\\r\\nThe current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\\r\\n\\r\\nShould I see a doctor?\\r\\n\\r\\nThe majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\\r\\n\\r\\nReferences: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"100\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-26 14:19:57', '2015-11-26 14:19:57', '901a40bc-1465-4eef-9c7c-ac6f25c798ea');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('115', '99', '2', '1', 'en_gb', '4', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nWhat have I done?\\r\\n\\r\\nYour back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nDo I need a scan?\\r\\n\\r\\nThe current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\\r\\n\\r\\nShould I see a doctor?\\r\\n\\r\\nThe majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\\r\\n\\r\\nReferences: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":\"\",\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-26 14:20:07', '2015-11-26 14:20:07', '806fbc1c-bbe9-441b-8968-e1639e5879c6');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('116', '99', '2', '1', 'en_gb', '5', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nWhat have I done?\\r\\n\\r\\nYour back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\\r\\nDo I need a scan?\\r\\n\\r\\nThe current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\\r\\n\\r\\nShould I see a doctor?\\r\\n\\r\\nThe majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\\r\\n\\r\\nReferences: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"new1\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\"}},\"new2\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\"}},\"new3\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\"}},\"new4\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"66\":\"\"}}', '2015-11-26 14:30:34', '2015-11-26 14:30:34', '51c77d86-fe81-4a9e-ac6f-22da84dab529');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('117', '99', '2', '1', 'en_gb', '6', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"References: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"101\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\"}},\"102\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\"}},\"103\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\"}},\"104\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"66\":{\"new1\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Active Rest\",\"paragraph\":\"In the initial stages it is important that you have \\u2018active rest\\u2019. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe try a gentle swim and sauna or treat yourself to a massage.\"}},\"new2\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Gentle exercises\",\"paragraph\":\"Much of the pain felt can be caused by muscle spasm. You can counter this by trying not to \\u2018brace\\u2019 your trunk, (try to move freely),elaxed  breathing, and gentle exercises. Initially try lying on your back (or side) with your knees bent to 90 degrees, and gently rock your pelvis. Progress to gently bringing alternate knees to your chest, or rolling both knees from one side to the other.\"}},\"new3\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Increasing physical activity\",\"paragraph\":\"Once the first few days have passed you should find that your symptoms are improving a little. At this stage it is important to gradually increase the levels of your activity in a graded way. Try sitting down for a little bit longer or walking a little bit further each day. Aim to increase your activity levels by about 10% a week.\"}},\"new4\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"What about returning to sport?\",\"paragraph\":\"Try to build up your exercise tolerance. Initially you may need to exercise for shorter periods of time several times a day. Aim to undertake 20-30 mins of aerobic exercise a day, however this doesn\'t mean being straight back on the running track, you might benefit from building up your aerobic fitness by walking, cycling or swimming first.\\r\\n\\r\\nThe key is to make small, achievable, functional goals so that you don\\u2019t become frustrated. For instance, if you want to return to cycling 1 hr a day, but you can\\u2019t even sit for 10 mins, you might first want to make a goal of sitting for longer (20 min), alongside trying walking or swimming to maintain your cardiovascular fitness. Then when you can achieve this, try cycling on a static bike for 10 mins and build up\\u2026.at least then if you get into difficulties you can just climb off rather than having to walk miles home!\\r\\n\\r\\nThe most important thing is not to lose heart, and stay positive, your pain should improve.\"}}}}}', '2015-11-26 14:46:03', '2015-11-26 14:46:03', '388ba72d-5239-49e5-86c7-d8b02693fb76');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('118', '99', '2', '1', 'en_gb', '7', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"slug\":\"ouch-ive-hurt-my-back\",\"postDate\":1448546340,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"\",\"38\":\"\",\"54\":\"Getting the low down on what to do when you\\u2019ve hurt your back\\u2026\",\"63\":{\"101\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Well the first thing to say is \\u2018Don\\u2019t panic!\\u2019. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8\\/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered \\u2018non-specific\\u2019 (O\\u2019Sullivan and Lin, 2014).\"}},\"102\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"What have I done?\",\"sectionParagraph\":\"Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a \\u2018twisted ankle\\u2019, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O\\u2019Sullivan and Lin, 2014).\\r\\n\"}},\"103\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Do I need a scan?\",\"sectionParagraph\":\"The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of \\u2018abnormal findings\\u2019 on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become \\u2018defined by your diagnosis\\u2019, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!\"}},\"104\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"Should I see a doctor?\",\"sectionParagraph\":\"The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven\\u2019t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\\r\\n\\r\\nIt is worth seeing your GP if you are needing more effective pain relief, but don\\u2019t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness\\/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\\r\\n\\r\\nIf you have any further questions, or wish to have a session with our physiotherapist, please don\\u2019t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk\"}}},\"37\":\"Ouch\\u2026I\\u2019ve hurt my back\\u2026\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"References: O\\u2019Sullivan, P. and Lin, I (2014) PainManagementToday, Jan, 1, 1. McCullough BJ, Johnson GR, Brook MI, Jarvik JG. Lumbar MR imaging and reporting epidemiology: do epidemiologic data in reports affect clinical management? Radiology 2012; 262: 941-946.\",\"66\":{\"105\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Active Rest\",\"paragraph\":\"In the initial stages it is important that you have \\u2018active rest\\u2019. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe try a gentle swim and sauna or treat yourself to a massage.\"}},\"106\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Gentle exercises\",\"paragraph\":\"Much of the pain felt can be caused by muscle spasm. You can counter this by trying not to \\u2018brace\\u2019 your trunk, (try to move freely),elaxed  breathing, and gentle exercises. Initially try lying on your back (or side) with your knees bent to 90 degrees, and gently rock your pelvis. Progress to gently bringing alternate knees to your chest, or rolling both knees from one side to the other.\"}},\"107\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Increasing physical activity\",\"paragraph\":\"Once the first few days have passed you should find that your symptoms are improving a little. At this stage it is important to gradually increase the levels of your activity in a graded way. Try sitting down for a little bit longer or walking a little bit further each day. Aim to increase your activity levels by about 10% a week.\"}},\"108\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"What about returning to sport?\",\"paragraph\":\"Try to build up your exercise tolerance. Initially you may need to exercise for shorter periods of time several times a day. Aim to undertake 20-30 mins of aerobic exercise a day, however this doesn\'t mean being straight back on the running track, you might benefit from building up your aerobic fitness by walking, cycling or swimming first.\\r\\n\\r\\nThe key is to make small, achievable, functional goals so that you don\\u2019t become frustrated. For instance, if you want to return to cycling 1 hr a day, but you can\\u2019t even sit for 10 mins, you might first want to make a goal of sitting for longer (20 min), alongside trying walking or swimming to maintain your cardiovascular fitness. Then when you can achieve this, try cycling on a static bike for 10 mins and build up\\u2026.at least then if you get into difficulties you can just climb off rather than having to walk miles home!\\r\\n\\r\\nThe most important thing is not to lose heart, and stay positive, your pain should improve.\"}}}}}', '2015-11-26 15:00:31', '2015-11-26 15:00:31', '40ecfbdf-8795-4ec4-bc56-54364a8cbd24');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('119', '58', '13', '1', 'en_gb', '9', '', '{\"typeId\":\"13\",\"authorId\":null,\"title\":\"Testimonials\",\"slug\":\"testimonialspg\",\"postDate\":1447769951,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Placeholder text for testimonials intro paragraph\",\"6\":\"Placeholder heading for testimonials\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"48\":{\"59\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Vanessa\",\"location\":\"Exeter\",\"quote\":\"Having had several physical difficulties (knee and back especially), I would not hesitate to recommend Cathedral Physiotherapy to you. Sarah is such a gifted therapist and her many years of expertise shines through as soon as you even begin discussing your problem with her. She is really friendly and put me at ease straight away. I was also impressed that not only was she able to explain why I was feeling pain in language that I understood, but also able to explain how the treatment she was going to give me would be effective. You will trust her completely! Sure enough, after a few sessions and a clear programme of exercises to carry out at home, I could feel a huge difference. I have tried several practices in the area and, without a doubt, Cathedral Physiotherapy out shines them all.\"}},\"60\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"Great Team of staff with excellent knowledge, care and professionalism\"}},\"74\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"After seven years of suffering with arm pain, I went to Sarah to see if there was anything she could do to relieve it. Now three months on, all I can say is a HUGE Thank You, as I am completely clear of all arm and neck pain. For the first time in years I can do \\u2018normal\\u2019 things\"}},\"75\":{\"type\":\"testimonial\",\"enabled\":\"1\",\"fields\":{\"customerForename\":\"Client Name\",\"location\":\"Exeter\",\"quote\":\"Quickly diagnosed the problem, clearly explained the body\'s reaction and devised an effective remedy both in session and through exercises. All in all I am delighted.\"}}}}}', '2015-11-30 09:13:29', '2015-11-30 09:13:29', '02da1f97-5ed0-4cc2-b028-c9cede286ff2');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('120', '109', '2', '1', 'en_gb', '1', '', '{\"typeId\":null,\"authorId\":\"1\",\"title\":\"Media comment: November\",\"slug\":\"media-comment-november\",\"postDate\":1448875437,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"\",\"38\":\"\",\"54\":\"As we look forward to Christmas and ahead to 2016, we will inevitably get thinking about those dreaded \\u2018New Year Resolutions\\u2019. Why not take a longer term approach to your health rather than the \\u2018boom and bust\\u2019 which often occurs as people go out to buy their new trainers in Jan, and then come across them under the woolly hats and gloves in the cupboard under the stairs whilst spring cleaning!\",\"63\":{\"new1\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"This November an article was published in Gerontology, reported in the media (http:\\/\\/www.dailymail.co.uk\\/health\\/article-3311222\\/How-squats-lunges-walking-mind-young-Strong-legs-help-brain-resist-effects-ageing.html; http:\\/\\/www.bbc.co.uk\\/news\\/health-34764693; http:\\/\\/www.theguardian.com\\/uk-news\\/2015\\/nov\\/09\\/strong-legs-healthier-brain-in-old-age), which appears to suggest that physical activity and leg extensor power had statistically significant protective effects on age-related cognition. The study assessed 324 female twins in the UK over a period of 10 years, and overall the twins that had stronger quadriceps (front thigh muscle) at the initial assessment, had better cognition 10 years on. There are clearly a number of questions that could be asked of the research, including that of the chicken and egg effect \\u2013 is it because one of the twins had greater cognition that they were more active and therefore stayed stronger, or is the strength of the muscles linked in some way to brain activity? \\r\\n\\r\\nWhether or not leg strength is linked to your brain power, it is clear from much other research that exercise is good for your health in many other ways \\u2013 heart, lungs, blood pressure, mental health, bone strength\\u2026.. the list goes on. The key is to make it easy to fit into your lifestyle (exercise on the way to or from work, go cycling as a family, play chase around the park with the kids), cheap and fun. The NHS Choices website gives guidance on just how much exercise we should do at what stage in our lives, and this is a useful starting point (http:\\/\\/www.nhs.uk\\/Livewell\\/fitness\\/Pages\\/physical-activity-guidelines-for-adults.aspx). \\r\\n\\r\\nHowever, many people find that they have physical or psychological barriers to exercise because of a diagnosis they have previously been given, or concern they have with regards to exacerbating previous injuries. Here at Cathedral Physiotherapy in Exeter we are passionate that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and we work with clients in a friendly and positive way to facilitate them achieving their functional potential and goals. Go on\\u2026.give the family an exercise make over this year\\u2026..who knows, you might be reaping the benefits on those crosswords in years to come!\"}},\"new2\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\"}}},\"37\":\"Media comment: November\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"66\":\"\"}}', '2015-11-30 09:23:58', '2015-11-30 09:23:58', 'b5c7db18-0132-4977-9d23-cc41dee088ef');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('121', '73', '2', '1', 'en_gb', '2', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Another Test Article\",\"slug\":\"another-test-article\",\"postDate\":1448291340,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"\",\"38\":\"\",\"54\":\"Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro.\",\"63\":{\"new1\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro.\\r\\n\\r\\nAgfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro.\"}}},\"37\":\"Another Test Article\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"66\":\"\"}}', '2015-11-30 09:49:33', '2015-11-30 09:49:33', 'd4c42c4f-83a6-4f7f-8d5c-0175484a0e2e');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('122', '73', '2', '1', 'en_gb', '3', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Another Test Article\",\"slug\":\"another-test-article\",\"postDate\":1448291340,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"\",\"38\":\"\",\"54\":\"Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro.\",\"63\":{\"new1\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro.\\r\\n\\r\\nAgfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro.\"}}},\"37\":\"Another Test Article\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"66\":\"\"}}', '2015-11-30 09:49:34', '2015-11-30 09:49:34', '813cfeeb-754f-4f21-847c-b231566a4b55');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('123', '72', '2', '1', 'en_gb', '2', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Test article\",\"slug\":\"test-article\",\"postDate\":1448278740,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi venenatis eros nunc, at venenatis nibh gravida nec. Donec tincidunt lectus vel bibendum auctor. Aenean congue aliquam turpis, ac scelerisque elit consequat ut. Fusce at metus congue, mattis quam in, eleifend metus. Sed ipsum ipsum, ultricies vel sem nec, ultricies fringilla purus. Fusce a tortor eget lorem dapibus placerat. Aenean ut arcu in lorem finibus sagittis. Suspendisse venenatis, urna ut tempus finibus, mauris dui malesuada lectus, at mattis tortor lorem nec purus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi venenatis eros nunc, at venenatis nibh gravida nec. \",\"38\":\"\",\"54\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi venenatis eros nunc, at venenatis.\",\"63\":{\"new1\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi venenatis eros nunc, at venenatis nibh gravida nec. Donec tincidunt lectus vel bibendum auctor. Aenean congue aliquam turpis, ac scelerisque elit consequat ut. Fusce at metus congue, mattis quam in, eleifend metus. Sed ipsum ipsum, ultricies vel sem nec, ultricies fringilla purus. Fusce a tortor eget lorem dapibus placerat. Aenean ut arcu in lorem finibus sagittis. Suspendisse venenatis, urna ut tempus finibus, mauris dui malesuada lectus, at mattis tortor lorem nec purus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi venenatis eros nunc, at venenatis nibh gravida nec. \"}}},\"37\":\"Test article\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"66\":\"\"}}', '2015-11-30 09:50:13', '2015-11-30 09:50:13', '7c11b97c-46e4-4321-9f71-c718b761e7df');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('124', '71', '2', '1', 'en_gb', '5', '', '{\"typeId\":\"2\",\"authorId\":\"1\",\"title\":\"Preventing tennis elbow\",\"slug\":\"preventing-tennis-elbow\",\"postDate\":1447933380,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"36\":\"\",\"38\":[\"70\"],\"54\":\"This is the intro to the article in a short sentence.\",\"63\":{\"new1\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"Our top tips on how to prevent tennis elbow. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.\\r\\n\\r\\nNemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.\\r\\n\\r\\nUt enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen\"}},\"new2\":{\"type\":\"articleSection\",\"enabled\":\"1\",\"fields\":{\"sectionHeading\":\"\",\"sectionParagraph\":\"\"}}},\"37\":\"Preventing tennis elbow\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"69\":\"\",\"66\":{\"new1\":{\"type\":\"sidebarSection\",\"enabled\":\"1\",\"fields\":{\"heading\":\"\",\"paragraph\":\"\"}}}}}', '2015-11-30 11:26:37', '2015-11-30 11:26:37', 'ba4c4b61-1f18-4b9a-99e2-7a5b4559eaa8');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('125', '4', '3', '1', 'en_gb', '5', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"About\",\"slug\":\"about\",\"postDate\":1447172556,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Excellence, experience and enthusiasm \\u2013 three qualities which represents cathedral physiotherapy.\\r\\nCreated by Sarah Moore, an Exeter physio with 18 years of experience, 15 of those specifically within the field of musculoskeletal physiotherapy, who is passionate about providing the best possible care. \",\"6\":\"Providing the best care\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"39\":{\"52\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Excellence\",\"description\":\"Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.\"}},\"53\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Experience\",\"description\":\"Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. Currently her time is split between working as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, where she has been working for the last 12 years, and running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.\"}},\"54\":{\"type\":\"column\",\"enabled\":\"1\",\"fields\":{\"heading\":\"Enthusiasm\",\"description\":\"Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. Sarah is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.\"}}},\"42\":{\"55\":{\"type\":\"profile\",\"enabled\":\"1\",\"fields\":{\"profilePhoto\":[\"118\"],\"heading\":\"About Sarah Moore\",\"qualifications\":\"BSc (Hons)\",\"bio\":\"After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\\r\\n\\r\\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy \\u2013a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women\\u2019s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\\r\\n\\r\\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute fo rHealth Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\\r\\n\\r\\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio\\u2019s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and audit a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct \\u2013 a physiotherapy advice line.\\r\\n\\r\\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.\"}}}}}', '2015-11-30 11:27:40', '2015-11-30 11:27:40', '243c6230-2eda-4da4-8849-404c279b4879');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('126', '2', '1', '1', 'en_gb', '3', '', '{\"typeId\":\"1\",\"authorId\":null,\"title\":\"Homepage\",\"slug\":\"homepage\",\"postDate\":1447423748,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"Physiotherapy helps to restore movement and function when someone has been affected by injury, work-related problems, illness or disease. It is a science-based profession and takes a \\u2018whole person\\u2019 approach to health and wellbeing, which includes the patient\\u2019s general lifestyle. At the core is the patient\\u2019s involvement in their own care, through education, awareness, empowerment and participation in their treatment:\",\"6\":\"Delivering Excellence, Experience and Enthusiasm \",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-30 12:00:24', '2015-11-30 12:00:24', '70da80c3-4ad6-49ce-b5ae-c2983c38774b');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('127', '57', '8', '1', 'en_gb', '5', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"At Cathedral Physiotherapy we like to keep things simple, so we only have two prices, regardless of the treatment you are having at the clinic: New appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Heading for pricing placeholder\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-11-30 12:20:27', '2015-11-30 12:20:27', '80a9d15b-e31e-4ec5-970f-f5baa6403931');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('128', '5', '5', '1', 'en_gb', '7', '', '{\"typeId\":null,\"authorId\":null,\"title\":\"Accreditations\",\"slug\":\"accreditations\",\"postDate\":1447172692,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"7\":\"You can be assured that the clinic is regulated and governed by the following bodies for your safety.\",\"6\":\"Accreditations\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"58\":{\"85\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"95\"],\"organisationName\":\"Chartered Society of Physiotherapy\",\"organisationDescription\":\"A chartered physiotherapist is a qualified member of their professional body, the Chartered Society of Physiotherapy (CSP). Through this membership they have committed themselves to providing high quality services and protecting the quality of physical treatments. For further information see: http:\\/\\/www.csp.org.uk\\/your-health\\/find-physio\\/choose-chartered\",\"organisationLogoReversed\":[\"90\"]}},\"86\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"94\"],\"organisationName\":\"British Medical Acupuncture Society\",\"organisationDescription\":\"The British Medical Acupuncture Society is a registered charity established to encourage the use and scientific understanding of acupuncture within medicine for the public benefit. It seeks to enhance the education and training of suitably qualified practitioners, and to promote high standards of working practices in acupuncture. Members are regulated healthcare professionals who practice acupuncture within the scope of their professional practice.\",\"organisationLogoReversed\":[\"89\"]}},\"87\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"96\"],\"organisationName\":\"Health Professionals Council\",\"organisationDescription\":\"The HCPC\\u2019s role is to protect the public. It does this by setting standards for registration as a health and care professional and keeping a register of individuals who meet these standards. HCPC standards relate to registrants\\u2019 education, professional knowledge and skills, behaviour (conduct, performance and ethics) and health. The HCPC register is open to the public so that individuals and employers can check whether a physiotherapist (or other health and care professional) holds registration.\",\"organisationLogoReversed\":[\"91\"]}},\"98\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"120\"],\"organisationName\":\"Musculoskeletal Association of Chartered Physiotherapists\",\"organisationDescription\":\"The Musculoskeletal Association of Chartered Physiotherapists (MACP) is a group of over 1100 physiotherapists, who are members of the Chartered Society of Physiotherapy. In addition to their undergraduate training they have all undertaken extensive postgraduate study and reached a recognised standard of excellence in neuromusculoskeletal physiotherapy. Their knowledge and practical skills ensures that all MACP Physiotherapists are able to provide an excellent standard of care in examination, treatment and management for people with neuromusculoskeletal problems.\\r\\n\\r\\nIn the UK the MACP is recognised as the specialist manipulative therapy group by the International Federation of Orthopaedic Manipulative Physical Therapists (IFOMPT). To obtain membership of the MACP clinicians have to complete a recognised postgraduate course of study, many of which are at a Master of Science level. The association has 1000 full members (members who have passed a stringent examination process) and almost 200 associate members (members undertaking post-graduate education leading to membership).\",\"organisationLogoReversed\":[\"119\"]}},\"88\":{\"type\":\"organisation\",\"enabled\":\"1\",\"fields\":{\"organisationLogo\":[\"97\"],\"organisationName\":\"Physio First\",\"organisationDescription\":\"Physio First is the Organisation which represents Physiotherapists in private practice launched in 1952 to promote the highest standards of clinical physiotherapy practice. Physio First, for the next 5-years, is for championing evidence based cost effective private physiotherapy with Physio First members in the changing healthcare marketplace. This includes our desire to help the general public understand how physiotherapy can help them and to facilitate easy access to our highly skilled members.\",\"organisationLogoReversed\":[\"93\"]}}}}}', '2015-12-01 09:37:28', '2015-12-01 09:37:28', '7623e56d-41b1-4c2c-adc1-3f03802e8f88');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('129', '63', '16', '1', 'en_gb', '4', '', '{\"typeId\":\"16\",\"authorId\":null,\"title\":\"Lifetime Support\",\"slug\":\"lifetime-support\",\"postDate\":1448274374,\"expiryDate\":null,\"enabled\":1,\"parentId\":null,\"fields\":{\"52\":[\"31\",\"32\",\"33\",\"34\",\"35\",\"36\",\"37\"],\"7\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed hendrerit lectus at enim condimentum egestas. Nulla molestie turpis ligula, eu auctor urna varius nec. \",\"6\":\"Lifetime Support\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\",\"70\":{\"new1\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionheading\":\"Initial assessments\",\"sectionParagraph\":\"Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top\\/T-shirt and shorts as you will need to remove some items of clothing. Following the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.\"}},\"new2\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionheading\":\"Follow up treatments\",\"sectionParagraph\":\"Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\\r\\n\"}},\"new3\":{\"type\":\"mainBody\",\"enabled\":\"1\",\"fields\":{\"sectionheading\":\"Acupuncture\",\"sectionParagraph\":\"If you are attending for your first session of Acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.\"}}},\"53\":[\"76\"]}}', '2015-12-01 09:52:45', '2015-12-01 09:52:45', '87d4afe2-7f4e-4400-8d1f-784549d92739');
INSERT INTO `craft_entryversions` (`id`, `entryId`, `sectionId`, `creatorId`, `locale`, `num`, `notes`, `data`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('130', '57', '8', '1', 'en_gb', '6', '', '{\"typeId\":\"8\",\"authorId\":null,\"title\":\"Pricing\",\"slug\":\"pricing\",\"postDate\":1447769788,\"expiryDate\":null,\"enabled\":1,\"fields\":{\"7\":\"At Cathedral Physiotherapy we like to keep things simple, so we only have two prices, regardless of the treatment you are having at the clinic: New appointments last an hour and cost \\u00a345\\r\\nFollow up appointments last \\u00bd an hour and cost \\u00a335.\",\"6\":\"Pricing\",\"31\":\"\",\"32\":\"\",\"35\":\"\",\"33\":\"INDEX, FOLLOW\",\"34\":\"\"}}', '2015-12-01 17:22:07', '2015-12-01 17:22:07', '8f93ca96-2388-4863-b40d-88eb45c19992');



DROP TABLE IF EXISTS `craft_fieldgroups`;


--
-- Schema for table `craft_fieldgroups`
--
CREATE TABLE `craft_fieldgroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_fieldgroups_name_unq_idx` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_fieldgroups`
--

INSERT INTO `craft_fieldgroups` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', 'Globals', '2015-11-04 11:36:31', '2015-11-10 16:29:13', '272b033f-a0e0-4bcc-8f8d-e3207cb4f1ff');
INSERT INTO `craft_fieldgroups` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', 'Generic fields', '2015-11-10 16:20:38', '2015-11-10 16:20:38', 'd1343a49-4a93-430c-9fc1-fdcd4041df48');
INSERT INTO `craft_fieldgroups` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', 'Homepage', '2015-11-10 16:20:48', '2015-11-10 16:20:48', '67fa5925-1a28-4be3-a403-96e8b7479bf3');
INSERT INTO `craft_fieldgroups` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', 'Testomonials', '2015-11-13 09:50:10', '2015-11-13 09:50:10', '1fe06795-06f0-4d93-8620-624e49c17b7f');
INSERT INTO `craft_fieldgroups` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('6', 'Treatments', '2015-11-13 09:50:22', '2015-11-13 09:50:22', 'cf7c62d3-048d-4699-a803-4b895571335f');
INSERT INTO `craft_fieldgroups` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('7', 'Quick Links', '2015-11-13 09:50:52', '2015-11-13 09:50:52', '8cfe3a34-4c46-4e83-97f3-c4249e375151');
INSERT INTO `craft_fieldgroups` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('8', 'News', '2015-11-13 09:51:14', '2015-11-13 09:51:14', '5aece28a-c561-4fe1-af6b-e2b708c12b81');
INSERT INTO `craft_fieldgroups` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('9', 'SEO', '2015-11-13 14:42:48', '2015-11-13 14:42:48', '1f425ab7-fb1f-47fb-9527-01893565c362');
INSERT INTO `craft_fieldgroups` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('10', 'About', '2015-11-17 11:08:30', '2015-11-17 11:08:30', '35fe8449-adad-43a4-acfb-04f57791e108');
INSERT INTO `craft_fieldgroups` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('11', 'Accreditations', '2015-11-25 13:52:39', '2015-11-25 13:52:39', '530128c1-ee4e-4d22-9210-2830910fef99');



DROP TABLE IF EXISTS `craft_fieldlayoutfields`;


--
-- Schema for table `craft_fieldlayoutfields`
--
CREATE TABLE `craft_fieldlayoutfields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `layoutId` int(11) NOT NULL,
  `tabId` int(11) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `required` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sortOrder` tinyint(4) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_fieldlayoutfields_layoutId_fieldId_unq_idx` (`layoutId`,`fieldId`),
  KEY `craft_fieldlayoutfields_sortOrder_idx` (`sortOrder`),
  KEY `craft_fieldlayoutfields_tabId_fk` (`tabId`),
  KEY `craft_fieldlayoutfields_fieldId_fk` (`fieldId`)
) ENGINE=InnoDB AUTO_INCREMENT=530 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_fieldlayoutfields`
--

INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', '16', '4', '9', '1', '1', '2015-11-13 09:48:49', '2015-11-13 09:48:49', 'bc035ad8-3825-4465-ba33-5953251e7c70');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('6', '16', '4', '10', '1', '2', '2015-11-13 09:48:49', '2015-11-13 09:48:49', '4b60e8be-050b-4cae-9330-ce634450fb3a');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('7', '16', '4', '11', '0', '3', '2015-11-13 09:48:49', '2015-11-13 09:48:49', 'd57d4ffe-0895-4c61-86fd-d2a8dda957dc');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('8', '16', '4', '12', '1', '4', '2015-11-13 09:48:49', '2015-11-13 09:48:49', '1a801101-eafd-48a4-9c56-3c2b31c04a88');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('9', '17', '5', '15', '1', '1', '2015-11-13 10:01:49', '2015-11-13 10:01:49', '17acaedf-b468-418c-a13d-6c8f31e78e39');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('10', '17', '5', '16', '1', '2', '2015-11-13 10:01:49', '2015-11-13 10:01:49', '416d73a4-3aaa-4fd8-b9c5-193e25d255af');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('11', '17', '5', '17', '1', '3', '2015-11-13 10:01:49', '2015-11-13 10:01:49', 'fe8afee8-f34c-4fe7-b81d-beb93b5a8f58');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('46', '33', '16', '14', '0', '1', '2015-11-13 12:54:54', '2015-11-13 12:54:54', 'f55cf66f-3ce3-4886-90af-e41d3a804706');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('108', '51', '36', '21', '0', '1', '2015-11-13 14:48:14', '2015-11-13 14:48:14', 'd61dbd8a-3ff1-430d-9e8c-b5e5025473d0');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('109', '51', '36', '22', '0', '2', '2015-11-13 14:48:14', '2015-11-13 14:48:14', 'f05f8a5a-9417-4ac2-a0e5-b4020f6a5f20');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('110', '51', '36', '23', '0', '3', '2015-11-13 14:48:14', '2015-11-13 14:48:14', 'a3949fa5-bafc-444d-9bef-15685a50e635');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('111', '51', '36', '24', '0', '4', '2015-11-13 14:48:14', '2015-11-13 14:48:14', '19e4fc38-6588-4994-b730-6656ea8821c6');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('161', '59', '50', '6', '0', '1', '2015-11-13 15:24:22', '2015-11-13 15:24:22', '38bb6b24-665f-42e3-96fe-a0b8415e1050');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('162', '59', '50', '7', '0', '2', '2015-11-13 15:24:22', '2015-11-13 15:24:22', '43924a08-eb19-42ff-b456-729fbd677ee3');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('163', '59', '51', '31', '0', '1', '2015-11-13 15:24:22', '2015-11-13 15:24:22', 'b1870f1c-f0dc-44ea-a35e-05ae76030a15');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('164', '59', '51', '32', '0', '2', '2015-11-13 15:24:22', '2015-11-13 15:24:22', '91a764e2-f091-4c02-9883-129c82dde9f3');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('165', '59', '51', '35', '0', '3', '2015-11-13 15:24:22', '2015-11-13 15:24:22', '9cdd0742-c8d1-4f03-9eec-accf2354c6dc');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('166', '59', '51', '33', '0', '4', '2015-11-13 15:24:22', '2015-11-13 15:24:22', 'cc697aaa-13c4-4c0e-b147-145cec9ec1f3');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('167', '59', '51', '34', '0', '5', '2015-11-13 15:24:22', '2015-11-13 15:24:22', '0c4dbc18-fa61-46ca-96b0-64e65e3820ec');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('193', '64', '59', '40', '1', '1', '2015-11-17 11:13:44', '2015-11-17 11:13:44', 'c227e402-c808-4e6d-b259-30d2949f4004');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('194', '64', '59', '41', '1', '2', '2015-11-17 11:13:44', '2015-11-17 11:13:44', 'b316e4f5-36e8-41c2-b144-bcb66a48b444');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('208', '68', '64', '47', '1', '1', '2015-11-17 11:56:20', '2015-11-17 11:56:20', 'bc4f5a71-b347-41ab-af27-5c4bcffc683f');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('209', '68', '64', '43', '1', '2', '2015-11-17 11:56:20', '2015-11-17 11:56:20', '5ce33385-ba63-4cee-844f-300356eb2b90');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('210', '68', '64', '44', '1', '3', '2015-11-17 11:56:20', '2015-11-17 11:56:20', '4c3f2c27-45cb-4590-b493-3cf005cb0b4d');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('211', '68', '64', '45', '1', '4', '2015-11-17 11:56:20', '2015-11-17 11:56:20', 'ed4dc763-c9f2-42ea-8582-339d13c635af');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('293', '85', '86', '8', '0', '1', '2015-11-23 15:34:58', '2015-11-23 15:34:58', 'b403b2b5-820f-46c3-af21-2dd2d1d4019c');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('294', '85', '86', '3', '0', '2', '2015-11-23 15:34:58', '2015-11-23 15:34:58', 'ad750890-e9ce-4028-8b12-c1a49f2ff532');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('295', '85', '86', '4', '0', '3', '2015-11-23 15:34:58', '2015-11-23 15:34:58', '7b15d413-f72c-43ee-9275-8b7719979b92');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('296', '85', '86', '13', '0', '4', '2015-11-23 15:34:58', '2015-11-23 15:34:58', 'b8c4b1fe-d014-4127-afbf-d7458b7400fb');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('297', '85', '86', '5', '0', '5', '2015-11-23 15:34:58', '2015-11-23 15:34:58', '92279dbc-01f0-465d-84cd-8d0438770eb7');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('298', '85', '86', '55', '0', '6', '2015-11-23 15:34:58', '2015-11-23 15:34:58', '8216a6f6-6f06-42e1-990f-a61b84c444f0');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('299', '86', '87', '6', '0', '1', '2015-11-23 16:47:24', '2015-11-23 16:47:24', '7880f4f8-6914-4aad-9b86-67e32672d55e');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('300', '86', '87', '7', '0', '2', '2015-11-23 16:47:24', '2015-11-23 16:47:24', 'c2353046-d645-4d0c-bbea-39d5ce757af7');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('301', '86', '87', '39', '0', '3', '2015-11-23 16:47:24', '2015-11-23 16:47:24', 'ad84e5c1-ec19-4bc5-98b8-d97e29dfe115');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('302', '86', '87', '42', '0', '4', '2015-11-23 16:47:24', '2015-11-23 16:47:24', 'e9c3f39c-61b0-4dbe-b4ac-10ba63d6d422');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('303', '86', '88', '34', '0', '1', '2015-11-23 16:47:24', '2015-11-23 16:47:24', '735cc6c1-e7d1-4462-ab6b-b31a5a774d6d');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('304', '86', '88', '32', '0', '2', '2015-11-23 16:47:24', '2015-11-23 16:47:24', '54847126-2ba1-433c-a1a0-a4fa8738d1a2');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('305', '86', '88', '35', '0', '3', '2015-11-23 16:47:24', '2015-11-23 16:47:24', '44d33330-e00b-403e-9aff-bc3915acbc13');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('306', '86', '88', '33', '0', '4', '2015-11-23 16:47:24', '2015-11-23 16:47:24', '84b7bf77-a8c9-4e10-b7a2-24973f1c910c');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('307', '86', '88', '31', '0', '5', '2015-11-23 16:47:24', '2015-11-23 16:47:24', '17e5d523-5270-4708-aab2-e64a2634e72f');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('322', '89', '93', '6', '0', '1', '2015-11-23 16:47:51', '2015-11-23 16:47:51', 'afb799f5-1e26-4e02-85b3-f83679bd27cf');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('323', '89', '93', '7', '0', '2', '2015-11-23 16:47:51', '2015-11-23 16:47:51', '692fa27c-582c-4975-9e9b-bba14680a132');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('324', '89', '94', '34', '0', '1', '2015-11-23 16:47:51', '2015-11-23 16:47:51', 'ad4afd3a-1c55-4a75-904d-530d64c2c7df');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('325', '89', '94', '32', '0', '2', '2015-11-23 16:47:51', '2015-11-23 16:47:51', 'e93485ef-39ec-4e02-9f23-fdd12d4eaf33');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('326', '89', '94', '35', '0', '3', '2015-11-23 16:47:51', '2015-11-23 16:47:51', '560deef8-a482-43d5-8452-139a5828c2c8');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('327', '89', '94', '33', '0', '4', '2015-11-23 16:47:51', '2015-11-23 16:47:51', 'e8dd34f1-e155-45c8-a0f3-fa439c204a06');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('328', '89', '94', '31', '0', '5', '2015-11-23 16:47:51', '2015-11-23 16:47:51', 'e97fcff5-067e-4692-b5eb-9c1d329f2372');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('345', '92', '99', '6', '0', '1', '2015-11-23 16:50:06', '2015-11-23 16:50:06', '1f83cd62-c087-4de0-ae43-60c0d6e97f76');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('346', '92', '99', '7', '0', '2', '2015-11-23 16:50:06', '2015-11-23 16:50:06', '2134c091-fde2-4117-91fd-24f7371ee416');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('347', '92', '100', '34', '0', '1', '2015-11-23 16:50:06', '2015-11-23 16:50:06', 'da9477a9-6bec-4ab1-826e-34568c7b8226');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('348', '92', '100', '32', '0', '2', '2015-11-23 16:50:06', '2015-11-23 16:50:06', 'd327eb1b-5813-4a5a-aa60-1afd52691419');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('349', '92', '100', '35', '0', '3', '2015-11-23 16:50:06', '2015-11-23 16:50:06', 'e420b20d-efb0-4dd7-aee8-677ab27c2b40');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('350', '92', '100', '33', '0', '4', '2015-11-23 16:50:06', '2015-11-23 16:50:06', '72a3af84-e5ab-4c94-a3c9-039ef92b0662');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('351', '92', '100', '31', '0', '5', '2015-11-23 16:50:06', '2015-11-23 16:50:06', '49418f75-7fa4-4ad2-9d8c-2af29fd8dba3');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('370', '95', '105', '6', '0', '1', '2015-11-23 16:51:25', '2015-11-23 16:51:25', 'fe7bee02-4cca-445a-8cd1-c4595dd01fa3');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('371', '95', '105', '7', '0', '2', '2015-11-23 16:51:25', '2015-11-23 16:51:25', '2507f915-5748-4edb-a3dd-5e6f5fbe69c5');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('372', '95', '106', '34', '0', '1', '2015-11-23 16:51:25', '2015-11-23 16:51:25', 'e90267ce-f13e-42a5-98b8-69487dd930ab');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('373', '95', '106', '32', '0', '2', '2015-11-23 16:51:25', '2015-11-23 16:51:25', 'a19a29a3-0a82-459a-849e-01f4c5e850eb');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('374', '95', '106', '35', '0', '3', '2015-11-23 16:51:25', '2015-11-23 16:51:25', '5b03dd51-1196-4859-9aef-d135dff7c17d');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('375', '95', '106', '33', '0', '4', '2015-11-23 16:51:25', '2015-11-23 16:51:25', 'c31bb213-d2bb-42e6-85b1-da0186401453');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('376', '95', '106', '31', '0', '5', '2015-11-23 16:51:25', '2015-11-23 16:51:25', 'c2170a97-9935-41b8-941a-a82336d5453b');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('385', '97', '109', '6', '0', '1', '2015-11-23 16:51:51', '2015-11-23 16:51:51', 'a87db14a-6f01-491c-a9da-1a8c5ffe93b3');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('386', '97', '109', '7', '0', '2', '2015-11-23 16:51:51', '2015-11-23 16:51:51', '6a8f54a7-e10e-4e47-ac01-c6cd1e2dfb24');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('387', '97', '110', '34', '0', '1', '2015-11-23 16:51:51', '2015-11-23 16:51:51', 'a5f94e4b-632e-4da8-b1af-cb9dfe251dc5');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('388', '97', '110', '32', '0', '2', '2015-11-23 16:51:51', '2015-11-23 16:51:51', '3429a028-27cd-4044-9bd0-1c6075672e58');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('389', '97', '110', '35', '0', '3', '2015-11-23 16:51:51', '2015-11-23 16:51:51', 'aa28ca2b-bb3d-4a52-8659-6852e0b2a523');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('390', '97', '110', '33', '0', '4', '2015-11-23 16:51:51', '2015-11-23 16:51:51', '53ba7254-d836-45fa-872a-5c4aece150ce');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('391', '97', '110', '31', '0', '5', '2015-11-23 16:51:51', '2015-11-23 16:51:51', '2863e0e5-56f8-40ef-adc8-9aa1dc063e70');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('419', '101', '117', '49', '0', '1', '2015-11-24 17:13:59', '2015-11-24 17:13:59', '77462668-1ddb-43dc-94d0-2455fd5d64ab');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('420', '101', '117', '50', '0', '2', '2015-11-24 17:13:59', '2015-11-24 17:13:59', 'b177211a-25d6-452e-a216-be9fa0a9a2fd');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('421', '101', '117', '51', '0', '3', '2015-11-24 17:13:59', '2015-11-24 17:13:59', 'de37e1f0-1dd4-4a1d-a1c7-c2b675b9f794');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('425', '104', '119', '6', '0', '1', '2015-11-25 13:58:40', '2015-11-25 13:58:40', 'bfcf5857-6088-4264-8043-6d7de3112538');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('426', '104', '119', '7', '0', '2', '2015-11-25 13:58:40', '2015-11-25 13:58:40', '7469edad-e457-4501-9c8a-0b191305f9c4');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('427', '104', '119', '58', '0', '3', '2015-11-25 13:58:40', '2015-11-25 13:58:40', '295cc99b-52fb-418d-9419-d08575f4e18e');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('428', '104', '120', '34', '0', '1', '2015-11-25 13:58:40', '2015-11-25 13:58:40', 'dec981e7-d725-4f00-a580-c09193fc5f53');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('429', '104', '120', '32', '0', '2', '2015-11-25 13:58:40', '2015-11-25 13:58:40', 'f12f5c09-1c84-4437-b637-830e69100696');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('430', '104', '120', '35', '0', '3', '2015-11-25 13:58:40', '2015-11-25 13:58:40', '073d39e4-2927-4fe0-baaf-e6b2f2d62e98');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('431', '104', '120', '33', '0', '4', '2015-11-25 13:58:40', '2015-11-25 13:58:40', '92dfcab9-8db2-46be-9cba-833a2c4822fa');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('432', '104', '120', '31', '0', '5', '2015-11-25 13:58:40', '2015-11-25 13:58:40', 'bca98e57-dfe7-4631-a095-cace92167f9b');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('437', '106', '122', '59', '0', '1', '2015-11-25 14:19:53', '2015-11-25 14:19:53', 'cf3902fc-61a6-4a96-bfb3-fa8d637e8c5e');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('438', '106', '122', '60', '1', '2', '2015-11-25 14:19:53', '2015-11-25 14:19:53', '0bc8c225-e1a9-4887-9922-c15fb1af2e8f');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('439', '106', '122', '61', '0', '3', '2015-11-25 14:19:53', '2015-11-25 14:19:53', '50419906-5534-42e2-9231-62f5c3fc9b6a');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('440', '106', '122', '62', '0', '4', '2015-11-25 14:19:53', '2015-11-25 14:19:53', '17132c58-0ad5-4fd1-8e01-55bf3898b85f');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('441', '107', '123', '6', '0', '1', '2015-11-25 15:15:43', '2015-11-25 15:15:43', '998c1d7b-c0dc-43aa-bb02-809216e39e91');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('442', '107', '123', '7', '0', '2', '2015-11-25 15:15:43', '2015-11-25 15:15:43', 'd67b9c47-9535-4c45-af2b-b363de998cee');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('443', '107', '123', '48', '0', '3', '2015-11-25 15:15:43', '2015-11-25 15:15:43', 'b3822d22-73af-4367-8556-965d0907a0ad');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('444', '107', '124', '34', '0', '1', '2015-11-25 15:15:43', '2015-11-25 15:15:43', '76ff5926-80ec-4bdf-925d-cdae20f0462f');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('445', '107', '124', '32', '0', '2', '2015-11-25 15:15:43', '2015-11-25 15:15:43', '28f30c5a-dcce-4f3f-bcec-c4e4a5966ada');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('446', '107', '124', '35', '0', '3', '2015-11-25 15:15:43', '2015-11-25 15:15:43', 'f0957290-471d-4f02-8aac-a04d432c017d');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('447', '107', '124', '33', '0', '4', '2015-11-25 15:15:43', '2015-11-25 15:15:43', '78a4c9a8-ab04-4b3d-9dc4-3f3f157aa423');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('448', '107', '124', '31', '0', '5', '2015-11-25 15:15:43', '2015-11-25 15:15:43', '2b7cf3d7-f2ea-4bab-8fe5-7998a8ae9f83');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('449', '108', '125', '64', '0', '1', '2015-11-26 14:08:08', '2015-11-26 14:08:08', '899236ee-7903-4e46-b2a8-d12a68f94343');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('450', '108', '125', '65', '0', '2', '2015-11-26 14:08:08', '2015-11-26 14:08:08', '7ad87b8b-5c68-40df-9fa3-8aed00729a85');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('461', '110', '128', '67', '0', '1', '2015-11-26 14:23:00', '2015-11-26 14:23:00', 'a5c3db45-f6a9-4855-9150-53968f722a26');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('462', '110', '128', '68', '0', '2', '2015-11-26 14:23:00', '2015-11-26 14:23:00', '362851be-8c47-4815-9065-f7d5eafe7f4f');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('474', '112', '131', '37', '0', '1', '2015-11-26 15:00:13', '2015-11-26 15:00:13', '08295b45-c48e-457f-931a-a6d365dc4503');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('475', '112', '131', '54', '0', '2', '2015-11-26 15:00:13', '2015-11-26 15:00:13', '23a07881-245a-40a4-af5c-da0b8d8d2a34');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('476', '112', '131', '36', '0', '3', '2015-11-26 15:00:13', '2015-11-26 15:00:13', '56ceb990-9ee7-4d6f-84de-5ae7abe9efc1');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('477', '112', '131', '63', '0', '4', '2015-11-26 15:00:13', '2015-11-26 15:00:13', '38001f53-b9c4-48ba-8ee3-0c8a2aa1d6eb');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('478', '112', '131', '66', '0', '5', '2015-11-26 15:00:13', '2015-11-26 15:00:13', '7b1549df-fac7-4ee7-9394-6e3e74005863');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('479', '112', '131', '69', '0', '6', '2015-11-26 15:00:13', '2015-11-26 15:00:13', 'd3474bd4-e441-43e1-9a22-2c95e6e37d35');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('480', '112', '131', '38', '0', '7', '2015-11-26 15:00:13', '2015-11-26 15:00:13', 'b984bd97-4786-4afe-a19d-e6213977f51e');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('481', '112', '132', '34', '0', '1', '2015-11-26 15:00:13', '2015-11-26 15:00:13', 'f4b2fef7-2c5a-4590-9c90-e55c5d731062');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('482', '112', '132', '32', '0', '2', '2015-11-26 15:00:13', '2015-11-26 15:00:13', '1f402514-9526-45f9-a095-812add1da4ee');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('483', '112', '132', '35', '0', '3', '2015-11-26 15:00:13', '2015-11-26 15:00:13', '7fec9e1f-2f9a-4be4-bccf-1a1fe84f9a3d');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('484', '112', '132', '33', '0', '4', '2015-11-26 15:00:13', '2015-11-26 15:00:13', '7bdc5f73-7aa7-4c96-9b6b-daed8c12c7fa');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('485', '112', '132', '31', '0', '5', '2015-11-26 15:00:13', '2015-11-26 15:00:13', 'b13ee687-93a8-4831-b461-2c789b4f5e35');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('496', '114', '135', '6', '0', '1', '2015-11-30 12:35:56', '2015-11-30 12:35:56', '2ed64d7f-dc85-45a8-8bef-fb0303a82c2d');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('497', '114', '135', '7', '0', '2', '2015-11-30 12:35:56', '2015-11-30 12:35:56', 'b0f888b7-c1fb-400f-8b43-ca7cc8fc9d1f');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('498', '114', '135', '52', '0', '3', '2015-11-30 12:35:56', '2015-11-30 12:35:56', '61dd3210-3b65-4d5d-9041-86601adadbb0');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('499', '114', '135', '53', '0', '4', '2015-11-30 12:35:56', '2015-11-30 12:35:56', 'e05b65a7-007c-42b1-b105-496245ab5429');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('500', '114', '135', '63', '0', '5', '2015-11-30 12:35:56', '2015-11-30 12:35:56', 'dd8fe998-61de-4d40-b8e9-deef956d8a7b');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('501', '114', '136', '34', '0', '1', '2015-11-30 12:35:56', '2015-11-30 12:35:56', 'bfd2a431-88b6-45f9-b30c-32458df76370');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('502', '114', '136', '32', '0', '2', '2015-11-30 12:35:56', '2015-11-30 12:35:56', 'f74da2a7-d71f-4eae-b447-5de0f66fc6b5');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('503', '114', '136', '35', '0', '3', '2015-11-30 12:35:56', '2015-11-30 12:35:56', '0311c452-1eea-416c-bf29-5ca6709b1973');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('504', '114', '136', '33', '0', '4', '2015-11-30 12:35:56', '2015-11-30 12:35:56', 'e9565b55-390d-4382-bb85-a65ac0141782');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('505', '114', '136', '31', '0', '5', '2015-11-30 12:35:56', '2015-11-30 12:35:56', '9ff055e9-be75-417c-9e5d-140cfce6cec3');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('506', '115', '137', '6', '0', '1', '2015-11-30 12:36:07', '2015-11-30 12:36:07', '8df31c4b-adbd-4a9d-a728-af3e784d130a');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('507', '115', '137', '7', '0', '2', '2015-11-30 12:36:07', '2015-11-30 12:36:07', '8fd90d6d-c143-4d9f-95c5-0de3ce6bcee3');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('508', '115', '137', '52', '0', '3', '2015-11-30 12:36:07', '2015-11-30 12:36:07', '7db81870-c928-4172-9ab5-94d1d5c3ca6b');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('509', '115', '137', '53', '0', '4', '2015-11-30 12:36:07', '2015-11-30 12:36:07', 'f5ee52de-ce56-4916-934d-ef160fe69d7d');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('510', '115', '137', '63', '0', '5', '2015-11-30 12:36:07', '2015-11-30 12:36:07', 'fd53f449-276e-46f4-b4d3-4029dae03b09');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('511', '115', '138', '34', '0', '1', '2015-11-30 12:36:07', '2015-11-30 12:36:07', '81590bbc-28f0-43de-881c-1796844d4944');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('512', '115', '138', '32', '0', '2', '2015-11-30 12:36:07', '2015-11-30 12:36:07', '930f925f-ad44-442b-bb04-e8e91ccfce23');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('513', '115', '138', '35', '0', '3', '2015-11-30 12:36:07', '2015-11-30 12:36:07', '639c2ca6-ce9e-4e3f-a87e-fc33a791bbb8');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('514', '115', '138', '33', '0', '4', '2015-11-30 12:36:07', '2015-11-30 12:36:07', '87cc72ef-01c3-4b2d-8dd7-d2a50d64fef9');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('515', '115', '138', '31', '0', '5', '2015-11-30 12:36:07', '2015-11-30 12:36:07', 'c2f62053-daf2-4a97-83c4-28bd7a569d01');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('518', '117', '140', '6', '0', '1', '2015-12-01 09:49:57', '2015-12-01 09:49:57', 'c97f46bc-7510-4a01-8121-7285e3f61147');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('519', '117', '140', '7', '0', '2', '2015-12-01 09:49:57', '2015-12-01 09:49:57', '6710bd09-d414-49f3-bebb-feb149ac3667');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('520', '117', '140', '52', '0', '3', '2015-12-01 09:49:57', '2015-12-01 09:49:57', 'f710186b-e669-4bc6-b98d-b22284ca60a4');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('521', '117', '140', '53', '0', '4', '2015-12-01 09:49:57', '2015-12-01 09:49:57', '4221287c-7519-4ac3-86c6-c9f0985c658e');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('522', '117', '140', '70', '0', '5', '2015-12-01 09:49:57', '2015-12-01 09:49:57', '47beb8dc-40cc-4af5-9643-53eefa00dc59');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('523', '117', '141', '34', '0', '1', '2015-12-01 09:49:57', '2015-12-01 09:49:57', 'e59e8664-053b-47af-93dd-fca85715563a');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('524', '117', '141', '32', '0', '2', '2015-12-01 09:49:57', '2015-12-01 09:49:57', '994b364f-806f-4397-a35d-639553750953');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('525', '117', '141', '35', '0', '3', '2015-12-01 09:49:57', '2015-12-01 09:49:57', 'cbfd9406-b3a3-447c-8614-1ec501728d18');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('526', '117', '141', '33', '0', '4', '2015-12-01 09:49:57', '2015-12-01 09:49:57', '21eda073-4766-4225-8f88-aa8f2c64e68f');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('527', '117', '141', '31', '0', '5', '2015-12-01 09:49:57', '2015-12-01 09:49:57', '659db750-843f-4d08-a91b-2b8638d58fc8');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('528', '118', '142', '71', '0', '1', '2015-12-01 09:54:31', '2015-12-01 09:54:31', 'c19651de-3f47-44f4-9c1d-e294cf60d45f');
INSERT INTO `craft_fieldlayoutfields` (`id`, `layoutId`, `tabId`, `fieldId`, `required`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('529', '118', '142', '72', '0', '2', '2015-12-01 09:54:31', '2015-12-01 09:54:31', '34b5784c-3ab8-410d-aa44-4075687b07c6');



DROP TABLE IF EXISTS `craft_fieldlayouts`;


--
-- Schema for table `craft_fieldlayouts`
--
CREATE TABLE `craft_fieldlayouts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_fieldlayouts_type_idx` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=119 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_fieldlayouts`
--

INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', 'Tag', '2015-11-04 11:36:31', '2015-11-04 11:36:31', '4e874080-8e70-48f4-ac2c-50506a61ae23');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('7', 'Entry', '2015-11-10 16:23:51', '2015-11-10 16:23:51', '17c4d114-317a-412a-99f9-a743f7dce435');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('9', 'Entry', '2015-11-10 16:25:04', '2015-11-10 16:25:04', '744c9133-0c14-4451-adbc-9b601190e710');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('16', 'MatrixBlock', '2015-11-13 09:48:49', '2015-11-13 09:48:49', '5324122e-f3f3-4314-bce0-b452f773cdb2');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('17', 'MatrixBlock', '2015-11-13 10:01:49', '2015-11-13 10:01:49', '8fbf4d1e-eb86-4684-b697-5190ffe36e9a');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('24', 'Asset', '2015-11-13 12:07:01', '2015-11-13 12:07:01', '43fb26cc-ecf4-4970-8fbf-c8bbb60cf0df');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('25', 'Asset', '2015-11-13 12:10:07', '2015-11-13 12:10:07', 'c45dd60b-b39d-4160-ad30-71b0b9ab4e8c');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('26', 'Asset', '2015-11-13 12:10:46', '2015-11-13 12:10:46', 'c10b55d8-e400-4da9-9a55-238db177895b');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('33', 'GlobalSet', '2015-11-13 12:54:54', '2015-11-13 12:54:54', '523c6cea-d541-42a7-9ebf-21bff6c4e7ae');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('37', 'Entry', '2015-11-13 14:15:51', '2015-11-13 14:15:51', '03134d53-fe9e-4dcf-af36-35d17ce8e49f');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('51', 'Entry', '2015-11-13 14:48:14', '2015-11-13 14:48:14', '43cee39a-ee1a-4dd0-aab1-7905e10b6584');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('59', 'Entry', '2015-11-13 15:24:22', '2015-11-13 15:24:22', 'dcc69eda-b162-40a6-a206-35fd3cec4277');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('64', 'MatrixBlock', '2015-11-17 11:13:44', '2015-11-17 11:13:44', '3553fa39-7e0f-449e-bd71-9eb6011e36ae');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('68', 'MatrixBlock', '2015-11-17 11:56:20', '2015-11-17 11:56:20', 'd76e4e49-1c33-4651-a85d-e5568d5f9e12');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('85', 'GlobalSet', '2015-11-23 15:34:58', '2015-11-23 15:34:58', '0f17156e-16e1-450b-8d11-0f54cb3c935c');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('86', 'Entry', '2015-11-23 16:47:24', '2015-11-23 16:47:24', 'f366b500-0691-40cb-a7f2-c4b44dfbf85a');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('89', 'Entry', '2015-11-23 16:47:51', '2015-11-23 16:47:51', '68843714-7f65-441e-91d9-2a701f4679a4');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('92', 'Entry', '2015-11-23 16:50:06', '2015-11-23 16:50:06', '771e1734-6d78-450a-ab8e-699521e57a45');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('95', 'Entry', '2015-11-23 16:51:25', '2015-11-23 16:51:25', 'de88af9c-1865-4643-ad98-cccfd36119f1');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('97', 'Entry', '2015-11-23 16:51:51', '2015-11-23 16:51:51', '878fefca-f7ed-42fc-9064-5ac2a1a826b2');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('101', 'MatrixBlock', '2015-11-24 17:13:59', '2015-11-24 17:13:59', '92508f33-2864-436d-b2de-201446b6f015');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('102', 'Asset', '2015-11-25 13:46:10', '2015-11-25 13:46:10', '94039a1f-508d-45d7-827b-ad2038a7a1f1');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('104', 'Entry', '2015-11-25 13:58:40', '2015-11-25 13:58:40', '4cafc6d3-98b9-4161-865d-c71ed0b6d429');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('106', 'MatrixBlock', '2015-11-25 14:19:53', '2015-11-25 14:19:53', 'b4389e31-66f8-4604-9ef1-d5f624670494');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('107', 'Entry', '2015-11-25 15:15:43', '2015-11-25 15:15:43', 'd5efcb9a-b252-4d06-ae80-d512245aba34');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('108', 'MatrixBlock', '2015-11-26 14:08:08', '2015-11-26 14:08:08', '66dd6714-2843-4a49-aa49-bd77d58684c0');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('110', 'MatrixBlock', '2015-11-26 14:23:00', '2015-11-26 14:23:00', 'db67af69-da41-4a02-9175-3ed75c2b6a59');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('112', 'Entry', '2015-11-26 15:00:13', '2015-11-26 15:00:13', '0ebf8a5f-5e4f-4fc8-a441-6a877c6f65a9');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('114', 'Entry', '2015-11-30 12:35:56', '2015-11-30 12:35:56', '51037c75-3ff4-45b4-af0b-478c70e5ded7');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('115', 'Entry', '2015-11-30 12:36:07', '2015-11-30 12:36:07', '284d5d3b-679a-4880-a51e-782c6eb64fbd');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('117', 'Entry', '2015-12-01 09:49:57', '2015-12-01 09:49:57', '8f789dff-46b2-44cd-9cbb-2d8e8fa85e07');
INSERT INTO `craft_fieldlayouts` (`id`, `type`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('118', 'MatrixBlock', '2015-12-01 09:54:31', '2015-12-01 09:54:31', '392931e7-78ca-4fda-9f56-080ecf1285d5');



DROP TABLE IF EXISTS `craft_fieldlayouttabs`;


--
-- Schema for table `craft_fieldlayouttabs`
--
CREATE TABLE `craft_fieldlayouttabs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `layoutId` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `sortOrder` tinyint(4) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_fieldlayouttabs_sortOrder_idx` (`sortOrder`),
  KEY `craft_fieldlayouttabs_layoutId_fk` (`layoutId`)
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_fieldlayouttabs`
--

INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', '16', 'Content', '1', '2015-11-13 09:48:49', '2015-11-13 09:48:49', '0477f685-3717-4c96-886c-c38ab1b463c9');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', '17', 'Content', '1', '2015-11-13 10:01:49', '2015-11-13 10:01:49', 'cf4e9fd8-438e-4812-ac6d-127a3e3d9d6a');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('16', '33', 'Content', '1', '2015-11-13 12:54:54', '2015-11-13 12:54:54', '6e3d452b-3141-4812-baa6-d4371a4e79e9');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('18', '37', 'Testomonials', '1', '2015-11-13 14:15:51', '2015-11-13 14:15:51', 'dabeb776-5db7-44dc-9e13-227b603be856');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('36', '51', 'Treatment Details', '1', '2015-11-13 14:48:14', '2015-11-13 14:48:14', '1a1c204d-150a-472e-ad48-874e40c6410a');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('50', '59', 'Content', '1', '2015-11-13 15:24:22', '2015-11-13 15:24:22', '45275e5b-9dd0-47a8-a5c1-00309b0ff318');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('51', '59', 'SEO', '2', '2015-11-13 15:24:22', '2015-11-13 15:24:22', '73b2303d-69cb-4cfd-ae11-c535a7fab5e6');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('59', '64', 'Content', '1', '2015-11-17 11:13:44', '2015-11-17 11:13:44', '7bb58a32-a9fe-4a73-904a-3cc85986195a');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('64', '68', 'Content', '1', '2015-11-17 11:56:20', '2015-11-17 11:56:20', '17ff2690-12fb-45e6-9ab4-bcec1ee8358e');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('86', '85', 'Content', '1', '2015-11-23 15:34:58', '2015-11-23 15:34:58', '6a7f994d-cd7d-417e-9b7a-f3b167f27c24');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('87', '86', 'Content', '1', '2015-11-23 16:47:24', '2015-11-23 16:47:24', 'cd82dcbc-7153-424e-8ffe-bba4baa8de80');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('88', '86', 'SEO', '2', '2015-11-23 16:47:24', '2015-11-23 16:47:24', 'e9f0d2d5-b9cd-4df6-b9c4-2226a87512e2');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('93', '89', 'Content', '1', '2015-11-23 16:47:51', '2015-11-23 16:47:51', 'c9139717-5d4c-4901-b55a-53637cea24d6');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('94', '89', 'SEO', '2', '2015-11-23 16:47:51', '2015-11-23 16:47:51', '3bdd4ec3-ccff-4360-90c5-419579966b5f');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('99', '92', 'Content', '1', '2015-11-23 16:50:06', '2015-11-23 16:50:06', '4e83b470-c50c-47c3-8f9f-1c0e0feea6b9');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('100', '92', 'SEO', '2', '2015-11-23 16:50:06', '2015-11-23 16:50:06', '46112622-68a1-498b-95cb-5206a108c172');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('105', '95', 'Generic fields', '1', '2015-11-23 16:51:25', '2015-11-23 16:51:25', '4b536fa1-e199-4a30-98d0-9cb78b474889');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('106', '95', 'SEO', '2', '2015-11-23 16:51:25', '2015-11-23 16:51:25', 'e5c03a43-b1ad-466a-a1ca-022972c3d60f');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('109', '97', 'Content', '1', '2015-11-23 16:51:51', '2015-11-23 16:51:51', 'd99bb4ab-661c-48a2-bc49-1122ad8bdab0');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('110', '97', 'SEO', '2', '2015-11-23 16:51:51', '2015-11-23 16:51:51', '9e9ae599-829d-4a14-b49c-355775a7a6bd');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('117', '101', 'Content', '1', '2015-11-24 17:13:59', '2015-11-24 17:13:59', 'bdd4e482-dbf7-4c4b-980b-7ac8b49580fe');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('119', '104', 'Content', '1', '2015-11-25 13:58:40', '2015-11-25 13:58:40', '10a22ca6-26fd-492f-bd0b-01727e521e0a');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('120', '104', 'SEO', '2', '2015-11-25 13:58:40', '2015-11-25 13:58:40', '09afe172-b450-43a8-836b-52ecb6677cfc');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('122', '106', 'Content', '1', '2015-11-25 14:19:53', '2015-11-25 14:19:53', 'bca2e31b-d176-42ed-94dd-3ff958c0f8a7');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('123', '107', 'Content', '1', '2015-11-25 15:15:43', '2015-11-25 15:15:43', '5b5db14b-a836-4c84-a79d-32838a292f05');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('124', '107', 'SEO', '2', '2015-11-25 15:15:43', '2015-11-25 15:15:43', 'dac637f8-6ce2-4558-8439-051f682d7713');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('125', '108', 'Content', '1', '2015-11-26 14:08:08', '2015-11-26 14:08:08', 'b29e1977-dc20-4281-8786-2c13b98b9b05');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('128', '110', 'Content', '1', '2015-11-26 14:23:00', '2015-11-26 14:23:00', '5efa9806-2920-4807-b80f-16ac354db28a');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('131', '112', 'News', '1', '2015-11-26 15:00:13', '2015-11-26 15:00:13', '721e59bb-7635-4487-81d1-7f51e4b24653');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('132', '112', 'SEO', '2', '2015-11-26 15:00:13', '2015-11-26 15:00:13', '30ced317-b09f-46f9-a105-5de51595ef93');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('135', '114', 'Generic fields', '1', '2015-11-30 12:35:56', '2015-11-30 12:35:56', '008eb0a5-9765-4eb0-a896-296c9f7ef000');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('136', '114', 'SEO', '2', '2015-11-30 12:35:56', '2015-11-30 12:35:56', '96cf1e52-99c9-4729-96a0-eb5aa35d5618');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('137', '115', 'Generic fields', '1', '2015-11-30 12:36:07', '2015-11-30 12:36:07', '0b56049a-8814-425a-9b7b-c29b038db05e');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('138', '115', 'SEO', '2', '2015-11-30 12:36:07', '2015-11-30 12:36:07', '310d1693-4dcd-44ee-8f3a-5224c5a74b4d');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('140', '117', 'Generic fields', '1', '2015-12-01 09:49:57', '2015-12-01 09:49:57', '63cf3966-a076-4d8f-9d78-60b89d730220');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('141', '117', 'SEO', '2', '2015-12-01 09:49:57', '2015-12-01 09:49:57', '2134f00f-b88f-4b2f-9582-197f1f1a71ca');
INSERT INTO `craft_fieldlayouttabs` (`id`, `layoutId`, `name`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('142', '118', 'Content', '1', '2015-12-01 09:54:31', '2015-12-01 09:54:31', '68f2e10d-55e8-41bc-8871-f98ce3f1f5b8');



DROP TABLE IF EXISTS `craft_fields`;


--
-- Schema for table `craft_fields`
--
CREATE TABLE `craft_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `handle` varchar(58) COLLATE utf8_unicode_ci NOT NULL,
  `context` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'global',
  `instructions` text COLLATE utf8_unicode_ci,
  `translatable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `type` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `settings` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_fields_handle_context_unq_idx` (`handle`,`context`),
  KEY `craft_fields_context_idx` (`context`),
  KEY `craft_fields_groupId_fk` (`groupId`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_fields`
--

INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', '1', 'Telephone', 'telephone', 'global', '', '0', 'PlainText', '{\"placeholder\":\"01382 123 456\",\"maxLength\":\"15\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-10 16:30:42', '2015-11-13 09:43:22', 'fa9f74fc-6d9b-4e77-b008-e7af1dfa7215');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', '1', 'Email', 'email', 'global', 'Company email address for new enquiries', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-10 16:31:12', '2015-11-10 16:31:12', '1807186f-4fa0-4254-8325-6ba8787d04ff');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', '1', 'Twitter', 'twitter', 'global', '', '0', 'PlainText', '{\"placeholder\":\"@twitter\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-10 16:33:33', '2015-11-13 09:42:50', 'afa251ee-7fa9-4843-8a69-24a36305a710');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('6', '3', 'Main Heading', 'mainHeading', 'global', 'This field is the main capitalised heading in blue', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 09:39:39', '2015-11-13 09:39:39', '9460f936-23f9-4a32-b3b1-7810b2b650e6');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('7', '3', 'Intro Paragraph', 'introParagraph', 'global', 'This is the intro paragraph under the blue text', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"4\"}', '2015-11-13 09:40:57', '2015-11-13 12:50:01', '7d0829b4-0a12-4841-8100-ddb20a232dbb');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('8', '1', 'Address', 'address', 'global', 'Company address goes here', '0', 'Matrix', '{\"maxBlocks\":\"1\"}', '2015-11-13 09:47:09', '2015-11-13 09:48:49', '150ee7b7-4c85-408f-af21-4cca3abbbbb0');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('9', NULL, 'Line1', 'line1', 'matrixBlockType:1', 'Address line 1', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 09:47:10', '2015-11-13 09:48:49', '0c9dcf34-a3f9-43c8-9240-a4d0abccc6ad');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('10', NULL, 'Line2', 'line2', 'matrixBlockType:1', 'Address line 2', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 09:48:49', '2015-11-13 09:48:49', '9790dad3-5bab-4e91-bc02-f5b910dcb40c');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('11', NULL, 'Line3', 'line3', 'matrixBlockType:1', 'Address line 3', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 09:48:49', '2015-11-13 09:48:49', '6a1e8a11-29b2-428d-a132-ea41f76e2840');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('12', NULL, 'Post Code', 'postCode', 'matrixBlockType:1', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 09:48:49', '2015-11-13 09:48:49', '0c617b25-f7b7-4988-8ad4-3c44eaac42a8');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('13', '1', 'Facebook', 'facebook', 'global', 'Enter facebook page url', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 09:49:43', '2015-11-13 09:49:43', '72cc37ab-0fdc-415f-b380-7052fb747f6e');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('14', '7', 'Quick Links', 'quickLinks', 'global', '', '0', 'Matrix', '{\"maxBlocks\":\"3\"}', '2015-11-13 10:01:48', '2015-11-13 10:01:48', '2d954197-4bd1-4ee5-b604-908cb05d841d');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('15', NULL, 'Heading', 'heading', 'matrixBlockType:2', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"25\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 10:01:48', '2015-11-13 10:01:48', '34d9e8d3-cb85-4131-980d-490ac655b0cf');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('16', NULL, 'Description', 'description', 'matrixBlockType:2', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"150\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 10:01:48', '2015-11-13 10:01:48', 'd8c77c0c-e9fd-4561-8ea6-18fbd1397e69');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('17', NULL, 'Links to', 'linksTo', 'matrixBlockType:2', 'Select the page this item links to', '0', 'Dropdown', '{\"options\":[{\"label\":\"Treatments\",\"value\":\"\\/treatments\",\"default\":\"\"},{\"label\":\"Pricing\",\"value\":\"\\/pricing\",\"default\":\"\"},{\"label\":\"Testimonials\",\"value\":\"\\/testimonials\",\"default\":\"\"},{\"label\":\"About\",\"value\":\"\\/about\",\"default\":\"\"},{\"label\":\"Accreditations\",\"value\":\"\\/accreditations\",\"default\":\"\"},{\"label\":\"News\",\"value\":\"\\/news\",\"default\":\"\"},{\"label\":\"Find Us\",\"value\":\"\\/find-us\",\"default\":\"\"}]}', '2015-11-13 10:01:49', '2015-11-13 10:01:49', 'dc4f0914-a2a3-46a6-aff6-d87701b4447c');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('21', '6', 'Treatment Name', 'treatmentName', 'global', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 11:18:21', '2015-11-13 11:18:21', '4b991fd1-62d7-4d11-a55e-6a62d53bdeb6');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('22', '6', 'Treatment Description', 'treatmentDescription', 'global', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"4\"}', '2015-11-13 11:18:37', '2015-11-13 11:50:37', '6d48e72b-7eaf-49b7-9a23-3dd9c69fba5a');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('23', '6', 'Initial Assessment', 'initialAssessment', 'global', 'Price for Initial Assessment', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 11:34:01', '2015-11-13 11:35:00', 'b5e12ae5-5320-4c62-be92-7896e2ed739a');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('24', '6', 'Subsequent Treatments', 'subsequentTreatments', 'global', 'Price for subsequent treatments', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 11:34:39', '2015-11-13 11:34:39', '1495c2a7-1345-4d27-9b24-d205774002d0');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('31', '9', 'Meta Canonical', 'metaCanonical', 'global', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 14:43:31', '2015-11-13 14:43:31', '81482046-68ed-4903-9cf4-ee8acd1bed26');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('32', '9', 'Meta Description', 'metaDescription', 'global', 'Enter meta description', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"160\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 14:43:46', '2015-11-13 14:43:46', '9141de12-0165-48cd-9086-983489ac160b');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('33', '9', 'Meta Robots', 'metaRobots', 'global', 'You can use special HTML <meta> tags to tell search robots not to index the content of a page and/or not scan for links to follow.\r\n\'noindex\' prevents the page from being included in the index.\r\n\'nofollow\' prevents Googlebot from following any links on the page.', '0', 'RadioButtons', '{\"options\":[{\"label\":\"index, follow\",\"value\":\"INDEX, FOLLOW\",\"default\":\"1\"},{\"label\":\"noindex, follow\",\"value\":\"NOINDEX, FOLLOW\",\"default\":\"\"},{\"label\":\"index, nofollow\",\"value\":\"INDEX, NOFOLLOW\",\"default\":\"\"},{\"label\":\"noindex, nofollow\",\"value\":\"NOINDEX, NOFOLLOW\",\"default\":\"\"}]}', '2015-11-13 14:45:15', '2015-11-13 14:45:15', '2ff75076-adff-4413-b85c-f2d454942913');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('34', '9', 'Meta Title', 'metaTitle', 'global', 'Enter the meta page title', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"55\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 14:45:55', '2015-11-13 14:45:55', '2286bd66-1eb9-4288-be99-7a78264aec38');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('35', '9', 'Meta Keywords', 'metaKeywords', 'global', 'Enter meta keywords', '0', 'Tags', '{\"source\":\"taggroup:1\",\"selectionLabel\":\"Add a keyword\"}', '2015-11-13 14:46:33', '2015-11-13 14:46:33', 'eac8ef89-db44-4fad-a3f6-7595a53b3785');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('36', '8', 'Article', 'article', 'global', 'Article body goes here', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"15\"}', '2015-11-13 14:51:01', '2015-11-13 14:51:01', '8c6d3dd2-d28e-4b92-8781-ccbdc7022782');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('37', '8', 'Headline', 'headline', 'global', 'Article headline goes here', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"120\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-13 15:04:51', '2015-11-13 15:04:51', '48d68835-1120-4da3-bccf-728747411a2c');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('38', '8', 'Article Image', 'articleImage', 'global', '', '0', 'Assets', '{\"useSingleFolder\":\"\",\"sources\":[\"folder:1\"],\"defaultUploadLocationSource\":\"1\",\"defaultUploadLocationSubpath\":\"\",\"singleUploadLocationSource\":\"1\",\"singleUploadLocationSubpath\":\"\",\"restrictFiles\":\"1\",\"allowedKinds\":[\"image\"],\"limit\":\"1\",\"selectionLabel\":\"Add an image\"}', '2015-11-13 15:11:17', '2015-11-17 11:54:05', '4064ae28-2d32-4b8f-b4ad-dbb1e6d203c4');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('39', '10', 'Principles', 'principles', 'global', 'This text appears in 3 columns underneath the intro paragraph on the \'About\' page', '0', 'Matrix', '{\"maxBlocks\":\"3\"}', '2015-11-17 11:13:43', '2015-11-17 11:13:43', 'c74e588a-5669-4c5c-a15b-a19c7c327b18');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('40', NULL, 'Heading', 'heading', 'matrixBlockType:4', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-17 11:13:43', '2015-11-17 11:13:43', 'b2672dc2-f5c9-47e2-b720-7b183141739f');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('41', NULL, 'Description', 'description', 'matrixBlockType:4', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"5\"}', '2015-11-17 11:13:43', '2015-11-17 11:13:43', 'ff40337e-dff3-462a-9bf5-11958a4b7f58');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('42', '10', 'Profiles', 'profiles', 'global', 'Edit and add team profiles', '0', 'Matrix', '{\"maxBlocks\":null}', '2015-11-17 11:16:05', '2015-11-17 11:56:19', '756acc88-2f32-446d-bece-4bb60fe17e17');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('43', NULL, 'Heading', 'heading', 'matrixBlockType:5', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-17 11:16:06', '2015-11-17 11:56:19', '729272a1-91d2-4608-98af-aec9f766ee08');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('44', NULL, 'Qualifications', 'qualifications', 'matrixBlockType:5', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-17 11:17:02', '2015-11-17 11:56:20', 'd1b4dbc9-5f49-4fd0-94be-74e8b210c372');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('45', NULL, 'Biography', 'bio', 'matrixBlockType:5', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"8\"}', '2015-11-17 11:17:02', '2015-11-17 11:56:20', 'bcb7ab42-ff22-481f-aa29-b3f71328018b');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('47', NULL, 'Profile photo', 'profilePhoto', 'matrixBlockType:5', '', '0', 'Assets', '{\"useSingleFolder\":\"\",\"sources\":[\"folder:3\"],\"defaultUploadLocationSource\":\"1\",\"defaultUploadLocationSubpath\":\"\",\"singleUploadLocationSource\":\"1\",\"singleUploadLocationSubpath\":\"\",\"restrictFiles\":\"1\",\"allowedKinds\":[\"image\"],\"limit\":\"1\",\"selectionLabel\":\"Add profile photo\"}', '2015-11-17 11:56:19', '2015-11-17 11:56:19', 'c66a0e29-a355-40c3-9061-1d026866a1c8');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('48', '5', 'Testimonials', 'testimonials', 'global', '', '0', 'Matrix', '{\"maxBlocks\":null}', '2015-11-17 15:41:07', '2015-11-24 17:13:59', '47caeb8c-4b00-4580-b35b-42d1d5d6746d');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('49', NULL, 'Customer Forename', 'customerForename', 'matrixBlockType:6', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-17 15:41:07', '2015-11-24 17:13:59', 'a68bc337-2ec6-4282-b7bc-471bac51f902');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('50', NULL, 'Location', 'location', 'matrixBlockType:6', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-17 15:41:08', '2015-11-24 17:13:59', '63cc5d8a-ed58-483d-8bdb-321a4c90fc0a');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('51', NULL, 'Quote', 'quote', 'matrixBlockType:6', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"4\"}', '2015-11-17 15:41:08', '2015-11-24 17:13:59', 'e24b96cc-daf8-4eab-959c-b7398cd6fb51');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('52', '6', 'Add Treatments', 'addTreatments', 'global', 'Select treatments to ass to this section', '0', 'Entries', '{\"sources\":[\"section:11\"],\"limit\":\"\",\"selectionLabel\":\"Add a treatment\"}', '2015-11-17 16:47:01', '2015-11-17 16:47:01', '193e8a58-c7bf-43bd-8b93-e0faaa3ef372');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('53', '6', 'Treatment Image', 'treatmentImage', 'global', 'This image appears above the treatment name', '0', 'Assets', '{\"useSingleFolder\":\"\",\"sources\":[\"folder:2\"],\"defaultUploadLocationSource\":\"2\",\"defaultUploadLocationSubpath\":\"\",\"singleUploadLocationSource\":\"1\",\"singleUploadLocationSubpath\":\"\",\"restrictFiles\":\"1\",\"allowedKinds\":[\"image\"],\"limit\":\"1\",\"selectionLabel\":\"Add an image\"}', '2015-11-17 16:48:11', '2015-11-17 16:48:11', 'b6f8b3b2-48bc-4e19-bb47-2f346bdd77f6');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('54', '8', 'Article Intro', 'articleIntro', 'global', 'This is the introductory paragraph for the article and should be a brief one sentence summary - it appears in bold.', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-23 11:16:20', '2015-11-23 11:16:20', 'a6f45cf6-a9e7-4777-ab4e-ff14742f117d');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('55', '1', 'Google Analytics', 'googleAnalytics', 'global', '', '0', 'PlainText', '{\"placeholder\":\"XX-XXXXXXXX-X\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-23 15:34:41', '2015-11-23 15:34:41', '591ebec1-ebda-4244-ab80-76cd7ddac989');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('58', '11', 'Organisations', 'organisations', 'global', '', '0', 'Matrix', '{\"maxBlocks\":null}', '2015-11-25 13:58:14', '2015-11-25 14:19:52', 'f48c084b-ca6d-4ae3-9ad8-9dcc841f30b4');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('59', NULL, 'Organisation Logo', 'organisationLogo', 'matrixBlockType:7', '', '0', 'Assets', '{\"useSingleFolder\":\"1\",\"sources\":\"*\",\"defaultUploadLocationSource\":\"1\",\"defaultUploadLocationSubpath\":\"\",\"singleUploadLocationSource\":\"4\",\"singleUploadLocationSubpath\":\"\",\"restrictFiles\":\"1\",\"allowedKinds\":[\"image\"],\"limit\":\"1\",\"selectionLabel\":\"Add a logo\"}', '2015-11-25 13:58:14', '2015-11-25 14:19:52', '80c76968-8fae-41a5-bb82-45d64563dae1');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('60', NULL, 'Organisation Name', 'organisationName', 'matrixBlockType:7', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-25 13:58:14', '2015-11-25 14:19:52', '3ae7617f-5b77-476c-a89d-f0248ecc7b33');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('61', NULL, 'Organisation Description', 'organisationDescription', 'matrixBlockType:7', 'Put the organisation in context, explaining the reasons for/advantages of this accreditation', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"4\"}', '2015-11-25 13:58:15', '2015-11-25 14:19:53', '8c9fadbf-8f9b-482b-a81e-1044201bbc41');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('62', NULL, 'Organisation Logo Reversed', 'organisationLogoReversed', 'matrixBlockType:7', 'Upload a second logo if you would like it to appear in the footer on each page. It must be a pdf with a transparent background.', '0', 'Assets', '{\"useSingleFolder\":\"1\",\"sources\":\"*\",\"defaultUploadLocationSource\":\"1\",\"defaultUploadLocationSubpath\":\"\",\"singleUploadLocationSource\":\"4\",\"singleUploadLocationSubpath\":\"\",\"restrictFiles\":\"1\",\"allowedKinds\":[\"image\"],\"limit\":\"1\",\"selectionLabel\":\"Add a logo\"}', '2015-11-25 14:11:38', '2015-11-25 14:19:53', '4f62aeac-3cb5-4b67-b2a6-56381b21bd47');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('63', '8', 'Article Sections', 'articleSections', 'global', '', '0', 'Matrix', '{\"maxBlocks\":null}', '2015-11-26 14:08:07', '2015-11-26 14:08:07', '988380d0-fb85-4966-89ff-ee805542e1cb');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('64', NULL, 'Section Heading', 'sectionHeading', 'matrixBlockType:8', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"100\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-26 14:08:07', '2015-11-26 14:08:07', '1ffbf149-abeb-4ece-affe-5b2d33e36738');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('65', NULL, 'Section Paragraph', 'sectionParagraph', 'matrixBlockType:8', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"4\"}', '2015-11-26 14:08:08', '2015-11-26 14:08:08', '493eaf11-1268-4662-bde4-f47f0411eb64');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('66', '8', 'Sidebar info', 'sidebarInfo', 'global', '', '0', 'Matrix', '{\"maxBlocks\":null}', '2015-11-26 14:23:00', '2015-11-26 14:23:00', '6809d506-8f13-4d4a-87ec-750a274810d5');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('67', NULL, 'Heading', 'heading', 'matrixBlockType:9', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"30\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-26 14:23:00', '2015-11-26 14:23:00', '7f741802-a798-4e5b-b871-5afd0c595459');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('68', NULL, 'Paragraph', 'paragraph', 'matrixBlockType:9', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"4\"}', '2015-11-26 14:23:00', '2015-11-26 14:23:00', '362a187f-e262-4f15-a479-d6311809b3f1');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('69', '8', 'References', 'references', 'global', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-11-26 14:59:48', '2015-11-26 14:59:48', '7eb0e52e-bce1-4e98-a0a4-d787b2f11a64');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('70', '6', 'Description', 'sections', 'global', '', '0', 'Matrix', '{\"maxBlocks\":null}', '2015-12-01 09:49:09', '2015-12-01 09:54:31', '0b03e9e4-7492-404b-8846-a64c4b2c98ed');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('71', NULL, 'Section Heading', 'sectionHeading', 'matrixBlockType:10', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"\",\"initialRows\":\"4\"}', '2015-12-01 09:49:10', '2015-12-01 09:54:31', 'e037ab1a-9813-4c6b-a365-44af8a91d797');
INSERT INTO `craft_fields` (`id`, `groupId`, `name`, `handle`, `context`, `instructions`, `translatable`, `type`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('72', NULL, 'Section Paragraph', 'sectionParagraph', 'matrixBlockType:10', '', '0', 'PlainText', '{\"placeholder\":\"\",\"maxLength\":\"\",\"multiline\":\"1\",\"initialRows\":\"4\"}', '2015-12-01 09:49:10', '2015-12-01 09:54:31', '661933ac-56e5-4b81-b96e-2ab114825e85');



DROP TABLE IF EXISTS `craft_globalsets`;


--
-- Schema for table `craft_globalsets`
--
CREATE TABLE `craft_globalsets` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fieldLayoutId` int(10) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_globalsets_name_unq_idx` (`name`),
  UNIQUE KEY `craft_globalsets_handle_unq_idx` (`handle`),
  KEY `craft_globalsets_fieldLayoutId_fk` (`fieldLayoutId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_globalsets`
--

INSERT INTO `craft_globalsets` (`id`, `name`, `handle`, `fieldLayoutId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('7', 'General info', 'generalInfo', '85', '2015-11-10 16:28:51', '2015-11-23 15:34:58', 'e93a49b5-83bd-439f-90f9-a062bb787de6');
INSERT INTO `craft_globalsets` (`id`, `name`, `handle`, `fieldLayoutId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('43', 'Repeated Sections', 'repeatedSections', '33', '2015-11-13 12:54:44', '2015-11-13 12:54:54', '0cbebc7a-d67d-4038-a96d-b4f6e713d23a');



DROP TABLE IF EXISTS `craft_info`;


--
-- Schema for table `craft_info`
--
CREATE TABLE `craft_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `build` int(11) unsigned NOT NULL,
  `schemaVersion` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `releaseDate` datetime NOT NULL,
  `edition` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `siteName` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `siteUrl` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `timezone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `on` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `maintenance` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `track` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_info`
--

INSERT INTO `craft_info` (`id`, `version`, `build`, `schemaVersion`, `releaseDate`, `edition`, `siteName`, `siteUrl`, `timezone`, `on`, `maintenance`, `track`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', '2.4', '2702', '2.4.0', '2015-10-28 22:36:17', '0', 'Cathedral Physiotherapy', 'http://cathedralphysiotherapy.loc', 'Europe/London', '1', '1', 'stable', '2015-11-04 11:36:26', '2015-12-02 08:58:43', '50676890-2f25-46c2-8996-e4e88e74c44a');



DROP TABLE IF EXISTS `craft_locales`;


--
-- Schema for table `craft_locales`
--
CREATE TABLE `craft_locales` (
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `sortOrder` tinyint(4) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`locale`),
  KEY `craft_locales_sortOrder_idx` (`sortOrder`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_locales`
--

INSERT INTO `craft_locales` (`locale`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('en_gb', '1', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '0934c33b-9c71-4f24-a565-42850311e078');



DROP TABLE IF EXISTS `craft_matrixblocks`;


--
-- Schema for table `craft_matrixblocks`
--
CREATE TABLE `craft_matrixblocks` (
  `id` int(11) NOT NULL,
  `ownerId` int(11) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `typeId` int(11) DEFAULT NULL,
  `sortOrder` tinyint(4) DEFAULT NULL,
  `ownerLocale` char(12) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_matrixblocks_ownerId_idx` (`ownerId`),
  KEY `craft_matrixblocks_fieldId_idx` (`fieldId`),
  KEY `craft_matrixblocks_typeId_idx` (`typeId`),
  KEY `craft_matrixblocks_sortOrder_idx` (`sortOrder`),
  KEY `craft_matrixblocks_ownerLocale_fk` (`ownerLocale`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixblocks`
--

INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('42', '7', '8', '1', '1', NULL, '2015-11-13 12:54:30', '2015-12-01 17:07:15', '20953397-c477-4383-9bbc-0b8f20f46806');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('44', '43', '14', '2', '1', NULL, '2015-11-13 12:57:48', '2015-11-13 12:57:48', '54c61c3e-7cb2-4456-b08e-0014db9799ec');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('45', '43', '14', '2', '2', NULL, '2015-11-13 12:57:48', '2015-11-13 12:57:48', '144dbcfb-1bb5-43ab-9f40-8b520504e9c6');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('46', '43', '14', '2', '3', NULL, '2015-11-13 12:57:48', '2015-11-13 12:57:48', 'e0fb0e17-da48-43ba-9544-56eaaee7dd58');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('52', '4', '39', '4', '1', NULL, '2015-11-17 11:20:23', '2015-11-30 11:27:40', '278083af-6393-4081-88bd-6368c9efe0ce');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('53', '4', '39', '4', '2', NULL, '2015-11-17 11:20:23', '2015-11-30 11:27:40', '9219d4d9-20f8-4cdf-be52-d9dd5900812d');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('54', '4', '39', '4', '3', NULL, '2015-11-17 11:20:23', '2015-11-30 11:27:40', 'b3d03740-db1b-4845-aa72-ebb1b3afa780');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('55', '4', '42', '5', '1', NULL, '2015-11-17 11:20:23', '2015-11-30 11:27:40', '3c994bd2-e134-41b5-9e31-3948713327c1');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('59', '58', '48', '6', '1', NULL, '2015-11-17 15:45:10', '2015-11-30 09:13:28', 'dd4061cc-670b-4cbc-b4e6-412108d38e44');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('60', '58', '48', '6', '2', NULL, '2015-11-17 15:45:10', '2015-11-30 09:13:28', '5a16367a-4044-463b-b5ed-06c3a2438e1b');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('74', '58', '48', '6', '3', NULL, '2015-11-24 16:38:18', '2015-11-30 09:13:28', 'f6d5efc5-3690-4e8f-9db1-a76a478f6c00');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('75', '58', '48', '6', '4', NULL, '2015-11-24 16:38:18', '2015-11-30 09:13:28', '12e31d4c-70f5-4242-ac4c-a66e5bef786b');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('85', '5', '58', '7', '1', NULL, '2015-11-25 14:09:00', '2015-12-01 09:37:28', '145e738c-dacc-40a9-bdfd-f1145a3a9114');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('86', '5', '58', '7', '2', NULL, '2015-11-25 14:09:00', '2015-12-01 09:37:28', '4fef6fe3-396f-41a4-9d56-d1ded68c53ba');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('87', '5', '58', '7', '3', NULL, '2015-11-25 14:09:00', '2015-12-01 09:37:28', '4a0804be-b44c-4373-ad0e-8c8129b3a6bf');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('88', '5', '58', '7', '5', NULL, '2015-11-25 14:09:00', '2015-12-01 09:37:28', '34dc1371-4c42-4235-9edb-259e190f3f74');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('98', '5', '58', '7', '4', NULL, '2015-11-26 11:46:49', '2015-12-01 09:37:28', '19e7758e-9ae0-4953-afa7-2308cbf5d33a');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('101', '99', '63', '8', '1', NULL, '2015-11-26 14:30:34', '2015-11-26 15:00:31', '3db95ca8-5dd9-4999-8728-a14669a034f4');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('102', '99', '63', '8', '2', NULL, '2015-11-26 14:30:34', '2015-11-26 15:00:31', 'af2c4cf3-78ff-4b58-8eca-d172a1bd41a4');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('103', '99', '63', '8', '3', NULL, '2015-11-26 14:30:34', '2015-11-26 15:00:31', '10c5f8f0-837a-4b59-8dd1-fcbb68c734ae');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('104', '99', '63', '8', '4', NULL, '2015-11-26 14:30:34', '2015-11-26 15:00:31', '2c5b6682-c33a-435d-b1a7-385913a2e93e');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('105', '99', '66', '9', '1', NULL, '2015-11-26 14:46:03', '2015-11-26 15:00:31', 'd68583de-eb79-4e06-a3cb-a7ef057d4227');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('106', '99', '66', '9', '2', NULL, '2015-11-26 14:46:03', '2015-11-26 15:00:31', '07b21e49-a637-4ecc-9e14-e1fb9af69bc4');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('107', '99', '66', '9', '3', NULL, '2015-11-26 14:46:03', '2015-11-26 15:00:31', 'e933bc3c-df06-41e0-a947-82a6fde5578c');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('108', '99', '66', '9', '4', NULL, '2015-11-26 14:46:03', '2015-11-26 15:00:31', 'ecaf0d8f-1cf2-4385-97bc-0f55e78a2415');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('110', '109', '63', '8', '1', NULL, '2015-11-30 09:23:58', '2015-11-30 09:23:58', '4abce45a-8793-455c-9aef-52b311d46689');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('111', '109', '63', '8', '2', NULL, '2015-11-30 09:23:58', '2015-11-30 09:23:58', '2e2d8711-9d0b-4acf-b449-e07e48b4dba4');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('113', '73', '63', '8', '1', NULL, '2015-11-30 09:49:34', '2015-11-30 09:49:34', '438c2428-3902-4039-85e5-22b095ad0bfa');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('114', '72', '63', '8', '1', NULL, '2015-11-30 09:50:13', '2015-11-30 09:50:13', '6e5cef01-7aae-42f0-a1cf-9fb9b73b2fe2');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('115', '71', '63', '8', '1', NULL, '2015-11-30 11:26:37', '2015-11-30 11:26:37', '85d0b566-beb8-4780-a056-506cd4288f12');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('116', '71', '63', '8', '2', NULL, '2015-11-30 11:26:37', '2015-11-30 11:26:37', 'f8029eb8-ac60-4402-8cf6-69e02819c292');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('117', '71', '66', '9', '1', NULL, '2015-11-30 11:26:37', '2015-11-30 11:26:37', '0a348708-1d1f-45bd-a95e-95ff83952c1e');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('121', '63', '70', '10', '1', NULL, '2015-12-01 09:52:45', '2015-12-01 09:52:45', '5e72e1b6-6b5f-4010-b9dc-11199d67a700');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('122', '63', '70', '10', '2', NULL, '2015-12-01 09:52:45', '2015-12-01 09:52:45', '5410dbf3-6d8f-4998-a2e8-648051ae00a2');
INSERT INTO `craft_matrixblocks` (`id`, `ownerId`, `fieldId`, `typeId`, `sortOrder`, `ownerLocale`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('123', '63', '70', '10', '3', NULL, '2015-12-01 09:52:45', '2015-12-01 09:52:45', '833e85f3-3d9a-40e0-ba95-c614e1648c26');



DROP TABLE IF EXISTS `craft_matrixblocktypes`;


--
-- Schema for table `craft_matrixblocktypes`
--
CREATE TABLE `craft_matrixblocktypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldId` int(11) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `sortOrder` tinyint(4) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixblocktypes_name_fieldId_unq_idx` (`name`,`fieldId`),
  UNIQUE KEY `craft_matrixblocktypes_handle_fieldId_unq_idx` (`handle`,`fieldId`),
  KEY `craft_matrixblocktypes_fieldId_fk` (`fieldId`),
  KEY `craft_matrixblocktypes_fieldLayoutId_fk` (`fieldLayoutId`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixblocktypes`
--

INSERT INTO `craft_matrixblocktypes` (`id`, `fieldId`, `fieldLayoutId`, `name`, `handle`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', '8', '16', 'Address Lines', 'addressLines', '1', '2015-11-13 09:47:09', '2015-11-13 09:48:49', '255d7c85-fcd4-44ab-9fc7-78f93e6782f6');
INSERT INTO `craft_matrixblocktypes` (`id`, `fieldId`, `fieldLayoutId`, `name`, `handle`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', '14', '17', 'Quick Link', 'quickLink', '1', '2015-11-13 10:01:48', '2015-11-13 10:01:49', '1a3a44fc-bbcb-4c85-8abc-c0be740317d5');
INSERT INTO `craft_matrixblocktypes` (`id`, `fieldId`, `fieldLayoutId`, `name`, `handle`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', '39', '64', 'Column', 'column', '1', '2015-11-17 11:13:43', '2015-11-17 11:13:44', '906b89dd-5b7d-414c-9ad1-ae8f10328c81');
INSERT INTO `craft_matrixblocktypes` (`id`, `fieldId`, `fieldLayoutId`, `name`, `handle`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', '42', '68', 'Profile', 'profile', '1', '2015-11-17 11:16:06', '2015-11-17 11:56:20', 'f70e7e2e-b332-4912-b571-ccf584d5320c');
INSERT INTO `craft_matrixblocktypes` (`id`, `fieldId`, `fieldLayoutId`, `name`, `handle`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('6', '48', '101', 'Testimonial', 'testimonial', '1', '2015-11-17 15:41:07', '2015-11-24 17:13:59', 'b020ae60-cf00-4954-b7dd-2de4debe9067');
INSERT INTO `craft_matrixblocktypes` (`id`, `fieldId`, `fieldLayoutId`, `name`, `handle`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('7', '58', '106', 'Organisation', 'organisation', '1', '2015-11-25 13:58:14', '2015-11-25 14:19:53', '6d13b7b7-2b83-4cf4-90b5-d7ec29a88ffe');
INSERT INTO `craft_matrixblocktypes` (`id`, `fieldId`, `fieldLayoutId`, `name`, `handle`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('8', '63', '108', 'Article section', 'articleSection', '1', '2015-11-26 14:08:07', '2015-11-26 14:08:08', '207ac506-5f9c-4003-ac1e-f2ad6ba78709');
INSERT INTO `craft_matrixblocktypes` (`id`, `fieldId`, `fieldLayoutId`, `name`, `handle`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('9', '66', '110', 'Sidebar section', 'sidebarSection', '1', '2015-11-26 14:23:00', '2015-11-26 14:23:00', 'b83a7770-57d2-4480-af04-0d1428280f1f');
INSERT INTO `craft_matrixblocktypes` (`id`, `fieldId`, `fieldLayoutId`, `name`, `handle`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('10', '70', '118', 'Section', 'mainBody', '1', '2015-12-01 09:49:10', '2015-12-01 09:54:31', '61b45393-dc87-448b-802e-7369c1e7bed1');



DROP TABLE IF EXISTS `craft_matrixcontent_address`;


--
-- Schema for table `craft_matrixcontent_address`
--
CREATE TABLE `craft_matrixcontent_address` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `field_addressLines_line1` text COLLATE utf8_unicode_ci,
  `field_addressLines_line2` text COLLATE utf8_unicode_ci,
  `field_addressLines_line3` text COLLATE utf8_unicode_ci,
  `field_addressLines_postCode` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixcontent_address_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_matrixcontent_address_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixcontent_address`
--

INSERT INTO `craft_matrixcontent_address` (`id`, `elementId`, `locale`, `field_addressLines_line1`, `field_addressLines_line2`, `field_addressLines_line3`, `field_addressLines_postCode`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', '42', 'en_gb', 'Lower Ground Floor', '22 Southernhay West', 'Southernhay', 'EX1 1PR', '2015-11-13 12:54:30', '2015-12-01 17:07:15', '99d141ad-190f-4202-9b5d-31b512df4780');



DROP TABLE IF EXISTS `craft_matrixcontent_articlesections`;


--
-- Schema for table `craft_matrixcontent_articlesections`
--
CREATE TABLE `craft_matrixcontent_articlesections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `field_articleSection_sectionHeading` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_articleSection_sectionParagraph` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixcontent_articlesections_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_matrixcontent_articlesections_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixcontent_articlesections`
--

INSERT INTO `craft_matrixcontent_articlesections` (`id`, `elementId`, `locale`, `field_articleSection_sectionHeading`, `field_articleSection_sectionParagraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', '101', 'en_gb', '', 'Well the first thing to say is ‘Don’t panic!’. Low back pain (LBP) is reported by 80% of people at some point during their life time, and the majority of it gets better within 6-8/52. In fact only 1-2% of people presenting with LBP will have a serious or systemic disorder and 90% is considered ‘non-specific’ (O’Sullivan and Lin, 2014).', '2015-11-26 14:30:34', '2015-11-26 15:00:31', '1e5d002d-b708-430c-9d43-eeaf05558a23');
INSERT INTO `craft_matrixcontent_articlesections` (`id`, `elementId`, `locale`, `field_articleSection_sectionHeading`, `field_articleSection_sectionParagraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', '102', 'en_gb', 'What have I done?', 'Your back is one of the strongest structures in the body, made up of 24 individual bones, all with associated discs, joints and ligaments, and it is rare to do permanent damage to it. Often pain is associated with a sprain or strain of one of the structures in the back - similar to that which occurs in a ‘twisted ankle’, which can undoubtedly be very sore to move, but it will get better as you gently exercise it. It is also important to understand that back pain does not solely relate to tissue damage, but represents tissues being sensitised, which can occur secondary to awkward movements, poor posture, muscle tension, inactivity, lack of sleep, stress, worry and low mood (O’Sullivan and Lin, 2014).\r\n', '2015-11-26 14:30:34', '2015-11-26 15:00:31', '6cbd2e34-6927-4ce7-a730-2909bb57614e');
INSERT INTO `craft_matrixcontent_articlesections` (`id`, `elementId`, `locale`, `field_articleSection_sectionHeading`, `field_articleSection_sectionParagraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', '103', 'en_gb', 'Do I need a scan?', 'The current NICE guidance (2009) states that x-rays should not be offered for non specific LBP, and an MRI should only be offered in very specific circumstances. This is because there is a high prevalence of ‘abnormal findings’ on MRI in pain free populations, and the fear associated with receiving a diagnosis can make pain worse. A commonly reported diagnosis on an MRI is disc degeneration which people can find very worrying, however it should be noted that a study by McCullough et al. (2012) found that 91% of pain free individuals studied, also demonstrated these findings. At Cathedral Physiotherapy we are passionate about not letting you become ‘defined by your diagnosis’, and encouraging you back to full activity. The best way to rationalise the above findings is to think of them as normal changes associated with ageing, like getting grey hair!', '2015-11-26 14:30:34', '2015-11-26 15:00:31', '559ff0f8-c55d-41d5-b4ca-94361520b352');
INSERT INTO `craft_matrixcontent_articlesections` (`id`, `elementId`, `locale`, `field_articleSection_sectionHeading`, `field_articleSection_sectionParagraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', '104', 'en_gb', 'Should I see a doctor?', 'The majority of LBP can be managed without seeing your GP. Follow the advice in the grey box and see a physiotherapist if things haven’t improving within the expected time frames, or if you are struggling to stay in work or return to your sport.\r\n\r\nIt is worth seeing your GP if you are needing more effective pain relief, but don’t forget to use your local pharmacist for advice first because this is quick and easy to do. Having said this, do see a doctor immediately  if you are getting unremitting pain (especially not linked to activity or at night), changes in bladder or bowel control - especially leakage or being unable to pass urine, pins and needles or numbness in your saddle area between your legs, numbness/pins and needles or weakness in both legs, or unsteadiness on your feet. However, these symptoms are very rare.\r\n\r\nIf you have any further questions, or wish to have a session with our physiotherapist, please don’t hesitate to contact us at: enquiries@cathedralphysiotherapy.co.uk', '2015-11-26 14:30:34', '2015-11-26 15:00:31', '3b43ed18-6fa9-4ae8-8c95-25fdb098c7a1');
INSERT INTO `craft_matrixcontent_articlesections` (`id`, `elementId`, `locale`, `field_articleSection_sectionHeading`, `field_articleSection_sectionParagraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('6', '110', 'en_gb', '', 'This November an article was published in Gerontology, reported in the media (http://www.dailymail.co.uk/health/article-3311222/How-squats-lunges-walking-mind-young-Strong-legs-help-brain-resist-effects-ageing.html; http://www.bbc.co.uk/news/health-34764693; http://www.theguardian.com/uk-news/2015/nov/09/strong-legs-healthier-brain-in-old-age), which appears to suggest that physical activity and leg extensor power had statistically significant protective effects on age-related cognition. The study assessed 324 female twins in the UK over a period of 10 years, and overall the twins that had stronger quadriceps (front thigh muscle) at the initial assessment, had better cognition 10 years on. There are clearly a number of questions that could be asked of the research, including that of the chicken and egg effect – is it because one of the twins had greater cognition that they were more active and therefore stayed stronger, or is the strength of the muscles linked in some way to brain activity? \r\n\r\nWhether or not leg strength is linked to your brain power, it is clear from much other research that exercise is good for your health in many other ways – heart, lungs, blood pressure, mental health, bone strength….. the list goes on. The key is to make it easy to fit into your lifestyle (exercise on the way to or from work, go cycling as a family, play chase around the park with the kids), cheap and fun. The NHS Choices website gives guidance on just how much exercise we should do at what stage in our lives, and this is a useful starting point (http://www.nhs.uk/Livewell/fitness/Pages/physical-activity-guidelines-for-adults.aspx). \r\n\r\nHowever, many people find that they have physical or psychological barriers to exercise because of a diagnosis they have previously been given, or concern they have with regards to exacerbating previous injuries. Here at Cathedral Physiotherapy in Exeter we are passionate that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and we work with clients in a friendly and positive way to facilitate them achieving their functional potential and goals. Go on….give the family an exercise make over this year…..who knows, you might be reaping the benefits on those crosswords in years to come!', '2015-11-30 09:23:58', '2015-11-30 09:23:58', 'e7dd621d-4114-495a-aa2a-909a68d64311');
INSERT INTO `craft_matrixcontent_articlesections` (`id`, `elementId`, `locale`, `field_articleSection_sectionHeading`, `field_articleSection_sectionParagraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('7', '111', 'en_gb', '', '', '2015-11-30 09:23:58', '2015-11-30 09:23:58', '4730f919-6c69-4534-88c9-0f1957d07fb2');
INSERT INTO `craft_matrixcontent_articlesections` (`id`, `elementId`, `locale`, `field_articleSection_sectionHeading`, `field_articleSection_sectionParagraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('9', '113', 'en_gb', '', 'Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro.\r\n\r\nAgfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro. Agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs; csojprj jfopro.', '2015-11-30 09:49:34', '2015-11-30 09:49:34', '235e2d3c-cc1e-40d8-b3db-0ef3f5b8612f');
INSERT INTO `craft_matrixcontent_articlesections` (`id`, `elementId`, `locale`, `field_articleSection_sectionHeading`, `field_articleSection_sectionParagraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('10', '114', 'en_gb', '', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi venenatis eros nunc, at venenatis nibh gravida nec. Donec tincidunt lectus vel bibendum auctor. Aenean congue aliquam turpis, ac scelerisque elit consequat ut. Fusce at metus congue, mattis quam in, eleifend metus. Sed ipsum ipsum, ultricies vel sem nec, ultricies fringilla purus. Fusce a tortor eget lorem dapibus placerat. Aenean ut arcu in lorem finibus sagittis. Suspendisse venenatis, urna ut tempus finibus, mauris dui malesuada lectus, at mattis tortor lorem nec purus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi venenatis eros nunc, at venenatis nibh gravida nec. ', '2015-11-30 09:50:13', '2015-11-30 09:50:13', '2f1de341-4161-45e6-bec6-dccf2dfd5b7b');
INSERT INTO `craft_matrixcontent_articlesections` (`id`, `elementId`, `locale`, `field_articleSection_sectionHeading`, `field_articleSection_sectionParagraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('11', '115', 'en_gb', '', 'Our top tips on how to prevent tennis elbow. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.\r\n\r\nNemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.\r\n\r\nUt enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehen', '2015-11-30 11:26:37', '2015-11-30 11:26:37', '9cd5febe-e770-4352-8ce3-16715b39a7be');
INSERT INTO `craft_matrixcontent_articlesections` (`id`, `elementId`, `locale`, `field_articleSection_sectionHeading`, `field_articleSection_sectionParagraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('12', '116', 'en_gb', '', '', '2015-11-30 11:26:37', '2015-11-30 11:26:37', 'ee80b7d7-b846-4ac3-88e0-f20b7b6dcf2c');



DROP TABLE IF EXISTS `craft_matrixcontent_organisations`;


--
-- Schema for table `craft_matrixcontent_organisations`
--
CREATE TABLE `craft_matrixcontent_organisations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `field_organisation_organisationName` text COLLATE utf8_unicode_ci,
  `field_organisation_organisationDescription` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixcontent_organisations_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_matrixcontent_organisations_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixcontent_organisations`
--

INSERT INTO `craft_matrixcontent_organisations` (`id`, `elementId`, `locale`, `field_organisation_organisationName`, `field_organisation_organisationDescription`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', '85', 'en_gb', 'Chartered Society of Physiotherapy', 'A chartered physiotherapist is a qualified member of their professional body, the Chartered Society of Physiotherapy (CSP). Through this membership they have committed themselves to providing high quality services and protecting the quality of physical treatments. For further information see: http://www.csp.org.uk/your-health/find-physio/choose-chartered', '2015-11-25 14:09:00', '2015-12-01 09:37:28', 'e00b72ac-28ad-489f-80a6-9a0d46116dc2');
INSERT INTO `craft_matrixcontent_organisations` (`id`, `elementId`, `locale`, `field_organisation_organisationName`, `field_organisation_organisationDescription`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', '86', 'en_gb', 'British Medical Acupuncture Society', 'The British Medical Acupuncture Society is a registered charity established to encourage the use and scientific understanding of acupuncture within medicine for the public benefit. It seeks to enhance the education and training of suitably qualified practitioners, and to promote high standards of working practices in acupuncture. Members are regulated healthcare professionals who practice acupuncture within the scope of their professional practice.', '2015-11-25 14:09:00', '2015-12-01 09:37:28', '984a6a9d-6783-4d6d-9987-244d5599b9fd');
INSERT INTO `craft_matrixcontent_organisations` (`id`, `elementId`, `locale`, `field_organisation_organisationName`, `field_organisation_organisationDescription`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', '87', 'en_gb', 'Health Professionals Council', 'The HCPC’s role is to protect the public. It does this by setting standards for registration as a health and care professional and keeping a register of individuals who meet these standards. HCPC standards relate to registrants’ education, professional knowledge and skills, behaviour (conduct, performance and ethics) and health. The HCPC register is open to the public so that individuals and employers can check whether a physiotherapist (or other health and care professional) holds registration.', '2015-11-25 14:09:00', '2015-12-01 09:37:28', 'd07d2d60-f15d-474b-8902-93f78ca5fec3');
INSERT INTO `craft_matrixcontent_organisations` (`id`, `elementId`, `locale`, `field_organisation_organisationName`, `field_organisation_organisationDescription`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', '88', 'en_gb', 'Physio First', 'Physio First is the Organisation which represents Physiotherapists in private practice launched in 1952 to promote the highest standards of clinical physiotherapy practice. Physio First, for the next 5-years, is for championing evidence based cost effective private physiotherapy with Physio First members in the changing healthcare marketplace. This includes our desire to help the general public understand how physiotherapy can help them and to facilitate easy access to our highly skilled members.', '2015-11-25 14:09:00', '2015-12-01 09:37:28', '37284fb2-8c67-42ff-8668-6d387014b9fb');
INSERT INTO `craft_matrixcontent_organisations` (`id`, `elementId`, `locale`, `field_organisation_organisationName`, `field_organisation_organisationDescription`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', '98', 'en_gb', 'Musculoskeletal Association of Chartered Physiotherapists', 'The Musculoskeletal Association of Chartered Physiotherapists (MACP) is a group of over 1100 physiotherapists, who are members of the Chartered Society of Physiotherapy. In addition to their undergraduate training they have all undertaken extensive postgraduate study and reached a recognised standard of excellence in neuromusculoskeletal physiotherapy. Their knowledge and practical skills ensures that all MACP Physiotherapists are able to provide an excellent standard of care in examination, treatment and management for people with neuromusculoskeletal problems.\r\n\r\nIn the UK the MACP is recognised as the specialist manipulative therapy group by the International Federation of Orthopaedic Manipulative Physical Therapists (IFOMPT). To obtain membership of the MACP clinicians have to complete a recognised postgraduate course of study, many of which are at a Master of Science level. The association has 1000 full members (members who have passed a stringent examination process) and almost 200 associate members (members undertaking post-graduate education leading to membership).', '2015-11-26 11:46:49', '2015-12-01 09:37:28', 'b50436b9-7e10-4ef5-8093-3bbffb0d8327');



DROP TABLE IF EXISTS `craft_matrixcontent_principles`;


--
-- Schema for table `craft_matrixcontent_principles`
--
CREATE TABLE `craft_matrixcontent_principles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `field_column_heading` text COLLATE utf8_unicode_ci,
  `field_column_description` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixcontent_principles_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_matrixcontent_principles_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixcontent_principles`
--

INSERT INTO `craft_matrixcontent_principles` (`id`, `elementId`, `locale`, `field_column_heading`, `field_column_description`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', '52', 'en_gb', 'Excellence', 'Excellence is ensured by the post graduate skills obtained including an MSc in Neuromusculoskeletal Physiotherapy from Cardiff University, membership of the Chartered Society of Physiotherapy (CSP), the Musculoskeletal Association of Physiotherapists (MACP), the British Medical Acupuncture Society (BMAS) and PhysioFIrst, as well as being regulated by the Health Care Professions Council (HCPC). This helps to maintain the practice at the pinnacle of Physiotherapy in Exeter.', '2015-11-17 11:20:23', '2015-11-30 11:27:40', '6b0b1d30-23db-442c-91e0-16361491c7d3');
INSERT INTO `craft_matrixcontent_principles` (`id`, `elementId`, `locale`, `field_column_heading`, `field_column_description`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', '53', 'en_gb', 'Experience', 'Experience is guaranteed following 18 years working in the NHS as a qualified Physiotherapist. Currently her time is split between working as clinical lead physiotherapist at the Royal Devon and Exeter (NHS) trust, where she has been working for the last 12 years, and running Cathedral Physiotherapy. She has a wealth of experience having worked in, among other areas, Outpatients, Occupational Health, Accident and Emergency, Trauma, Orthopaedics, Pain clinic, Rheumatology, Hydrotherapy, Haemophilia, and post Cancer rehabilitation, and specialises in complex conditions which may have previously failed conservative treatment.', '2015-11-17 11:20:23', '2015-11-30 11:27:40', '1c6fef41-aa77-4ceb-b963-ddee829fcf38');
INSERT INTO `craft_matrixcontent_principles` (`id`, `elementId`, `locale`, `field_column_heading`, `field_column_description`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', '54', 'en_gb', 'Enthusiasm', 'Enthusiasm motivates Sarah, who is absolutely passionate about providing the best possible care for your condition. Sarah is absolutely passionate about providing the best possible care for your condition. She strongly believes that people should not allow their difficulties (pain, weakness, loss of function, previous diagnoses) to define them as individuals, and works with her clients in a friendly and positive way, to help them achieve their functional potential and goals.', '2015-11-17 11:20:23', '2015-11-30 11:27:40', 'cd43e4a5-3904-4edd-b205-a14729b8fc23');



DROP TABLE IF EXISTS `craft_matrixcontent_profiles`;


--
-- Schema for table `craft_matrixcontent_profiles`
--
CREATE TABLE `craft_matrixcontent_profiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `field_profile_heading` text COLLATE utf8_unicode_ci,
  `field_profile_qualifications` text COLLATE utf8_unicode_ci,
  `field_profile_bio` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixcontent_profiles_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_matrixcontent_profiles_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixcontent_profiles`
--

INSERT INTO `craft_matrixcontent_profiles` (`id`, `elementId`, `locale`, `field_profile_heading`, `field_profile_qualifications`, `field_profile_bio`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', '55', 'en_gb', 'About Sarah Moore', 'BSc (Hons)', 'After obtaining her BSc (Hons) from the University of Brighton in 1997, she worked at UBH in Bristol between 1997 - 2004, which included taking a year to explore the world and work as a physio within HIH Insurance in New Zealand. She also worked as a medic for Trekforce in the jungles of Borneo for two months.\r\n\r\nHaving attended many postgraduate courses, including obtaining her certificate in Acupuncture, she undertook a specialist qualification in neuromusculoskeletal physiotherapy –a 2 year diploma and post graduate examinations resulting in her obtaining membership of the Musculoskeletal Association of Chartered Physiotherapists. During this time she moved to Exeter to take up a team lead role at the Royal Devon and Exeter NHS Trust, which quickly progressed to a Clinical Lead Role covering MSK Outpatients, Women’s Health (including Obstetrics), Rheumatology, Hydrotherapy and Cardiac Rehab and Respiratory outpatients, as well as working as the specialist physiotherapist for Haemophilia patients.\r\n\r\nKeen to continue developing, Sarah completed her MSc in Neuromusculoskeletal Physiotherapy from Cardiff University in 2012. Latterly, Sarah has also had a role as Principle Investigator, Exeter Site, in the PROVE trial run by Oxford University, the National Osteoporosis Society, National Institute fo rHealth Research and Oxford Nuffield NHS Trust. This is the largest trial in the UK investigating Physiotherapy rehabilitation for the treatment of Osteoporosis.\r\n\r\nHaving completed multiple service reviews over the years, Sarah has implemented this knowledge to ensure she runs an efficient and effective business. She has always enjoyed her regular teaching and 1:1 mentoring, and is keen to continue this within her private practice, both with other physio’s and doctors, as well as health promotion within local businesses. Initiatives she has been involved with include helping set up and audit a dedicated occupational physiotherapy service at UBH in Bristol, and Physio Direct – a physiotherapy advice line.\r\n\r\nSpecialising in complex conditions, but equally happy to treat any musculoskeletal problem, Sarah has a passion to provide the best possible care for your condition. She is determined to help clients not to be defined by their diagnoses, and to help them optimise their musculoskeletal health, function and well being.', '2015-11-17 11:20:23', '2015-11-30 11:27:40', '8f492b83-2a41-406a-a661-7640d133d282');



DROP TABLE IF EXISTS `craft_matrixcontent_quicklinks`;


--
-- Schema for table `craft_matrixcontent_quicklinks`
--
CREATE TABLE `craft_matrixcontent_quicklinks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `field_quickLink_heading` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_quickLink_description` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_quickLink_linksTo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixcontent_quicklinks_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_matrixcontent_quicklinks_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixcontent_quicklinks`
--

INSERT INTO `craft_matrixcontent_quicklinks` (`id`, `elementId`, `locale`, `field_quickLink_heading`, `field_quickLink_description`, `field_quickLink_linksTo`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', '44', 'en_gb', 'Treatments', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam metus nisl, varius nec hendrerit ut, cursus sed metus', '/treatments', '2015-11-13 12:57:48', '2015-11-13 12:57:48', '2e053511-5024-45d3-9426-f731626707ad');
INSERT INTO `craft_matrixcontent_quicklinks` (`id`, `elementId`, `locale`, `field_quickLink_heading`, `field_quickLink_description`, `field_quickLink_linksTo`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', '45', 'en_gb', 'About', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam metus nisl, varius nec hendrerit ut, cursus sed metus', '/about', '2015-11-13 12:57:48', '2015-11-13 12:57:48', '314059a2-2fe3-495e-a11d-26e904f782f7');
INSERT INTO `craft_matrixcontent_quicklinks` (`id`, `elementId`, `locale`, `field_quickLink_heading`, `field_quickLink_description`, `field_quickLink_linksTo`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', '46', 'en_gb', 'Accreditations', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam metus nisl, varius nec hendrerit ut, cursus sed metus', '/accreditations', '2015-11-13 12:57:48', '2015-11-13 12:57:48', '4c8d5d00-f7fd-4da1-85a5-5480d3880b64');



DROP TABLE IF EXISTS `craft_matrixcontent_sections`;


--
-- Schema for table `craft_matrixcontent_sections`
--
CREATE TABLE `craft_matrixcontent_sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `field_mainBody_sectionHeading` text COLLATE utf8_unicode_ci,
  `field_mainBody_sectionParagraph` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixcontent_sections_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_matrixcontent_sections_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixcontent_sections`
--

INSERT INTO `craft_matrixcontent_sections` (`id`, `elementId`, `locale`, `field_mainBody_sectionHeading`, `field_mainBody_sectionParagraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', '121', 'en_gb', 'Initial assessments', 'Initial assessments take up to 60 mins (depending on the condition) and involve talking through your physical problems, concerns, aims of treatment, and your personal functional goals. A physical assessment is then undertaken, looking at the parts of the body in question, including areas that connect with it or can refer symptoms to it. It is helpful to come prepared with a vest top/T-shirt and shorts as you will need to remove some items of clothing. Following the physical assessment you will have some form of treatment - either advice and exercises, or other adjuncts (mobilisation, manipulation, taping, electrotherapy) as appropriate for your condition. I work closely with you to ascertain what you want to achieve, and we will develop a treatment plan together, combining your aims, my experience and the evidence base for that specific problem.', '2015-12-01 09:52:45', '2015-12-01 09:52:45', 'c3dde3da-4be9-470a-aa71-98be8eb68251');
INSERT INTO `craft_matrixcontent_sections` (`id`, `elementId`, `locale`, `field_mainBody_sectionHeading`, `field_mainBody_sectionParagraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', '122', 'en_gb', 'Follow up treatments', 'Follow up treatments take up to 30 mins, and will involve a shortened re-assessment to ascertain how you have progressed, and if you have any concerns, advice, exercise (including reviewing your home exercise plan) and other forms of treatment as required.\r\n', '2015-12-01 09:52:45', '2015-12-01 09:52:45', '891e4eac-b21a-472c-a69f-93a4b9ef0ce8');
INSERT INTO `craft_matrixcontent_sections` (`id`, `elementId`, `locale`, `field_mainBody_sectionHeading`, `field_mainBody_sectionParagraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', '123', 'en_gb', 'Acupuncture', 'If you are attending for your first session of Acupuncture then you will either need to wait a short time after receiving it before you drive again, or arrange a lift home, as for some people it can make them drowsy.', '2015-12-01 09:52:45', '2015-12-01 09:52:45', '133fcf96-80b9-48cf-a35b-b88b904b3f72');



DROP TABLE IF EXISTS `craft_matrixcontent_sidebarinfo`;


--
-- Schema for table `craft_matrixcontent_sidebarinfo`
--
CREATE TABLE `craft_matrixcontent_sidebarinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `field_sidebarSection_heading` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `field_sidebarSection_paragraph` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixcontent_sidebarinfo_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_matrixcontent_sidebarinfo_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixcontent_sidebarinfo`
--

INSERT INTO `craft_matrixcontent_sidebarinfo` (`id`, `elementId`, `locale`, `field_sidebarSection_heading`, `field_sidebarSection_paragraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', '105', 'en_gb', 'Active Rest', 'In the initial stages it is important that you have ‘active rest’. This may mean modifying (not necessarily stopping) what you would normally do for the first few days of symptoms. Take painkillers, change your position regularly and try to find positions which ease your symptoms. It is generally safe to work and exercise with LBP, you will not be doing further damage, but again you may need to modify what you do slightly - rather than kick boxing, maybe try a gentle swim and sauna or treat yourself to a massage.', '2015-11-26 14:46:03', '2015-11-26 15:00:31', '70a4f014-efd6-49a0-83df-a4612acebfb3');
INSERT INTO `craft_matrixcontent_sidebarinfo` (`id`, `elementId`, `locale`, `field_sidebarSection_heading`, `field_sidebarSection_paragraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', '106', 'en_gb', 'Gentle exercises', 'Much of the pain felt can be caused by muscle spasm. You can counter this by trying not to ‘brace’ your trunk, (try to move freely),elaxed  breathing, and gentle exercises. Initially try lying on your back (or side) with your knees bent to 90 degrees, and gently rock your pelvis. Progress to gently bringing alternate knees to your chest, or rolling both knees from one side to the other.', '2015-11-26 14:46:03', '2015-11-26 15:00:31', '2b4c2ec7-d2da-4d80-aa8a-a05b7ce7fe2b');
INSERT INTO `craft_matrixcontent_sidebarinfo` (`id`, `elementId`, `locale`, `field_sidebarSection_heading`, `field_sidebarSection_paragraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', '107', 'en_gb', 'Increasing physical activity', 'Once the first few days have passed you should find that your symptoms are improving a little. At this stage it is important to gradually increase the levels of your activity in a graded way. Try sitting down for a little bit longer or walking a little bit further each day. Aim to increase your activity levels by about 10% a week.', '2015-11-26 14:46:03', '2015-11-26 15:00:31', 'db0e4be1-7173-4458-a15f-696edf9463ed');
INSERT INTO `craft_matrixcontent_sidebarinfo` (`id`, `elementId`, `locale`, `field_sidebarSection_heading`, `field_sidebarSection_paragraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', '108', 'en_gb', 'What about returning to sport?', 'Try to build up your exercise tolerance. Initially you may need to exercise for shorter periods of time several times a day. Aim to undertake 20-30 mins of aerobic exercise a day, however this doesn\'t mean being straight back on the running track, you might benefit from building up your aerobic fitness by walking, cycling or swimming first.\r\n\r\nThe key is to make small, achievable, functional goals so that you don’t become frustrated. For instance, if you want to return to cycling 1 hr a day, but you can’t even sit for 10 mins, you might first want to make a goal of sitting for longer (20 min), alongside trying walking or swimming to maintain your cardiovascular fitness. Then when you can achieve this, try cycling on a static bike for 10 mins and build up….at least then if you get into difficulties you can just climb off rather than having to walk miles home!\r\n\r\nThe most important thing is not to lose heart, and stay positive, your pain should improve.', '2015-11-26 14:46:03', '2015-11-26 15:00:31', '2480fa63-5148-451d-8744-82ee0d0cb79b');
INSERT INTO `craft_matrixcontent_sidebarinfo` (`id`, `elementId`, `locale`, `field_sidebarSection_heading`, `field_sidebarSection_paragraph`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', '117', 'en_gb', '', '', '2015-11-30 11:26:37', '2015-11-30 11:26:37', 'ec29cb21-d372-440f-9181-78de4519dd2e');



DROP TABLE IF EXISTS `craft_matrixcontent_testimonials`;


--
-- Schema for table `craft_matrixcontent_testimonials`
--
CREATE TABLE `craft_matrixcontent_testimonials` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `field_testimonial_customerForename` text COLLATE utf8_unicode_ci,
  `field_testimonial_location` text COLLATE utf8_unicode_ci,
  `field_testimonial_quote` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_matrixcontent_testimonials_elementId_locale_unq_idx` (`elementId`,`locale`),
  KEY `craft_matrixcontent_testimonials_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_matrixcontent_testimonials`
--

INSERT INTO `craft_matrixcontent_testimonials` (`id`, `elementId`, `locale`, `field_testimonial_customerForename`, `field_testimonial_location`, `field_testimonial_quote`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', '59', 'en_gb', 'Vanessa', 'Exeter', 'Having had several physical difficulties (knee and back especially), I would not hesitate to recommend Cathedral Physiotherapy to you. Sarah is such a gifted therapist and her many years of expertise shines through as soon as you even begin discussing your problem with her. She is really friendly and put me at ease straight away. I was also impressed that not only was she able to explain why I was feeling pain in language that I understood, but also able to explain how the treatment she was going to give me would be effective. You will trust her completely! Sure enough, after a few sessions and a clear programme of exercises to carry out at home, I could feel a huge difference. I have tried several practices in the area and, without a doubt, Cathedral Physiotherapy out shines them all.', '2015-11-17 15:45:10', '2015-11-30 09:13:28', 'a7d2c9ef-0803-4c1b-adcb-0091c63d8380');
INSERT INTO `craft_matrixcontent_testimonials` (`id`, `elementId`, `locale`, `field_testimonial_customerForename`, `field_testimonial_location`, `field_testimonial_quote`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', '60', 'en_gb', 'Client Name', 'Exeter', 'Great Team of staff with excellent knowledge, care and professionalism', '2015-11-17 15:45:10', '2015-11-30 09:13:28', '99b58acb-697d-4543-b057-981cf209e407');
INSERT INTO `craft_matrixcontent_testimonials` (`id`, `elementId`, `locale`, `field_testimonial_customerForename`, `field_testimonial_location`, `field_testimonial_quote`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', '74', 'en_gb', 'Client Name', 'Exeter', 'After seven years of suffering with arm pain, I went to Sarah to see if there was anything she could do to relieve it. Now three months on, all I can say is a HUGE Thank You, as I am completely clear of all arm and neck pain. For the first time in years I can do ‘normal’ things', '2015-11-24 16:38:18', '2015-11-30 09:13:28', '599e4028-adff-45d2-85c0-008c5da5149b');
INSERT INTO `craft_matrixcontent_testimonials` (`id`, `elementId`, `locale`, `field_testimonial_customerForename`, `field_testimonial_location`, `field_testimonial_quote`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', '75', 'en_gb', 'Client Name', 'Exeter', 'Quickly diagnosed the problem, clearly explained the body\'s reaction and devised an effective remedy both in session and through exercises. All in all I am delighted.', '2015-11-24 16:38:18', '2015-11-30 09:13:28', 'ebf3cd6b-0778-47ec-b510-91b6f0be469a');



DROP TABLE IF EXISTS `craft_migrations`;


--
-- Schema for table `craft_migrations`
--
CREATE TABLE `craft_migrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pluginId` int(11) DEFAULT NULL,
  `version` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `applyTime` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_migrations_version_unq_idx` (`version`),
  KEY `craft_migrations_pluginId_fk` (`pluginId`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_migrations`
--

INSERT INTO `craft_migrations` (`id`, `pluginId`, `version`, `applyTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', NULL, 'm000000_000000_base', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '2015-11-04 11:36:27', 'd3903717-45d0-4a67-8044-9ad9ff78f159');
INSERT INTO `craft_migrations` (`id`, `pluginId`, `version`, `applyTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', NULL, 'm140730_000001_add_filename_and_format_to_transformindex', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '09fc7dc3-ec3d-49d0-9d09-0de52c7083b2');
INSERT INTO `craft_migrations` (`id`, `pluginId`, `version`, `applyTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', NULL, 'm140815_000001_add_format_to_transforms', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '2015-11-04 11:36:27', 'a48f5d18-d600-4f96-aad7-0b6f382d7eba');
INSERT INTO `craft_migrations` (`id`, `pluginId`, `version`, `applyTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', NULL, 'm140822_000001_allow_more_than_128_items_per_field', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '5e13edb9-28df-4a51-a3c2-b8c928d7036b');
INSERT INTO `craft_migrations` (`id`, `pluginId`, `version`, `applyTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', NULL, 'm140829_000001_single_title_formats', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '2015-11-04 11:36:27', 'ab8f00b0-2ecf-4c23-bd03-b5b83b38b219');
INSERT INTO `craft_migrations` (`id`, `pluginId`, `version`, `applyTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('6', NULL, 'm140831_000001_extended_cache_keys', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '2015-11-04 11:36:27', 'b77e0bbf-1e86-4081-961e-d6265359ed08');
INSERT INTO `craft_migrations` (`id`, `pluginId`, `version`, `applyTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('7', NULL, 'm140922_000001_delete_orphaned_matrix_blocks', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '0f126a93-8b3b-4bea-9285-fd6fcf7b853f');
INSERT INTO `craft_migrations` (`id`, `pluginId`, `version`, `applyTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('8', NULL, 'm141008_000001_elements_index_tune', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '1af2e46b-7d70-4ced-9b22-d352c811d77e');
INSERT INTO `craft_migrations` (`id`, `pluginId`, `version`, `applyTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('9', NULL, 'm141009_000001_assets_source_handle', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '2015-11-04 11:36:27', 'a37ed188-ef63-4b36-9a18-c29e15519848');
INSERT INTO `craft_migrations` (`id`, `pluginId`, `version`, `applyTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('10', NULL, 'm141024_000001_field_layout_tabs', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '7b039e71-003b-4388-9683-27d63df11163');
INSERT INTO `craft_migrations` (`id`, `pluginId`, `version`, `applyTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('11', NULL, 'm141030_000001_drop_structure_move_permission', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '9f04d448-bfa2-4f29-bb87-d7c22c46d905');
INSERT INTO `craft_migrations` (`id`, `pluginId`, `version`, `applyTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('12', NULL, 'm141103_000001_tag_titles', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '0aaca57d-517a-481e-8ac6-e3cab42734f8');
INSERT INTO `craft_migrations` (`id`, `pluginId`, `version`, `applyTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('13', NULL, 'm141109_000001_user_status_shuffle', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '968b31b3-ccb8-400f-a6f0-9b80131bda81');
INSERT INTO `craft_migrations` (`id`, `pluginId`, `version`, `applyTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('14', NULL, 'm141126_000001_user_week_start_day', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '641e3f52-dbde-4ffd-9513-1016c3561795');
INSERT INTO `craft_migrations` (`id`, `pluginId`, `version`, `applyTime`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('15', NULL, 'm150210_000001_adjust_user_photo_size', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '2015-11-04 11:36:27', '92bd292a-7333-4d87-86da-1369e7d562db');



DROP TABLE IF EXISTS `craft_plugins`;


--
-- Schema for table `craft_plugins`
--
CREATE TABLE `craft_plugins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `version` char(15) COLLATE utf8_unicode_ci NOT NULL,
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `settings` text COLLATE utf8_unicode_ci,
  `installDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_plugins`
--

INSERT INTO `craft_plugins` (`id`, `class`, `version`, `enabled`, `settings`, `installDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', 'Truncate', '0.1', '1', NULL, '2015-11-16 17:30:25', '2015-11-16 17:30:25', '2015-11-16 17:30:25', '26a1363c-25c0-4204-9964-ff9c2494807b');
INSERT INTO `craft_plugins` (`id`, `class`, `version`, `enabled`, `settings`, `installDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', 'LinkHelpers', '0.1.0', '1', NULL, '2015-11-30 09:30:33', '2015-11-30 09:30:33', '2015-11-30 09:30:33', 'c0986201-b530-4d93-8bb9-9ddbe383cbe3');



DROP TABLE IF EXISTS `craft_rackspaceaccess`;


--
-- Schema for table `craft_rackspaceaccess`
--
CREATE TABLE `craft_rackspaceaccess` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `connectionKey` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `storageUrl` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `cdnUrl` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_rackspaceaccess_connectionKey_unq_idx` (`connectionKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_relations`;


--
-- Schema for table `craft_relations`
--
CREATE TABLE `craft_relations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldId` int(11) NOT NULL,
  `sourceId` int(11) NOT NULL,
  `sourceLocale` char(12) COLLATE utf8_unicode_ci DEFAULT NULL,
  `targetId` int(11) NOT NULL,
  `sortOrder` smallint(6) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_relations_fieldId_sourceId_sourceLocale_targetId_unq_idx` (`fieldId`,`sourceId`,`sourceLocale`,`targetId`),
  KEY `craft_relations_sourceId_fk` (`sourceId`),
  KEY `craft_relations_sourceLocale_fk` (`sourceLocale`),
  KEY `craft_relations_targetId_fk` (`targetId`)
) ENGINE=InnoDB AUTO_INCREMENT=214 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_relations`
--

INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('104', '52', '62', NULL, '17', '1', '2015-11-17 16:51:31', '2015-11-17 16:51:31', 'bf32760f-1b5a-46e8-98b5-a4b626fe11a6');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('105', '52', '62', NULL, '16', '2', '2015-11-17 16:51:31', '2015-11-17 16:51:31', 'c84fbee7-1d2c-4602-9728-d7fbd57bdbc9');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('106', '52', '62', NULL, '15', '3', '2015-11-17 16:51:31', '2015-11-17 16:51:31', '910c6942-4496-48d4-81ed-c4eceed7dcb0');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('107', '53', '62', NULL, '41', '1', '2015-11-17 16:51:31', '2015-11-17 16:51:31', '54c06655-8160-4bd0-8500-afa9d1ba5a47');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('142', '38', '69', NULL, '67', '1', '2015-11-23 11:17:25', '2015-11-23 11:17:25', '0ccd8131-c069-4387-a814-e309f44f1782');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('143', '38', '68', NULL, '66', '1', '2015-11-23 11:17:34', '2015-11-23 11:17:34', '82cac227-488c-49bd-9197-473169893b4e');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('144', '38', '65', NULL, '64', '1', '2015-11-23 11:17:41', '2015-11-23 11:17:41', '019b0771-abb4-409f-b460-fafd3936ce71');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('145', '38', '50', NULL, '51', '1', '2015-11-23 11:17:46', '2015-11-23 11:17:46', '0dbed627-e6a3-4970-8357-d98161f02428');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('146', '38', '49', NULL, '48', '1', '2015-11-23 11:17:51', '2015-11-23 11:17:51', '9c06e7b8-6c25-4da0-bafc-4a9ec0200dca');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('147', '52', '61', NULL, '19', '1', '2015-11-25 12:05:55', '2015-11-25 12:05:55', 'c69eb28a-6a6b-4c26-9e9b-1c8580fd6154');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('148', '52', '61', NULL, '21', '2', '2015-11-25 12:05:55', '2015-11-25 12:05:55', '62839ffa-1e5e-49a8-94be-599040987be3');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('149', '52', '61', NULL, '22', '3', '2015-11-25 12:05:55', '2015-11-25 12:05:55', 'fd67a603-d1da-45eb-adcd-63dacd75ef3b');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('150', '52', '61', NULL, '23', '4', '2015-11-25 12:05:55', '2015-11-25 12:05:55', 'fadf5ac9-1545-4ba4-8762-3f5233b9567b');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('151', '52', '61', NULL, '24', '5', '2015-11-25 12:05:55', '2015-11-25 12:05:55', '20240f7a-6eb5-4ddf-a498-6dd4075969c2');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('152', '52', '61', NULL, '26', '6', '2015-11-25 12:05:55', '2015-11-25 12:05:55', '1d329205-d307-434b-ac91-52bdf26a3203');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('153', '52', '61', NULL, '27', '7', '2015-11-25 12:05:55', '2015-11-25 12:05:55', 'aa5a1dd2-4407-4690-9328-962b337622bd');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('154', '52', '61', NULL, '28', '8', '2015-11-25 12:05:55', '2015-11-25 12:05:55', 'ed00f8d9-87df-4118-b10b-bfa9a918a83b');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('155', '52', '61', NULL, '29', '9', '2015-11-25 12:05:55', '2015-11-25 12:05:55', '3ab1f8b7-c960-4943-8a1d-a2d0c570afb8');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('156', '52', '61', NULL, '30', '10', '2015-11-25 12:05:55', '2015-11-25 12:05:55', 'ee3b4a24-1ae8-4bf2-83b4-c49fa8aa889d');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('157', '53', '61', NULL, '77', '1', '2015-11-25 12:05:56', '2015-11-25 12:05:56', '0ec68665-f21f-4e04-bfcf-93cb7c96c939');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('194', '38', '71', NULL, '70', '1', '2015-11-30 11:26:37', '2015-11-30 11:26:37', '2d7f494b-0d48-4d7c-bf59-8660742c6fa8');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('195', '47', '55', NULL, '118', '1', '2015-11-30 11:27:40', '2015-11-30 11:27:40', '7a36baa3-15e0-48e7-9b51-66f0307f19e9');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('196', '59', '85', NULL, '95', '1', '2015-12-01 09:37:28', '2015-12-01 09:37:28', 'd4bbc624-ada6-4d8e-9622-df2ca8c3464b');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('197', '62', '85', NULL, '90', '1', '2015-12-01 09:37:28', '2015-12-01 09:37:28', '2cf89273-111b-4e3d-ac08-01b562bc81b7');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('198', '59', '86', NULL, '94', '1', '2015-12-01 09:37:28', '2015-12-01 09:37:28', '9ed65b95-b45b-49d7-8107-0fe6c7fd864a');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('199', '62', '86', NULL, '89', '1', '2015-12-01 09:37:28', '2015-12-01 09:37:28', '8cce566e-cf1a-478c-80b2-10518d622d7d');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('200', '59', '87', NULL, '96', '1', '2015-12-01 09:37:28', '2015-12-01 09:37:28', '135fb471-03cb-461d-8e82-ce250cab77f2');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('201', '62', '87', NULL, '91', '1', '2015-12-01 09:37:28', '2015-12-01 09:37:28', '87a8db81-4692-4b93-9725-a7e5f1aa36e6');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('202', '59', '98', NULL, '120', '1', '2015-12-01 09:37:28', '2015-12-01 09:37:28', '36b19f47-8524-41e4-8abb-f328f493e204');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('203', '62', '98', NULL, '119', '1', '2015-12-01 09:37:28', '2015-12-01 09:37:28', '80fa7aea-922b-4a51-9376-0a27618d0e2f');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('204', '59', '88', NULL, '97', '1', '2015-12-01 09:37:28', '2015-12-01 09:37:28', 'd73cb6a1-c4b2-4572-95c6-d7ebffee95e4');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('205', '62', '88', NULL, '93', '1', '2015-12-01 09:37:28', '2015-12-01 09:37:28', '4c57d100-7dbf-4027-b0c6-255c53d4ad79');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('206', '52', '63', NULL, '31', '1', '2015-12-01 09:52:45', '2015-12-01 09:52:45', '1c11623e-02d5-4482-a18a-f0a33b8bf244');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('207', '52', '63', NULL, '32', '2', '2015-12-01 09:52:45', '2015-12-01 09:52:45', 'fdd0ad15-f373-4113-905d-b0ffa8bcb0f6');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('208', '52', '63', NULL, '33', '3', '2015-12-01 09:52:45', '2015-12-01 09:52:45', 'd3790bea-5219-4dbe-9012-fecfa555dd53');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('209', '52', '63', NULL, '34', '4', '2015-12-01 09:52:45', '2015-12-01 09:52:45', '83fe267b-b099-405c-a76a-2d2f6642c068');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('210', '52', '63', NULL, '35', '5', '2015-12-01 09:52:45', '2015-12-01 09:52:45', '999be67b-d65e-4b24-81dd-60e569039fd2');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('211', '52', '63', NULL, '36', '6', '2015-12-01 09:52:45', '2015-12-01 09:52:45', 'f1f0dc2e-d7f7-48ef-81bd-52ca20be3f59');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('212', '52', '63', NULL, '37', '7', '2015-12-01 09:52:45', '2015-12-01 09:52:45', '219a135f-f863-4521-8f9c-0f094c454c8a');
INSERT INTO `craft_relations` (`id`, `fieldId`, `sourceId`, `sourceLocale`, `targetId`, `sortOrder`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('213', '53', '63', NULL, '76', '1', '2015-12-01 09:52:45', '2015-12-01 09:52:45', 'fdb4ae74-0267-48c2-8819-37aaaf13598a');



DROP TABLE IF EXISTS `craft_routes`;


--
-- Schema for table `craft_routes`
--
CREATE TABLE `craft_routes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `locale` char(12) COLLATE utf8_unicode_ci DEFAULT NULL,
  `urlParts` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `urlPattern` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `template` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `sortOrder` tinyint(4) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_routes_urlPattern_unq_idx` (`urlPattern`),
  KEY `craft_routes_locale_idx` (`locale`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_searchindex`;


--
-- Schema for table `craft_searchindex`
--
CREATE TABLE `craft_searchindex` (
  `elementId` int(11) NOT NULL,
  `attribute` varchar(25) COLLATE utf8_unicode_ci NOT NULL,
  `fieldId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `keywords` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`elementId`,`attribute`,`fieldId`,`locale`),
  FULLTEXT KEY `craft_searchindex_keywords_idx` (`keywords`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_searchindex`
--

INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('1', 'username', '0', 'en_gb', ' yello ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('1', 'firstname', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('1', 'lastname', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('1', 'fullname', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('1', 'email', '0', 'en_gb', ' jamesgrover yellostudio co uk ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('1', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('2', 'slug', '0', 'en_gb', ' homepage ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('2', 'title', '0', 'en_gb', ' homepage ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('2', 'field', '1', 'en_gb', ' it s true this site doesn t have a whole lot of content yet but don t worry our web developers have just installed the cms and they re setting things up for the content editors this very moment soon cathedral loc will be an oasis of fresh perspectives sharp analyses and astute opinions that will keep you coming back again and again ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('48', 'filename', '0', 'en_gb', ' joint pain jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('48', 'extension', '0', 'en_gb', ' jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('48', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('48', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('48', 'title', '0', 'en_gb', ' joint pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('49', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('49', 'field', '37', 'en_gb', ' winter chills ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('49', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('49', 'field', '36', 'en_gb', ' during the winter months aches and pains in joints can feel more painful and make getting up in the morning painful our specialities include treatment of injuries and conditions related to the joints and can help reduce pain swelling and discomfort sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium totam rem aperiam eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam est qui dolorem ipsum quia dolor sit amet consectetur adipisci velit sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem ut enim ad minima veniam quis nostrum exercitationem ullam corporis suscipit laboriosam nisi ut aliquid ex ea commodi consequatur quis autem vel eum iure reprehen ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('47', 'title', '0', 'en_gb', ' news ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('47', 'slug', '0', 'en_gb', ' news ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('4', 'slug', '0', 'en_gb', ' about ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('4', 'title', '0', 'en_gb', ' about ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('5', 'slug', '0', 'en_gb', ' accreditations ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('5', 'title', '0', 'en_gb', ' accreditations ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('59', 'field', '49', 'en_gb', ' vanessa ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('7', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('8', 'slug', '0', 'en_gb', ' find us ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('8', 'title', '0', 'en_gb', ' find us ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('9', 'slug', '0', 'en_gb', ' treatments ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('9', 'title', '0', 'en_gb', ' treatments ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('59', 'field', '50', 'en_gb', ' exeter ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('59', 'field', '51', 'en_gb', ' having had several physical difficulties knee and back especially i would not hesitate to recommend cathedral physiotherapy to you sarah is such a gifted therapist and her many years of expertise shines through as soon as you even begin discussing your problem with her she is really friendly and put me at ease straight away i was also impressed that not only was she able to explain why i was feeling pain in language that i understood but also able to explain how the treatment she was going to give me would be effective you will trust her completely sure enough after a few sessions and a clear programme of exercises to carry out at home i could feel a huge difference i have tried several practices in the area and without a doubt cathedral physiotherapy out shines them all ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('58', 'field', '48', 'en_gb', ' vanessa exeter having had several physical difficulties knee and back especially i would not hesitate to recommend cathedral physiotherapy to you sarah is such a gifted therapist and her many years of expertise shines through as soon as you even begin discussing your problem with her she is really friendly and put me at ease straight away i was also impressed that not only was she able to explain why i was feeling pain in language that i understood but also able to explain how the treatment she was going to give me would be effective you will trust her completely sure enough after a few sessions and a clear programme of exercises to carry out at home i could feel a huge difference i have tried several practices in the area and without a doubt cathedral physiotherapy out shines them all client name exeter great team of staff with excellent knowledge care and professionalism client name exeter after seven years of suffering with arm pain i went to sarah to see if there was anything she could do to relieve it now three months on all i can say is a huge thank you as i am completely clear of all arm and neck pain for the first time in years i can do normal things client name exeter quickly diagnosed the problem clearly explained the body s reaction and devised an effective remedy both in session and through exercises all in all i am delighted ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('12', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('12', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('12', 'field', '22', 'en_gb', ' test ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('12', 'field', '21', 'en_gb', ' elbow injuries ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('12', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('12', 'title', '0', 'en_gb', ' elbow injuries treatmentdescription ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('13', 'field', '21', 'en_gb', ' work related pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('13', 'field', '22', 'en_gb', ' whether you work at a desk all day or prune trees for a living at some point during your working life you are likely to suffer from pain related to your occupation in fact 60% of people on long term sick leave cite musculoskeletal disorders as the cause rapid access to musculoskeletal physiotherapy can reduce the amount of time people are off sick and it is vital in preventing a new acute problem becoming chronic and long lasting department of health 2008 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('13', 'field', '23', 'en_gb', ' 75 00 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('13', 'field', '24', 'en_gb', ' 30 00 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('13', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('13', 'title', '0', 'en_gb', ' work related pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('14', 'field', '21', 'en_gb', ' fractures ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('14', 'field', '22', 'en_gb', ' following a broken bone the joints around the area will often become stiff and painful the muscles weak and balance poor this is easily improved with the advice manual therapy and exercises provided by cathedral physiotherapy ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('14', 'field', '23', 'en_gb', ' 75 00 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('14', 'field', '24', 'en_gb', ' 30 00 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('14', 'slug', '0', 'en_gb', ' fractures ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('14', 'title', '0', 'en_gb', ' fractures ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('15', 'field', '21', 'en_gb', ' children s injuries ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('15', 'field', '22', 'en_gb', ' although many children bounce back quickly after injury if they are particularly sporty or have lost their confidence after a sprain strain or fracture they may need some reassurance and treatment exercises to return to their previous level of care free fitness ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('15', 'field', '23', 'en_gb', ' 50 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('15', 'field', '24', 'en_gb', ' 50 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('15', 'slug', '0', 'en_gb', ' childrens injuries ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('15', 'title', '0', 'en_gb', ' children s injuries ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('16', 'field', '21', 'en_gb', ' young adult hip pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('16', 'field', '22', 'en_gb', ' hip pain in young adults can be caused by a number of issues from muscle imbalance around the hip cartilage problems within the joint bony anatomical issues or referred pain from the back or pelvis the excellent clinical reasoning found at cathedral physiotherapy will help to differentiate the causes and formulate a treatment plan or onward referral as required i have worked closely with the royal devon and exeter nhs hospital hip consultants with patients with femoral acetabular impingement in particular including being involved in research and so am at the cutting edge of treating this group of patients ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('16', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('16', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('16', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('16', 'title', '0', 'en_gb', ' young adult hip pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('17', 'field', '21', 'en_gb', ' sports injuries ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('17', 'field', '22', 'en_gb', ' whether you are after prevention or cure cathedral physiotherapy can help you excellent assessment will ensure that you receive the treatment you require be it a combination of functional exercise manual therapy ultrasound taping or acupuncture we have a small exercise area in the clinic but can also adapt your training program for your to rehabilitate at your own gym pool ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('17', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('17', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('17', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('17', 'title', '0', 'en_gb', ' sports injuries ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('18', 'field', '21', 'en_gb', ' haemophilia ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('18', 'field', '22', 'en_gb', ' for those individuals diagnosed with haemophilia early access to physiotherapy is crucial following a bleed this is a niche area that sarah has worked in as the designated haemophilia physiotherapy specialist at the royal devon and exeter hospital over the last few years so you can be assured that you are in safe hands ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('18', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('18', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('18', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('18', 'title', '0', 'en_gb', ' haemophilia ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('19', 'field', '21', 'en_gb', ' work related pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('19', 'field', '22', 'en_gb', ' whether you work at a desk all day or prune trees for a living at some point during your working life you are likely to suffer from pain related to your occupation in fact 60% of people on long term sick leave cite musculoskeletal disorders as the cause rapid access to musculoskeletal physiotherapy can reduce the amount of time people are off sick and it is vital in preventing a new acute problem becoming chronic and long lasting department of health 2008 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('19', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('19', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('19', 'slug', '0', 'en_gb', ' work related pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('19', 'title', '0', 'en_gb', ' work related pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('20', 'field', '21', 'en_gb', ' sprains and strains ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('20', 'field', '22', 'en_gb', ' minor sprains and strains can be managed with price therapy protect the area using a support temporarily rest the are for the first 48 72 hrs apply ice wrapped in a damp towel for 15 20 mins every 2 3 hrs of the day for the first 72 hrs be careful not to place ice directly on the skin compress or bandage the injured area to limit swelling being careful not to affect the blood flow and remove the bandage before sleep elevate the injured area supported on a pillow to reduce the swelling ultrasound and taping can also promote healing following this we will help rehabilitate you range of movement strength and balance so that you return to your full function ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('20', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('20', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('20', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('20', 'title', '0', 'en_gb', ' sprains and strains ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('21', 'field', '21', 'en_gb', ' back pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('21', 'field', '22', 'en_gb', ' low back pain is reported by 80% of people at sometime in their life a large percentage of this will improve with basic advice and exercises but some people need more specific treatment work related advice functional exercises manual therapy or acupuncture come and be assessed today so that we can help you on your road to recovery and to help prevent recurrence ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('21', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('21', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('21', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('21', 'title', '0', 'en_gb', ' back pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('22', 'field', '21', 'en_gb', ' neck pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('22', 'field', '22', 'en_gb', ' neck pain is common but most cases aren t caused by a serious problem some people get it after an accident or injury whilst others find it appears if they are stressed or inactive or it can be related to age related changes in the structures of the neck commonly felt locally in the neck it can also refer to the shoulder arm and sometimes may cause pins and needles numbness with good advice reassurance specific exercises and sometimes manual therapy the majority of neck pain improved within about six weeks ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('22', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('22', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('22', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('22', 'title', '0', 'en_gb', ' neck pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('23', 'field', '21', 'en_gb', ' shoulder elbow wrist pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('23', 'field', '22', 'en_gb', ' whether your pain is work or hobby related it is important to get the correct advice early to prevent chronicity arm pain can be referred from the neck but is more commonly related to impingement of the tendons or tears of the muscle but can also be due to frozen shoulder elbow complaints include tennis elbow golfers elbow or nerve irritation wrist pain is commonly related to the position of the wrist at work or during hobbies but can be due to stiffness post fracture or carpal tunnel syndrome an excellent assessment will differentiate the problem and help you to manage and improve your symptoms ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('23', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('23', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('23', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('23', 'title', '0', 'en_gb', ' shoulder elbow wrist pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('24', 'field', '21', 'en_gb', ' hip knee ankle pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('24', 'field', '22', 'en_gb', ' hip pain problems with cartilage early osteoarthritis tendonopathy sprains and muscle imbalances can all cause hip pain but it can also be referred from the back accurate assessment is crucial to ensure you have the right treatment to improve your problem knee pain be it local pain swelling or stiffness secondary to an acute injury to the ligaments of the joint more insidious in nature or referred pain once diagnosed the majority of problems will significantly improve with a specific functional exercise program but if necessary it can also be treated with manual therapy ultrasound taping or acupuncture too ankle pain the majority of people have sustained a sprained ankle at some point and we can offer acute treatment for this with ultrasound soft tissie therapy taping and exercises however we rely on our legs heavily and the key is to prevent it recurring again through specific rehabilitation so that you can stay as fit and active as you wish ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('24', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('24', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('24', 'slug', '0', 'en_gb', ' hip knee ankle pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('24', 'title', '0', 'en_gb', ' hip knee ankle pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('25', 'field', '21', 'en_gb', ' orthopaedic post operative care ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('25', 'field', '22', 'en_gb', ' come to cathedral physiotherapy for your post operative care be it following a fracture ligament reconstruction hip arthroscopy or joint replacement we can help you regain your independence having worked at the royal devon and exeter hospital for the last 11 years i have strong links with the orthopaedic teams there ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('25', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('25', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('25', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('25', 'title', '0', 'en_gb', ' orthopaedic post operative care ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('26', 'field', '21', 'en_gb', ' post fracture rehabilitation ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('26', 'field', '22', 'en_gb', ' it is quite common to have on going problems with pain swelling and stiffness in the joints surrounding the area where you have fractured however the real issue is that people often lose their confidence too let us rehabilitate you back to your previous level of function or fitness allowing you to live your life to the full ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('26', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('26', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('26', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('26', 'title', '0', 'en_gb', ' post fracture rehabilitation ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('27', 'field', '21', 'en_gb', ' non specific arm pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('27', 'field', '22', 'en_gb', ' characterised by ongoing pain altered sensations in the hand arm and sometime feelings of weakness this can be a frustrating condition to have particularly as commonly many objective medical test are negative often modifications to posture work stations gaining an understanding of pain mechanisms and local tissues techniques can improve symptoms and function ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('27', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('27', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('27', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('27', 'title', '0', 'en_gb', ' non specific arm pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('28', 'field', '21', 'en_gb', ' thoracic outlet syndrome ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('28', 'field', '22', 'en_gb', ' characterised by neck shoulder arm pain feelings of weakness in the arm particularly with overhead activities and possible discolouration of the hand this condition can be debilitating with good quality conservative physiotherapy symptoms and function can be significantly improved thereby improving your quality of life ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('28', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('28', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('28', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('28', 'title', '0', 'en_gb', ' thoracic outlet syndrome ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('29', 'field', '21', 'en_gb', ' headaches and dizziness ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('29', 'field', '22', 'en_gb', ' benign headaches can be caused by tension in the muscles stiffness in the neck or muscle imbalance often characterised by being one sided or in a band around the head and associated with neck pain or certain movements symptoms can be improved significantly with a combination of exercise manual therapy acupuncture and an understanding of pain pathways dizziness can be generated from the neck the inner ear or the brain and accurate differential diagnosis is crucial for appropriate treatment ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('29', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('29', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('29', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('29', 'title', '0', 'en_gb', ' headaches and dizziness ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('30', 'field', '21', 'en_gb', ' pregnancy related pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('30', 'field', '22', 'en_gb', ' pregnancy related pelvic girdle pain is common and affects 1 in 5 women during their pregnancy there are a wide range of symptoms some of which improve naturally during the course of the pregnancy as your body adapts some which need advice and or treatment early on to keep you as active as possible don t suffer in silence get help early ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('30', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('30', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('30', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('30', 'title', '0', 'en_gb', ' pregnancy related pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('31', 'field', '21', 'en_gb', ' management of long term conditions ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('31', 'field', '22', 'en_gb', ' some people are diagnosed with long term conditions be it persistent pain generated by the nervous system or on going musculoskeletal problems following a car crash at cathedral physiotherapy we believe in working with you to assist you to maximise your physical potential ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('31', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('31', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('31', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('31', 'title', '0', 'en_gb', ' management of long term conditions ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('32', 'field', '21', 'en_gb', ' rheumatological conditions ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('32', 'field', '22', 'en_gb', ' although consisting of a variety of diagnosis for instance rheumatoid arthritis ankylosing spondylitis psoriatic arthritis etc many of these diseases follow a period of flare and recovery at cathedral physiotherapy we can help you not to be defined by your diagnosis assist you through your flares and maximise your return to function so that you continue to lead and full and fruitful life ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('32', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('32', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('32', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('32', 'title', '0', 'en_gb', ' rheumatological conditions ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('33', 'field', '21', 'en_gb', ' osteoarthritis ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('33', 'field', '22', 'en_gb', ' osteoarthritis is a common type of arthritis a painful condition which can affect the joints especially the hips knees neck lower back hand or feet although it can occur at any age it is more likely to appear between the ages of 45 75 years and often in women more than men there is much evidence showing that a combination of non steroidal anti inflammatories and exercise or physiotherapy will help to reduce the symptoms of pain and stiffness allowing you not to be restricted by your symptoms ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('33', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('33', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('33', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('33', 'title', '0', 'en_gb', ' osteoarthritis ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('34', 'field', '21', 'en_gb', ' joint replacements ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('34', 'field', '22', 'en_gb', ' following total or partial knee replacement hip replacement or shoulder replacement good quality regular physiotherapy is important to decrease swelling and pain and increase range of movement muscle power and function we are a lower ground premises therefore you need to be able to complete one flight of stairs however if access is an issue contact us and we will discuss the possibility of a domiciliary visit ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('34', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('34', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('34', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('34', 'title', '0', 'en_gb', ' joint replacements ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('35', 'field', '21', 'en_gb', ' osteoporosis ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('35', 'field', '22', 'en_gb', ' having been the principle investigator for exeter on the prove trial 2014 16 looking into rehabilitation of patients with osteoporosis who have vertebral fractures i am well qualified to help you manage your condition and to keep you as fit and active as possible ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('35', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('35', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('35', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('35', 'title', '0', 'en_gb', ' osteoporosis ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('36', 'field', '21', 'en_gb', ' post cancer rehabilitation ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('36', 'field', '22', 'en_gb', ' most people are so relieved to have stopped the active stage of their treatment be it radiotherapy or chemotherapy that they are happy to live with compromises in function for a time however it is common to become frustrated with these compromises once your energy returns we passionately believe that you should not be defined by your diagnosis and will work hard with you to facilitate and maximise your return to function be it to improve your shoulder range of movement post breast surgery so that you can reach the top cupboards or return to tennis and swimming again ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('36', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('36', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('36', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('36', 'title', '0', 'en_gb', ' post cancer rehabilitation ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('37', 'field', '21', 'en_gb', ' mild continence issues ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('37', 'field', '22', 'en_gb', ' bladder or bowel continence issues can be embarrassing but when it is only a mild issue much can be done with pelvic floor exercises and fluid intake management we can happily treat mild continence issues e g post pregnancy or stress incontinence related to respiratory problems if we feel your continence issues need further input then we will refer you on to the appropriate practitioner ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('37', 'field', '23', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('37', 'field', '24', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('37', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('37', 'title', '0', 'en_gb', ' mild continence issues ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('9', 'field', '26', 'en_gb', ' sports injuries young adult hip pain children s injuries lorem ipsum dolor sit amet consectetur adipiscing elit sed hendrerit lectus at enim condimentum egestas nulla molestie turpis ligula eu auctor urna varius nec young active sport woman work related pain back pain neck pain shoulder elbow wrist pain hip knee ankle pain orthopaedic post operative care post fracture rehabilitation non specific arm pain thoracic outlet syndrome headaches and dizziness pregnancy related pain lorem ipsum dolor sit amet consectetur adipiscing elit sed hendrerit lectus at enim condimentum egestas nulla molestie turpis ligula eu auctor urna varius nec work social sport woman management of long term conditions osteoarthritis joint replacements osteoporosis post cancer rehabilitation mild continence issues lorem ipsum dolor sit amet consectetur adipiscing elit sed hendrerit lectus at enim condimentum egestas nulla molestie turpis ligula eu auctor urna varius nec lifetime support sport woman ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('68', 'field', '36', 'en_gb', ' mobilise your back go swimming etc etc sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium totam rem aperiam eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam est qui dolorem ipsum quia dolor sit amet consectetur adipisci velit sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem ut enim ad minima veniam quis nostrum exercitationem ullam corporis suscipit laboriosam nisi ut aliquid ex ea commodi consequatur quis autem vel eum iure reprehen ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('68', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('68', 'field', '37', 'en_gb', ' back pain tips ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('68', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('67', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('67', 'title', '0', 'en_gb', ' istock rf photo of arthritis pain in hand ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('67', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('67', 'extension', '0', 'en_gb', ' jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('66', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('66', 'title', '0', 'en_gb', ' back pain gif 437580 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('67', 'filename', '0', 'en_gb', ' istock_rf_photo_of_arthritis_pain_in_hand jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('65', 'slug', '0', 'en_gb', ' sports injuries ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('65', 'title', '0', 'en_gb', ' sports injuries ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('66', 'filename', '0', 'en_gb', ' back pain gif 437580 gif ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('66', 'extension', '0', 'en_gb', ' gif ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('66', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('65', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('65', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('65', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('65', 'field', '38', 'en_gb', ' sports injury 2 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('65', 'field', '37', 'en_gb', ' sports injuries ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('65', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('65', 'field', '36', 'en_gb', ' tips for treating sports injuries immediately after they happen use ice to reduce swelling sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium totam rem aperiam eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam est qui dolorem ipsum quia dolor sit amet consectetur adipisci velit sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem ut enim ad minima veniam quis nostrum exercitationem ullam corporis suscipit laboriosam nisi ut aliquid ex ea commodi consequatur quis autem vel eum iure reprehen ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('65', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('41', 'filename', '0', 'en_gb', ' sport woman jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('41', 'extension', '0', 'en_gb', ' jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('41', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('41', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('41', 'title', '0', 'en_gb', ' sport woman ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('9', 'field', '6', 'en_gb', ' treatments ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('9', 'field', '7', 'en_gb', ' physiotherapy helps to restore movement and function when someone has been affected by injury work related problems illness or disease it is a science based profession and takes a whole person approach to health and wellbeing which includes the patient s general lifestyle at the core is the patient s involvement in their own care through education awareness empowerment and participation in their treatment please look through the lists below and see how we can help you ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('7', 'field', '8', 'en_gb', ' lower ground floor 22 southernhay west southernhay ex1 1pr ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('7', 'field', '3', 'en_gb', ' 07811 970 007 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('7', 'field', '4', 'en_gb', ' enquiries cathedralphysiotherapy co uk ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('7', 'field', '13', 'en_gb', ' https www facebook com cathedralphysiotherapy ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('7', 'field', '5', 'en_gb', ' twitter ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('42', 'field', '9', 'en_gb', ' lower ground floor ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('42', 'field', '10', 'en_gb', ' 22 southernhay west ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('42', 'field', '11', 'en_gb', ' southernhay ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('42', 'field', '12', 'en_gb', ' ex1 1pr ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('42', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('43', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('43', 'field', '14', 'en_gb', ' lorem ipsum dolor sit amet consectetur adipiscing elit nam metus nisl varius nec hendrerit ut cursus sed metus treatments treatments lorem ipsum dolor sit amet consectetur adipiscing elit nam metus nisl varius nec hendrerit ut cursus sed metus about about lorem ipsum dolor sit amet consectetur adipiscing elit nam metus nisl varius nec hendrerit ut cursus sed metus accreditations accreditations ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('44', 'field', '15', 'en_gb', ' treatments ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('44', 'field', '16', 'en_gb', ' lorem ipsum dolor sit amet consectetur adipiscing elit nam metus nisl varius nec hendrerit ut cursus sed metus ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('44', 'field', '17', 'en_gb', ' treatments ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('44', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('45', 'field', '15', 'en_gb', ' about ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('45', 'field', '16', 'en_gb', ' lorem ipsum dolor sit amet consectetur adipiscing elit nam metus nisl varius nec hendrerit ut cursus sed metus ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('45', 'field', '17', 'en_gb', ' about ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('45', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('46', 'field', '15', 'en_gb', ' accreditations ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('46', 'field', '16', 'en_gb', ' lorem ipsum dolor sit amet consectetur adipiscing elit nam metus nisl varius nec hendrerit ut cursus sed metus ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('46', 'field', '17', 'en_gb', ' accreditations ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('46', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('49', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('49', 'field', '38', 'en_gb', ' joint pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('49', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('49', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('49', 'slug', '0', 'en_gb', ' winter chills ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('49', 'title', '0', 'en_gb', ' winter chills ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('4', 'field', '6', 'en_gb', ' providing the best care ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('4', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('4', 'field', '7', 'en_gb', ' excellence experience and enthusiasm three qualities which represents cathedral physiotherapy created by sarah moore an exeter physio with 18 years of experience 15 of those specifically within the field of musculoskeletal physiotherapy who is passionate about providing the best possible care ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('4', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('4', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('4', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('4', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('5', 'field', '6', 'en_gb', ' accreditations ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('5', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('5', 'field', '7', 'en_gb', ' you can be assured that the clinic is regulated and governed by the following bodies for your safety ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('5', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('5', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('5', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('5', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('8', 'field', '6', 'en_gb', ' find us ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('8', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('8', 'field', '7', 'en_gb', ' lorem ipsum dolor sit amet consectetur adipiscing elit sed hendrerit lectus at enim condimentum egestas nulla molestie turpis ligula eu auctor urna varius nec ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('8', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('8', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('8', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('8', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('2', 'field', '6', 'en_gb', ' delivering excellence experience and enthusiasm ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('2', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('2', 'field', '7', 'en_gb', ' physiotherapy helps to restore movement and function when someone has been affected by injury work related problems illness or disease it is a science based profession and takes a whole person approach to health and wellbeing which includes the patient s general lifestyle at the core is the patient s involvement in their own care through education awareness empowerment and participation in their treatment ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('2', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('2', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('2', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('2', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('47', 'field', '6', 'en_gb', ' latest news ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('47', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('47', 'field', '7', 'en_gb', ' welcome to our news page which includes information from self help advice for what to do as soon as you ve hurt yourself to topical items in the news and copies of our monthly news letter there are also a number of useful links to u tube clips which we feel are useful if there is something that isn t here and you would like to see then please email us as enquiries cathedralphysiotherapy co uk and we will do our best to respond to your suggestions ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('47', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('47', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('47', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('47', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('9', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('9', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('9', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('9', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('9', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('50', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('50', 'field', '37', 'en_gb', ' muscle pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('50', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('50', 'field', '36', 'en_gb', ' this is a test news article about nothing in particular sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium totam rem aperiam eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam est qui dolorem ipsum quia dolor sit amet consectetur adipisci velit sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem ut enim ad minima veniam quis nostrum exercitationem ullam corporis suscipit laboriosam nisi ut aliquid ex ea commodi consequatur quis autem vel eum iure reprehen ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('64', 'filename', '0', 'en_gb', ' sports injury 2 jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('64', 'extension', '0', 'en_gb', ' jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('64', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('64', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('64', 'title', '0', 'en_gb', ' sports injury 2 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('50', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('50', 'field', '38', 'en_gb', ' banner ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('50', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('50', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('50', 'slug', '0', 'en_gb', ' test news article ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('50', 'title', '0', 'en_gb', ' muscle pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('51', 'filename', '0', 'en_gb', ' banner png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('51', 'extension', '0', 'en_gb', ' png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('51', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('51', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('51', 'title', '0', 'en_gb', ' banner ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('4', 'field', '39', 'en_gb', ' excellence is ensured by the post graduate skills obtained including an msc in neuromusculoskeletal physiotherapy from cardiff university membership of the chartered society of physiotherapy csp the musculoskeletal association of physiotherapists macp the british medical acupuncture society bmas and physiofirst as well as being regulated by the health care professions council hcpc this helps to maintain the practice at the pinnacle of physiotherapy in exeter excellence experience is guaranteed following 18 years working in the nhs as a qualified physiotherapist currently her time is split between working as clinical lead physiotherapist at the royal devon and exeter nhs trust where she has been working for the last 12 years and running cathedral physiotherapy she has a wealth of experience having worked in among other areas outpatients occupational health accident and emergency trauma orthopaedics pain clinic rheumatology hydrotherapy haemophilia and post cancer rehabilitation and specialises in complex conditions which may have previously failed conservative treatment experience enthusiasm motivates sarah who is absolutely passionate about providing the best possible care for your condition sarah is absolutely passionate about providing the best possible care for your condition she strongly believes that people should not allow their difficulties pain weakness loss of function previous diagnoses to define them as individuals and works with her clients in a friendly and positive way to help them achieve their functional potential and goals enthusiasm ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('4', 'field', '42', 'en_gb', ' after obtaining her bsc hons from the university of brighton in 1997 she worked at ubh in bristol between 1997 2004 which included taking a year to explore the world and work as a physio within hih insurance in new zealand she also worked as a medic for trekforce in the jungles of borneo for two months having attended many postgraduate courses including obtaining her certificate in acupuncture she undertook a specialist qualification in neuromusculoskeletal physiotherapy a 2 year diploma and post graduate examinations resulting in her obtaining membership of the musculoskeletal association of chartered physiotherapists during this time she moved to exeter to take up a team lead role at the royal devon and exeter nhs trust which quickly progressed to a clinical lead role covering msk outpatients women s health including obstetrics rheumatology hydrotherapy and cardiac rehab and respiratory outpatients as well as working as the specialist physiotherapist for haemophilia patients keen to continue developing sarah completed her msc in neuromusculoskeletal physiotherapy from cardiff university in 2012 latterly sarah has also had a role as principle investigator exeter site in the prove trial run by oxford university the national osteoporosis society national institute fo rhealth research and oxford nuffield nhs trust this is the largest trial in the uk investigating physiotherapy rehabilitation for the treatment of osteoporosis having completed multiple service reviews over the years sarah has implemented this knowledge to ensure she runs an efficient and effective business she has always enjoyed her regular teaching and 1 1 mentoring and is keen to continue this within her private practice both with other physio s and doctors as well as health promotion within local businesses initiatives she has been involved with include helping set up and audit a dedicated occupational physiotherapy service at ubh in bristol and physio direct a physiotherapy advice line specialising in complex conditions but equally happy to treat any musculoskeletal problem sarah has a passion to provide the best possible care for your condition she is determined to help clients not to be defined by their diagnoses and to help them optimise their musculoskeletal health function and well being about sarah moore wzgx w9oublvaajgcka uvwpwyl6hkg jn0 gwjoui4pvdzbhtafo1l9eafkc8swhdbtdk2xjdqurdgk7sjl8a bsc hons ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('52', 'field', '40', 'en_gb', ' excellence ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('52', 'field', '41', 'en_gb', ' excellence is ensured by the post graduate skills obtained including an msc in neuromusculoskeletal physiotherapy from cardiff university membership of the chartered society of physiotherapy csp the musculoskeletal association of physiotherapists macp the british medical acupuncture society bmas and physiofirst as well as being regulated by the health care professions council hcpc this helps to maintain the practice at the pinnacle of physiotherapy in exeter ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('52', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('53', 'field', '40', 'en_gb', ' experience ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('53', 'field', '41', 'en_gb', ' experience is guaranteed following 18 years working in the nhs as a qualified physiotherapist currently her time is split between working as clinical lead physiotherapist at the royal devon and exeter nhs trust where she has been working for the last 12 years and running cathedral physiotherapy she has a wealth of experience having worked in among other areas outpatients occupational health accident and emergency trauma orthopaedics pain clinic rheumatology hydrotherapy haemophilia and post cancer rehabilitation and specialises in complex conditions which may have previously failed conservative treatment ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('53', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('54', 'field', '40', 'en_gb', ' enthusiasm ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('54', 'field', '41', 'en_gb', ' enthusiasm motivates sarah who is absolutely passionate about providing the best possible care for your condition sarah is absolutely passionate about providing the best possible care for your condition she strongly believes that people should not allow their difficulties pain weakness loss of function previous diagnoses to define them as individuals and works with her clients in a friendly and positive way to help them achieve their functional potential and goals ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('54', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('55', 'field', '43', 'en_gb', ' about sarah moore ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('55', 'field', '44', 'en_gb', ' bsc hons ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('55', 'field', '45', 'en_gb', ' after obtaining her bsc hons from the university of brighton in 1997 she worked at ubh in bristol between 1997 2004 which included taking a year to explore the world and work as a physio within hih insurance in new zealand she also worked as a medic for trekforce in the jungles of borneo for two months having attended many postgraduate courses including obtaining her certificate in acupuncture she undertook a specialist qualification in neuromusculoskeletal physiotherapy a 2 year diploma and post graduate examinations resulting in her obtaining membership of the musculoskeletal association of chartered physiotherapists during this time she moved to exeter to take up a team lead role at the royal devon and exeter nhs trust which quickly progressed to a clinical lead role covering msk outpatients women s health including obstetrics rheumatology hydrotherapy and cardiac rehab and respiratory outpatients as well as working as the specialist physiotherapist for haemophilia patients keen to continue developing sarah completed her msc in neuromusculoskeletal physiotherapy from cardiff university in 2012 latterly sarah has also had a role as principle investigator exeter site in the prove trial run by oxford university the national osteoporosis society national institute fo rhealth research and oxford nuffield nhs trust this is the largest trial in the uk investigating physiotherapy rehabilitation for the treatment of osteoporosis having completed multiple service reviews over the years sarah has implemented this knowledge to ensure she runs an efficient and effective business she has always enjoyed her regular teaching and 1 1 mentoring and is keen to continue this within her private practice both with other physio s and doctors as well as health promotion within local businesses initiatives she has been involved with include helping set up and audit a dedicated occupational physiotherapy service at ubh in bristol and physio direct a physiotherapy advice line specialising in complex conditions but equally happy to treat any musculoskeletal problem sarah has a passion to provide the best possible care for your condition she is determined to help clients not to be defined by their diagnoses and to help them optimise their musculoskeletal health function and well being ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('55', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('56', 'filename', '0', 'en_gb', ' sarah profile png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('56', 'extension', '0', 'en_gb', ' png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('56', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('56', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('56', 'title', '0', 'en_gb', ' sarah profile ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('55', 'field', '47', 'en_gb', ' wzgx w9oublvaajgcka uvwpwyl6hkg jn0 gwjoui4pvdzbhtafo1l9eafkc8swhdbtdk2xjdqurdgk7sjl8a ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('57', 'field', '6', 'en_gb', ' pricing ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('57', 'field', '7', 'en_gb', ' at cathedral physiotherapy we like to keep things simple so we only have two prices regardless of the treatment you are having at the clinic new appointments last an hour and cost 45 follow up appointments last an hour and cost 35 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('57', 'slug', '0', 'en_gb', ' pricing ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('57', 'title', '0', 'en_gb', ' pricing ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('58', 'slug', '0', 'en_gb', ' testimonialspg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('58', 'title', '0', 'en_gb', ' testimonials ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('58', 'field', '7', 'en_gb', ' placeholder text for testimonials intro paragraph ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('58', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('58', 'field', '6', 'en_gb', ' placeholder heading for testimonials ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('58', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('58', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('58', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('58', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('59', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('60', 'field', '49', 'en_gb', ' client name ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('60', 'field', '50', 'en_gb', ' exeter ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('60', 'field', '51', 'en_gb', ' great team of staff with excellent knowledge care and professionalism ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('74', 'field', '49', 'en_gb', ' client name ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('60', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('61', 'slug', '0', 'en_gb', ' work and social ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('61', 'title', '0', 'en_gb', ' work and social ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('62', 'slug', '0', 'en_gb', ' young and active ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('62', 'title', '0', 'en_gb', ' young and active ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('63', 'slug', '0', 'en_gb', ' lifetime support ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('63', 'title', '0', 'en_gb', ' lifetime support ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('61', 'field', '6', 'en_gb', ' work social ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('61', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('61', 'field', '7', 'en_gb', ' lorem ipsum dolor sit amet consectetur adipiscing elit sed hendrerit lectus at enim condimentum egestas nulla molestie turpis ligula eu auctor urna varius nec ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('61', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('61', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('61', 'field', '52', 'en_gb', ' work related pain back pain neck pain shoulder elbow wrist pain hip knee ankle pain post fracture rehabilitation non specific arm pain thoracic outlet syndrome headaches and dizziness pregnancy related pain ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('61', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('61', 'field', '53', 'en_gb', ' work man ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('61', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('62', 'field', '6', 'en_gb', ' young active ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('62', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('62', 'field', '7', 'en_gb', ' lorem ipsum dolor sit amet consectetur adipiscing elit sed hendrerit lectus at enim condimentum egestas nulla molestie turpis ligula eu auctor urna varius nec ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('62', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('62', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('62', 'field', '52', 'en_gb', ' sports injuries young adult hip pain children s injuries ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('62', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('62', 'field', '53', 'en_gb', ' sport woman ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('62', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('63', 'field', '6', 'en_gb', ' lifetime support ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('63', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('63', 'field', '7', 'en_gb', ' lorem ipsum dolor sit amet consectetur adipiscing elit sed hendrerit lectus at enim condimentum egestas nulla molestie turpis ligula eu auctor urna varius nec ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('63', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('63', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('63', 'field', '52', 'en_gb', ' management of long term conditions rheumatological conditions osteoarthritis joint replacements osteoporosis post cancer rehabilitation mild continence issues ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('63', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('63', 'field', '53', 'en_gb', ' lifetime couple ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('63', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('68', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('68', 'field', '38', 'en_gb', ' back pain gif 437580 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('68', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('68', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('68', 'slug', '0', 'en_gb', ' back pain tips ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('68', 'title', '0', 'en_gb', ' back pain tips ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('69', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('69', 'field', '37', 'en_gb', ' arthritis ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('69', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('69', 'field', '36', 'en_gb', ' we can help you manage the pain a recommend techniques to reduce the debilitating effects sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium totam rem aperiam eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam est qui dolorem ipsum quia dolor sit amet consectetur adipisci velit sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem ut enim ad minima veniam quis nostrum exercitationem ullam corporis suscipit laboriosam nisi ut aliquid ex ea commodi consequatur quis autem vel eum iure reprehen ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('69', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('69', 'field', '38', 'en_gb', ' istock rf photo of arthritis pain in hand ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('69', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('69', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('69', 'slug', '0', 'en_gb', ' arthritis ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('69', 'title', '0', 'en_gb', ' arthritis ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('70', 'filename', '0', 'en_gb', ' tennis elbow jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('70', 'extension', '0', 'en_gb', ' jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('70', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('70', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('70', 'title', '0', 'en_gb', ' tennis elbow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('71', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('71', 'field', '37', 'en_gb', ' preventing tennis elbow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('71', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('71', 'field', '36', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('71', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('71', 'field', '38', 'en_gb', ' tennis elbow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('71', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('71', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('71', 'slug', '0', 'en_gb', ' preventing tennis elbow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('71', 'title', '0', 'en_gb', ' preventing tennis elbow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('71', 'field', '63', 'en_gb', ' our top tips on how to prevent tennis elbow sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium totam rem aperiam eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam est qui dolorem ipsum quia dolor sit amet consectetur adipisci velit sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem ut enim ad minima veniam quis nostrum exercitationem ullam corporis suscipit laboriosam nisi ut aliquid ex ea commodi consequatur quis autem vel eum iure reprehen ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('71', 'field', '54', 'en_gb', ' this is the intro to the article in a short sentence ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('69', 'field', '54', 'en_gb', ' this is the intro to the article in a short sentence ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('68', 'field', '54', 'en_gb', ' this is the intro to the article in a short sentence ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('65', 'field', '54', 'en_gb', ' this is the intro to the article in a short sentence ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('50', 'field', '54', 'en_gb', ' this is the intro to the article in a short sentence ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('49', 'field', '54', 'en_gb', ' this is the intro to the article in a short sentence ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('72', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('72', 'field', '37', 'en_gb', ' test article ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('72', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('72', 'field', '54', 'en_gb', ' lorem ipsum dolor sit amet consectetur adipiscing elit morbi venenatis eros nunc at venenatis ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('72', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('72', 'field', '36', 'en_gb', ' lorem ipsum dolor sit amet consectetur adipiscing elit morbi venenatis eros nunc at venenatis nibh gravida nec donec tincidunt lectus vel bibendum auctor aenean congue aliquam turpis ac scelerisque elit consequat ut fusce at metus congue mattis quam in eleifend metus sed ipsum ipsum ultricies vel sem nec ultricies fringilla purus fusce a tortor eget lorem dapibus placerat aenean ut arcu in lorem finibus sagittis suspendisse venenatis urna ut tempus finibus mauris dui malesuada lectus at mattis tortor lorem nec purus lorem ipsum dolor sit amet consectetur adipiscing elit morbi venenatis eros nunc at venenatis nibh gravida nec ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('72', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('72', 'field', '38', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('72', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('72', 'slug', '0', 'en_gb', ' test article ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('72', 'title', '0', 'en_gb', ' test article ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('73', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('73', 'field', '37', 'en_gb', ' another test article ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('73', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('73', 'field', '54', 'en_gb', ' agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('73', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('73', 'field', '36', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('73', 'field', '63', 'en_gb', ' agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('73', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('73', 'field', '38', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('73', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('73', 'slug', '0', 'en_gb', ' another test article ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('73', 'title', '0', 'en_gb', ' another test article ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('7', 'field', '55', 'en_gb', ' ua 70464796 1 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('74', 'field', '50', 'en_gb', ' exeter ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('74', 'field', '51', 'en_gb', ' after seven years of suffering with arm pain i went to sarah to see if there was anything she could do to relieve it now three months on all i can say is a huge thank you as i am completely clear of all arm and neck pain for the first time in years i can do normal things ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('74', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('75', 'field', '49', 'en_gb', ' client name ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('75', 'field', '50', 'en_gb', ' exeter ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('75', 'field', '51', 'en_gb', ' quickly diagnosed the problem clearly explained the body s reaction and devised an effective remedy both in session and through exercises all in all i am delighted ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('75', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('76', 'filename', '0', 'en_gb', ' lifetime couple jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('76', 'extension', '0', 'en_gb', ' jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('76', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('76', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('76', 'title', '0', 'en_gb', ' lifetime couple ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('77', 'filename', '0', 'en_gb', ' work man jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('77', 'extension', '0', 'en_gb', ' jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('77', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('77', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('77', 'title', '0', 'en_gb', ' work man ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('78', 'filename', '0', 'en_gb', ' 6f14d766 8edf 4b3c b385 96bfed558d4c jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('78', 'extension', '0', 'en_gb', ' jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('78', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('78', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('78', 'title', '0', 'en_gb', ' 6f14d766 8edf 4b3c b385 96bfed558d4c ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('79', 'filename', '0', 'en_gb', ' hpc logo registered jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('79', 'extension', '0', 'en_gb', ' jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('79', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('79', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('79', 'title', '0', 'en_gb', ' hpc logo registered ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('80', 'filename', '0', 'en_gb', ' imgres png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('80', 'extension', '0', 'en_gb', ' png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('80', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('80', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('80', 'title', '0', 'en_gb', ' imgres ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('81', 'filename', '0', 'en_gb', ' 6f14d766 8edf 4b3c b385 96bfed558d4c_1 jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('81', 'extension', '0', 'en_gb', ' jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('81', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('81', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('81', 'title', '0', 'en_gb', ' 6f14d766 8edf 4b3c b385 96bfed558d4c 1 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('82', 'filename', '0', 'en_gb', ' bmas logo jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('82', 'extension', '0', 'en_gb', ' jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('82', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('82', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('82', 'title', '0', 'en_gb', ' bmas logo ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('83', 'filename', '0', 'en_gb', ' hpc logo registered_1 jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('83', 'extension', '0', 'en_gb', ' jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('83', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('83', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('83', 'title', '0', 'en_gb', ' hpc logo registered 1 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('84', 'filename', '0', 'en_gb', ' imgres_1 png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('84', 'extension', '0', 'en_gb', ' png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('84', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('84', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('84', 'title', '0', 'en_gb', ' imgres 1 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('5', 'field', '58', 'en_gb', ' a chartered physiotherapist is a qualified member of their professional body the chartered society of physiotherapy csp through this membership they have committed themselves to providing high quality services and protecting the quality of physical treatments for further information see http www csp org uk your health find physio choose chartered csp csp footer chartered society of physiotherapy the british medical acupuncture society is a registered charity established to encourage the use and scientific understanding of acupuncture within medicine for the public benefit it seeks to enhance the education and training of suitably qualified practitioners and to promote high standards of working practices in acupuncture members are regulated healthcare professionals who practice acupuncture within the scope of their professional practice bmas bmas footer british medical acupuncture society the hcpc s role is to protect the public it does this by setting standards for registration as a health and care professional and keeping a register of individuals who meet these standards hcpc standards relate to registrants education professional knowledge and skills behaviour conduct performance and ethics and health the hcpc register is open to the public so that individuals and employers can check whether a physiotherapist or other health and care professional holds registration hpc hpc footer health professionals council the musculoskeletal association of chartered physiotherapists macp is a group of over 1100 physiotherapists who are members of the chartered society of physiotherapy in addition to their undergraduate training they have all undertaken extensive postgraduate study and reached a recognised standard of excellence in neuromusculoskeletal physiotherapy their knowledge and practical skills ensures that all macp physiotherapists are able to provide an excellent standard of care in examination treatment and management for people with neuromusculoskeletal problems in the uk the macp is recognised as the specialist manipulative therapy group by the international federation of orthopaedic manipulative physical therapists ifompt to obtain membership of the macp clinicians have to complete a recognised postgraduate course of study many of which are at a master of science level the association has 1000 full members members who have passed a stringent examination process and almost 200 associate members members undertaking post graduate education leading to membership macp logo macp logo reverse musculoskeletal association of chartered physiotherapists physio first is the organisation which represents physiotherapists in private practice launched in 1952 to promote the highest standards of clinical physiotherapy practice physio first for the next 5 years is for championing evidence based cost effective private physiotherapy with physio first members in the changing healthcare marketplace this includes our desire to help the general public understand how physiotherapy can help them and to facilitate easy access to our highly skilled members physio first physiofirst footer physio first ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('85', 'field', '59', 'en_gb', ' csp ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('85', 'field', '60', 'en_gb', ' chartered society of physiotherapy ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('85', 'field', '61', 'en_gb', ' a chartered physiotherapist is a qualified member of their professional body the chartered society of physiotherapy csp through this membership they have committed themselves to providing high quality services and protecting the quality of physical treatments for further information see http www csp org uk your health find physio choose chartered ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('85', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('86', 'field', '59', 'en_gb', ' bmas ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('86', 'field', '60', 'en_gb', ' british medical acupuncture society ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('86', 'field', '61', 'en_gb', ' the british medical acupuncture society is a registered charity established to encourage the use and scientific understanding of acupuncture within medicine for the public benefit it seeks to enhance the education and training of suitably qualified practitioners and to promote high standards of working practices in acupuncture members are regulated healthcare professionals who practice acupuncture within the scope of their professional practice ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('86', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('87', 'field', '59', 'en_gb', ' hpc ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('87', 'field', '60', 'en_gb', ' health professionals council ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('87', 'field', '61', 'en_gb', ' the hcpc s role is to protect the public it does this by setting standards for registration as a health and care professional and keeping a register of individuals who meet these standards hcpc standards relate to registrants education professional knowledge and skills behaviour conduct performance and ethics and health the hcpc register is open to the public so that individuals and employers can check whether a physiotherapist or other health and care professional holds registration ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('87', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('88', 'field', '59', 'en_gb', ' physio first ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('88', 'field', '60', 'en_gb', ' physio first ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('88', 'field', '61', 'en_gb', ' physio first is the organisation which represents physiotherapists in private practice launched in 1952 to promote the highest standards of clinical physiotherapy practice physio first for the next 5 years is for championing evidence based cost effective private physiotherapy with physio first members in the changing healthcare marketplace this includes our desire to help the general public understand how physiotherapy can help them and to facilitate easy access to our highly skilled members ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('88', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('89', 'filename', '0', 'en_gb', ' bmas footer png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('89', 'extension', '0', 'en_gb', ' png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('89', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('89', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('89', 'title', '0', 'en_gb', ' bmas footer ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('90', 'filename', '0', 'en_gb', ' csp footer png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('90', 'extension', '0', 'en_gb', ' png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('90', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('90', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('90', 'title', '0', 'en_gb', ' csp footer ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('91', 'filename', '0', 'en_gb', ' hpc footer png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('91', 'extension', '0', 'en_gb', ' png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('91', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('91', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('91', 'title', '0', 'en_gb', ' hpc footer ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('92', 'filename', '0', 'en_gb', ' physio footer png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('92', 'extension', '0', 'en_gb', ' png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('92', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('92', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('92', 'title', '0', 'en_gb', ' physio footer ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('93', 'filename', '0', 'en_gb', ' physiofirst footer png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('93', 'extension', '0', 'en_gb', ' png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('93', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('93', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('93', 'title', '0', 'en_gb', ' physiofirst footer ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('85', 'field', '62', 'en_gb', ' csp footer ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('86', 'field', '62', 'en_gb', ' bmas footer ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('87', 'field', '62', 'en_gb', ' hpc footer ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('88', 'field', '62', 'en_gb', ' physiofirst footer ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('94', 'filename', '0', 'en_gb', ' bmas png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('94', 'extension', '0', 'en_gb', ' png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('94', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('94', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('94', 'title', '0', 'en_gb', ' bmas ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('95', 'filename', '0', 'en_gb', ' csp png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('95', 'extension', '0', 'en_gb', ' png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('95', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('95', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('95', 'title', '0', 'en_gb', ' csp ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('96', 'filename', '0', 'en_gb', ' hpc png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('96', 'extension', '0', 'en_gb', ' png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('96', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('96', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('96', 'title', '0', 'en_gb', ' hpc ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('97', 'filename', '0', 'en_gb', ' physio first png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('97', 'extension', '0', 'en_gb', ' png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('97', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('97', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('97', 'title', '0', 'en_gb', ' physio first ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('98', 'field', '59', 'en_gb', ' macp logo ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('98', 'field', '60', 'en_gb', ' musculoskeletal association of chartered physiotherapists ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('98', 'field', '61', 'en_gb', ' the musculoskeletal association of chartered physiotherapists macp is a group of over 1100 physiotherapists who are members of the chartered society of physiotherapy in addition to their undergraduate training they have all undertaken extensive postgraduate study and reached a recognised standard of excellence in neuromusculoskeletal physiotherapy their knowledge and practical skills ensures that all macp physiotherapists are able to provide an excellent standard of care in examination treatment and management for people with neuromusculoskeletal problems in the uk the macp is recognised as the specialist manipulative therapy group by the international federation of orthopaedic manipulative physical therapists ifompt to obtain membership of the macp clinicians have to complete a recognised postgraduate course of study many of which are at a master of science level the association has 1000 full members members who have passed a stringent examination process and almost 200 associate members members undertaking post graduate education leading to membership ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('98', 'field', '62', 'en_gb', ' macp logo reverse ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('98', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('57', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('57', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('57', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('57', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('57', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('99', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('99', 'field', '37', 'en_gb', ' ouch i ve hurt my back ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('99', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('99', 'field', '54', 'en_gb', ' getting the low down on what to do when you ve hurt your back ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('99', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('99', 'field', '36', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('99', 'field', '69', 'en_gb', ' references o sullivan p and lin i 2014 painmanagementtoday jan 1 1 mccullough bj johnson gr brook mi jarvik jg lumbar mr imaging and reporting epidemiology do epidemiologic data in reports affect clinical management radiology 2012 262 941 946 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('105', 'field', '67', 'en_gb', ' active rest ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('105', 'field', '68', 'en_gb', ' in the initial stages it is important that you have active rest this may mean modifying not necessarily stopping what you would normally do for the first few days of symptoms take painkillers change your position regularly and try to find positions which ease your symptoms it is generally safe to work and exercise with lbp you will not be doing further damage but again you may need to modify what you do slightly rather than kick boxing maybe try a gentle swim and sauna or treat yourself to a massage ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('99', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('99', 'field', '38', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('99', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('99', 'slug', '0', 'en_gb', ' ouch ive hurt my back ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('99', 'title', '0', 'en_gb', ' ouch i ve hurt my back ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('99', 'field', '63', 'en_gb', ' well the first thing to say is don t panic low back pain lbp is reported by 80% of people at some point during their life time and the majority of it gets better within 6 8 52 in fact only 1 2% of people presenting with lbp will have a serious or systemic disorder and 90% is considered non specific o sullivan and lin 2014 what have i done your back is one of the strongest structures in the body made up of 24 individual bones all with associated discs joints and ligaments and it is rare to do permanent damage to it often pain is associated with a sprain or strain of one of the structures in the back similar to that which occurs in a twisted ankle which can undoubtedly be very sore to move but it will get better as you gently exercise it it is also important to understand that back pain does not solely relate to tissue damage but represents tissues being sensitised which can occur secondary to awkward movements poor posture muscle tension inactivity lack of sleep stress worry and low mood o sullivan and lin 2014 do i need a scan the current nice guidance 2009 states that x rays should not be offered for non specific lbp and an mri should only be offered in very specific circumstances this is because there is a high prevalence of abnormal findings on mri in pain free populations and the fear associated with receiving a diagnosis can make pain worse a commonly reported diagnosis on an mri is disc degeneration which people can find very worrying however it should be noted that a study by mccullough et al 2012 found that 91% of pain free individuals studied also demonstrated these findings at cathedral physiotherapy we are passionate about not letting you become defined by your diagnosis and encouraging you back to full activity the best way to rationalise the above findings is to think of them as normal changes associated with ageing like getting grey hair should i see a doctor the majority of lbp can be managed without seeing your gp follow the advice in the grey box and see a physiotherapist if things haven t improving within the expected time frames or if you are struggling to stay in work or return to your sport it is worth seeing your gp if you are needing more effective pain relief but don t forget to use your local pharmacist for advice first because this is quick and easy to do having said this do see a doctor immediately if you are getting unremitting pain especially not linked to activity or at night changes in bladder or bowel control especially leakage or being unable to pass urine pins and needles or numbness in your saddle area between your legs numbness pins and needles or weakness in both legs or unsteadiness on your feet however these symptoms are very rare if you have any further questions or wish to have a session with our physiotherapist please don t hesitate to contact us at enquiries cathedralphysiotherapy co uk ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('99', 'field', '66', 'en_gb', ' active rest in the initial stages it is important that you have active rest this may mean modifying not necessarily stopping what you would normally do for the first few days of symptoms take painkillers change your position regularly and try to find positions which ease your symptoms it is generally safe to work and exercise with lbp you will not be doing further damage but again you may need to modify what you do slightly rather than kick boxing maybe try a gentle swim and sauna or treat yourself to a massage gentle exercises much of the pain felt can be caused by muscle spasm you can counter this by trying not to brace your trunk try to move freely elaxed breathing and gentle exercises initially try lying on your back or side with your knees bent to 90 degrees and gently rock your pelvis progress to gently bringing alternate knees to your chest or rolling both knees from one side to the other increasing physical activity once the first few days have passed you should find that your symptoms are improving a little at this stage it is important to gradually increase the levels of your activity in a graded way try sitting down for a little bit longer or walking a little bit further each day aim to increase your activity levels by about 10% a week what about returning to sport try to build up your exercise tolerance initially you may need to exercise for shorter periods of time several times a day aim to undertake 20 30 mins of aerobic exercise a day however this doesn t mean being straight back on the running track you might benefit from building up your aerobic fitness by walking cycling or swimming first the key is to make small achievable functional goals so that you don t become frustrated for instance if you want to return to cycling 1 hr a day but you can t even sit for 10 mins you might first want to make a goal of sitting for longer 20 min alongside trying walking or swimming to maintain your cardiovascular fitness then when you can achieve this try cycling on a static bike for 10 mins and build up at least then if you get into difficulties you can just climb off rather than having to walk miles home the most important thing is not to lose heart and stay positive your pain should improve ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('101', 'field', '64', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('101', 'field', '65', 'en_gb', ' well the first thing to say is don t panic low back pain lbp is reported by 80% of people at some point during their life time and the majority of it gets better within 6 8 52 in fact only 1 2% of people presenting with lbp will have a serious or systemic disorder and 90% is considered non specific o sullivan and lin 2014 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('101', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('102', 'field', '64', 'en_gb', ' what have i done ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('102', 'field', '65', 'en_gb', ' your back is one of the strongest structures in the body made up of 24 individual bones all with associated discs joints and ligaments and it is rare to do permanent damage to it often pain is associated with a sprain or strain of one of the structures in the back similar to that which occurs in a twisted ankle which can undoubtedly be very sore to move but it will get better as you gently exercise it it is also important to understand that back pain does not solely relate to tissue damage but represents tissues being sensitised which can occur secondary to awkward movements poor posture muscle tension inactivity lack of sleep stress worry and low mood o sullivan and lin 2014 ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('102', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('103', 'field', '64', 'en_gb', ' do i need a scan ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('103', 'field', '65', 'en_gb', ' the current nice guidance 2009 states that x rays should not be offered for non specific lbp and an mri should only be offered in very specific circumstances this is because there is a high prevalence of abnormal findings on mri in pain free populations and the fear associated with receiving a diagnosis can make pain worse a commonly reported diagnosis on an mri is disc degeneration which people can find very worrying however it should be noted that a study by mccullough et al 2012 found that 91% of pain free individuals studied also demonstrated these findings at cathedral physiotherapy we are passionate about not letting you become defined by your diagnosis and encouraging you back to full activity the best way to rationalise the above findings is to think of them as normal changes associated with ageing like getting grey hair ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('103', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('104', 'field', '64', 'en_gb', ' should i see a doctor ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('104', 'field', '65', 'en_gb', ' the majority of lbp can be managed without seeing your gp follow the advice in the grey box and see a physiotherapist if things haven t improving within the expected time frames or if you are struggling to stay in work or return to your sport it is worth seeing your gp if you are needing more effective pain relief but don t forget to use your local pharmacist for advice first because this is quick and easy to do having said this do see a doctor immediately if you are getting unremitting pain especially not linked to activity or at night changes in bladder or bowel control especially leakage or being unable to pass urine pins and needles or numbness in your saddle area between your legs numbness pins and needles or weakness in both legs or unsteadiness on your feet however these symptoms are very rare if you have any further questions or wish to have a session with our physiotherapist please don t hesitate to contact us at enquiries cathedralphysiotherapy co uk ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('104', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('105', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('106', 'field', '67', 'en_gb', ' gentle exercises ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('106', 'field', '68', 'en_gb', ' much of the pain felt can be caused by muscle spasm you can counter this by trying not to brace your trunk try to move freely elaxed breathing and gentle exercises initially try lying on your back or side with your knees bent to 90 degrees and gently rock your pelvis progress to gently bringing alternate knees to your chest or rolling both knees from one side to the other ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('106', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('107', 'field', '67', 'en_gb', ' increasing physical activity ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('107', 'field', '68', 'en_gb', ' once the first few days have passed you should find that your symptoms are improving a little at this stage it is important to gradually increase the levels of your activity in a graded way try sitting down for a little bit longer or walking a little bit further each day aim to increase your activity levels by about 10% a week ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('107', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('108', 'field', '67', 'en_gb', ' what about returning to sport ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('108', 'field', '68', 'en_gb', ' try to build up your exercise tolerance initially you may need to exercise for shorter periods of time several times a day aim to undertake 20 30 mins of aerobic exercise a day however this doesn t mean being straight back on the running track you might benefit from building up your aerobic fitness by walking cycling or swimming first the key is to make small achievable functional goals so that you don t become frustrated for instance if you want to return to cycling 1 hr a day but you can t even sit for 10 mins you might first want to make a goal of sitting for longer 20 min alongside trying walking or swimming to maintain your cardiovascular fitness then when you can achieve this try cycling on a static bike for 10 mins and build up at least then if you get into difficulties you can just climb off rather than having to walk miles home the most important thing is not to lose heart and stay positive your pain should improve ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('108', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('109', 'field', '37', 'en_gb', ' media comment november ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('109', 'field', '34', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('109', 'field', '32', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('109', 'field', '54', 'en_gb', ' as we look forward to christmas and ahead to 2016 we will inevitably get thinking about those dreaded new year resolutions why not take a longer term approach to your health rather than the boom and bust which often occurs as people go out to buy their new trainers in jan and then come across them under the woolly hats and gloves in the cupboard under the stairs whilst spring cleaning ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('109', 'field', '35', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('109', 'field', '36', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('109', 'field', '33', 'en_gb', ' index follow ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('109', 'field', '63', 'en_gb', ' this november an article was published in gerontology reported in the media http www dailymail co uk health article 3311222 how squats lunges walking mind young strong legs help brain resist effects ageing html http www bbc co uk news health 34764693 http www theguardian com uk news 2015 nov 09 strong legs healthier brain in old age which appears to suggest that physical activity and leg extensor power had statistically significant protective effects on age related cognition the study assessed 324 female twins in the uk over a period of 10 years and overall the twins that had stronger quadriceps front thigh muscle at the initial assessment had better cognition 10 years on there are clearly a number of questions that could be asked of the research including that of the chicken and egg effect is it because one of the twins had greater cognition that they were more active and therefore stayed stronger or is the strength of the muscles linked in some way to brain activity whether or not leg strength is linked to your brain power it is clear from much other research that exercise is good for your health in many other ways heart lungs blood pressure mental health bone strength the list goes on the key is to make it easy to fit into your lifestyle exercise on the way to or from work go cycling as a family play chase around the park with the kids cheap and fun the nhs choices website gives guidance on just how much exercise we should do at what stage in our lives and this is a useful starting point http www nhs uk livewell fitness pages physical activity guidelines for adults aspx however many people find that they have physical or psychological barriers to exercise because of a diagnosis they have previously been given or concern they have with regards to exacerbating previous injuries here at cathedral physiotherapy in exeter we are passionate that people should not allow their difficulties pain weakness loss of function previous diagnoses to define them as individuals and we work with clients in a friendly and positive way to facilitate them achieving their functional potential and goals go on give the family an exercise make over this year who knows you might be reaping the benefits on those crosswords in years to come ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('109', 'field', '66', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('109', 'field', '31', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('109', 'field', '69', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('109', 'field', '38', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('109', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('109', 'title', '0', 'en_gb', ' media comment november ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('110', 'field', '64', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('110', 'field', '65', 'en_gb', ' this november an article was published in gerontology reported in the media http www dailymail co uk health article 3311222 how squats lunges walking mind young strong legs help brain resist effects ageing html http www bbc co uk news health 34764693 http www theguardian com uk news 2015 nov 09 strong legs healthier brain in old age which appears to suggest that physical activity and leg extensor power had statistically significant protective effects on age related cognition the study assessed 324 female twins in the uk over a period of 10 years and overall the twins that had stronger quadriceps front thigh muscle at the initial assessment had better cognition 10 years on there are clearly a number of questions that could be asked of the research including that of the chicken and egg effect is it because one of the twins had greater cognition that they were more active and therefore stayed stronger or is the strength of the muscles linked in some way to brain activity whether or not leg strength is linked to your brain power it is clear from much other research that exercise is good for your health in many other ways heart lungs blood pressure mental health bone strength the list goes on the key is to make it easy to fit into your lifestyle exercise on the way to or from work go cycling as a family play chase around the park with the kids cheap and fun the nhs choices website gives guidance on just how much exercise we should do at what stage in our lives and this is a useful starting point http www nhs uk livewell fitness pages physical activity guidelines for adults aspx however many people find that they have physical or psychological barriers to exercise because of a diagnosis they have previously been given or concern they have with regards to exacerbating previous injuries here at cathedral physiotherapy in exeter we are passionate that people should not allow their difficulties pain weakness loss of function previous diagnoses to define them as individuals and we work with clients in a friendly and positive way to facilitate them achieving their functional potential and goals go on give the family an exercise make over this year who knows you might be reaping the benefits on those crosswords in years to come ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('110', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('111', 'field', '64', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('111', 'field', '65', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('111', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('73', 'field', '66', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('73', 'field', '69', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('72', 'field', '66', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('72', 'field', '69', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('114', 'field', '64', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('114', 'field', '65', 'en_gb', ' lorem ipsum dolor sit amet consectetur adipiscing elit morbi venenatis eros nunc at venenatis nibh gravida nec donec tincidunt lectus vel bibendum auctor aenean congue aliquam turpis ac scelerisque elit consequat ut fusce at metus congue mattis quam in eleifend metus sed ipsum ipsum ultricies vel sem nec ultricies fringilla purus fusce a tortor eget lorem dapibus placerat aenean ut arcu in lorem finibus sagittis suspendisse venenatis urna ut tempus finibus mauris dui malesuada lectus at mattis tortor lorem nec purus lorem ipsum dolor sit amet consectetur adipiscing elit morbi venenatis eros nunc at venenatis nibh gravida nec ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('72', 'field', '63', 'en_gb', ' lorem ipsum dolor sit amet consectetur adipiscing elit morbi venenatis eros nunc at venenatis nibh gravida nec donec tincidunt lectus vel bibendum auctor aenean congue aliquam turpis ac scelerisque elit consequat ut fusce at metus congue mattis quam in eleifend metus sed ipsum ipsum ultricies vel sem nec ultricies fringilla purus fusce a tortor eget lorem dapibus placerat aenean ut arcu in lorem finibus sagittis suspendisse venenatis urna ut tempus finibus mauris dui malesuada lectus at mattis tortor lorem nec purus lorem ipsum dolor sit amet consectetur adipiscing elit morbi venenatis eros nunc at venenatis nibh gravida nec ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('113', 'field', '64', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('113', 'field', '65', 'en_gb', ' agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro agfs jkfgre ijerijorg ijogriojf jgjifji giorin jigijorj goiriog ijgij jigjs csojprj jfopro ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('113', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('114', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('71', 'field', '66', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('71', 'field', '69', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('115', 'field', '64', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('115', 'field', '65', 'en_gb', ' our top tips on how to prevent tennis elbow sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium totam rem aperiam eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam est qui dolorem ipsum quia dolor sit amet consectetur adipisci velit sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem ut enim ad minima veniam quis nostrum exercitationem ullam corporis suscipit laboriosam nisi ut aliquid ex ea commodi consequatur quis autem vel eum iure reprehen ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('115', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('116', 'field', '64', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('116', 'field', '65', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('116', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('117', 'field', '67', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('117', 'field', '68', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('117', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('118', 'filename', '0', 'en_gb', ' wzgx_w9oublvaajgcka_uvwpwyl6hkg_jn0 gwjoui4pvdzbhtafo1l9eafkc8swhdbtdk2xjdqurdgk7sjl8a jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('118', 'extension', '0', 'en_gb', ' jpg ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('118', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('118', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('118', 'title', '0', 'en_gb', ' wzgx w9oublvaajgcka uvwpwyl6hkg jn0 gwjoui4pvdzbhtafo1l9eafkc8swhdbtdk2xjdqurdgk7sjl8a ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('119', 'filename', '0', 'en_gb', ' macp_logo_reverse png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('119', 'extension', '0', 'en_gb', ' png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('119', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('119', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('119', 'title', '0', 'en_gb', ' macp logo reverse ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('120', 'filename', '0', 'en_gb', ' macp_logo png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('120', 'extension', '0', 'en_gb', ' png ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('120', 'kind', '0', 'en_gb', ' image ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('120', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('120', 'title', '0', 'en_gb', ' macp logo ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('63', 'field', '70', 'en_gb', ' initial assessments take up to 60 mins depending on the condition and involve talking through your physical problems concerns aims of treatment and your personal functional goals a physical assessment is then undertaken looking at the parts of the body in question including areas that connect with it or can refer symptoms to it it is helpful to come prepared with a vest top t shirt and shorts as you will need to remove some items of clothing following the physical assessment you will have some form of treatment either advice and exercises or other adjuncts mobilisation manipulation taping electrotherapy as appropriate for your condition i work closely with you to ascertain what you want to achieve and we will develop a treatment plan together combining your aims my experience and the evidence base for that specific problem initial assessments follow up treatments take up to 30 mins and will involve a shortened re assessment to ascertain how you have progressed and if you have any concerns advice exercise including reviewing your home exercise plan and other forms of treatment as required follow up treatments if you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again or arrange a lift home as for some people it can make them drowsy acupuncture ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('121', 'field', '71', 'en_gb', ' initial assessments ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('121', 'field', '72', 'en_gb', ' initial assessments take up to 60 mins depending on the condition and involve talking through your physical problems concerns aims of treatment and your personal functional goals a physical assessment is then undertaken looking at the parts of the body in question including areas that connect with it or can refer symptoms to it it is helpful to come prepared with a vest top t shirt and shorts as you will need to remove some items of clothing following the physical assessment you will have some form of treatment either advice and exercises or other adjuncts mobilisation manipulation taping electrotherapy as appropriate for your condition i work closely with you to ascertain what you want to achieve and we will develop a treatment plan together combining your aims my experience and the evidence base for that specific problem ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('121', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('122', 'field', '71', 'en_gb', ' follow up treatments ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('122', 'field', '72', 'en_gb', ' follow up treatments take up to 30 mins and will involve a shortened re assessment to ascertain how you have progressed and if you have any concerns advice exercise including reviewing your home exercise plan and other forms of treatment as required ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('122', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('123', 'field', '71', 'en_gb', ' acupuncture ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('123', 'field', '72', 'en_gb', ' if you are attending for your first session of acupuncture then you will either need to wait a short time after receiving it before you drive again or arrange a lift home as for some people it can make them drowsy ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('123', 'slug', '0', 'en_gb', '');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('124', 'username', '0', 'en_gb', ' sarah moore ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('124', 'firstname', '0', 'en_gb', ' sarah ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('124', 'lastname', '0', 'en_gb', ' moore ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('124', 'fullname', '0', 'en_gb', ' sarah moore ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('124', 'email', '0', 'en_gb', ' sarah cathedralphysiotherapy co uk ');
INSERT INTO `craft_searchindex` (`elementId`, `attribute`, `fieldId`, `locale`, `keywords`) VALUES ('124', 'slug', '0', 'en_gb', '');



DROP TABLE IF EXISTS `craft_sections`;


--
-- Schema for table `craft_sections`
--
CREATE TABLE `craft_sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `structureId` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` enum('single','channel','structure') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'channel',
  `hasUrls` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `template` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `enableVersioning` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_sections_name_unq_idx` (`name`),
  UNIQUE KEY `craft_sections_handle_unq_idx` (`handle`),
  KEY `craft_sections_structureId_fk` (`structureId`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_sections`
--

INSERT INTO `craft_sections` (`id`, `structureId`, `name`, `handle`, `type`, `hasUrls`, `template`, `enableVersioning`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', NULL, 'Homepage', 'homepage', 'single', '1', 'index', '1', '2015-11-04 11:36:32', '2015-11-13 14:09:08', '007c540f-7197-427d-980f-69190b9e3cea');
INSERT INTO `craft_sections` (`id`, `structureId`, `name`, `handle`, `type`, `hasUrls`, `template`, `enableVersioning`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', NULL, 'News Articles', 'newsArticles', 'channel', '1', 'news/_entry', '1', '2015-11-04 11:36:32', '2015-11-13 14:40:47', '5ecef085-9035-46e6-a4f7-a129919d7929');
INSERT INTO `craft_sections` (`id`, `structureId`, `name`, `handle`, `type`, `hasUrls`, `template`, `enableVersioning`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', NULL, 'About', 'about', 'single', '1', 'about', '1', '2015-11-10 16:22:35', '2015-11-10 16:22:35', 'a0ee5abb-3913-414d-a520-24a5727e491a');
INSERT INTO `craft_sections` (`id`, `structureId`, `name`, `handle`, `type`, `hasUrls`, `template`, `enableVersioning`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', NULL, 'Accreditations', 'accreditations', 'single', '1', 'accreditations', '1', '2015-11-10 16:24:52', '2015-11-10 16:24:52', 'dde750b7-aeb9-4887-86d5-99ea82fb6e73');
INSERT INTO `craft_sections` (`id`, `structureId`, `name`, `handle`, `type`, `hasUrls`, `template`, `enableVersioning`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('8', NULL, 'Pricing', 'pricing', 'single', '1', 'pricing', '1', '2015-11-10 16:25:52', '2015-11-17 14:16:28', '752696bf-df53-4752-9230-6794417407f7');
INSERT INTO `craft_sections` (`id`, `structureId`, `name`, `handle`, `type`, `hasUrls`, `template`, `enableVersioning`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('9', NULL, 'Find Us', 'findUs', 'single', '1', 'find-us', '1', '2015-11-13 09:37:14', '2015-11-17 14:20:25', '2c8246cc-83d8-4f53-be1d-185bef02bd17');
INSERT INTO `craft_sections` (`id`, `structureId`, `name`, `handle`, `type`, `hasUrls`, `template`, `enableVersioning`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('10', NULL, 'Treatments', 'treatments', 'single', '1', 'treatments', '1', '2015-11-13 09:37:53', '2015-11-13 09:37:53', 'c9ef83ad-1c2e-4082-9a2c-47b1eeff727a');
INSERT INTO `craft_sections` (`id`, `structureId`, `name`, `handle`, `type`, `hasUrls`, `template`, `enableVersioning`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('11', '2', 'Treatments List', 'treatmentsList', 'structure', '0', NULL, '1', '2015-11-13 11:16:57', '2015-11-13 11:47:43', '7558212f-2bba-496c-b48b-89469ea8fb87');
INSERT INTO `craft_sections` (`id`, `structureId`, `name`, `handle`, `type`, `hasUrls`, `template`, `enableVersioning`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('12', NULL, 'News', 'news', 'single', '1', 'news', '1', '2015-11-13 14:41:24', '2015-11-13 14:41:24', 'bd74e021-0f30-4dcb-9589-6b1fafcb1615');
INSERT INTO `craft_sections` (`id`, `structureId`, `name`, `handle`, `type`, `hasUrls`, `template`, `enableVersioning`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('13', NULL, 'Testimonials', 'testimonials', 'single', '1', 'testimonials', '1', '2015-11-17 14:17:42', '2015-11-17 14:19:11', '67e36d79-7cdc-47dd-a9e9-077a494f14a6');
INSERT INTO `craft_sections` (`id`, `structureId`, `name`, `handle`, `type`, `hasUrls`, `template`, `enableVersioning`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('14', NULL, 'Work and Social', 'workAndSocial', 'single', '1', 'treatments/work-and-social', '1', '2015-11-17 16:40:59', '2015-11-23 10:25:46', '0e85456d-6570-4388-8d56-185a6e94ae69');
INSERT INTO `craft_sections` (`id`, `structureId`, `name`, `handle`, `type`, `hasUrls`, `template`, `enableVersioning`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('15', NULL, 'Young and Active', 'youngAndActive', 'single', '1', 'treatments/young-and-active', '1', '2015-11-17 16:41:18', '2015-11-23 10:26:03', '5769956e-f970-4fdb-97b8-528a80b1dc46');
INSERT INTO `craft_sections` (`id`, `structureId`, `name`, `handle`, `type`, `hasUrls`, `template`, `enableVersioning`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('16', NULL, 'Lifetime Support', 'lifetimeSupport', 'single', '1', 'treatments/lifetime-support', '1', '2015-11-17 16:41:32', '2015-11-23 10:26:14', 'f716f1f9-31bc-4536-ab52-dde46f42dad5');



DROP TABLE IF EXISTS `craft_sections_i18n`;


--
-- Schema for table `craft_sections_i18n`
--
CREATE TABLE `craft_sections_i18n` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sectionId` int(11) NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `enabledByDefault` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `urlFormat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nestedUrlFormat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_sections_i18n_sectionId_locale_unq_idx` (`sectionId`,`locale`),
  KEY `craft_sections_i18n_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_sections_i18n`
--

INSERT INTO `craft_sections_i18n` (`id`, `sectionId`, `locale`, `enabledByDefault`, `urlFormat`, `nestedUrlFormat`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', '1', 'en_gb', '0', '__home__', NULL, '2015-11-04 11:36:32', '2015-11-13 14:09:08', '19af0d10-bbfa-48f2-b765-f181b9ca717d');
INSERT INTO `craft_sections_i18n` (`id`, `sectionId`, `locale`, `enabledByDefault`, `urlFormat`, `nestedUrlFormat`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', '2', 'en_gb', '0', 'news/{postDate.year}/{slug}', NULL, '2015-11-04 11:36:32', '2015-11-13 14:40:47', 'a668d487-4065-4ce8-99fc-8bd4d6e1d473');
INSERT INTO `craft_sections_i18n` (`id`, `sectionId`, `locale`, `enabledByDefault`, `urlFormat`, `nestedUrlFormat`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', '3', 'en_gb', '0', 'about', NULL, '2015-11-10 16:22:35', '2015-11-10 16:22:35', '948314a4-c2be-41a3-8f10-3cead8e715e2');
INSERT INTO `craft_sections_i18n` (`id`, `sectionId`, `locale`, `enabledByDefault`, `urlFormat`, `nestedUrlFormat`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', '5', 'en_gb', '0', 'accreditations', NULL, '2015-11-10 16:24:52', '2015-11-10 16:24:52', '56c15ba9-2bb0-4f3f-96ac-5fd24afd53f7');
INSERT INTO `craft_sections_i18n` (`id`, `sectionId`, `locale`, `enabledByDefault`, `urlFormat`, `nestedUrlFormat`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('8', '8', 'en_gb', '0', 'pricing', NULL, '2015-11-10 16:25:52', '2015-11-17 14:07:49', '8fcf24be-1292-4486-9b64-c6496e6dfb20');
INSERT INTO `craft_sections_i18n` (`id`, `sectionId`, `locale`, `enabledByDefault`, `urlFormat`, `nestedUrlFormat`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('9', '9', 'en_gb', '0', 'find-us', NULL, '2015-11-13 09:37:14', '2015-11-13 09:37:14', '157b75fd-8122-447b-863e-7f98b64866e0');
INSERT INTO `craft_sections_i18n` (`id`, `sectionId`, `locale`, `enabledByDefault`, `urlFormat`, `nestedUrlFormat`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('10', '10', 'en_gb', '0', 'treatments', NULL, '2015-11-13 09:37:53', '2015-11-13 09:37:53', '13114878-6bdd-4158-bfbe-24b9b0b57c2b');
INSERT INTO `craft_sections_i18n` (`id`, `sectionId`, `locale`, `enabledByDefault`, `urlFormat`, `nestedUrlFormat`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('11', '11', 'en_gb', '0', NULL, NULL, '2015-11-13 11:16:57', '2015-11-13 11:47:43', '3276290c-a2e6-47c7-a50c-1b51c8eb4ee2');
INSERT INTO `craft_sections_i18n` (`id`, `sectionId`, `locale`, `enabledByDefault`, `urlFormat`, `nestedUrlFormat`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('12', '12', 'en_gb', '0', 'news', NULL, '2015-11-13 14:41:24', '2015-11-13 14:41:24', '416b52fe-fe5c-41c0-b671-99478e79cdb0');
INSERT INTO `craft_sections_i18n` (`id`, `sectionId`, `locale`, `enabledByDefault`, `urlFormat`, `nestedUrlFormat`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('13', '13', 'en_gb', '0', 'testimonials', NULL, '2015-11-17 14:17:42', '2015-11-17 14:17:42', '40395972-ca15-4107-b73d-6db48f3e5ad0');
INSERT INTO `craft_sections_i18n` (`id`, `sectionId`, `locale`, `enabledByDefault`, `urlFormat`, `nestedUrlFormat`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('14', '14', 'en_gb', '0', 'treatments/work-and-social', NULL, '2015-11-17 16:40:59', '2015-11-23 10:25:46', '15ea5b36-bb8c-4cca-bfc2-d59566d50710');
INSERT INTO `craft_sections_i18n` (`id`, `sectionId`, `locale`, `enabledByDefault`, `urlFormat`, `nestedUrlFormat`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('15', '15', 'en_gb', '0', 'treatments/young-and-active', NULL, '2015-11-17 16:41:18', '2015-11-23 10:26:03', '585e745f-2495-4014-8fa0-9d1fbb005a58');
INSERT INTO `craft_sections_i18n` (`id`, `sectionId`, `locale`, `enabledByDefault`, `urlFormat`, `nestedUrlFormat`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('16', '16', 'en_gb', '0', 'treatments/lifetime-support', NULL, '2015-11-17 16:41:32', '2015-11-23 10:26:14', 'be78d316-886e-45ce-8cdc-cd3c06391f9c');



DROP TABLE IF EXISTS `craft_sessions`;


--
-- Schema for table `craft_sessions`
--
CREATE TABLE `craft_sessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `token` char(100) COLLATE utf8_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_sessions_uid_idx` (`uid`),
  KEY `craft_sessions_token_idx` (`token`),
  KEY `craft_sessions_dateUpdated_idx` (`dateUpdated`),
  KEY `craft_sessions_userId_fk` (`userId`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_shunnedmessages`;


--
-- Schema for table `craft_shunnedmessages`
--
CREATE TABLE `craft_shunnedmessages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `message` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_shunnedmessages_userId_message_unq_idx` (`userId`,`message`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_structureelements`;


--
-- Schema for table `craft_structureelements`
--
CREATE TABLE `craft_structureelements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `structureId` int(11) NOT NULL,
  `elementId` int(11) DEFAULT NULL,
  `root` int(11) unsigned DEFAULT NULL,
  `lft` int(11) unsigned NOT NULL,
  `rgt` int(11) unsigned NOT NULL,
  `level` smallint(6) unsigned NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_structureelements_structureId_elementId_unq_idx` (`structureId`,`elementId`),
  KEY `craft_structureelements_root_idx` (`root`),
  KEY `craft_structureelements_lft_idx` (`lft`),
  KEY `craft_structureelements_rgt_idx` (`rgt`),
  KEY `craft_structureelements_level_idx` (`level`),
  KEY `craft_structureelements_elementId_fk` (`elementId`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_structureelements`
--

INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', '2', NULL, '5', '1', '50', '0', '2015-11-13 11:49:40', '2015-11-13 11:49:40', '46fe907e-75a8-469d-8578-e8ff92bc1ffd');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('6', '2', '14', '5', '8', '9', '1', '2015-11-13 11:49:40', '2015-11-13 11:49:40', '491711c4-bd53-4e96-ba3e-28a8b21f6bcc');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('7', '2', '15', '5', '6', '7', '1', '2015-11-13 11:50:05', '2015-11-13 11:50:05', 'db01e4e1-7bbd-4d4c-8b29-cdfd86f3b3ec');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('8', '2', '16', '5', '4', '5', '1', '2015-11-13 11:51:14', '2015-11-13 11:51:14', 'e0f9252c-50c9-4cb6-bbe6-901211a50403');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('9', '2', '17', '5', '2', '3', '1', '2015-11-13 11:51:34', '2015-11-13 11:51:34', '0a2c8b58-5652-45bb-ba58-4a9b598ab36d');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('10', '2', '18', '5', '10', '11', '1', '2015-11-13 11:51:51', '2015-11-13 11:51:51', 'ac920825-074c-486a-93ff-9a9dcf3f9634');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('11', '2', '19', '5', '12', '13', '1', '2015-11-13 11:53:14', '2015-11-13 11:53:14', '027ce5cd-6c2d-416a-95aa-2d1fa9ffce29');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('12', '2', '20', '5', '14', '15', '1', '2015-11-13 11:53:29', '2015-11-13 11:53:29', 'ecdb5f55-1fd7-47b5-936c-66cc7e960acd');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('13', '2', '21', '5', '16', '17', '1', '2015-11-13 11:53:48', '2015-11-13 11:53:48', 'e56df386-991e-4394-bd8f-9f2d0f451fdf');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('14', '2', '22', '5', '18', '19', '1', '2015-11-13 11:54:01', '2015-11-13 11:54:01', '3ebf3740-b824-4a48-88b9-dc79bfecc23e');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('15', '2', '23', '5', '20', '21', '1', '2015-11-13 11:54:15', '2015-11-13 11:54:15', 'a48166c2-0855-45c7-9d25-d4090b1cf977');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('16', '2', '24', '5', '22', '23', '1', '2015-11-13 11:54:33', '2015-11-13 11:54:33', '36862196-84f4-4690-84eb-4e463a37b245');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('17', '2', '25', '5', '24', '25', '1', '2015-11-13 11:55:27', '2015-11-13 11:55:27', '0d7ef027-1d56-4c94-9cbf-7e1a24ce4a86');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('18', '2', '26', '5', '26', '27', '1', '2015-11-13 11:55:43', '2015-11-13 11:55:43', 'c680e1b2-850d-4687-88df-bb0e22d2d118');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('19', '2', '27', '5', '28', '29', '1', '2015-11-13 11:55:55', '2015-11-13 11:55:55', 'e65d392e-c243-4864-954e-010137ade398');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('20', '2', '28', '5', '30', '31', '1', '2015-11-13 11:56:08', '2015-11-13 11:56:08', '9136357a-f8e4-4bd7-9889-14996ed0e16b');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('21', '2', '29', '5', '32', '33', '1', '2015-11-13 11:56:26', '2015-11-13 11:56:26', 'deed50dd-247f-4d91-aeb5-88f6f4e31a0b');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('22', '2', '30', '5', '34', '35', '1', '2015-11-13 11:56:42', '2015-11-13 11:56:42', '46de7cab-6fcb-42d9-ad24-fcf09336ea2b');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('23', '2', '31', '5', '36', '37', '1', '2015-11-13 11:56:55', '2015-11-13 11:56:55', '6184e5d7-9b59-4336-90e9-69ab35262222');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('24', '2', '32', '5', '38', '39', '1', '2015-11-13 11:57:11', '2015-11-13 11:57:11', '533b87bb-5695-4100-a133-3dc84322cded');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('25', '2', '33', '5', '40', '41', '1', '2015-11-13 11:57:28', '2015-11-13 11:57:28', 'ecb3cab5-8418-44e2-ae2d-17f038643970');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('26', '2', '34', '5', '42', '43', '1', '2015-11-13 11:57:39', '2015-11-13 11:57:39', '6476af7d-3b1c-4a3d-8ca0-99fc24b65e87');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('27', '2', '35', '5', '44', '45', '1', '2015-11-13 11:57:51', '2015-11-13 11:57:51', 'ff985612-488b-4da1-9aca-29747036af08');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('28', '2', '36', '5', '46', '47', '1', '2015-11-13 11:58:03', '2015-11-13 11:58:03', 'a5ebb83e-04ed-4874-8bb0-de71123d40bd');
INSERT INTO `craft_structureelements` (`id`, `structureId`, `elementId`, `root`, `lft`, `rgt`, `level`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('29', '2', '37', '5', '48', '49', '1', '2015-11-13 11:58:20', '2015-11-13 11:58:20', '7c935828-96d3-47e1-af43-30053279d79c');



DROP TABLE IF EXISTS `craft_structures`;


--
-- Schema for table `craft_structures`
--
CREATE TABLE `craft_structures` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `maxLevels` smallint(6) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_structures`
--

INSERT INTO `craft_structures` (`id`, `maxLevels`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', NULL, '2015-11-13 11:16:57', '2015-11-13 11:47:43', '486257a5-e504-4923-a606-2334b1c8840e');



DROP TABLE IF EXISTS `craft_systemsettings`;


--
-- Schema for table `craft_systemsettings`
--
CREATE TABLE `craft_systemsettings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `settings` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_systemsettings_category_unq_idx` (`category`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_systemsettings`
--

INSERT INTO `craft_systemsettings` (`id`, `category`, `settings`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', 'email', '{\"protocol\":\"php\",\"emailAddress\":\"jamesgrover@yellostudio.co.uk\",\"senderName\":\"Cathedral\"}', '2015-11-04 11:36:31', '2015-11-04 11:36:31', '67755068-8751-46c1-aaa1-7fa0af34fd73');



DROP TABLE IF EXISTS `craft_taggroups`;


--
-- Schema for table `craft_taggroups`
--
CREATE TABLE `craft_taggroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fieldLayoutId` int(10) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_taggroups_name_unq_idx` (`name`),
  UNIQUE KEY `craft_taggroups_handle_unq_idx` (`handle`),
  KEY `craft_taggroups_fieldLayoutId_fk` (`fieldLayoutId`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_taggroups`
--

INSERT INTO `craft_taggroups` (`id`, `name`, `handle`, `fieldLayoutId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', 'Default', 'default', '1', '2015-11-04 11:36:31', '2015-11-04 11:36:31', 'ca3eb158-e43a-4ec4-8248-a1462c29ef5d');



DROP TABLE IF EXISTS `craft_tags`;


--
-- Schema for table `craft_tags`
--
CREATE TABLE `craft_tags` (
  `id` int(11) NOT NULL,
  `groupId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_tags_groupId_fk` (`groupId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_tasks`;


--
-- Schema for table `craft_tasks`
--
CREATE TABLE `craft_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `root` int(11) unsigned DEFAULT NULL,
  `lft` int(11) unsigned NOT NULL,
  `rgt` int(11) unsigned NOT NULL,
  `level` smallint(6) unsigned NOT NULL,
  `currentStep` int(11) unsigned DEFAULT NULL,
  `totalSteps` int(11) unsigned DEFAULT NULL,
  `status` enum('pending','error','running') COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `settings` text COLLATE utf8_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_tasks_root_idx` (`root`),
  KEY `craft_tasks_lft_idx` (`lft`),
  KEY `craft_tasks_rgt_idx` (`rgt`),
  KEY `craft_tasks_level_idx` (`level`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_templatecachecriteria`;


--
-- Schema for table `craft_templatecachecriteria`
--
CREATE TABLE `craft_templatecachecriteria` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cacheId` int(11) NOT NULL,
  `type` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `criteria` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `craft_templatecachecriteria_cacheId_fk` (`cacheId`),
  KEY `craft_templatecachecriteria_type_idx` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_templatecacheelements`;


--
-- Schema for table `craft_templatecacheelements`
--
CREATE TABLE `craft_templatecacheelements` (
  `cacheId` int(11) NOT NULL,
  `elementId` int(11) NOT NULL,
  KEY `craft_templatecacheelements_cacheId_fk` (`cacheId`),
  KEY `craft_templatecacheelements_elementId_fk` (`elementId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_templatecaches`;


--
-- Schema for table `craft_templatecaches`
--
CREATE TABLE `craft_templatecaches` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cacheKey` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `locale` char(12) COLLATE utf8_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `expiryDate` datetime NOT NULL,
  `body` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `craft_templatecaches_expiryDate_cacheKey_locale_path_idx` (`expiryDate`,`cacheKey`,`locale`,`path`),
  KEY `craft_templatecaches_locale_fk` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_tokens`;


--
-- Schema for table `craft_tokens`
--
CREATE TABLE `craft_tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` char(32) COLLATE utf8_unicode_ci NOT NULL,
  `route` text COLLATE utf8_unicode_ci,
  `usageLimit` tinyint(3) unsigned DEFAULT NULL,
  `usageCount` tinyint(3) unsigned DEFAULT NULL,
  `expiryDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_tokens_token_unq_idx` (`token`),
  KEY `craft_tokens_expiryDate_idx` (`expiryDate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `craft_usergroups`;


--
-- Schema for table `craft_usergroups`
--
CREATE TABLE `craft_usergroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_usergroups`
--

INSERT INTO `craft_usergroups` (`id`, `name`, `handle`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', 'Cathedral Physiotherapy', 'cathedralPhysiotherapy', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '7f09a8ba-aeb0-4178-8a20-6209bbd8264d');



DROP TABLE IF EXISTS `craft_usergroups_users`;


--
-- Schema for table `craft_usergroups_users`
--
CREATE TABLE `craft_usergroups_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_usergroups_users_groupId_userId_unq_idx` (`groupId`,`userId`),
  KEY `craft_usergroups_users_userId_fk` (`userId`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_usergroups_users`
--

INSERT INTO `craft_usergroups_users` (`id`, `groupId`, `userId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', '1', '124', '2015-12-01 17:35:02', '2015-12-01 17:35:02', 'd58539d3-b6c1-4154-a1de-da0e4eee853b');



DROP TABLE IF EXISTS `craft_userpermissions`;


--
-- Schema for table `craft_userpermissions`
--
CREATE TABLE `craft_userpermissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_userpermissions_name_unq_idx` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_userpermissions`
--

INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', 'publishentries:3', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '3ff3fd5f-2ad5-418d-ab5c-d8707b0193f8');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', 'publishpeerentrydrafts:3', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'a802279b-1532-40af-b4d2-b3c21aba530e');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', 'deletepeerentrydrafts:3', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'ca8e7fd3-6ae0-47c1-8a66-c60c6fe77cdc');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', 'editpeerentrydrafts:3', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'ae5fa9db-5647-45bc-85c5-b56460ef6b2f');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', 'editentries:3', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'fa8684fc-fc54-4f44-89cb-6acadf4235d5');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('6', 'publishentries:5', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'b6076f91-4ce0-45d2-b8e9-dd4d415bff9b');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('7', 'publishpeerentrydrafts:5', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '323c6a1d-4fe5-4747-b29c-c85d1c38a0d2');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('8', 'deletepeerentrydrafts:5', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'cf04f05c-9edd-429e-92d3-624f1a53bec2');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('9', 'editpeerentrydrafts:5', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '84adae60-04d5-4fde-99c8-131e48ce130b');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('10', 'editentries:5', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '34b775fe-d19f-421e-b559-ce0bc9d18457');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('11', 'publishentries:9', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '51bed91e-df0f-4549-8d3d-eb97896701e2');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('12', 'publishpeerentrydrafts:9', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '42dd438a-87fc-46b0-a5f6-66407fb0a56e');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('13', 'deletepeerentrydrafts:9', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '2c00b938-209a-4963-b6ab-e23fc7330c94');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('14', 'editpeerentrydrafts:9', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '83e61756-580f-44d3-a24b-d8585d8139dd');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('15', 'editentries:9', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '1550393f-da20-49a2-aeac-c8eae117a31c');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('16', 'publishentries:1', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'f532ea8c-a592-4604-921b-09dda482d052');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('17', 'publishpeerentrydrafts:1', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '1fce6adc-4126-49fa-9772-7063ec590422');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('18', 'deletepeerentrydrafts:1', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'e025631d-6a1c-439b-bce9-c6124fd35bef');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('19', 'editpeerentrydrafts:1', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '8256af9a-7cf2-4a6e-9b5a-4847dcd9890d');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('20', 'editentries:1', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '332f4dc7-91b4-43b9-88f3-d130c7925866');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('21', 'publishentries:16', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'fd22dc26-b418-41a7-bdc8-9b7ff17f3a7d');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('22', 'publishpeerentrydrafts:16', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'a652c1e4-3acb-418b-a4f2-69056609726c');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('23', 'deletepeerentrydrafts:16', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '655bf044-0d29-4754-8fa0-dafb506d35c4');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('24', 'editpeerentrydrafts:16', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '5bd9e6a2-e854-41e1-99f7-2de1025ed36f');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('25', 'editentries:16', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '25bd06ae-b3aa-4e19-b1fb-ff201fff59d7');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('26', 'publishentries:12', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'ce60fd66-e682-4f2e-9c84-781a36b802c2');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('27', 'publishpeerentrydrafts:12', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '06b6f26c-ba7f-4f80-a49e-58b4470ae6b9');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('28', 'deletepeerentrydrafts:12', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '0701da6b-64e1-4851-8d61-a7ed2d5922fd');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('29', 'editpeerentrydrafts:12', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '644579ba-c988-49bf-993e-56cca565ccee');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('30', 'editentries:12', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'afeb1f78-ba10-4ed3-a739-718fb3d87936');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('31', 'createentries:2', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '251a94ce-1749-4f6d-a7df-385ae3d676ed');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('32', 'publishentries:2', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '0f54e405-dc46-4f62-8530-b47bcacb6f58');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('33', 'deleteentries:2', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'd4761007-fc15-4fa7-b669-30450e2eff0b');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('34', 'publishpeerentries:2', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '36aa32c7-fcb1-499e-a13e-bf2c9c36e839');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('35', 'deletepeerentries:2', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '8177d713-2248-4286-9270-5104d2b74710');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('36', 'editpeerentries:2', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '40bf693e-f40d-4057-ae06-2c933e4d0642');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('37', 'publishpeerentrydrafts:2', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'c9063131-e898-49cd-9c67-9fe028536b0f');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('38', 'deletepeerentrydrafts:2', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'd621e475-537a-4944-8969-d8cb7830e1cd');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('39', 'editpeerentrydrafts:2', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'a0fe23bc-4deb-4149-9aaf-c3eff5640275');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('40', 'editentries:2', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '16ecf12f-e8ec-4aea-8614-ee82018fb797');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('41', 'publishentries:8', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '170f5c04-3409-42e1-bd76-1bd4083f6fbf');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('42', 'publishpeerentrydrafts:8', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'a7eeb152-3284-4881-9470-646bb1208f6c');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('43', 'deletepeerentrydrafts:8', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'a0b7163b-a078-4897-9ed5-5e8fcb886757');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('44', 'editpeerentrydrafts:8', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '894098e9-2126-4b3a-80f0-ce533b2f75ca');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('45', 'editentries:8', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '710ff0c5-40f3-4434-a872-3965ac92bb09');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('46', 'publishentries:13', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'bef2b93e-ab3c-4072-8b0a-7ffe02f0b0f1');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('47', 'publishpeerentrydrafts:13', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '90e53d40-0f2f-4b46-bf15-bd3de441c24e');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('48', 'deletepeerentrydrafts:13', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '531cb0fe-597e-43a7-9ee3-3c134217522b');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('49', 'editpeerentrydrafts:13', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '998182c3-d776-4267-ab5e-f7c9f70c3e5b');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('50', 'editentries:13', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '104e0eee-65e2-4116-a36d-e2934e316c06');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('51', 'publishentries:10', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '45ef75d8-8d20-420a-b0a2-d81fc5f0ca28');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('52', 'publishpeerentrydrafts:10', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '5e3cf54c-1ea9-4a70-8024-ec3f61f6f7a6');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('53', 'deletepeerentrydrafts:10', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'd0caff7c-d2f6-4d8f-87b9-2efbf30ca969');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('54', 'editpeerentrydrafts:10', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '0cb2d702-aa57-45b4-8aad-ca8d38751036');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('55', 'editentries:10', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'cce4fa1d-b266-4d20-aaf2-28e4fd8e6315');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('56', 'createentries:11', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'b6a8e36f-da4e-4acf-bbc7-edef88f5845b');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('57', 'publishentries:11', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'b353bec9-a86c-4804-b310-b3afda812784');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('58', 'deleteentries:11', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '207b1d72-4f89-43ef-b67e-25954b2a61b7');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('59', 'publishpeerentries:11', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'e6b89013-cba0-422d-a0c3-a2d2ea98e82f');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('60', 'deletepeerentries:11', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '32b87252-8316-4d1b-9f01-e499e779594c');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('61', 'editpeerentries:11', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '4c98adb9-2f64-4062-98c7-dbc103a16bf2');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('62', 'publishpeerentrydrafts:11', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '6dcc2b04-932e-4b93-b319-448282b9162d');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('63', 'deletepeerentrydrafts:11', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '59669a17-0c3b-45db-97f4-2adeecd6be75');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('64', 'editpeerentrydrafts:11', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '2e8b185f-4e66-48f7-a577-51c279fcd841');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('65', 'editentries:11', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '4aa13ed3-4738-40fb-acf1-f0ef61f63620');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('66', 'publishentries:14', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '7c437a0c-69df-4201-a489-ac5727b9a3aa');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('67', 'publishpeerentrydrafts:14', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '40d4fe31-1e95-4b5b-aeb0-41c3bebf0892');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('68', 'deletepeerentrydrafts:14', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '9f94325f-1d2d-447f-a3a2-f95d2c8012aa');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('69', 'editpeerentrydrafts:14', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '54803111-2c59-4159-ba11-c68e64da62be');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('70', 'editentries:14', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'd6e4a6b0-b993-463b-9096-96c8a655a29c');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('71', 'publishentries:15', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '8b8d4675-e97a-404f-9edb-9174ee7ac8f0');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('72', 'publishpeerentrydrafts:15', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '9cd14dc3-1a8d-4e0c-8145-01289912936c');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('73', 'deletepeerentrydrafts:15', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'bf95a044-6b8a-4d45-b169-8093a61e259c');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('74', 'editpeerentrydrafts:15', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'cec53d3f-4607-4274-826d-621cde3989ae');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('75', 'editentries:15', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '01ef8732-3839-40f6-a4d9-84b128177a40');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('76', 'editglobalset:7', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'dd8365db-1e73-4e5c-8826-3d1133a500b9');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('77', 'editglobalset:43', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '1796675c-0ff8-49c7-9a8a-4009ea5cbc54');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('78', 'uploadtoassetsource:1', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '9baf1920-a660-4cea-874b-36ac63431ef9');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('79', 'createsubfoldersinassetsource:1', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '4022adba-9cc3-4f90-ac63-2cbe89f797a0');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('80', 'removefromassetsource:1', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'fd78008c-0e7a-4480-a9cc-620a4675d80b');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('81', 'viewassetsource:1', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '0910d0be-e7aa-4904-822d-fa15e15b8949');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('82', 'uploadtoassetsource:2', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '5a80d94c-bc2c-43db-97a9-0b3cbc8b2065');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('83', 'createsubfoldersinassetsource:2', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '6f4cd2e9-f910-45f1-8768-bdb4b4fbc91c');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('84', 'removefromassetsource:2', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'b1356beb-cf38-45d5-bd23-4136f0fbdc92');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('85', 'viewassetsource:2', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'ed3fc778-0b5c-4996-a313-b490ffbd7e87');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('86', 'uploadtoassetsource:3', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'e2acdbb0-eebb-4def-bb0e-ae14e819616b');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('87', 'createsubfoldersinassetsource:3', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'aed0b0d8-52e1-4f29-8222-7cfc947cabd8');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('88', 'removefromassetsource:3', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '812f1a86-7278-4269-b8b2-1ca649052443');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('89', 'viewassetsource:3', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '1f9736c1-ce7a-499a-af6f-e44166345fd7');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('90', 'uploadtoassetsource:4', '2015-11-25 15:17:34', '2015-11-25 15:17:34', 'c475503a-3586-4431-bfc4-f04f0f416b0a');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('91', 'createsubfoldersinassetsource:4', '2015-11-25 15:17:34', '2015-11-25 15:17:34', '1e3115a0-72ed-4a62-9749-8688144ddacf');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('92', 'removefromassetsource:4', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '5a767223-c25b-485a-bf0a-2abb09f0bf19');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('93', 'viewassetsource:4', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '39bf266d-4cb0-4163-bdbb-c1d3f9432bd2');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('94', 'registerusers', '2015-12-01 17:25:21', '2015-12-01 17:25:21', '8edd1591-70a9-4c6b-858d-be5a4b5d4b8e');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('95', 'assignuserpermissions', '2015-12-01 17:25:21', '2015-12-01 17:25:21', '6d8559eb-88c0-45f8-b62d-aa566bf8ca3b');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('96', 'changeuseremails', '2015-12-01 17:25:21', '2015-12-01 17:25:21', 'f8db8692-419a-4204-b0d3-2f466f8bb887');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('97', 'administrateusers', '2015-12-01 17:25:21', '2015-12-01 17:25:21', '77176647-21a8-4c9e-acb2-5828704ea592');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('98', 'editusers', '2015-12-01 17:25:21', '2015-12-01 17:25:21', '30a50c47-c653-4d3a-8269-fc32b4b6039c');
INSERT INTO `craft_userpermissions` (`id`, `name`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('99', 'deleteusers', '2015-12-01 17:25:21', '2015-12-01 17:25:21', '4ea23be2-fe04-4257-8ac4-189b761c40ee');



DROP TABLE IF EXISTS `craft_userpermissions_usergroups`;


--
-- Schema for table `craft_userpermissions_usergroups`
--
CREATE TABLE `craft_userpermissions_usergroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permissionId` int(11) NOT NULL,
  `groupId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_userpermissions_usergroups_permissionId_groupId_unq_idx` (`permissionId`,`groupId`),
  KEY `craft_userpermissions_usergroups_groupId_fk` (`groupId`)
) ENGINE=InnoDB AUTO_INCREMENT=94 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_userpermissions_usergroups`
--

INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', '1', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'a4e4c25a-b04b-460d-8cff-bdcfa59abc21');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', '2', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '355704db-308a-4d88-91bd-a596576aa826');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', '3', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '9b256b4f-ec4b-448a-8922-ad517be41c9f');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', '4', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '8ee01a8f-4fce-401e-bd65-c5ba877801d2');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('5', '5', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '1c8f672c-7648-4141-a14f-098970bff4b4');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('6', '6', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'a79d6f23-5040-4e1b-b06c-6f8fb400de1d');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('7', '7', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '52e8fc22-88e2-4fb5-9d98-68b42678ad97');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('8', '8', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '8b7df38c-b513-4bc7-81f7-9098c8b8843f');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('9', '9', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '6ac5a783-8bbe-4782-a0fb-42bc4c784930');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('10', '10', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'e378a76e-2c61-4e0c-840d-a3340f43d86f');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('11', '11', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'dde9c03a-04db-492a-b411-2cddd1b0b4f8');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('12', '12', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'd56de57e-efb7-421d-9e89-5dd2c2f36b2a');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('13', '13', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '1922f13d-5f67-4691-b069-6d40092ffee2');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('14', '14', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '05175b6e-619c-4f33-8c10-acb84a72493f');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('15', '15', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '44dec9d2-6c96-42c5-9f93-6dbc872acc3b');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('16', '16', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'ac43e060-e42f-4bb3-a1d4-c7ead6041ecc');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('17', '17', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '1ad68e3e-cea7-419e-81a1-7a65779893ae');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('18', '18', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'b3523f4f-54f8-4118-a931-34f21ddc6350');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('19', '19', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '33cdf959-84f4-4e75-b666-d3f927a1f14c');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('20', '20', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '62b2bc62-d900-4025-ada7-1f52538bdec6');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('21', '21', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '3d1a6d93-bda8-4821-a92a-f38ad6e2f7fe');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('22', '22', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '107f392f-b3af-4440-815a-bd7a4b684e71');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('23', '23', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'f51f76f8-9253-4f10-9c00-4b457db8ee09');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('24', '24', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'b7b9f5ba-fe3a-46c7-af09-8720cf9fe8a0');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('25', '25', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'f99cc74e-e0a0-4a4f-91cd-993e00ec3967');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('26', '26', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'f215c21a-0873-4235-a939-3690da750387');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('27', '27', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'eece0a6e-1bab-4f28-a5cb-48d0e2cacfa0');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('28', '28', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '6ac9ca11-a81c-49b5-808e-4b6a514d0f02');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('29', '29', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'be146eef-0a5a-4b11-a92f-2155aa4df7c9');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('30', '30', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'a0d626ff-648b-4158-9f25-e330af124384');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('31', '31', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '4382481a-8774-4be0-91e1-205664eb8d93');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('32', '32', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '88f5af18-52a0-4a1b-9649-94a3cd857d9b');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('33', '33', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '671ad494-6ac2-42e9-a961-c286706d2a10');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('34', '34', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'eefce039-8ab9-414f-bfed-7326a2353ef6');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('35', '35', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '14f1e180-6dd2-437c-beeb-2b8acce31b8f');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('36', '36', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '281fb2f1-04cd-4e9a-80c2-a62a8b4fb044');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('37', '37', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '7b43747c-64b7-4026-a3a8-a1e299f326c9');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('38', '38', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'fb811040-a1ce-4cc4-a287-afbd9fe6f779');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('39', '39', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'b009ca75-e506-4c85-a614-01e978575f79');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('40', '40', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '6d78d75b-98c5-4f63-a812-eba957368513');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('41', '41', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'c6f14d8f-e098-4792-a70c-d2f2fd5f9a76');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('42', '42', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '6e6988ab-b17c-436c-96bb-8fd7bf90366c');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('43', '43', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'caaeb5db-7eee-4709-b499-f30cc5d9ada8');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('44', '44', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '4661299d-8587-4907-bb42-951a122ba9c7');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('45', '45', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '53f5c4f0-f152-4418-8ddf-7402f504185b');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('46', '46', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '7cc978f6-2f9e-4ead-9474-6b9c4a14c079');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('47', '47', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '0da5df86-8db0-45e7-a2ad-619538451cc8');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('48', '48', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '090a4198-3534-43cd-b9e4-314e28b24e84');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('49', '49', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'e80a10f1-f9c0-495b-8e89-17018fe4325b');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('50', '50', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '24b6863c-d25e-4ae7-a655-85cff4c7e556');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('51', '51', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '3d0bcd8c-fb49-4b2d-829f-bf9f1557d033');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('52', '52', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '4a467c0f-5474-4c98-84d7-199b2f55cfc6');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('53', '53', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '50a41cca-29ff-44a8-9db3-d1ce781affda');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('54', '54', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'cc7228d7-54a1-4e14-89d5-ecc73336d4a3');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('55', '55', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'c62324bf-7f63-485e-98a1-0f214ddad93c');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('56', '56', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '273259c2-f48e-4faf-bd20-1911f3b71de8');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('57', '57', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'a099c769-b94a-41b5-a4c2-1afe2ea4e283');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('58', '58', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'fffda4a0-2965-4fb0-b916-1d09079aab55');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('59', '59', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'b81644cf-b61a-450d-a1b7-28035b061397');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('60', '60', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'e33d651d-f002-4513-8b2b-8d781559747e');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('61', '61', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'cb2d68e3-a9d0-4d49-a604-340b7441a17a');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('62', '62', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '7f53ccd1-16ec-4108-ad73-0fa815225286');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('63', '63', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'd7c6ca82-6193-44d5-99b9-509e54732007');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('64', '64', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '0c9dc701-b01f-4d5c-b8e3-bc99e57168a2');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('65', '65', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '87dc4f7f-6daf-4c76-b7fd-ba2c81901d02');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('66', '66', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'b9023b9a-6557-458e-805e-011ebc97205d');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('67', '67', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '894518fc-ed8a-423a-9787-558b23e2f473');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('68', '68', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '0a51b902-0158-4d67-b0b4-4e90937f5a5b');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('69', '69', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '6f7c1c69-fe59-48bd-9b48-885acd1ad6a2');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('70', '70', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'd1d73b40-a9f9-48fa-920b-676eeb86281f');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('71', '71', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'c3d9c3a0-0564-4439-884a-e31af471c312');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('72', '72', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '4fb6c73c-5bb7-4e2e-9461-9a36bc760bcc');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('73', '73', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '86e38511-703c-481a-b2bd-89ee6e1944ea');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('74', '74', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'd074d2df-6513-4d91-8e08-2b767a450d03');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('75', '75', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'bc4b2fe0-ebf3-4628-84bc-f0a3e77bde40');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('76', '76', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'b581cfc1-3c12-4787-a70d-83256d457193');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('77', '77', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'f35a3e83-b174-4c38-a366-3993a9bd471c');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('78', '78', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '91d4b577-7715-49fd-971a-6602f816a06d');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('79', '79', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'c3fce1f0-7c71-43ef-af37-6a5f54196b7c');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('80', '80', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '6c8f7fd7-ebba-46ab-8077-e235b8719761');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('81', '81', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'd79b7557-41c2-4474-8e56-0dea124e56d3');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('82', '82', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '7c45b7ef-d28d-4826-be2f-abcdbc5bcd26');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('83', '83', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '6d9ff817-196b-465d-b765-d72e889f90bc');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('84', '84', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '9a373403-7f4e-4062-8a93-f7e4cff55955');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('85', '85', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'c19957e8-9ae9-4230-98ef-86acf4fb3912');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('86', '86', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '2582dd9d-ba1f-4841-b07c-3ca84d66e4c0');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('87', '87', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'e573f42f-c9a7-4e89-b734-3ebefe8be1a5');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('88', '88', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'f5e7bb9f-fa31-47ab-9d5a-f360091a4670');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('89', '89', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'c4519146-6163-494b-af26-44c7aaef8485');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('90', '90', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'bf3d14b0-3f1c-47ed-9f26-06fb418001fb');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('91', '91', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', '5dcb57fc-a8c1-42c2-83b5-e8e14449f0b6');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('92', '92', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'b56c58fc-f022-4790-85f8-63781c6efa87');
INSERT INTO `craft_userpermissions_usergroups` (`id`, `permissionId`, `groupId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('93', '93', '1', '2015-11-25 15:17:35', '2015-11-25 15:17:35', 'fb03ba54-8e70-481f-b745-34bb1d724a8e');



DROP TABLE IF EXISTS `craft_userpermissions_users`;


--
-- Schema for table `craft_userpermissions_users`
--
CREATE TABLE `craft_userpermissions_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permissionId` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_userpermissions_users_permissionId_userId_unq_idx` (`permissionId`,`userId`),
  KEY `craft_userpermissions_users_userId_fk` (`userId`)
) ENGINE=InnoDB AUTO_INCREMENT=112 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_userpermissions_users`
--

INSERT INTO `craft_userpermissions_users` (`id`, `permissionId`, `userId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('106', '94', '124', '2015-12-01 17:35:02', '2015-12-01 17:35:02', '189ad744-7e08-42ff-9560-90601172ef6b');
INSERT INTO `craft_userpermissions_users` (`id`, `permissionId`, `userId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('107', '95', '124', '2015-12-01 17:35:02', '2015-12-01 17:35:02', 'e62c327c-97be-4902-ab00-e783ab1a2d67');
INSERT INTO `craft_userpermissions_users` (`id`, `permissionId`, `userId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('108', '96', '124', '2015-12-01 17:35:02', '2015-12-01 17:35:02', '87d6edff-f82c-4cb6-8f5f-6424226a46f2');
INSERT INTO `craft_userpermissions_users` (`id`, `permissionId`, `userId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('109', '97', '124', '2015-12-01 17:35:02', '2015-12-01 17:35:02', '814fb900-6f71-468c-a18d-f830355be253');
INSERT INTO `craft_userpermissions_users` (`id`, `permissionId`, `userId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('110', '98', '124', '2015-12-01 17:35:02', '2015-12-01 17:35:02', '4cc79322-d916-49b9-b004-243ae445d379');
INSERT INTO `craft_userpermissions_users` (`id`, `permissionId`, `userId`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('111', '99', '124', '2015-12-01 17:35:02', '2015-12-01 17:35:02', '4a7717cc-9d55-4484-9096-924e25e797be');



DROP TABLE IF EXISTS `craft_users`;


--
-- Schema for table `craft_users`
--
CREATE TABLE `craft_users` (
  `id` int(11) NOT NULL,
  `username` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `photo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `firstName` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lastName` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `password` char(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `preferredLocale` char(12) COLLATE utf8_unicode_ci DEFAULT NULL,
  `weekStartDay` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `admin` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `client` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `suspended` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `pending` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `archived` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `lastLoginDate` datetime DEFAULT NULL,
  `lastLoginAttemptIPAddress` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `invalidLoginWindowStart` datetime DEFAULT NULL,
  `invalidLoginCount` tinyint(4) unsigned DEFAULT NULL,
  `lastInvalidLoginDate` datetime DEFAULT NULL,
  `lockoutDate` datetime DEFAULT NULL,
  `verificationCode` char(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `verificationCodeIssuedDate` datetime DEFAULT NULL,
  `unverifiedEmail` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `passwordResetRequired` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `lastPasswordChangeDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `craft_users_username_unq_idx` (`username`),
  UNIQUE KEY `craft_users_email_unq_idx` (`email`),
  KEY `craft_users_verificationCode_idx` (`verificationCode`),
  KEY `craft_users_uid_idx` (`uid`),
  KEY `craft_users_preferredLocale_fk` (`preferredLocale`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_users`
--

INSERT INTO `craft_users` (`id`, `username`, `photo`, `firstName`, `lastName`, `email`, `password`, `preferredLocale`, `weekStartDay`, `admin`, `client`, `locked`, `suspended`, `pending`, `archived`, `lastLoginDate`, `lastLoginAttemptIPAddress`, `invalidLoginWindowStart`, `invalidLoginCount`, `lastInvalidLoginDate`, `lockoutDate`, `verificationCode`, `verificationCodeIssuedDate`, `unverifiedEmail`, `passwordResetRequired`, `lastPasswordChangeDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', 'yello', NULL, NULL, NULL, 'jamesgrover@yellostudio.co.uk', '$2y$13$X1H0w7YBKIQ08KimBAurfeQtQuiz9kZE4nAeciz.jfse6M1HXjVgy', NULL, '0', '1', '0', '0', '0', '0', '0', '2015-12-02 08:56:58', '81.133.86.182', NULL, NULL, '2015-12-01 23:09:05', NULL, NULL, NULL, NULL, '0', '2015-11-04 11:36:29', '2015-11-04 11:36:29', '2015-12-02 08:56:58', '6e825616-63fe-4d60-b28e-6265fa50060d');
INSERT INTO `craft_users` (`id`, `username`, `photo`, `firstName`, `lastName`, `email`, `password`, `preferredLocale`, `weekStartDay`, `admin`, `client`, `locked`, `suspended`, `pending`, `archived`, `lastLoginDate`, `lastLoginAttemptIPAddress`, `invalidLoginWindowStart`, `invalidLoginCount`, `lastInvalidLoginDate`, `lockoutDate`, `verificationCode`, `verificationCodeIssuedDate`, `unverifiedEmail`, `passwordResetRequired`, `lastPasswordChangeDate`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('124', 'sarah-moore', NULL, 'Sarah', 'Moore', 'sarah@cathedralphhysiotherapy.co.uk', '$2y$13$U0AY29M6kcorWCk91IVfzuKmaiuV.uTHjODC8odNqJ.h7PK8D4uMq', NULL, '0', '0', '0', '0', '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', '2015-12-01 23:00:30', '2015-12-01 17:25:21', '2015-12-01 23:12:05', '33e9725d-4c4b-4d53-9c28-fff2bf3bec43');



DROP TABLE IF EXISTS `craft_widgets`;


--
-- Schema for table `craft_widgets`
--
CREATE TABLE `craft_widgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `type` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `sortOrder` tinyint(4) DEFAULT NULL,
  `settings` text COLLATE utf8_unicode_ci,
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `craft_widgets_userId_fk` (`userId`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Data for table `craft_widgets`
--

INSERT INTO `craft_widgets` (`id`, `userId`, `type`, `sortOrder`, `settings`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('1', '1', 'RecentEntries', '1', NULL, '1', '2015-11-04 11:36:36', '2015-11-04 11:36:36', '26560a96-da2b-4828-8132-e53106799ed3');
INSERT INTO `craft_widgets` (`id`, `userId`, `type`, `sortOrder`, `settings`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('2', '1', 'GetHelp', '2', NULL, '1', '2015-11-04 11:36:36', '2015-11-04 11:36:36', '82aa0798-b2ef-4e1f-ac82-251c53e98ec4');
INSERT INTO `craft_widgets` (`id`, `userId`, `type`, `sortOrder`, `settings`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('3', '1', 'Updates', '3', NULL, '1', '2015-11-04 11:36:36', '2015-11-04 11:36:36', 'f34ce2ff-1946-45b3-8291-ec424b68364b');
INSERT INTO `craft_widgets` (`id`, `userId`, `type`, `sortOrder`, `settings`, `enabled`, `dateCreated`, `dateUpdated`, `uid`) VALUES ('4', '1', 'Feed', '4', '{\"url\":\"http:\\/\\/feeds.feedburner.com\\/blogandtonic\",\"title\":\"Blog & Tonic\"}', '1', '2015-11-04 11:36:36', '2015-11-04 11:36:36', '735bf54f-c75a-4069-a829-d04dbd5c810f');


--
-- Constraints for tables
--


--
-- Constraints for table `craft_assetfiles`
--
ALTER TABLE `craft_assetfiles`
	ADD CONSTRAINT `craft_assetfiles_folderId_fk` FOREIGN KEY (`folderId`) REFERENCES `craft_assetfolders` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_assetfiles_id_fk` FOREIGN KEY (`id`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_assetfiles_sourceId_fk` FOREIGN KEY (`sourceId`) REFERENCES `craft_assetsources` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_assetfolders`
--
ALTER TABLE `craft_assetfolders`
	ADD CONSTRAINT `craft_assetfolders_parentId_fk` FOREIGN KEY (`parentId`) REFERENCES `craft_assetfolders` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_assetfolders_sourceId_fk` FOREIGN KEY (`sourceId`) REFERENCES `craft_assetsources` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_assetindexdata`
--
ALTER TABLE `craft_assetindexdata`
	ADD CONSTRAINT `craft_assetindexdata_sourceId_fk` FOREIGN KEY (`sourceId`) REFERENCES `craft_assetsources` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_assetsources`
--
ALTER TABLE `craft_assetsources`
	ADD CONSTRAINT `craft_assetsources_fieldLayoutId_fk` FOREIGN KEY (`fieldLayoutId`) REFERENCES `craft_fieldlayouts` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `craft_categories`
--
ALTER TABLE `craft_categories`
	ADD CONSTRAINT `craft_categories_groupId_fk` FOREIGN KEY (`groupId`) REFERENCES `craft_categorygroups` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_categories_id_fk` FOREIGN KEY (`id`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_categorygroups`
--
ALTER TABLE `craft_categorygroups`
	ADD CONSTRAINT `craft_categorygroups_fieldLayoutId_fk` FOREIGN KEY (`fieldLayoutId`) REFERENCES `craft_fieldlayouts` (`id`) ON DELETE SET NULL,
	ADD CONSTRAINT `craft_categorygroups_structureId_fk` FOREIGN KEY (`structureId`) REFERENCES `craft_structures` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_categorygroups_i18n`
--
ALTER TABLE `craft_categorygroups_i18n`
	ADD CONSTRAINT `craft_categorygroups_i18n_groupId_fk` FOREIGN KEY (`groupId`) REFERENCES `craft_categorygroups` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_categorygroups_i18n_locale_fk` FOREIGN KEY (`locale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `craft_content`
--
ALTER TABLE `craft_content`
	ADD CONSTRAINT `craft_content_elementId_fk` FOREIGN KEY (`elementId`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_content_locale_fk` FOREIGN KEY (`locale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `craft_elements_i18n`
--
ALTER TABLE `craft_elements_i18n`
	ADD CONSTRAINT `craft_elements_i18n_elementId_fk` FOREIGN KEY (`elementId`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_elements_i18n_locale_fk` FOREIGN KEY (`locale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `craft_emailmessages`
--
ALTER TABLE `craft_emailmessages`
	ADD CONSTRAINT `craft_emailmessages_locale_fk` FOREIGN KEY (`locale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `craft_entries`
--
ALTER TABLE `craft_entries`
	ADD CONSTRAINT `craft_entries_authorId_fk` FOREIGN KEY (`authorId`) REFERENCES `craft_users` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_entries_id_fk` FOREIGN KEY (`id`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_entries_sectionId_fk` FOREIGN KEY (`sectionId`) REFERENCES `craft_sections` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_entries_typeId_fk` FOREIGN KEY (`typeId`) REFERENCES `craft_entrytypes` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_entrydrafts`
--
ALTER TABLE `craft_entrydrafts`
	ADD CONSTRAINT `craft_entrydrafts_creatorId_fk` FOREIGN KEY (`creatorId`) REFERENCES `craft_users` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_entrydrafts_entryId_fk` FOREIGN KEY (`entryId`) REFERENCES `craft_entries` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_entrydrafts_locale_fk` FOREIGN KEY (`locale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE,
	ADD CONSTRAINT `craft_entrydrafts_sectionId_fk` FOREIGN KEY (`sectionId`) REFERENCES `craft_sections` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_entrytypes`
--
ALTER TABLE `craft_entrytypes`
	ADD CONSTRAINT `craft_entrytypes_fieldLayoutId_fk` FOREIGN KEY (`fieldLayoutId`) REFERENCES `craft_fieldlayouts` (`id`) ON DELETE SET NULL,
	ADD CONSTRAINT `craft_entrytypes_sectionId_fk` FOREIGN KEY (`sectionId`) REFERENCES `craft_sections` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_entryversions`
--
ALTER TABLE `craft_entryversions`
	ADD CONSTRAINT `craft_entryversions_creatorId_fk` FOREIGN KEY (`creatorId`) REFERENCES `craft_users` (`id`) ON DELETE SET NULL,
	ADD CONSTRAINT `craft_entryversions_entryId_fk` FOREIGN KEY (`entryId`) REFERENCES `craft_entries` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_entryversions_locale_fk` FOREIGN KEY (`locale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE,
	ADD CONSTRAINT `craft_entryversions_sectionId_fk` FOREIGN KEY (`sectionId`) REFERENCES `craft_sections` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_fieldlayoutfields`
--
ALTER TABLE `craft_fieldlayoutfields`
	ADD CONSTRAINT `craft_fieldlayoutfields_fieldId_fk` FOREIGN KEY (`fieldId`) REFERENCES `craft_fields` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_fieldlayoutfields_layoutId_fk` FOREIGN KEY (`layoutId`) REFERENCES `craft_fieldlayouts` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_fieldlayoutfields_tabId_fk` FOREIGN KEY (`tabId`) REFERENCES `craft_fieldlayouttabs` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_fieldlayouttabs`
--
ALTER TABLE `craft_fieldlayouttabs`
	ADD CONSTRAINT `craft_fieldlayouttabs_layoutId_fk` FOREIGN KEY (`layoutId`) REFERENCES `craft_fieldlayouts` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_fields`
--
ALTER TABLE `craft_fields`
	ADD CONSTRAINT `craft_fields_groupId_fk` FOREIGN KEY (`groupId`) REFERENCES `craft_fieldgroups` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_globalsets`
--
ALTER TABLE `craft_globalsets`
	ADD CONSTRAINT `craft_globalsets_fieldLayoutId_fk` FOREIGN KEY (`fieldLayoutId`) REFERENCES `craft_fieldlayouts` (`id`) ON DELETE SET NULL,
	ADD CONSTRAINT `craft_globalsets_id_fk` FOREIGN KEY (`id`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_matrixblocks`
--
ALTER TABLE `craft_matrixblocks`
	ADD CONSTRAINT `craft_matrixblocks_fieldId_fk` FOREIGN KEY (`fieldId`) REFERENCES `craft_fields` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_matrixblocks_id_fk` FOREIGN KEY (`id`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_matrixblocks_ownerId_fk` FOREIGN KEY (`ownerId`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_matrixblocks_ownerLocale_fk` FOREIGN KEY (`ownerLocale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE,
	ADD CONSTRAINT `craft_matrixblocks_typeId_fk` FOREIGN KEY (`typeId`) REFERENCES `craft_matrixblocktypes` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_matrixblocktypes`
--
ALTER TABLE `craft_matrixblocktypes`
	ADD CONSTRAINT `craft_matrixblocktypes_fieldId_fk` FOREIGN KEY (`fieldId`) REFERENCES `craft_fields` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_matrixblocktypes_fieldLayoutId_fk` FOREIGN KEY (`fieldLayoutId`) REFERENCES `craft_fieldlayouts` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `craft_matrixcontent_address`
--
ALTER TABLE `craft_matrixcontent_address`
	ADD CONSTRAINT `craft_matrixcontent_address_elementId_fk` FOREIGN KEY (`elementId`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_matrixcontent_address_locale_fk` FOREIGN KEY (`locale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `craft_matrixcontent_articlesections`
--
ALTER TABLE `craft_matrixcontent_articlesections`
	ADD CONSTRAINT `craft_matrixcontent_articlesections_elementId_fk` FOREIGN KEY (`elementId`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_matrixcontent_articlesections_locale_fk` FOREIGN KEY (`locale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `craft_matrixcontent_organisations`
--
ALTER TABLE `craft_matrixcontent_organisations`
	ADD CONSTRAINT `craft_matrixcontent_organisations_elementId_fk` FOREIGN KEY (`elementId`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_matrixcontent_organisations_locale_fk` FOREIGN KEY (`locale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `craft_matrixcontent_principles`
--
ALTER TABLE `craft_matrixcontent_principles`
	ADD CONSTRAINT `craft_matrixcontent_principles_elementId_fk` FOREIGN KEY (`elementId`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_matrixcontent_principles_locale_fk` FOREIGN KEY (`locale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `craft_matrixcontent_profiles`
--
ALTER TABLE `craft_matrixcontent_profiles`
	ADD CONSTRAINT `craft_matrixcontent_profiles_elementId_fk` FOREIGN KEY (`elementId`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_matrixcontent_profiles_locale_fk` FOREIGN KEY (`locale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `craft_matrixcontent_quicklinks`
--
ALTER TABLE `craft_matrixcontent_quicklinks`
	ADD CONSTRAINT `craft_matrixcontent_quicklinks_elementId_fk` FOREIGN KEY (`elementId`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_matrixcontent_quicklinks_locale_fk` FOREIGN KEY (`locale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `craft_matrixcontent_sections`
--
ALTER TABLE `craft_matrixcontent_sections`
	ADD CONSTRAINT `craft_matrixcontent_sections_elementId_fk` FOREIGN KEY (`elementId`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_matrixcontent_sections_locale_fk` FOREIGN KEY (`locale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `craft_matrixcontent_sidebarinfo`
--
ALTER TABLE `craft_matrixcontent_sidebarinfo`
	ADD CONSTRAINT `craft_matrixcontent_sidebarinfo_elementId_fk` FOREIGN KEY (`elementId`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_matrixcontent_sidebarinfo_locale_fk` FOREIGN KEY (`locale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `craft_matrixcontent_testimonials`
--
ALTER TABLE `craft_matrixcontent_testimonials`
	ADD CONSTRAINT `craft_matrixcontent_testimonials_elementId_fk` FOREIGN KEY (`elementId`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_matrixcontent_testimonials_locale_fk` FOREIGN KEY (`locale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `craft_migrations`
--
ALTER TABLE `craft_migrations`
	ADD CONSTRAINT `craft_migrations_pluginId_fk` FOREIGN KEY (`pluginId`) REFERENCES `craft_plugins` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_relations`
--
ALTER TABLE `craft_relations`
	ADD CONSTRAINT `craft_relations_fieldId_fk` FOREIGN KEY (`fieldId`) REFERENCES `craft_fields` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_relations_sourceId_fk` FOREIGN KEY (`sourceId`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_relations_sourceLocale_fk` FOREIGN KEY (`sourceLocale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE,
	ADD CONSTRAINT `craft_relations_targetId_fk` FOREIGN KEY (`targetId`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_routes`
--
ALTER TABLE `craft_routes`
	ADD CONSTRAINT `craft_routes_locale_fk` FOREIGN KEY (`locale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `craft_sections`
--
ALTER TABLE `craft_sections`
	ADD CONSTRAINT `craft_sections_structureId_fk` FOREIGN KEY (`structureId`) REFERENCES `craft_structures` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `craft_sections_i18n`
--
ALTER TABLE `craft_sections_i18n`
	ADD CONSTRAINT `craft_sections_i18n_locale_fk` FOREIGN KEY (`locale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE,
	ADD CONSTRAINT `craft_sections_i18n_sectionId_fk` FOREIGN KEY (`sectionId`) REFERENCES `craft_sections` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_sessions`
--
ALTER TABLE `craft_sessions`
	ADD CONSTRAINT `craft_sessions_userId_fk` FOREIGN KEY (`userId`) REFERENCES `craft_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_shunnedmessages`
--
ALTER TABLE `craft_shunnedmessages`
	ADD CONSTRAINT `craft_shunnedmessages_userId_fk` FOREIGN KEY (`userId`) REFERENCES `craft_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_structureelements`
--
ALTER TABLE `craft_structureelements`
	ADD CONSTRAINT `craft_structureelements_elementId_fk` FOREIGN KEY (`elementId`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_structureelements_structureId_fk` FOREIGN KEY (`structureId`) REFERENCES `craft_structures` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_taggroups`
--
ALTER TABLE `craft_taggroups`
	ADD CONSTRAINT `craft_taggroups_fieldLayoutId_fk` FOREIGN KEY (`fieldLayoutId`) REFERENCES `craft_fieldlayouts` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `craft_tags`
--
ALTER TABLE `craft_tags`
	ADD CONSTRAINT `craft_tags_groupId_fk` FOREIGN KEY (`groupId`) REFERENCES `craft_taggroups` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_tags_id_fk` FOREIGN KEY (`id`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_templatecachecriteria`
--
ALTER TABLE `craft_templatecachecriteria`
	ADD CONSTRAINT `craft_templatecachecriteria_cacheId_fk` FOREIGN KEY (`cacheId`) REFERENCES `craft_templatecaches` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_templatecacheelements`
--
ALTER TABLE `craft_templatecacheelements`
	ADD CONSTRAINT `craft_templatecacheelements_cacheId_fk` FOREIGN KEY (`cacheId`) REFERENCES `craft_templatecaches` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_templatecacheelements_elementId_fk` FOREIGN KEY (`elementId`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_templatecaches`
--
ALTER TABLE `craft_templatecaches`
	ADD CONSTRAINT `craft_templatecaches_locale_fk` FOREIGN KEY (`locale`) REFERENCES `craft_locales` (`locale`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `craft_usergroups_users`
--
ALTER TABLE `craft_usergroups_users`
	ADD CONSTRAINT `craft_usergroups_users_groupId_fk` FOREIGN KEY (`groupId`) REFERENCES `craft_usergroups` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_usergroups_users_userId_fk` FOREIGN KEY (`userId`) REFERENCES `craft_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_userpermissions_usergroups`
--
ALTER TABLE `craft_userpermissions_usergroups`
	ADD CONSTRAINT `craft_userpermissions_usergroups_groupId_fk` FOREIGN KEY (`groupId`) REFERENCES `craft_usergroups` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_userpermissions_usergroups_permissionId_fk` FOREIGN KEY (`permissionId`) REFERENCES `craft_userpermissions` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_userpermissions_users`
--
ALTER TABLE `craft_userpermissions_users`
	ADD CONSTRAINT `craft_userpermissions_users_permissionId_fk` FOREIGN KEY (`permissionId`) REFERENCES `craft_userpermissions` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_userpermissions_users_userId_fk` FOREIGN KEY (`userId`) REFERENCES `craft_users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `craft_users`
--
ALTER TABLE `craft_users`
	ADD CONSTRAINT `craft_users_id_fk` FOREIGN KEY (`id`) REFERENCES `craft_elements` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `craft_users_preferredLocale_fk` FOREIGN KEY (`preferredLocale`) REFERENCES `craft_locales` (`locale`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `craft_widgets`
--
ALTER TABLE `craft_widgets`
	ADD CONSTRAINT `craft_widgets_userId_fk` FOREIGN KEY (`userId`) REFERENCES `craft_users` (`id`) ON DELETE CASCADE;

SET FOREIGN_KEY_CHECKS = 1;
